---
title: Introduction
description: 'Nuxt UI is a comprehensive UI library for Vue and Nuxt applications, offering a collection of fully styled and accessible components.'
navigation.icon: i-lucide-house
---

## What is Nuxt UI?

A modern UI library built on [Reka UI](https://reka-ui.com/), [Tailwind CSS](https://tailwindcss.com/), and [Tailwind Variants](https://www.tailwind-variants.org/) to ship beautiful and accessible applications with 100+ production-ready components.

::card-group

:::card
---
icon: i-lucide-sparkles
title: Developer Experience First
---
Intuitive APIs, excellent TypeScript support, auto-completion, and comprehensive docs.
:::

:::card
---
icon: i-lucide-palette
title: Beautiful by Default
---
A modern, clean design out of the box with a theme you can adapt in minutes.
:::

:::card
---
icon: i-lucide-accessibility
title: Accessible by Default
---
WAI-ARIA compliant with keyboard navigation, focus management, and screen reader support.
:::

:::card
---
icon: i-lucide-blocks
title: Production Ready
---
100+ battle-tested components used by thousands of applications in production.
:::

::

## What's new in v4?

Nuxt UI v4 marks a major milestone: Nuxt UI and Nuxt UI Pro are now unified into a single, fully open-source and free library of 100+ production-ready components and a complete Figma Kit.

The migration from v3 to v4 will be much smoother than from v2 to v3. Read more in the [migration guide](/docs/getting-started/migration/v4).

::note{to="/docs/getting-started/migration/v3"}
If you are migrating from v2, you can read more in this **migration guide**.
::

## Core technologies

### Reka UI

Nuxt UI is built on top of [Reka UI](https://reka-ui.com/) as a foundation for the components:

- **WAI-ARIA Compliance**: Follows [WAI-ARIA authoring practices](https://reka-ui.com/docs/overview/accessibility) with proper semantics and roles
- **Keyboard Navigation**: Built-in keyboard support for complex components like tabs and dialogs
- **Focus Management**: Intelligent focus handling that moves focus based on user interactions
- **Accessible Labels**: Abstractions to simplify labeling controls for screen readers

### Tailwind CSS

Nuxt UI integrates the latest [Tailwind CSS](https://tailwindcss.com/) v4, bringing significant improvements:

- **5x Faster Builds**: Full builds up to 5x faster, incremental builds over 100x faster
- **Unified Toolchain**: Built-in import handling, vendor prefixing, and syntax transforms
- **CSS-first Configuration**: Customize and extend directly in CSS instead of JavaScript
- **Modern Web Features**: Container queries, cascade layers, wide-gamut colors, and more

### Tailwind Variants

Nuxt UI takes advantage of [Tailwind Variants](https://www.tailwind-variants.org/) to provide a powerful theming system:

- **Dynamic Styling**: Flexible component variants with a powerful API
- **Type Safety**: Full TypeScript support with auto-completion
- **Conflict Resolution**: Efficient merging of conflicting styles

## Key features

### Ecosystem integration

Nuxt UI integrates with the Nuxt ecosystem to provide a seamless development experience:

- [**Icons**](/docs/getting-started/integrations/icons): Access 200,000+ icons from Iconify
- [**Fonts**](/docs/getting-started/integrations/fonts): Plug-and-play web font optimization and configuration
- [**Color Mode**](/docs/getting-started/integrations/color-mode): Dark and Light mode with auto detection
- [**i18n**](/docs/getting-started/integrations/i18n): Internationalize your components with 50+ languages
- [**Content**](/docs/getting-started/integrations/content): Beautiful typography out of the box

### Vue Compatibility

Nuxt UI works with any Vue project. Simply add the Vite and Vue plugins to your configuration:

- **Auto-imports**: Components and composables are automatically imported and available globally
- **Theming System**: Full theming support with customizable colors, sizes, variants, and more
- **Developer Experience**: Complete TypeScript support with IntelliSense and auto-completion

::tip{to="/docs/getting-started/installation/vue" aria-label="Vue installation guide"}
Learn how to install and configure Nuxt UI in a Vue project in the **Vue installation guide**.
::

### TypeScript Support

Nuxt UI provides comprehensive TypeScript integration for a superior developer experience:

- **Auto-completion**: For all component props, slots, and events
- **Generic Components**: Using [Vue Generics](https://vuejs.org/api/sfc-script-setup.html#generics)
- **Type-safe Theming**: In `app.config.ts`
- **IntelliSense**: Throughout your entire codebase

## FAQ

::accordion

:::accordion-item{label="Is Nuxt UI free to use?"}
Yes! Nuxt UI is completely free and open source under the MIT license. All 100+ components are available to everyone.
:::

:::accordion-item{label="Can I use Nuxt UI with Vue without Nuxt?"}
Yes! While optimized for Nuxt, Nuxt UI works perfectly with standalone Vue projects via our Vite plugin. You can follow the [installation guide](/docs/getting-started/installation/vue) to get started.
:::

:::accordion-item{label="Will Nuxt UI work with other CSS frameworks like UnoCSS?"}
No. Nuxt UI is designed exclusively for Tailwind CSS. UnoCSS support would require significant architecture changes due to different class naming conventions.
:::

:::accordion-item{label="How does Nuxt UI handle accessibility?"}
Through [Reka UI](https://reka-ui.com/docs/overview/accessibility) integration, Nuxt UI provides automatic ARIA attributes, keyboard navigation, focus management, and screen reader support. While offering a strong foundation, testing in your specific use case remains important.
:::

:::accordion-item{label="How is Nuxt UI tested?"}
Nuxt UI ensures reliability with 1000+ Vitest tests covering core functionality and accessibility.
:::

:::accordion-item{label="Is Nuxt UI production-ready?"}
Yes! Nuxt UI is used in production by thousands of applications with extensive tests, regular updates, and active maintenance.
:::

::
