---
title: Color Mode
description: 'Nuxt UI integrates with VueUse to allow for easy switching between light and dark themes.'
framework: vue
navigation.icon: i-lucide-sun-moon
---

::callout{to="/docs/getting-started/integrations/color-mode/nuxt" icon="i-logos-nuxt-icon" class="hidden"}
Looking for the **Nuxt** version?
::

## Usage

Nuxt UI automatically registers the [useDark](https://vueuse.org/core/useDark) composable as a Vue plugin, so there's no additional setup required.

### Components

You can use the built-in [ColorModeAvatar](/docs/components/color-mode-avatar) or [ColorModeImage](/docs/components/color-mode-image) components to display different images for light and dark mode and the [ColorModeButton](/docs/components/color-mode-button), [ColorModeSwitch](/docs/components/color-mode-switch) or [ColorModeSelect](/docs/components/color-mode-select) components to switch between light and dark modes.

You can also use the [useColorMode](https://vueuse.org/core/useColorMode) composable to build your own custom component:

```vue [ColorModeButton.vue]
<script setup lang="ts">
import { useColorMode } from '@vueuse/core'

const colorMode = useColorMode()

const isDark = computed({
  get() {
    return colorMode.value === 'dark'
  },
  set(_isDark: boolean) {
    colorMode.preference = _isDark ? 'dark' : 'light'
  }
})
</script>

<template>
  <UButton
    :icon="isDark ? 'i-lucide-moon' : 'i-lucide-sun'"
    :color="color"
    :variant="variant"
    :aria-label="`Switch to ${isDark ? 'light' : 'dark'} mode`"
    @click="isDark = !isDark"
  />
</template>
```

### Configuration

You can disable this plugin with the `colorMode` option in your `vite.config.ts`:

```ts [vite.config.ts]
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import ui from '@nuxt/ui/vite'

export default defineConfig({
  plugins: [
    vue(),
    ui({
      colorMode: false
    })
  ]
})
```
