---
title: Components
description: Build beautiful, accessible, and responsive user interfaces with 110+ Vue components powered by Tailwind CSS and Reka UI.
seo:
  title: Vue Components
navigation: false
---

## Layout

Core structural components for organizing your application's layout and establishing a consistent foundation for your UI.

:components-list{category="layout"}

## Element

Essential UI building blocks including buttons, badges, avatars, icons, and other foundational interface elements for crafting intuitive and consistent user experiences.

:components-list{category="element"}

## Form

Comprehensive form components for building interactive user input experiences, including text inputs, selects, checkboxes, radio groups, switches, sliders, and complete form validation.

:components-list{category="form"}

## Data

Components for displaying and organizing data, including tables, accordions, carousels, timelines, trees, and user profiles.

:components-list{category="data"}

## Navigation

Components for user navigation and wayfinding, including menus, breadcrumbs, pagination, tabs, steppers, links, and command palettes.

:components-list{category="navigation"}

## Overlay

Floating UI elements that appear above the main content, including modals, popovers, tooltips, drawers, slideovers, and context menus.

:components-list{category="overlay"}

## Page

Pre-built marketing and content sections for creating landing pages, blogs, pricing pages, and other marketing materials.

:components-list{category="page"}

::note{to="https://github.com/nuxt-ui-templates/saas" target="_blank"}
Check out the **SaaS template** on GitHub for a real-life example.
::

## Dashboard

Specialized components for building dynamic dashboards with resizable panels, collapsible sidebars, toolbars, and search functionality.

:components-list{category="dashboard"}

::note{to="https://github.com/nuxt-ui-templates/dashboard" target="_blank"}
Check out the **Dashboard template** on GitHub for a real-life example.
::

## Chat

Components for building conversational interfaces and chatbots, powered by the **[Vercel AI SDK](https://sdk.vercel.ai)**.

:components-list{category="chat"}

::note{to="https://github.com/nuxt-ui-templates/chat" target="_blank"}
Check out the **AI Chat template** on GitHub for a real-life example.
::

## Content

Components that integrate with [Content](/docs/getting-started/integrations/content) for documentation sites, including table of contents, search, navigation trees, and surrounding page links.

:components-list{category="content"}

::note{to="https://github.com/nuxt-ui-templates/docs" target="_blank"}
Check out the **Docs template** on GitHub for a real-life example.
::

## Color Mode

Components that integrate with [Color Mode](/docs/getting-started/integrations/color-mode) for theme switching between light, dark, and system preferences.

:components-list{category="color-mode"}

## i18n

Components that integrate with [i18n](/docs/getting-started/integrations/i18n) for internationalization and locale management.

:components-list{category="i18n"}
