import { describe, it, expect } from 'vitest'
import { axe } from 'vitest-axe'
import { mountSuspended } from '@nuxt/test-utils/runtime'
import Main from '../../src/runtime/components/Main.vue'
import type { MainProps, MainSlots } from '../../src/runtime/components/Main.vue'
import ComponentRender from '../component-render'

describe('Main', () => {
  it.each([
    // Props
    ['with as', { props: { as: 'main' } }],
    ['with class', { props: { class: 'min-h-full' } }],
    // Slots
    ['with default slot', { slots: { default: () => 'Default slot' } }]
  ])('renders %s correctly', async (nameOrHtml: string, options: { props?: MainProps, slots?: Partial<MainSlots> }) => {
    const html = await ComponentRender(nameOrHtml, options, Main)
    expect(html).toMatchSnapshot()
  })

  it('passes accessibility tests', async () => {
    const wrapper = await mountSuspended(Main, {
      slots: {
        default: () => 'Default slot'
      }
    })

    expect(await axe(wrapper.element)).toHaveNoViolations()
  })
})
