# Open eHealth Integration Platform

[![Build Status](https://buildhive.cloudbees.com/job/oehf/job/ipf/badge/icon)](https://buildhive.cloudbees.com/job/oehf/job/ipf/)

## IPF Overview

The eHealth Integration Framework (IPF) is an extension of the Apache Camel routing and mediation engine and comes with
comprehensive support for message processing and connecting information systems in the healthcare sector.
It is available under the Apache License version 2.0.

IPF focuses on a domain-specific language (DSL) to implement Enterprise Integration Patterns (EIPs) in integration solutions.
IPF is based on the Java and Groovy programming languages for application development and for designing project-specific DSLs.

IPF provides highl-level building blocks for implementing IHE profiles such as XDS, PIX, PDQ or XCPD.
Other supported standards are HL7v2 and HL7v3 (CDA and CCD) for which IPF provides domain-specific languages (DSLs) for
creation, parsing, rendering, navigation and modification.

* [Detailed overview](http://repo.openehealth.org/confluence/display/ipf2/IPF+Overview)

## Documentation

The IPF 3 documentation is located at [github](https://oehf.github.io/ipf)

The old IPF 2 documentation is available at:

* [Single-page view](http://repo.openehealth.org/confluence/display/ipf2/IPF+reference+-+single)
* [Multi-page view](http://repo.openehealth.org/confluence/display/ipf2/IPF+reference+-+multi)
* [Introductory article](http://architects.dzone.com/articles/introduction-open-ehealth)

## Mailing Lists

* [ipf-dev](http://groups.google.com/group/ipf-dev)
* [ipf-user](http://groups.google.com/group/ipf-user)
