# Code of Conduct

This Code of Conduct governs how we behave in any forum and whenever we will be judged by our actions. We expect it to be honored by everyone who represents the Akka community officially or informally, claims affiliation with the project or participates directly.

We strive to:

- **Be open**: We invite anybody, either in their personal capacity or from any company, to participate in any aspect of our projects. Our community is open, and any responsibility can be carried by any contributor who demonstrates the required capacity and competence.
- **Be empathetic**: We work together to resolve conflict, assume good intentions and do our best to act in an empathic fashion. We don’t allow frustration to turn into a personal attack. A community where people feel uncomfortable or threatened is not a productive one.
- **Be collaborative**: Collaboration reduces redundancy and improves the quality of our work. We prefer to work transparently and involve interested parties as early as possible. Wherever possible, we work closely with upstream projects and others in the free software community to coordinate our efforts.
- **Be inquisitive**: Nobody knows everything, asking questions early avoids many problems later, so questions are encouraged, though they may be directed to the appropriate forum. Those who are asked should be responsive and helpful.
- **Step down considerately**: Members of every project come and go. When somebody leaves or disengages from the project they should tell people they are leaving and take the proper steps to ensure that others can pick up where they left off.

This code is not exhaustive or complete. It serves to distill our common understanding of a collaborative, shared environment and goals. We expect it to be followed in spirit as much as in the letter.

## Diversity Statement

We encourage participation by everyone. We are committed to being a community that everyone feels good about joining. Although we may not be able to satisfy everyone, we will always work to treat everyone well.

Standards for behavior in the Akka community are detailed in the Code of Conduct above. We expect participants in our community to meet these standards in all their interactions and to help others to do so as well.

Whenever any participant has made a mistake, we expect them to take responsibility for it. If someone has been harmed or offended, it is our responsibility to listen carefully and respectfully, and do our best to right the wrong.

Although this list cannot be exhaustive, we explicitly honor diversity in age, culture, ethnicity, genotype, gender identity or expression, language, national origin, neurotype, phenotype, political beliefs, profession, race, religion, sexual orientation, socioeconomic status, subculture and technical ability.

## Reporting Conduct Issues

If you have a concern about the conduct of other community members, we recommend you first speak with respective project leads and committers about the problem. If unsure where to ask, you can contact the team via the info@lightbend.com email address or the [contact owner](https://groups.google.com/forum/#!contactowner/akka-user) form for the Akka mailing list.

## Thanks

Some of the ideas and wording for the statements above were based on work by the [Python](http://www.python.org/community/diversity), [Ubuntu](http://www.ubuntu.com/about/about-ubuntu/conduct), [Mozilla](https://wiki.mozilla.org/Code_of_Conduct/Draft), [TwitterOSS](https://engineering.twitter.com/opensource/code-of-conduct), and [Play Framework](https://playframework.com/conduct) communities. We are thankful for their work.

*The Akka of Conduct is licensed under the [Creative Commons Attribution-Share Alike 3.0 license](http://creativecommons.org/licenses/by-sa/3.0/). You may re-use it for your own project, and modify it as you wish, just please allow others to use your modifications and give credit to Akka and other communities listed above.*
