# Other Akka modules

## [Akka HTTP](https://doc.akka.io/docs/akka-http/current/)

A full server- and client-side HTTP stack on top of akka-actor and akka-stream.

## [Alpakka](https://doc.akka.io/docs/alpakka/current/)

Alpakka is a Reactive Enterprise Integration library for Java and Scala, based on Reactive Streams and Akka.

## [Alpakka Kafka Connector](https://doc.akka.io/docs/akka-stream-kafka/current/)

The Alpakka Kafka Connector connects Apache Kafka with Akka Streams.

## [Cassandra Plugin for Akka Persistence](https://doc.akka.io/docs/akka-persistence-cassandra/current/)

An Akka Persistence journal and snapshot store backed by Apache Cassandra.

## [Couchbase Plugin for Akka Persistence](https://doc.akka.io/docs/akka-persistence-couchbase/current/)

An Akka Persistence journal and snapshot store backed by Couchbase.

## Akka Management

* [Akka Management](https://doc.akka.io/docs/akka-management/current/) provides a central HTTP endpoint for Akka management extensions.
* [Akka Cluster Bootstrap](https://doc.akka.io/docs/akka-management/current/bootstrap/) helps bootstrapping an Akka cluster using Akka Discovery.
* [Akka Management Cluster HTTP](https://doc.akka.io/docs/akka-management/current/cluster-http-management.html) provides HTTP endpoints for introspecting and managing Akka clusters.
* [Akka Discovery for Kubernetes, Consul, Marathon, and AWS](https://doc.akka.io/docs/akka-management/current/discovery/)

## [Akka gRPC](https://doc.akka.io/docs/akka-grpc/current/)

Akka gRPC provides support for building streaming gRPC servers and clients on top of Akka Streams.

## Akka Resilience Enhancements

* [Akka Split Brain Resolver](https://doc.akka.io/docs/akka-enhancements/current/split-brain-resolver.html)
* [Kubernetes Lease](https://doc.akka.io/docs/akka-enhancements/current/kubernetes-lease.html)
* [Akka Thread Starvation Detector](https://doc.akka.io/docs/akka-enhancements/current/starvation-detector.html)
* [Akka Configuration Checker](https://doc.akka.io/docs/akka-enhancements/current/config-checker.html)
* [Akka Diagnostics Recorder](https://doc.akka.io/docs/akka-enhancements/current/diagnostics-recorder.html)

## Akka Persistence Enhancements

* [Akka Multi-DC Persistence](https://doc.akka.io/docs/akka-enhancements/current/persistence-dc/index.html)
* [Akka GDPR for Persistence](https://doc.akka.io/docs/akka-enhancements/current/gdpr/index.html)


## Community Projects

Akka has a vibrant and passionate user community, the members of which have created many independent projects using Akka as well as extensions to it. See [Community Projects](https://akka.io/community/).

## Related Projects Sponsored by Lightbend

### [Play Framework](https://www.playframework.com)

Play Framework provides a complete framework to build modern web applications, including tools for front end pipeline integration, 
a HTML template language etc. It is built on top of Akka HTTP, and integrates well with Akka and Actors.

### [Lagom](https://www.lagomframework.com)

Lagom is a microservice framework which strives to be opinionated and encode best practices for building microservice systems with Akka and Play.

### [Lightbend Telemetry](https://developer.lightbend.com/docs/telemetry/current/home.html)

Distributed tracing, metrics and monitoring for Akka Actors, Cluster, HTTP and more.
