# Broken random number generators AES128CounterSecureRNG / AES256CounterSecureRNG, Fixed in Akka 2.5.16

### CVE ID

CVE-2018-16115

### Date

29 August 2018

### Description of Vulnerability

A random number generator is used in Akka Remoting for TLS (both classic and Artery
Remoting). Akka allows to configure custom random number generators. For historical reasons,
Akka included the `AES128CounterSecureRNG` and `AES256CounterSecureRNG` random number
generators. The implementations had a bug that caused the generated numbers to be repeated
after only a few bytes.

The custom RNG implementations were not configured by default but examples in the
documentation showed (and therefore implicitly recommended) using the custom ones.

This can be used by an attacker to compromise the communication if these random number generators
are enabled in configuration. It would be possible to eavesdrop, replay or modify the messages sent with
Akka Remoting/Cluster.

To protect against such attacks the system should be updated to Akka *2.5.16* or later, or the default
configuration of the TLS random number generator should be used:

```
# Set `SecureRandom` RNG explicitly (but it is also the default)
akka.remote.classic.netty.ssl.random-number-generator = "SecureRandom"
akka.remote.artery.ssl.config-ssl-engine.random-number-generator = "SecureRandom"
```

Please subscribe to the [akka-security](https://groups.google.com/forum/#!forum/akka-security) mailing list to be notified promptly about future security issues.

### Severity

The [CVSS](https://en.wikipedia.org/wiki/CVSS) score of this vulnerability is 5.9 (Medium), based on vector [AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N/E:U/RL:O/RC:C](https://nvd.nist.gov/vuln-metrics/cvss/v3-calculator?vector=AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N/E:U/RL:O/RC:C).

Rationale for the score:

 * AV:A - Best practice is that Akka remoting nodes should only be accessible from the adjacent network, so in
   good setups, this will be adjacent.
 * AC:H - Any one in the adjacent network can launch the attack with non-special access privileges,
   but man-in-the-middle attacks are not trivial.
 * C:H, I:H - Confidentiality and Integrity are only partially affected because only the networking component
   is affected and not the whole Akka cluster. Assessed to be High anyway because access to actor system data would
   probably be possible by injecting messages into the remoting communication.

### Affected Versions

 * Akka *2.5.0 - 2.5.15* with any of the following configuration properties defined:

```
akka.remote.netty.ssl.random-number-generator = "AES128CounterSecureRNG"
akka.remote.netty.ssl.random-number-generator = "AES256CounterSecureRNG"
akka.remote.artery.ssl.config-ssl-engine.random-number-generator = "AES128CounterSecureRNG"
akka.remote.artery.ssl.config-ssl-engine.random-number-generator = "AES256CounterSecureRNG"
```

Akka *2.4.x* versions are not affected by this particular bug. It has reached
end-of-life since start of 2018. If you still run on Akka 2.4, we still
recommend to use the default `SecureRandom` implementation for the reasons
given below. Please check your configuration files not to configure the
custom RNGs.

### Fixed Versions

We have prepared patches for the affected versions, and have released the following version which resolve the issue:

 * Akka *2.5.16* (Scala 2.11, 2.12)

Binary and source compatibility has been maintained for the patched releases so the upgrade procedure is as simple
as changing the library dependency.

The exact historical reasons to include custom RNG implementations could not be reconstructed
but it was likely because RNGs provided by previous versions of the JDK were deemed too slow.

Including custom cryptographic components in your library (or application) should not be done
lightly. We acknowledge that we cannot prove that the custom RNGs that Akka provides or has
been providing are generally correct or just correct enough for the purposes in Akka.

The reporter of this vulnerability, Rafał Sumisławski, kindly provided us with fixes for the
custom RNGs in Akka. However, as we cannot thoroughly verify the correctness of the algorithm
we decided to remove custom RNGs from Akka.

If the "AES128CounterSecureRNG" and "AES256CounterSecureRNG" configuration values are still used with Akka 2.5.16
they will be ignored and the default `SecureRandom` is used and a warning is logged. This is to avoid accidental
use of these unverified and possibly insecure implementations. The deprecated implementations are not recommended,
but they can be enabled by using configuration values "DeprecatedAES128CounterSecureRNG" or "DeprecatedAES256CounterSecureRNG"
during the transition period until they have been removed.

*Edit*: `DeprecatedAES128CounterSecureRNG` and `DeprecatedAES256CounterSecureRNG` have been removed since Akka 2.5.19.

### Acknowledgements

We would like to thank Rafał Sumisławski at NetworkedAssets for bringing this issue to our attention and providing
a patch.
