# Security Announcements

## Receiving Security Advisories

The best way to receive any and all security announcements is to subscribe to the [Akka security list](https://groups.google.com/forum/#!forum/akka-security).

The mailing list is very low traffic, and receives notifications only after security reports have been managed by the core team and fixes are publicly available.

## Reporting Vulnerabilities

We strongly encourage people to report such problems to our private security mailing list first, before disclosing them in a public forum.

Following best practice, we strongly encourage anyone to report potential security 
vulnerabilities to [security@akka.io](mailto:security@akka.io) before disclosing them in a public forum like the mailing list or as a GitHub issue.

Reports to this email address will be handled by our security team, who will work together with you
to ensure that a fix can be provided without delay.

## Security Related Documentation

 * @ref:[Java Serialization](../serialization.md#java-serialization)
 * @ref:[Remote deployment whitelist](../remoting.md#remote-deployment-whitelist)
 * @ref:[Remote Security](../remoting-artery.md#remote-security)

## Fixed Security Vulnerabilities

@@toc { .list depth=1 }

@@@ index

* [2017-02-10-java-serialization](2017-02-10-java-serialization.md)
* [2017-08-09-camel](2017-08-09-camel.md)
* [2018-08-29-aes-rng](2018-08-29-aes-rng.md)

@@@
