import * as React from "react";
import { cn } from "@workspace/ui/lib/utils";
import { Button } from "@workspace/ui/components/button";
import { LucideIcon } from "lucide-react";

interface EmptyStateProps {
  title: string;
  description: string;
  icons?: LucideIcon[];
  action?: {
    label: string | React.ReactNode;
    onClick: () => void;
  };
  secondaryAction?: {
    label: string | React.ReactNode;
    onClick: () => void;
    disabled?: boolean;
  };
  className?: string;
}

export function EmptyState({
  title,
  description,
  icons = [],
  action,
  secondaryAction,
  className,
}: EmptyStateProps) {
  return (
    <div
      className={cn(
        "bg-background border-border hover:border-border/80 text-center",
        "border-2 border-dashed rounded-xl p-14 w-full max-w-3xl",
        "group hover:bg-muted/50 transition duration-500 hover:duration-200",
        className
      )}
    >
      <div className="flex justify-center isolate">
        {icons.length === 3 ? (
          <>
            <div className="bg-background size-12 grid place-items-center rounded-xl relative left-2.5 top-1.5 -rotate-6 shadow-lg ring-1 ring-border group-hover:-translate-x-5 group-hover:-rotate-12 group-hover:-translate-y-0.5 transition duration-500 group-hover:duration-200">
              {icons[0] &&
                React.createElement(icons[0], {
                  className: "w-6 h-6 text-muted-foreground",
                })}
            </div>
            <div className="bg-background size-12 grid place-items-center rounded-xl relative z-10 shadow-lg ring-1 ring-border group-hover:-translate-y-0.5 transition duration-500 group-hover:duration-200">
              {icons[1] &&
                React.createElement(icons[1], {
                  className: "w-6 h-6 text-muted-foreground",
                })}
            </div>
            <div className="bg-background size-12 grid place-items-center rounded-xl relative right-2.5 top-1.5 rotate-6 shadow-lg ring-1 ring-border group-hover:translate-x-5 group-hover:rotate-12 group-hover:-translate-y-0.5 transition duration-500 group-hover:duration-200">
              {icons[2] &&
                React.createElement(icons[2], {
                  className: "w-6 h-6 text-muted-foreground",
                })}
            </div>
          </>
        ) : (
          <div className="bg-background size-12 grid place-items-center rounded-xl shadow-lg ring-1 ring-border group-hover:-translate-y-0.5 transition duration-500 group-hover:duration-200">
            {icons[0] &&
              React.createElement(icons[0], {
                className: "w-6 h-6 text-muted-foreground",
              })}
          </div>
        )}
      </div>
      <h1 className="text-2xl leading-none font-semibold text-center mt-10">
        {title}
      </h1>
      <p className="text-sm text-muted-foreground mt-6 whitespace-pre-line">
        {description}
      </p>

      {(action || secondaryAction) && (
        <div className="mt-10 flex flex-col sm:flex-row items-center justify-center gap-4">
          {action && (
            <Button
              onClick={action.onClick}
              size="lg"
              className={cn("shadow-sm active:shadow-none cursor-pointer")}
            >
              {action.label}
            </Button>
          )}

          {secondaryAction && (
            <Button
              variant="secondary"
              onClick={secondaryAction.onClick}
              disabled={secondaryAction.disabled}
              size="lg"
              className={cn("shadow-sm active:shadow-none cursor-pointer")}
            >
              {secondaryAction.label}
            </Button>
          )}
        </div>
      )}
    </div>
  );
}
