/**
 * Complete language code to key mapping for all supported Whisper languages
 * Maps ISO language codes to translation keys in the i18n Languages namespace
 */
export const LANGUAGE_KEYS = [
  { value: "auto", key: "auto" },
  { value: "af", key: "afrikaans" },
  { value: "sq", key: "albanian" },
  { value: "am", key: "amharic" },
  { value: "ar", key: "arabic" },
  { value: "hy", key: "armenian" },
  { value: "as", key: "assamese" },
  { value: "az", key: "azerbaijani" },
  { value: "ba", key: "bashkir" },
  { value: "eu", key: "basque" },
  { value: "be", key: "belarusian" },
  { value: "bn", key: "bengali" },
  { value: "bs", key: "bosnian" },
  { value: "br", key: "breton" },
  { value: "bg", key: "bulgarian" },
  { value: "ca", key: "catalan" },
  { value: "zh", key: "chinese" },
  { value: "hr", key: "croatian" },
  { value: "cs", key: "czech" },
  { value: "da", key: "danish" },
  { value: "nl", key: "dutch" },
  { value: "en", key: "english" },
  { value: "et", key: "estonian" },
  { value: "fo", key: "faroese" },
  { value: "fi", key: "finnish" },
  { value: "fr", key: "french" },
  { value: "gl", key: "galician" },
  { value: "ka", key: "georgian" },
  { value: "de", key: "german" },
  { value: "el", key: "greek" },
  { value: "gu", key: "gujarati" },
  { value: "ht", key: "haitiancreole" },
  { value: "ha", key: "hausa" },
  { value: "haw", key: "hawaiian" },
  { value: "he", key: "hebrew" },
  { value: "hi", key: "hindi" },
  { value: "hu", key: "hungarian" },
  { value: "is", key: "icelandic" },
  { value: "id", key: "indonesian" },
  { value: "it", key: "italian" },
  { value: "ja", key: "japanese" },
  { value: "jw", key: "javanese" },
  { value: "kn", key: "kannada" },
  { value: "kk", key: "kazakh" },
  { value: "km", key: "khmer" },
  { value: "ko", key: "korean" },
  { value: "lo", key: "lao" },
  { value: "la", key: "latin" },
  { value: "lv", key: "latvian" },
  { value: "ln", key: "lingala" },
  { value: "lt", key: "lithuanian" },
  { value: "lb", key: "luxembourgish" },
  { value: "mk", key: "macedonian" },
  { value: "mg", key: "malagasy" },
  { value: "ms", key: "malay" },
  { value: "ml", key: "malayalam" },
  { value: "mt", key: "maltese" },
  { value: "mi", key: "maori" },
  { value: "mr", key: "marathi" },
  { value: "mn", key: "mongolian" },
  { value: "my", key: "myanmar" },
  { value: "ne", key: "nepali" },
  { value: "no", key: "norwegian" },
  { value: "nn", key: "nynorsk" },
  { value: "oc", key: "occitan" },
  { value: "ps", key: "pashto" },
  { value: "fa", key: "persian" },
  { value: "pl", key: "polish" },
  { value: "pt", key: "portuguese" },
  { value: "pa", key: "punjabi" },
  { value: "ro", key: "romanian" },
  { value: "ru", key: "russian" },
  { value: "sa", key: "sanskrit" },
  { value: "sr", key: "serbian" },
  { value: "sn", key: "shona" },
  { value: "sd", key: "sindhi" },
  { value: "si", key: "sinhala" },
  { value: "sk", key: "slovak" },
  { value: "sl", key: "slovenian" },
  { value: "so", key: "somali" },
  { value: "es", key: "spanish" },
  { value: "su", key: "sundanese" },
  { value: "sw", key: "swahili" },
  { value: "sv", key: "swedish" },
  { value: "tl", key: "tagalog" },
  { value: "tg", key: "tajik" },
  { value: "ta", key: "tamil" },
  { value: "tt", key: "tatar" },
  { value: "te", key: "telugu" },
  { value: "th", key: "thai" },
  { value: "bo", key: "tibetan" },
  { value: "tr", key: "turkish" },
  { value: "tk", key: "turkmen" },
  { value: "uk", key: "ukrainian" },
  { value: "ur", key: "urdu" },
  { value: "uz", key: "uzbek" },
  { value: "vi", key: "vietnamese" },
  { value: "cy", key: "welsh" },
  { value: "yi", key: "yiddish" },
  { value: "yo", key: "yoruba" },
] as const;

export type LanguageKey = (typeof LANGUAGE_KEYS)[number]["key"];
export type LanguageValue = (typeof LANGUAGE_KEYS)[number]["value"];
