/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.vafer.jdeb.ar.ArArchive;
import org.vafer.jdeb.ar.FileArEntry;
import org.vafer.jdeb.ar.StaticArEntry;

public class DebAntTask
extends Task {
    private File deb;
    private File control;
    private Collection dataCollection = new ArrayList();

    public void setDestfile(File deb) {
        this.deb = deb;
    }

    public void setControl(File control) {
        this.control = control;
    }

    public void addData(Data data) {
        this.dataCollection.add(data);
    }

    public void execute() {
        if (this.control == null || !this.control.isDirectory()) {
            throw new BuildException("you need to point the 'control' attribute to the control directory");
        }
        if (this.dataCollection.size() == 0) {
            throw new BuildException("you need to provide at least one pointer to a tgz or directory with the data");
        }
        if (this.deb == null) {
            throw new BuildException("you need to point the 'destfile' attribute to where the deb is supposed to be created");
        }
        File tempData = null;
        File tempControl = null;
        try {
            tempData = File.createTempFile("deb", "data");
            tempControl = File.createTempFile("deb", "control");
            TarOutputStream outputStream = new TarOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(tempData)));
            outputStream.setLongFileMode(2);
            StringBuffer md5sum = new StringBuffer();
            Iterator it = this.dataCollection.iterator();
            while (it.hasNext()) {
                Data data = (Data)it.next();
                this.log("*** adding data from " + data);
                this.buildData(data, outputStream, md5sum);
            }
            outputStream.close();
            this.buildControl(this.control, md5sum.toString(), tempControl);
            ArArchive ar = new ArArchive(new FileOutputStream(this.deb));
            ar.add(new StaticArEntry("debian-binary", 0, 0, 33188, "2.0\n"));
            ar.add(new FileArEntry(tempControl, "control.tar.gz", 0, 0, 33188));
            ar.add(new FileArEntry(tempData, "data.tar.gz", 0, 0, 33188));
            ar.close();
        }
        catch (Exception e) {
            if (tempData != null) {
                tempData.delete();
            }
            if (tempControl != null) {
                tempControl.delete();
            }
            e.printStackTrace();
            throw new BuildException("could not create deb package", (Throwable)e);
        }
    }

    private void iterate(File dir, FileVisitor visitor) {
        visitor.visit(dir);
        if (dir.isDirectory()) {
            File[] childs = dir.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                this.iterate(childs[i], visitor);
            }
        }
    }

    private String stripPath(int p, String s) {
        if (p <= 0) {
            return s;
        }
        int x = 0;
        for (int i = 0; i < p; ++i) {
            if ((x = s.indexOf(47, x)) >= 0) continue;
            return s;
        }
        return s.substring(x + 1);
    }

    private void buildData(final Data srcData, final TarOutputStream outputStream, final StringBuffer md5sum) throws Exception {
        final File src = srcData.getFile();
        if (!src.exists()) {
            return;
        }
        if (src.isFile()) {
            TarEntry entry;
            TarInputStream inputStream = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(src)));
            MessageDigest digest = MessageDigest.getInstance("MD5");
            while ((entry = inputStream.getNextEntry()) != null) {
                entry.setName(srcData.getPrefix() + this.stripPath(srcData.getStrip(), entry.getName()));
                outputStream.putNextEntry(entry);
                digest.reset();
                DebAntTask.copy((InputStream)inputStream, new DigestOutputStream((OutputStream)outputStream, digest));
                this.log("adding data file name:" + entry.getName() + " size:" + entry.getSize() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId() + " modtime:" + entry.getModTime() + " md5: " + DebAntTask.toHex(digest.digest()));
                outputStream.closeEntry();
                md5sum.append(entry.getName()).append(" ").append(DebAntTask.toHex(digest.digest())).append('\n');
            }
            inputStream.close();
        } else {
            final MessageDigest digest = MessageDigest.getInstance("MD5");
            this.iterate(src, new FileVisitor(){

                public void visit(File file) {
                    try {
                        TarEntry entry = new TarEntry(file);
                        String localName = file.getAbsolutePath().substring(src.getAbsolutePath().length());
                        if ("".equals(localName)) {
                            return;
                        }
                        entry.setName(srcData.getPrefix() + DebAntTask.this.stripPath(srcData.getStrip(), localName.substring(1)));
                        if (file.isDirectory()) {
                            DebAntTask.this.log("adding data directory name:" + entry.getName() + " size:" + entry.getSize() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId() + " modtime:" + entry.getModTime());
                            outputStream.putNextEntry(entry);
                            outputStream.closeEntry();
                            return;
                        }
                        FileInputStream inputStream = new FileInputStream(file);
                        DebAntTask.this.log("adding data file name:" + entry.getName() + " size:" + entry.getSize() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId() + " modtime:" + entry.getModTime() + " md5: " + DebAntTask.toHex(digest.digest()));
                        outputStream.putNextEntry(entry);
                        digest.reset();
                        DebAntTask.copy(inputStream, new DigestOutputStream((OutputStream)outputStream, digest));
                        outputStream.closeEntry();
                        md5sum.append(entry.getName()).append(" ").append(DebAntTask.toHex(digest.digest())).append('\n');
                        ((InputStream)inputStream).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void buildControl(File src, String digests, File dst) throws Exception {
        final TarOutputStream outputStream = new TarOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(dst)));
        outputStream.setLongFileMode(2);
        this.iterate(src, new FileVisitor(){

            public void visit(File file) {
                if (file.isDirectory()) {
                    return;
                }
                try {
                    TarEntry entry = new TarEntry(file);
                    entry.setName(file.getName());
                    FileInputStream inputStream = new FileInputStream(file);
                    DebAntTask.this.log("adding control file " + entry.getName());
                    outputStream.putNextEntry(entry);
                    DebAntTask.copy(inputStream, (OutputStream)outputStream);
                    outputStream.closeEntry();
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        byte[] data = digests.getBytes("UTF-8");
        TarEntry entry = new TarEntry("md5sums");
        entry.setSize((long)data.length);
        this.log("adding control file " + entry.getName());
        outputStream.putNextEntry(entry);
        outputStream.write(data);
        outputStream.closeEntry();
        outputStream.close();
    }

    private static String toHex(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toHexString(b[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(b[i] & 0xF));
        }
        return sb.toString();
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[2048];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    private static interface FileVisitor {
        public void visit(File var1);
    }

    public static class Data {
        private String prefix = "";
        private int strip = 0;
        private File data;

        public void setStrip(int strip) {
            this.strip = strip;
        }

        public void setPrefix(String prefix) {
            if (!prefix.endsWith("/")) {
                this.prefix = prefix + "/";
                return;
            }
            this.prefix = prefix;
        }

        public void setSrc(File data) {
            this.data = data;
        }

        public File getFile() {
            return this.data;
        }

        public int getStrip() {
            return this.strip;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

