/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.StringMatcher;

public class DynamicMemberReferenceInitializer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
AttributeVisitor,
MemberVisitor {
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    private final Constant[] GET_FIELD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getField"), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/reflect/Field;")};
    private final Constant[] GET_DECLARED_FIELD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getDeclaredField"), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/reflect/Field;")};
    private final Constant[] GET_METHOD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getMethod"), new Utf8Constant("(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;")};
    private final Constant[] GET_DECLARED_METHOD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getDeclaredMethod"), new Utf8Constant("(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;")};
    private final Instruction[] CONSTANT_GET_FIELD_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_GET_METHOD_INSTRUCTIONS0 = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new SimpleInstruction(3), new ConstantInstruction(-67, 1), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_GET_METHOD_INSTRUCTIONS1 = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new SimpleInstruction(4), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_GET_METHOD_INSTRUCTIONS2 = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new SimpleInstruction(5), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new SimpleInstruction(89), new SimpleInstruction(4), new ConstantInstruction(18, 0x40000004), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_FIELD_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_METHOD_INSTRUCTIONS0 = new Instruction[]{new ConstantInstruction(18, 0x40000001), new SimpleInstruction(3), new ConstantInstruction(-67, 1), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_METHOD_INSTRUCTIONS1 = new Instruction[]{new ConstantInstruction(18, 0x40000001), new SimpleInstruction(4), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_METHOD_INSTRUCTIONS2 = new Instruction[]{new ConstantInstruction(18, 0x40000001), new SimpleInstruction(5), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new SimpleInstruction(89), new SimpleInstruction(4), new ConstantInstruction(18, 0x40000004), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private final StringMatcher noteFieldExceptionMatcher;
    private final StringMatcher noteMethodExceptionMatcher;
    private final InstructionSequenceMatcher constantGetFieldMatcher = new InstructionSequenceMatcher(this.GET_FIELD_CONSTANTS, this.CONSTANT_GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantGetDeclaredFieldMatcher = new InstructionSequenceMatcher(this.GET_DECLARED_FIELD_CONSTANTS, this.CONSTANT_GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantGetMethodMatcher0 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher constantGetDeclaredMethodMatcher0 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher constantGetMethodMatcher1 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher constantGetDeclaredMethodMatcher1 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher constantGetMethodMatcher2 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher constantGetDeclaredMethodMatcher2 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher getFieldMatcher = new InstructionSequenceMatcher(this.GET_FIELD_CONSTANTS, this.GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher getDeclaredFieldMatcher = new InstructionSequenceMatcher(this.GET_DECLARED_FIELD_CONSTANTS, this.GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher getMethodMatcher0 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher getDeclaredMethodMatcher0 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher getMethodMatcher1 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher getDeclaredMethodMatcher1 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher getMethodMatcher2 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher getDeclaredMethodMatcher2 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS2);
    private final MemberFinder memberFinder = new MemberFinder();
    private Clazz referencedClass;
    private boolean isDeclared;
    private boolean isField;

    public DynamicMemberReferenceInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.notePrinter = warningPrinter;
        this.noteFieldExceptionMatcher = stringMatcher;
        this.noteMethodExceptionMatcher = stringMatcher2;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetFieldMatcher, this.getFieldMatcher, true, false);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredFieldMatcher, this.getDeclaredFieldMatcher, true, true);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetMethodMatcher0, this.getMethodMatcher0, false, false);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredMethodMatcher0, this.getDeclaredMethodMatcher0, false, true);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetMethodMatcher1, this.getMethodMatcher1, false, false);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredMethodMatcher1, this.getDeclaredMethodMatcher1, false, true);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetMethodMatcher2, this.getMethodMatcher2, false, false);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredMethodMatcher2, this.getDeclaredMethodMatcher2, false, true);
    }

    private void matchGetMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction, InstructionSequenceMatcher instructionSequenceMatcher, InstructionSequenceMatcher instructionSequenceMatcher2, boolean bl, boolean bl2) {
        instruction.accept(clazz, method, codeAttribute, n, instructionSequenceMatcher);
        if (instructionSequenceMatcher.isMatching()) {
            this.isField = bl;
            this.isDeclared = bl2;
            clazz.constantPoolEntryAccept(instructionSequenceMatcher.matchedConstantIndex(0x40000000), this);
            clazz.constantPoolEntryAccept(instructionSequenceMatcher.matchedConstantIndex(0x40000001), this);
            instructionSequenceMatcher2.reset();
        }
        instruction.accept(clazz, method, codeAttribute, n, instructionSequenceMatcher2);
        if (instructionSequenceMatcher2.isMatching()) {
            this.printDynamicInvocationNote(clazz, instructionSequenceMatcher2, bl, bl2);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencedClass = ClassUtil.isInternalArrayType(classConstant.getName(clazz)) ? null : classConstant.referencedClass;
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (this.referencedClass != null) {
            Member member;
            String string = stringConstant.getString(clazz);
            Member member2 = this.isDeclared ? (this.isField ? this.referencedClass.findField(string, null) : this.referencedClass.findMethod(string, null)) : (member = this.memberFinder.findMember(clazz, this.referencedClass, string, null, this.isField));
            if (member != null) {
                stringConstant.referencedMember = member;
                stringConstant.referencedClass = this.isDeclared ? this.referencedClass : this.memberFinder.correspondingClass();
            }
        }
    }

    private void printDynamicInvocationNote(Clazz clazz, InstructionSequenceMatcher instructionSequenceMatcher, boolean bl, boolean bl2) {
        if (this.notePrinter != null) {
            StringMatcher stringMatcher = bl ? this.noteFieldExceptionMatcher : this.noteMethodExceptionMatcher;
            int n = instructionSequenceMatcher.matchedConstantIndex(0x40000001);
            String string = clazz.getStringString(n);
            if (stringMatcher == null || !stringMatcher.matches(string)) {
                ClassVisitor classVisitor;
                String string2 = string;
                if (!bl) {
                    string2 = string2 + '(';
                    for (int i = 0; i < 2; ++i) {
                        int n2 = instructionSequenceMatcher.matchedConstantIndex(0x40000003 + i);
                        if (n2 <= 0) continue;
                        if (i > 0) {
                            string2 = string2 + ',';
                        }
                        String string3 = clazz.getClassName(n2);
                        string2 = string2 + (ClassUtil.isInternalArrayType(string3) ? ClassUtil.externalType(string3) : ClassUtil.externalClassName(string3));
                    }
                    string2 = string2 + ')';
                }
                this.notePrinter.print("Note: " + ClassUtil.externalClassName(clazz.getName()) + " accesses a " + (bl2 ? "declared " : "") + (bl ? "field" : "method") + " '" + string2 + "' dynamically");
                if (bl) {
                    classVisitor = new AllFieldVisitor(new MemberNameFilter(string, this));
                } else {
                    String string4 = "(";
                    for (int i = 0; i < 2; ++i) {
                        int n3 = instructionSequenceMatcher.matchedConstantIndex(0x40000003 + i);
                        if (n3 <= 0) continue;
                        if (i > 0) {
                            string4 = string4 + ',';
                        }
                        String string5 = clazz.getClassName(n3);
                        string4 = string4 + (ClassUtil.isInternalArrayType(string5) ? string5 : ClassUtil.internalTypeFromClassName(string5));
                    }
                    string4 = string4 + ")L///;";
                    classVisitor = new AllMethodVisitor(new MemberNameFilter(string, new MemberDescriptorFilter(string4, this)));
                }
                this.programClassPool.classesAcceptAlphabetically(classVisitor);
                this.libraryClassPool.classesAcceptAlphabetically(classVisitor);
            }
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        System.out.println("      Maybe this is program field '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + "; }'");
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        System.out.println("      Maybe this is program method '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(null, 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + "; }'");
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        System.out.println("      Maybe this is library field '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)) + "; }'");
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        System.out.println("      Maybe this is library method '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(null, 0, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)) + "; }'");
    }
}

