/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.MutableValue;
import proguard.evaluation.Variables;
import proguard.evaluation.value.Value;

public class TracedVariables
extends Variables {
    public static final int NONE = -1;
    private Value producerValue;
    private Value collectedProducerValue;
    private final Variables producerVariables;
    private final Variables consumerVariables;
    private int initializationIndex;

    public TracedVariables(int n) {
        super(n);
        this.producerVariables = new Variables(n);
        this.consumerVariables = new Variables(n);
    }

    public TracedVariables(TracedVariables tracedVariables) {
        super(tracedVariables);
        this.producerVariables = new Variables(tracedVariables.producerVariables);
        this.consumerVariables = new Variables(tracedVariables.consumerVariables);
    }

    public void setProducerValue(Value value) {
        this.producerValue = value;
    }

    public void setCollectedProducerValue(Value value) {
        this.collectedProducerValue = value;
    }

    public Value getCollectedProducerValue() {
        return this.collectedProducerValue;
    }

    public void resetInitialization() {
        this.initializationIndex = -1;
    }

    public int getInitializationIndex() {
        return this.initializationIndex;
    }

    public Value getProducerValue(int n) {
        return this.producerVariables.getValue(n);
    }

    public void setProducerValue(int n, Value value) {
        this.producerVariables.store(n, value);
    }

    public Value getConsumerValue(int n) {
        return ((MutableValue)this.consumerVariables.getValue(n)).getContainedValue();
    }

    public void setConsumerValue(int n, Value value) {
        ((MutableValue)this.consumerVariables.getValue(n)).setContainedValue(value);
        this.consumerVariables.store(n, new MutableValue());
    }

    public void reset(int n) {
        super.reset(n);
        this.producerVariables.reset(n);
        this.consumerVariables.reset(n);
    }

    public void initialize(TracedVariables tracedVariables) {
        super.initialize(tracedVariables);
        this.producerVariables.initialize(tracedVariables.producerVariables);
        this.consumerVariables.initialize(tracedVariables.consumerVariables);
    }

    public boolean generalize(TracedVariables tracedVariables, boolean bl) {
        boolean bl2 = super.generalize(tracedVariables, bl);
        boolean bl3 = this.producerVariables.generalize(tracedVariables.producerVariables, bl);
        if (bl2) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] != null) continue;
                this.producerVariables.values[i] = null;
                this.consumerVariables.values[i] = null;
                if (!bl) continue;
                tracedVariables.producerVariables.values[i] = null;
                tracedVariables.consumerVariables.values[i] = null;
            }
        }
        return bl2 || bl3;
    }

    public void store(int n, Value value) {
        Value value2 = super.load(n);
        if (value2 == null || value2.computationalType() != value.computationalType()) {
            this.initializationIndex = n;
        }
        super.store(n, value);
        this.producerVariables.store(n, this.producerValue);
        MutableValue mutableValue = new MutableValue();
        this.consumerVariables.store(n, mutableValue);
        if (value.isCategory2()) {
            this.producerVariables.store(n + 1, this.producerValue);
            this.consumerVariables.store(n + 1, mutableValue);
        }
    }

    public Value load(int n) {
        if (this.collectedProducerValue != null) {
            this.collectedProducerValue = this.collectedProducerValue.generalize(this.producerVariables.load(n));
        }
        ((MutableValue)this.consumerVariables.load(n)).generalizeContainedValue(this.producerValue);
        return super.load(n);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedVariables tracedVariables = (TracedVariables)object;
        return super.equals(object) && this.producerVariables.equals(tracedVariables.producerVariables);
    }

    public int hashCode() {
        return super.hashCode() ^ this.producerVariables.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.producerVariables.getValue(i);
            Value value3 = this.consumerVariables.getValue(i);
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty" : value2.toString()).append('>').append(value == null ? "empty" : value.toString()).append('>').append(value3 == null ? "empty" : value3.toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

