/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class MethodDescriptorShrinker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraParameterMemberVisitor;
    private final ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();

    public MethodDescriptorShrinker() {
        this(null);
    }

    public MethodDescriptorShrinker(MemberVisitor memberVisitor) {
        this.extraParameterMemberVisitor = memberVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string;
        String string2 = programMethod.getDescriptor(programClass);
        if (!string2.equals(string = MethodDescriptorShrinker.shrinkDescriptor(programClass, programMethod))) {
            String string3;
            programMethod.attributesAccept(programClass, this);
            String string4 = programMethod.getName(programClass);
            if (string4.equals("<init>")) {
                if (programClass.findMethod(string4, string) != null) {
                    ParameterUsageMarker.markUsedParameters(programMethod, -1L);
                    return;
                }
                string3 = string4;
            } else {
                string3 = string4 + '$' + Long.toHexString(Math.abs(string2.hashCode()));
            }
            if (!string3.equals(string4)) {
                programMethod.u2nameIndex = this.constantPoolEditor.addUtf8Constant(programClass, string3);
            }
            MethodDescriptorShrinker.shrinkReferencedClasses(programClass, programMethod);
            programMethod.u2descriptorIndex = this.constantPoolEditor.addUtf8Constant(programClass, string);
            if (this.extraParameterMemberVisitor != null) {
                this.extraParameterMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int[] nArray = parameterAnnotationsAttribute.u2parameterAnnotationsCount;
        Annotation[][] annotationArray = parameterAnnotationsAttribute.parameterAnnotations;
        int n = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
        int n2 = 0;
        int n3 = 0;
        String string = method.getDescriptor(clazz);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, n)) {
                nArray[n3] = nArray[n2];
                annotationArray[n3++] = annotationArray[n2];
            }
            ++n2;
            n += ClassUtil.isInternalCategory2Type(string2) ? 2 : 1;
        }
        parameterAnnotationsAttribute.u2parametersCount = n3;
        while (n3 < n2) {
            nArray[n3] = 0;
            annotationArray[n3++] = null;
        }
    }

    public static String shrinkDescriptor(ProgramClass programClass, ProgramMethod programMethod) {
        int n = (programMethod.getAccessFlags() & 8) != 0 ? 0 : 1;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(programMethod.getDescriptor(programClass));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(programMethod, n)) {
                stringBuffer.append(string);
            }
            n += ClassUtil.isInternalCategory2Type(string) ? 2 : 1;
        }
        stringBuffer.append(')');
        stringBuffer.append(internalTypeEnumeration.returnType());
        return stringBuffer.toString();
    }

    private static void shrinkReferencedClasses(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz[] clazzArray = programMethod.referencedClasses;
        if (clazzArray != null) {
            String string;
            int n = (programMethod.getAccessFlags() & 8) != 0 ? 0 : 1;
            int n2 = 0;
            int n3 = 0;
            String string2 = programMethod.getDescriptor(programClass);
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string2);
            while (internalTypeEnumeration.hasMoreTypes()) {
                string = internalTypeEnumeration.nextType();
                if (ClassUtil.isInternalArrayType(string)) {
                    string = ClassUtil.internalTypeFromArrayType(string);
                }
                if (ClassUtil.isInternalClassType(string)) {
                    if (ParameterUsageMarker.isParameterUsed(programMethod, n)) {
                        clazzArray[n3++] = clazzArray[n2];
                    }
                    ++n2;
                }
                n += ClassUtil.isInternalCategory2Type(string) ? 2 : 1;
            }
            string = internalTypeEnumeration.returnType();
            if (ClassUtil.isInternalArrayType(string)) {
                string = ClassUtil.internalTypeFromArrayType(string);
            }
            if (ClassUtil.isInternalClassType(string)) {
                clazzArray[n3++] = clazzArray[n2];
                ++n2;
            }
            while (n3 < n2) {
                clazzArray[n3++] = null;
            }
        }
    }
}

