/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicBranchUnit;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Processor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.TracedBranchUnit;
import proguard.optimize.peephole.BranchTargetFinder;

public class PartialEvaluator
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int MAXIMUM_EVALUATION_COUNT = 5;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int AT_CATCH_ENTRY = -1;
    private final ValueFactory valueFactory;
    private final InvocationUnit invocationUnit;
    private final boolean evaluateAllCode;
    private InstructionOffsetValue[] varProducerValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] stackProducerValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[1024];
    private TracedVariables[] variablesBefore = new TracedVariables[1024];
    private TracedStack[] stacksBefore = new TracedStack[1024];
    private TracedVariables[] variablesAfter = new TracedVariables[1024];
    private TracedStack[] stacksAfter = new TracedStack[1024];
    private boolean[] generalizedContexts = new boolean[1024];
    private int[] evaluationCounts = new int[1024];
    private int[] initializedVariables = new int[1024];
    private boolean evaluateExceptions;
    private final BasicBranchUnit branchUnit;
    private final BranchTargetFinder branchTargetFinder = new BranchTargetFinder();

    public PartialEvaluator() {
        this(new ValueFactory(), new BasicInvocationUnit(), true);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean bl) {
        this.valueFactory = valueFactory;
        this.invocationUnit = invocationUnit;
        this.evaluateAllCode = bl;
        this.branchUnit = bl ? new BasicBranchUnit() : new TracedBranchUnit();
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while performing partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        TracedVariables tracedVariables = new TracedVariables(codeAttribute.u2maxLocals);
        TracedStack tracedStack = new TracedStack(codeAttribute.u2maxStack);
        this.initializeVariables(clazz, method, codeAttribute, tracedVariables, tracedStack);
        codeAttribute.accept(clazz, method, (AttributeVisitor)this.branchTargetFinder);
        this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, 0);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.evaluateExceptions);
    }

    public boolean isTraced(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isTraced(int n) {
        return this.evaluationCounts[n] > 0;
    }

    public boolean isBranchOrExceptionTarget(int n) {
        return this.branchTargetFinder.isBranchTarget(n) || this.branchTargetFinder.isExceptionHandler(n);
    }

    public boolean isSubroutine(int n) {
        return this.branchTargetFinder.isSubroutine(n);
    }

    public boolean isSubroutineReturning(int n) {
        return this.branchTargetFinder.isSubroutineReturning(n);
    }

    public int subroutineEnd(int n) {
        return this.branchTargetFinder.subroutineEnd(n);
    }

    public int initializationOffset(int n) {
        return this.branchTargetFinder.initializationOffset(n);
    }

    public boolean isInitializer() {
        return this.branchTargetFinder.isInitializer();
    }

    public int superInitializationOffset() {
        return this.branchTargetFinder.superInitializationOffset();
    }

    public int creationOffset(int n) {
        return this.branchTargetFinder.creationOffset(n);
    }

    public TracedVariables getVariablesBefore(int n) {
        return this.variablesBefore[n];
    }

    public TracedVariables getVariablesAfter(int n) {
        return this.variablesAfter[n];
    }

    public InstructionOffsetValue varProducerOffsets(int n) {
        return this.varProducerValues[n];
    }

    public TracedStack getStackBefore(int n) {
        return this.stacksBefore[n];
    }

    public TracedStack getStackAfter(int n) {
        return this.stacksAfter[n];
    }

    public InstructionOffsetValue stackProducerOffsets(int n) {
        return this.stackProducerValues[n];
    }

    public InstructionOffsetValue branchOrigins(int n) {
        return this.branchOriginValues[n];
    }

    public InstructionOffsetValue branchTargets(int n) {
        return this.branchTargetValues[n];
    }

    public int initializedVariable(int n) {
        return this.initializedVariables[n];
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        int n2 = exceptionInfo.u2endPC;
        if (this.isTraced(n, n2)) {
            int n3 = exceptionInfo.u2handlerPC;
            int n4 = exceptionInfo.u2catchType;
            TracedVariables tracedVariables = new TracedVariables(codeAttribute.u2maxLocals);
            TracedStack tracedStack = new TracedStack(codeAttribute.u2maxStack);
            InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(-1);
            tracedVariables.setProducerValue(instructionOffsetValue);
            tracedStack.setProducerValue(instructionOffsetValue);
            this.generalizeVariables(n, n2, this.evaluateAllCode, tracedVariables);
            String string = n4 != 0 ? clazz.getClassName(n4) : "java/lang/Throwable";
            Clazz clazz2 = n4 != 0 ? ((ClassConstant)((ProgramClass)clazz).getConstant((int)n4)).referencedClass : null;
            tracedStack.push(this.valueFactory.createReferenceValue(string, clazz2, false));
            int n5 = this.evaluationCounts[n3];
            this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n3);
            if (!this.evaluateExceptions) {
                this.evaluateExceptions = n5 < this.evaluationCounts[n3];
            }
        } else if (this.evaluateAllCode) {
            this.evaluateExceptions = true;
        }
    }

    private void pushInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n, Stack stack) {
        stack.push(new MyInstructionBlock(tracedVariables, tracedStack, n));
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        Stack stack = new Stack();
        this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n, stack);
        while (!stack.empty()) {
            MyInstructionBlock myInstructionBlock = (MyInstructionBlock)stack.pop();
            this.evaluateInstructionBlock(clazz, method, codeAttribute, myInstructionBlock.variables, myInstructionBlock.stack, myInstructionBlock.startOffset, stack);
        }
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n, Stack stack) {
        block19: {
            int n2;
            Instruction instruction;
            byte[] byArray = codeAttribute.code;
            Processor processor = new Processor(tracedVariables, tracedStack, this.valueFactory, this.branchUnit, this.invocationUnit);
            int n3 = n;
            int n4 = n;
            do {
                int n5;
                if (n4 < n3) {
                    n4 = n3;
                }
                if ((n5 = this.evaluationCounts[n3]) == 0) {
                    if (this.variablesBefore[n3] == null) {
                        this.variablesBefore[n3] = new TracedVariables(tracedVariables);
                        this.stacksBefore[n3] = new TracedStack(tracedStack);
                    } else {
                        this.variablesBefore[n3].initialize(tracedVariables);
                        this.stacksBefore[n3].copy(tracedStack);
                    }
                    this.generalizedContexts[n3] = true;
                } else {
                    boolean bl = this.variablesBefore[n3].generalize(tracedVariables, true);
                    boolean bl2 = this.stacksBefore[n3].generalize(tracedStack);
                    if (!bl && !bl2 && this.generalizedContexts[n3]) break block19;
                    if (n5 >= 5) {
                        tracedVariables.generalize(this.variablesBefore[n3], false);
                        tracedStack.generalize(this.stacksBefore[n3]);
                        this.generalizedContexts[n3] = true;
                    } else {
                        this.generalizedContexts[n3] = false;
                    }
                }
                int n6 = n3;
                this.evaluationCounts[n6] = this.evaluationCounts[n6] + 1;
                InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(n3);
                tracedVariables.setProducerValue(instructionOffsetValue);
                tracedStack.setProducerValue(instructionOffsetValue);
                InstructionOffsetValue instructionOffsetValue2 = InstructionOffsetValue.EMPTY_VALUE;
                tracedVariables.setCollectedProducerValue(instructionOffsetValue2);
                tracedStack.setCollectedProducerValue(instructionOffsetValue2);
                tracedVariables.resetInitialization();
                instruction = InstructionFactory.create(byArray, n3);
                int n7 = n3 + instruction.length(n3);
                InstructionOffsetValue instructionOffsetValue3 = new InstructionOffsetValue(n7);
                this.branchUnit.resetCalled();
                this.branchUnit.setTraceBranchTargets(instructionOffsetValue3);
                try {
                    instruction.accept(clazz, method, codeAttribute, n3, processor);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Unexpected error while evaluating instruction:");
                    System.err.println("  Class       = [" + clazz.getName() + "]");
                    System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
                    System.err.println("  Instruction = " + instruction.toString(n3));
                    System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
                    throw runtimeException;
                }
                InstructionOffsetValue instructionOffsetValue4 = tracedVariables.getCollectedProducerValue().instructionOffsetValue();
                InstructionOffsetValue instructionOffsetValue5 = tracedStack.getCollectedProducerValue().instructionOffsetValue();
                this.varProducerValues[n3] = this.varProducerValues[n3].generalize(instructionOffsetValue4).instructionOffsetValue();
                this.stackProducerValues[n3] = this.stackProducerValues[n3].generalize(instructionOffsetValue5).instructionOffsetValue();
                this.initializedVariables[n3] = tracedVariables.getInitializationIndex();
                InstructionOffsetValue instructionOffsetValue6 = this.branchUnit.getTraceBranchTargets();
                int n8 = instructionOffsetValue6.instructionOffsetCount();
                tracedVariables.setCollectedProducerValue(instructionOffsetValue2);
                tracedStack.setCollectedProducerValue(instructionOffsetValue2);
                this.branchUnit.setTraceBranchTargets(instructionOffsetValue2);
                if (n5 == 0) {
                    if (this.variablesAfter[n3] == null) {
                        this.variablesAfter[n3] = new TracedVariables(tracedVariables);
                        this.stacksAfter[n3] = new TracedStack(tracedStack);
                    } else {
                        this.variablesAfter[n3].initialize(tracedVariables);
                        this.stacksAfter[n3].copy(tracedStack);
                    }
                } else {
                    this.variablesAfter[n3].generalize(tracedVariables, true);
                    this.stacksAfter[n3].generalize(tracedStack);
                }
                if (this.branchUnit.wasCalled()) {
                    InstructionOffsetValue instructionOffsetValue7 = this.branchTargetValues[n3] = this.branchTargetValues[n3] == null ? instructionOffsetValue6 : this.branchTargetValues[n3].generalize(instructionOffsetValue6).instructionOffsetValue();
                    if (n8 == 0) break block19;
                    InstructionOffsetValue instructionOffsetValue8 = new InstructionOffsetValue(n3);
                    for (n2 = 0; n2 < n8; ++n2) {
                        int n9 = instructionOffsetValue6.instructionOffset(n2);
                        this.branchOriginValues[n9] = this.branchOriginValues[n9] == null ? instructionOffsetValue8 : this.branchOriginValues[n9].generalize(instructionOffsetValue8).instructionOffsetValue();
                    }
                    if (n8 > 1) {
                        for (n2 = 0; n2 < n8; ++n2) {
                            this.pushInstructionBlock(new TracedVariables(tracedVariables), new TracedStack(tracedStack), instructionOffsetValue6.instructionOffset(n2), stack);
                        }
                        break block19;
                    }
                }
                n3 = instructionOffsetValue6.instructionOffset(0);
            } while (instruction.opcode != -88 && instruction.opcode != -55);
            int n10 = this.branchTargetFinder.subroutineEnd(n3);
            for (n2 = n3; n2 < n10; ++n2) {
                if (!this.branchTargetFinder.isInstruction(n2)) continue;
                this.evaluationCounts[n2] = 0;
            }
            this.evaluateInstructionBlock(clazz, method, codeAttribute, new TracedVariables(tracedVariables), new TracedStack(tracedStack), n3);
            codeAttribute.exceptionsAccept(clazz, method, n3, n10, this);
        }
    }

    private void initializeVariables(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack) {
        int n;
        int n2 = codeAttribute.u4codeLength;
        if (this.variablesAfter.length < n2) {
            this.varProducerValues = new InstructionOffsetValue[n2];
            this.stackProducerValues = new InstructionOffsetValue[n2];
            this.branchOriginValues = new InstructionOffsetValue[n2];
            this.branchTargetValues = new InstructionOffsetValue[n2];
            this.variablesBefore = new TracedVariables[n2];
            this.stacksBefore = new TracedStack[n2];
            this.variablesAfter = new TracedVariables[n2];
            this.stacksAfter = new TracedStack[n2];
            this.generalizedContexts = new boolean[n2];
            this.evaluationCounts = new int[n2];
            this.initializedVariables = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.varProducerValues[n] = InstructionOffsetValue.EMPTY_VALUE;
                this.stackProducerValues[n] = InstructionOffsetValue.EMPTY_VALUE;
                this.initializedVariables[n] = -2;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.varProducerValues[n] = InstructionOffsetValue.EMPTY_VALUE;
                this.stackProducerValues[n] = InstructionOffsetValue.EMPTY_VALUE;
                this.branchOriginValues[n] = null;
                this.branchTargetValues[n] = null;
                this.generalizedContexts[n] = false;
                this.evaluationCounts[n] = 0;
                this.initializedVariables[n] = -2;
                if (this.variablesBefore[n] != null) {
                    this.variablesBefore[n].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksBefore[n] != null) {
                    this.stacksBefore[n].reset(codeAttribute.u2maxStack);
                }
                if (this.variablesAfter[n] != null) {
                    this.variablesAfter[n].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksAfter[n] == null) continue;
                this.stacksAfter[n].reset(codeAttribute.u2maxStack);
            }
        }
        TracedVariables tracedVariables2 = new TracedVariables(codeAttribute.u2maxLocals);
        InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(-1);
        tracedVariables2.setProducerValue(instructionOffsetValue);
        InstructionOffsetValue instructionOffsetValue2 = InstructionOffsetValue.EMPTY_VALUE;
        tracedVariables2.setCollectedProducerValue(instructionOffsetValue2);
        this.invocationUnit.enterMethod(clazz, method, tracedVariables2);
        tracedVariables.initialize(tracedVariables2);
        InstructionOffsetValue instructionOffsetValue3 = new InstructionOffsetValue(-1);
        for (int i = 0; i < tracedVariables2.size(); ++i) {
            tracedVariables.setProducerValue(i, instructionOffsetValue3);
        }
    }

    private void generalizeVariables(int n, int n2, boolean bl, TracedVariables tracedVariables) {
        boolean bl2 = true;
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            TracedVariables tracedVariables2 = this.variablesBefore[i];
            if (bl2) {
                tracedVariables.initialize(tracedVariables2);
                bl2 = false;
            } else {
                tracedVariables.generalize(tracedVariables2, false);
            }
            n3 = i;
        }
        if (bl && n3 >= 0) {
            TracedVariables tracedVariables3 = this.variablesAfter[n3];
            if (bl2) {
                tracedVariables.initialize(tracedVariables3);
            } else {
                tracedVariables.generalize(tracedVariables3, false);
            }
        }
        if (bl2) {
            tracedVariables.reset(tracedVariables.size());
        }
    }

    private static class MyInstructionBlock {
        private TracedVariables variables;
        private TracedStack stack;
        private int startOffset;

        private MyInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
            this.variables = tracedVariables;
            this.stack = tracedStack;
            this.startOffset = n;
        }
    }
}

