/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Browser
extends JFrame
implements ServiceListener,
ServiceTypeListener,
ListSelectionListener {
    JmDNS jmdns;
    Vector headers;
    String type;
    DefaultListModel types;
    JList typeList;
    DefaultListModel services;
    JList serviceList;
    JTextArea info;

    Browser(JmDNS jmdns) throws IOException {
        super("JmDNS Browser");
        this.jmdns = jmdns;
        Color bg = new Color(230, 230, 230);
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        Container content = this.getContentPane();
        content.setLayout(new GridLayout(1, 3));
        this.types = new DefaultListModel();
        this.typeList = new JList(this.types);
        this.typeList.setBorder(border);
        this.typeList.setBackground(bg);
        this.typeList.setSelectionMode(0);
        this.typeList.addListSelectionListener(this);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BorderLayout());
        typePanel.add("North", new JLabel("Types"));
        typePanel.add("Center", new JScrollPane(this.typeList, 20, 30));
        content.add(typePanel);
        this.services = new DefaultListModel();
        this.serviceList = new JList(this.services);
        this.serviceList.setBorder(border);
        this.serviceList.setBackground(bg);
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(this);
        JPanel servicePanel = new JPanel();
        servicePanel.setLayout(new BorderLayout());
        servicePanel.add("North", new JLabel("Services"));
        servicePanel.add("Center", new JScrollPane(this.serviceList, 20, 30));
        content.add(servicePanel);
        this.info = new JTextArea();
        this.info.setBorder(border);
        this.info.setBackground(bg);
        this.info.setEditable(false);
        this.info.setLineWrap(true);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.add("North", new JLabel("Details"));
        infoPanel.add("Center", new JScrollPane(this.info, 20, 30));
        content.add(infoPanel);
        this.setDefaultCloseOperation(3);
        this.setLocation(100, 100);
        this.setSize(600, 400);
        jmdns.addServiceTypeListener(this);
        String[] list = new String[]{"_http._tcp.local.", "_ftp._tcp.local.", "_tftp._tcp.local.", "_ssh._tcp.local.", "_smb._tcp.local.", "_printer._tcp.local.", "_airport._tcp.local.", "_afpovertcp._tcp.local.", "_ichat._tcp.local.", "_eppc._tcp.local.", "_presence._tcp.local."};
        for (int i = 0; i < list.length; ++i) {
            jmdns.registerServiceType(list[i]);
        }
        this.show();
    }

    public void serviceAdded(ServiceEvent event) {
        final String name = event.getName();
        System.out.println("ADD: " + name);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.insertSorted(Browser.this.services, name);
            }
        });
    }

    public void serviceRemoved(ServiceEvent event) {
        final String name = event.getName();
        System.out.println("REMOVE: " + name);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.services.removeElement(name);
            }
        });
    }

    public void serviceTypeAdded(ServiceEvent event) {
        final String type = event.getType();
        System.out.println("TYPE: " + type);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.insertSorted(Browser.this.types, type);
            }
        });
    }

    void insertSorted(DefaultListModel model, String value) {
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            if (value.compareToIgnoreCase((String)model.elementAt(i)) >= 0) continue;
            model.insertElementAt(value, i);
            return;
        }
        model.addElement(value);
    }

    public void serviceResolved(ServiceEvent event) {
        String name = event.getName();
        String type = event.getType();
        ServiceInfo info = event.getInfo();
        if (name.equals(this.serviceList.getSelectedValue())) {
            if (info == null) {
                this.info.setText("service not found");
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(name);
                buf.append('.');
                buf.append(type);
                buf.append('\n');
                buf.append(info.getServer());
                buf.append(':');
                buf.append(info.getPort());
                buf.append('\n');
                buf.append(info.getAddress());
                buf.append(':');
                buf.append(info.getPort());
                buf.append('\n');
                Enumeration names = info.getPropertyNames();
                while (names.hasMoreElements()) {
                    String prop = (String)names.nextElement();
                    buf.append(prop);
                    buf.append('=');
                    buf.append(info.getPropertyString(prop));
                    buf.append('\n');
                }
                this.info.setText(buf.toString());
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (e.getSource() == this.typeList) {
                this.type = (String)this.typeList.getSelectedValue();
                this.jmdns.removeServiceListener(this.type, this);
                this.services.setSize(0);
                this.info.setText("");
                if (this.type != null) {
                    this.jmdns.addServiceListener(this.type, this);
                }
            } else if (e.getSource() == this.serviceList) {
                String name = (String)this.serviceList.getSelectedValue();
                if (name == null) {
                    this.info.setText("");
                } else {
                    System.out.println(this + " valueChanged() type:" + this.type + " name:" + name);
                    System.out.flush();
                    ServiceInfo service = this.jmdns.getServiceInfo(this.type, name);
                    if (service == null) {
                        this.info.setText("service not found");
                    } else {
                        this.jmdns.requestServiceInfo(this.type, name);
                    }
                }
            }
        }
    }

    public String toString() {
        return "RVBROWSER";
    }

    public static void main(String[] argv) throws IOException {
        new Browser(new JmDNS());
    }

    class ServiceTableModel
    extends AbstractTableModel {
        ServiceTableModel() {
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "service";
                }
                case 1: {
                    return "address";
                }
                case 2: {
                    return "port";
                }
                case 3: {
                    return "text";
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return Browser.this.services.size();
        }

        public Object getValueAt(int row, int col) {
            return Browser.this.services.elementAt(row);
        }
    }
}

