/*
 * Decompiled with CFR 0.152.
 */
package javancss.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import ccl.xml.XMLUtil;
import java.io.File;
import javancss.Javancss;
import javancss.XmlFormatter;

public class XmlFormatterTest
extends Test {
    private String _sTestDir = null;

    private void _checkParsing() throws Exception {
        Javancss pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test57.java"));
        pJavancss.setXML(true);
        String sXML = XmlFormatter.printStart() + pJavancss.printPackageNcss() + pJavancss.printObjectNcss() + pJavancss.printFunctionNcss() + pJavancss.printJavaNcss() + XmlFormatter.printEnd();
        String sXSLTFile = FileUtil.concatPath(this._sTestDir, ".." + File.separator + "xslt" + File.separator + "xmltest.xsl");
        try {
            String sText = XMLUtil.getXML(sXML, new File(sXSLTFile));
            this.Assert(sText.equals("79"), sText);
        }
        catch (NoClassDefFoundError error) {
            Util.print("skipped: 'xalan.jar' and or 'xerces.jar' library missing.");
        }
        pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test117.java"));
        pJavancss.setXML(true);
        sXML = XmlFormatter.printStart() + pJavancss.printPackageNcss() + pJavancss.printObjectNcss() + pJavancss.printFunctionNcss() + pJavancss.printJavaNcss() + XmlFormatter.printEnd();
        this.Assert(!Util.isEmpty(sXML));
        pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test118.java"));
        pJavancss.setXML(true);
        sXML = XmlFormatter.printStart() + pJavancss.printPackageNcss() + pJavancss.printObjectNcss() + pJavancss.printFunctionNcss() + pJavancss.printJavaNcss() + XmlFormatter.printEnd();
        this.Assert(!Util.isEmpty(sXML));
    }

    private void _checkXML2Text() throws Exception {
        Javancss pJavancss = new Javancss(FileUtil.concatPath(this._sTestDir, "Test32.java"));
        pJavancss.setXML(true);
        String sXML = XmlFormatter.printStart() + pJavancss.printPackageNcss() + pJavancss.printObjectNcss() + pJavancss.printFunctionNcss() + pJavancss.printJavaNcss() + XmlFormatter.printEnd();
        String sXSLTFile = FileUtil.concatPath(this._sTestDir, ".." + File.separator + "xslt" + File.separator + "javancss2text.xsl");
        try {
            String sText = XMLUtil.getXML(sXML, new File(sXSLTFile));
            FileUtil.writeFile("/tmp/t", sText);
            String sCompare = FileUtil.readFile(FileUtil.concatPath(this._sTestDir, "Output32.txt"));
            this.Assert(sText.equals(sCompare), sText);
        }
        catch (NoClassDefFoundError error) {
            Util.print("skipped: 'xalan.jar' and or 'xerces.jar' library missing.");
        }
    }

    public XmlFormatterTest() {
    }

    public XmlFormatterTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        this._checkParsing();
        this._checkXML2Text();
    }

    public static void main(String[] asArg_) {
        XmlFormatterTest pTest = new XmlFormatterTest();
        pTest.setVerbose(true);
        pTest.run();
        pTest.printResult();
        System.exit(0);
    }

    public void setTestDir(String sTestDir_) {
        this._sTestDir = sTestDir_;
    }
}

