/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

public class SigningDigest
implements SmbConstants {
    static LogStream log = LogStream.getInstance();
    private MessageDigest digest;
    private byte[] macSigningKey;
    private int updates;
    private int signSequence;

    public SigningDigest(SmbTransport transport, NtlmPasswordAuthentication auth) throws SmbException {
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            if (LogStream.level > 0) {
                ex.printStackTrace(log);
            }
            throw new SmbException("MD5", (Throwable)ex);
        }
        try {
            switch (LM_COMPATIBILITY) {
                case 0: 
                case 1: 
                case 2: {
                    this.macSigningKey = new byte[40];
                    auth.getUserSessionKey(transport.server.encryptionKey, this.macSigningKey, 0);
                    System.arraycopy(auth.getUnicodeHash(transport.server.encryptionKey), 0, this.macSigningKey, 16, 24);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.macSigningKey = new byte[16];
                    auth.getUserSessionKey(transport.server.encryptionKey, this.macSigningKey, 0);
                    break;
                }
                default: {
                    this.macSigningKey = new byte[40];
                    auth.getUserSessionKey(transport.server.encryptionKey, this.macSigningKey, 0);
                    System.arraycopy(auth.getUnicodeHash(transport.server.encryptionKey), 0, this.macSigningKey, 16, 24);
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new SmbException("", (Throwable)ex);
        }
        if (LogStream.level >= 5) {
            log.println("LM_COMPATIBILITY=" + LM_COMPATIBILITY);
            Hexdump.hexdump(log, this.macSigningKey, 0, this.macSigningKey.length);
        }
    }

    public void update(byte[] input, int offset, int len) {
        if (LogStream.level >= 5) {
            log.println("update: " + this.updates + " " + offset + ":" + len);
            Hexdump.hexdump(log, input, offset, Math.min(len, 256));
            log.flush();
        }
        if (len == 0) {
            return;
        }
        this.digest.update(input, offset, len);
        ++this.updates;
    }

    public byte[] digest() {
        byte[] b = this.digest.digest();
        if (LogStream.level >= 5) {
            log.println("digest: ");
            Hexdump.hexdump(log, b, 0, b.length);
            log.flush();
        }
        this.updates = 0;
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sign(byte[] data, int offset, int length, ServerMessageBlock request, ServerMessageBlock response) {
        request.signSeq = this.signSequence;
        if (response != null) {
            response.signSeq = this.signSequence + 1;
            response.verifyFailed = false;
        }
        try {
            this.update(this.macSigningKey, 0, this.macSigningKey.length);
            int index = offset + 14;
            for (int i = 0; i < 8; ++i) {
                data[index + i] = 0;
            }
            ServerMessageBlock.writeInt4(this.signSequence, data, index);
            this.update(data, offset, length);
            System.arraycopy(this.digest(), 0, data, index, 8);
        }
        catch (Exception ex) {
            if (LogStream.level > 0) {
                ex.printStackTrace(log);
            }
        }
        finally {
            this.signSequence += 2;
        }
    }

    boolean verify(byte[] data, int offset, ServerMessageBlock response) {
        this.update(this.macSigningKey, 0, this.macSigningKey.length);
        int index = offset;
        this.update(data, index, 14);
        index += 14;
        byte[] sequence = new byte[8];
        ServerMessageBlock.writeInt4(response.signSeq, sequence, 0);
        this.update(sequence, 0, sequence.length);
        index += 8;
        if (response.command == 46) {
            SmbComReadAndXResponse raxr = (SmbComReadAndXResponse)response;
            int length = response.length - raxr.dataLength;
            this.update(data, index, length - 14 - 8);
            this.update(raxr.b, raxr.off, raxr.dataLength);
        } else {
            this.update(data, index, response.length - 14 - 8);
        }
        byte[] signature = this.digest();
        for (int i = 0; i < 8; ++i) {
            if (signature[i] == data[offset + 14 + i]) continue;
            if (LogStream.level >= 2) {
                log.println("signature verification failure");
                Hexdump.hexdump(log, signature, 0, 8);
                Hexdump.hexdump(log, data, offset + 14, 8);
            }
            response.verifyFailed = true;
            return true;
        }
        response.verifyFailed = false;
        return false;
    }

    public String toString() {
        return "LM_COMPATIBILITY=" + LM_COMPATIBILITY + " MacSigningKey=" + Hexdump.toHexString(this.macSigningKey, 0, this.macSigningKey.length);
    }
}

