/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbTransport;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class SmbComNegotiateResponse
extends ServerMessageBlock {
    int dialectIndex;
    SmbTransport.ServerData server;

    SmbComNegotiateResponse(SmbTransport.ServerData server) {
        this.server = server;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.dialectIndex = SmbComNegotiateResponse.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.dialectIndex > 10) {
            return bufferIndex - start;
        }
        this.server.securityMode = buffer[bufferIndex++] & 0xFF;
        this.server.security = this.server.securityMode & 1;
        this.server.encryptedPasswords = (this.server.securityMode & 2) == 2;
        this.server.signaturesEnabled = (this.server.securityMode & 4) == 4;
        this.server.signaturesRequired = (this.server.securityMode & 8) == 8;
        this.server.maxMpxCount = SmbComNegotiateResponse.readInt2(buffer, bufferIndex);
        this.server.maxNumberVcs = SmbComNegotiateResponse.readInt2(buffer, bufferIndex += 2);
        this.server.maxBufferSize = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 2);
        this.server.maxRawSize = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 4);
        this.server.sessionKey = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 4);
        this.server.capabilities = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 4);
        this.server.serverTime = SmbComNegotiateResponse.readTime(buffer, bufferIndex += 4);
        this.server.serverTimeZone = SmbComNegotiateResponse.readInt2(buffer, bufferIndex += 8);
        bufferIndex += 2;
        this.server.encryptionKeyLength = buffer[bufferIndex++] & 0xFF;
        return bufferIndex - start;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.server.encryptionKey = new byte[this.server.encryptionKeyLength];
        System.arraycopy(buffer, bufferIndex, this.server.encryptionKey, 0, this.server.encryptionKeyLength);
        bufferIndex += this.server.encryptionKeyLength;
        if (this.byteCount > this.server.encryptionKeyLength) {
            int len;
            block8: {
                len = 0;
                try {
                    if ((this.flags2 & 0x8000) == 32768) {
                        while (buffer[bufferIndex + len] != 0 || buffer[bufferIndex + len + 1] != 0) {
                            if ((len += 2) <= 256) continue;
                            throw new RuntimeException("zero termination not found");
                        }
                        this.server.oemDomainName = new String(buffer, bufferIndex, len, "UnicodeLittleUnmarked");
                    } else {
                        while (buffer[bufferIndex + len] != 0) {
                            if (++len <= 256) continue;
                            throw new RuntimeException("zero termination not found");
                        }
                        this.server.oemDomainName = new String(buffer, bufferIndex, len, ServerMessageBlock.OEM_ENCODING);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    if (LogStream.level <= 1) break block8;
                    uee.printStackTrace(log);
                }
            }
            bufferIndex += len;
        } else {
            this.server.oemDomainName = new String();
        }
        return bufferIndex - start;
    }

    public String toString() {
        return new String("SmbComNegotiateResponse[" + super.toString() + ",wordCount=" + this.wordCount + ",dialectIndex=" + this.dialectIndex + ",securityMode=0x" + Hexdump.toHexString(this.server.securityMode, 1) + ",security=" + (this.server.security == 0 ? "share" : "user") + ",encryptedPasswords=" + this.server.encryptedPasswords + ",maxMpxCount=" + this.server.maxMpxCount + ",maxNumberVcs=" + this.server.maxNumberVcs + ",maxBufferSize=" + this.server.maxBufferSize + ",maxRawSize=" + this.server.maxRawSize + ",sessionKey=0x" + Hexdump.toHexString(this.server.sessionKey, 8) + ",capabilities=0x" + Hexdump.toHexString(this.server.capabilities, 8) + ",serverTime=" + new Date(this.server.serverTime) + ",serverTimeZone=" + this.server.serverTimeZone + ",encryptionKeyLength=" + this.server.encryptionKeyLength + ",byteCount=" + this.byteCount + ",encryptionKey=0x" + Hexdump.toHexString(this.server.encryptionKey, 0, this.server.encryptionKeyLength * 2) + ",oemDomainName=" + this.server.oemDomainName + "]");
    }
}

