/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Arrays;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;

class SmbComSessionSetupAndX
extends AndXServerMessageBlock {
    private static final int BATCH_LIMIT = Config.getInt("jcifs.smb.client.SessionSetupAndX.TreeConnectAndX", 1);
    private static final boolean DISABLE_PLAIN_TEXT_PASSWORDS = Config.getBoolean("jcifs.smb.client.disablePlainTextPasswords", true);
    private byte[] accountPassword;
    private byte[] unicodePassword;
    private int passwordLength;
    private int unicodePasswordLength;
    private int sessionKey;
    private String accountName;
    private String primaryDomain;
    SmbSession session;
    NtlmPasswordAuthentication auth;

    SmbComSessionSetupAndX(SmbSession session, ServerMessageBlock andx) throws SmbException {
        super(andx);
        this.command = (byte)115;
        this.session = session;
        this.auth = session.auth;
        if (this.auth.hashesExternal && !Arrays.equals(this.auth.challenge, session.transport.server.encryptionKey)) {
            throw new SmbAuthException(-1073741819);
        }
    }

    int getBatchLimit(byte command) {
        return command == 117 ? BATCH_LIMIT : 0;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.session.transport.server.security == 1 && (this.auth.hashesExternal || this.auth.password.length() > 0)) {
            if (this.session.transport.server.encryptedPasswords) {
                this.accountPassword = this.auth.getAnsiHash(this.session.transport.server.encryptionKey);
                this.passwordLength = this.accountPassword.length;
                this.unicodePassword = this.auth.getUnicodeHash(this.session.transport.server.encryptionKey);
                this.unicodePasswordLength = this.unicodePassword.length;
                if (this.unicodePasswordLength == 0 && this.passwordLength == 0) {
                    throw new RuntimeException("Null setup prohibited.");
                }
            } else {
                if (DISABLE_PLAIN_TEXT_PASSWORDS) {
                    throw new RuntimeException("Plain text passwords are disabled");
                }
                if (this.useUnicode) {
                    String password = this.auth.getPassword();
                    this.accountPassword = new byte[0];
                    this.passwordLength = 0;
                    this.unicodePassword = new byte[(password.length() + 1) * 2];
                    this.unicodePasswordLength = this.writeString(password, this.unicodePassword, 0);
                } else {
                    String password = this.auth.getPassword();
                    this.accountPassword = new byte[(password.length() + 1) * 2];
                    this.passwordLength = this.writeString(password, this.accountPassword, 0);
                    this.unicodePassword = new byte[0];
                    this.unicodePasswordLength = 0;
                }
            }
        } else {
            this.unicodePasswordLength = 0;
            this.passwordLength = 0;
        }
        this.sessionKey = this.session.transport.sessionKey;
        SmbComSessionSetupAndX.writeInt2(this.session.transport.snd_buf_size, dst, dstIndex);
        SmbComSessionSetupAndX.writeInt2(this.session.transport.maxMpxCount, dst, dstIndex += 2);
        SmbTransport cfr_ignored_0 = this.session.transport;
        SmbComSessionSetupAndX.writeInt2(1L, dst, dstIndex += 2);
        SmbComSessionSetupAndX.writeInt4(this.sessionKey, dst, dstIndex += 2);
        SmbComSessionSetupAndX.writeInt2(this.passwordLength, dst, dstIndex += 4);
        SmbComSessionSetupAndX.writeInt2(this.unicodePasswordLength, dst, dstIndex += 2);
        dstIndex += 2;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        SmbComSessionSetupAndX.writeInt4(this.session.transport.capabilities, dst, dstIndex);
        return (dstIndex += 4) - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        this.accountName = this.useUnicode ? this.auth.username : this.auth.username.toUpperCase();
        this.primaryDomain = this.auth.domain.toUpperCase();
        if (this.session.transport.server.security == 1 && (this.auth.hashesExternal || this.auth.password.length() > 0)) {
            System.arraycopy(this.accountPassword, 0, dst, dstIndex, this.passwordLength);
            if (!this.session.transport.server.encryptedPasswords && this.useUnicode && ((dstIndex += this.passwordLength) - this.headerStart) % 2 != 0) {
                dst[dstIndex++] = 0;
            }
            System.arraycopy(this.unicodePassword, 0, dst, dstIndex, this.unicodePasswordLength);
            dstIndex += this.unicodePasswordLength;
        }
        dstIndex += this.writeString(this.accountName, dst, dstIndex);
        dstIndex += this.writeString(this.primaryDomain, dst, dstIndex);
        SmbTransport cfr_ignored_0 = this.session.transport;
        dstIndex += this.writeString(SmbTransport.NATIVE_OS, dst, dstIndex);
        SmbTransport cfr_ignored_1 = this.session.transport;
        dstIndex += this.writeString(SmbTransport.NATIVE_LANMAN, dst, dstIndex);
        return dstIndex - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    public String toString() {
        SmbTransport cfr_ignored_0 = this.session.transport;
        SmbTransport cfr_ignored_1 = this.session.transport;
        SmbTransport cfr_ignored_2 = this.session.transport;
        String result = new String("SmbComSessionSetupAndX[" + super.toString() + ",snd_buf_size=" + this.session.transport.snd_buf_size + ",maxMpxCount=" + this.session.transport.maxMpxCount + ",VC_NUMBER=" + 1 + ",sessionKey=" + this.sessionKey + ",passwordLength=" + this.passwordLength + ",unicodePasswordLength=" + this.unicodePasswordLength + ",capabilities=" + this.session.transport.capabilities + ",accountName=" + this.accountName + ",primaryDomain=" + this.primaryDomain + ",NATIVE_OS=" + SmbTransport.NATIVE_OS + ",NATIVE_LANMAN=" + SmbTransport.NATIVE_LANMAN + "]");
        return result;
    }
}

