/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcShareEnum;
import jcifs.dcerpc.msrpc.MsrpcShareGetInfo;
import jcifs.netbios.NbtAddress;
import jcifs.smb.ACE;
import jcifs.smb.DfsReferral;
import jcifs.smb.DosFileFilter;
import jcifs.smb.FileEntry;
import jcifs.smb.Handler;
import jcifs.smb.Info;
import jcifs.smb.NetServerEnum2;
import jcifs.smb.NetServerEnum2Response;
import jcifs.smb.NetShareEnum;
import jcifs.smb.NetShareEnumResponse;
import jcifs.smb.NtTransQuerySecurityDesc;
import jcifs.smb.NtTransQuerySecurityDescResponse;
import jcifs.smb.NtlmAuthenticator;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SID;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComClose;
import jcifs.smb.SmbComCreateDirectory;
import jcifs.smb.SmbComDelete;
import jcifs.smb.SmbComDeleteDirectory;
import jcifs.smb.SmbComFindClose2;
import jcifs.smb.SmbComNTCreateAndX;
import jcifs.smb.SmbComNTCreateAndXResponse;
import jcifs.smb.SmbComOpenAndX;
import jcifs.smb.SmbComOpenAndXResponse;
import jcifs.smb.SmbComQueryInformation;
import jcifs.smb.SmbComQueryInformationResponse;
import jcifs.smb.SmbComReadAndX;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbComRename;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbComWrite;
import jcifs.smb.SmbComWriteAndX;
import jcifs.smb.SmbComWriteAndXResponse;
import jcifs.smb.SmbComWriteResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2FindFirst2;
import jcifs.smb.Trans2FindFirst2Response;
import jcifs.smb.Trans2FindNext2;
import jcifs.smb.Trans2QueryFSInformation;
import jcifs.smb.Trans2QueryFSInformationResponse;
import jcifs.smb.Trans2QueryPathInformation;
import jcifs.smb.Trans2QueryPathInformationResponse;
import jcifs.smb.Trans2SetFileInformation;
import jcifs.smb.Trans2SetFileInformationResponse;
import jcifs.util.LogStream;

public class SmbFile
extends URLConnection
implements SmbConstants {
    static final int O_RDONLY = 1;
    static final int O_WRONLY = 2;
    static final int O_RDWR = 3;
    static final int O_APPEND = 4;
    static final int O_CREAT = 16;
    static final int O_EXCL = 32;
    static final int O_TRUNC = 64;
    public static final int FILE_NO_SHARE = 0;
    public static final int FILE_SHARE_READ = 1;
    public static final int FILE_SHARE_WRITE = 2;
    public static final int FILE_SHARE_DELETE = 4;
    public static final int ATTR_READONLY = 1;
    public static final int ATTR_HIDDEN = 2;
    public static final int ATTR_SYSTEM = 4;
    public static final int ATTR_VOLUME = 8;
    public static final int ATTR_DIRECTORY = 16;
    public static final int ATTR_ARCHIVE = 32;
    static final int ATTR_COMPRESSED = 2048;
    static final int ATTR_NORMAL = 128;
    static final int ATTR_TEMPORARY = 256;
    static final int ATTR_GET_MASK = Short.MAX_VALUE;
    static final int ATTR_SET_MASK = 12455;
    static final int DEFAULT_ATTR_EXPIRATION_PERIOD = 5000;
    static final int HASH_DOT = ".".hashCode();
    static final int HASH_DOT_DOT = "..".hashCode();
    static LogStream log = LogStream.getInstance();
    static long attrExpirationPeriod;
    public static final int TYPE_FILESYSTEM = 1;
    public static final int TYPE_WORKGROUP = 2;
    public static final int TYPE_SERVER = 4;
    public static final int TYPE_SHARE = 8;
    public static final int TYPE_NAMED_PIPE = 16;
    public static final int TYPE_PRINTER = 32;
    public static final int TYPE_COMM = 64;
    private String canon;
    private String share;
    private long createTime;
    private long lastModified;
    private int attributes;
    private long attrExpiration;
    private long size;
    private long sizeExpiration;
    private boolean isExists;
    private int shareAccess = 7;
    private SmbComBlankResponse blank_resp = null;
    private DfsReferral dfsReferral = null;
    NtlmPasswordAuthentication auth;
    SmbTree tree = null;
    String unc;
    int fid;
    int type;
    boolean opened;
    int tree_num;
    UniAddress[] addresses;
    int addressIndex;

    public SmbFile(String url) throws MalformedURLException {
        this(new URL(null, url, Handler.SMB_HANDLER));
    }

    public SmbFile(SmbFile context, String name) throws MalformedURLException, UnknownHostException {
        this(context.isWorkgroup0() ? new URL(null, "smb://" + name, Handler.SMB_HANDLER) : new URL(context.url, name, Handler.SMB_HANDLER), context.auth);
    }

    public SmbFile(String context, String name) throws MalformedURLException {
        this(new URL(new URL(null, context, Handler.SMB_HANDLER), name, Handler.SMB_HANDLER));
    }

    public SmbFile(String url, NtlmPasswordAuthentication auth) throws MalformedURLException {
        this(new URL(null, url, Handler.SMB_HANDLER), auth);
    }

    public SmbFile(String url, NtlmPasswordAuthentication auth, int shareAccess) throws MalformedURLException {
        this(new URL(null, url, Handler.SMB_HANDLER), auth);
        if ((shareAccess & 0xFFFFFFF8) != 0) {
            throw new RuntimeException("Illegal shareAccess parameter");
        }
        this.shareAccess = shareAccess;
    }

    public SmbFile(String context, String name, NtlmPasswordAuthentication auth) throws MalformedURLException {
        this(new URL(new URL(null, context, Handler.SMB_HANDLER), name, Handler.SMB_HANDLER), auth);
    }

    public SmbFile(String context, String name, NtlmPasswordAuthentication auth, int shareAccess) throws MalformedURLException {
        this(new URL(new URL(null, context, Handler.SMB_HANDLER), name, Handler.SMB_HANDLER), auth);
        if ((shareAccess & 0xFFFFFFF8) != 0) {
            throw new RuntimeException("Illegal shareAccess parameter");
        }
        this.shareAccess = shareAccess;
    }

    public SmbFile(SmbFile context, String name, int shareAccess) throws MalformedURLException, UnknownHostException {
        this(context.isWorkgroup0() ? new URL(null, "smb://" + name, Handler.SMB_HANDLER) : new URL(context.url, name, Handler.SMB_HANDLER), context.auth);
        if ((shareAccess & 0xFFFFFFF8) != 0) {
            throw new RuntimeException("Illegal shareAccess parameter");
        }
        this.shareAccess = shareAccess;
    }

    public SmbFile(URL url) {
        this(url, new NtlmPasswordAuthentication(url.getUserInfo()));
    }

    public SmbFile(URL url, NtlmPasswordAuthentication auth) {
        super(url);
        this.auth = auth == null ? new NtlmPasswordAuthentication(url.getUserInfo()) : auth;
        this.getUncPath0();
    }

    SmbFile(SmbFile context, String name, int type, int attributes, long createTime, long lastModified, long size) throws MalformedURLException, UnknownHostException {
        this(context.isWorkgroup0() ? new URL(null, "smb://" + name + "/", Handler.SMB_HANDLER) : new URL(context.url, name + ((attributes & 0x10) > 0 ? "/" : "")));
        int last;
        this.auth = context.auth;
        if (context.share != null) {
            this.tree = context.tree;
            this.dfsReferral = context.dfsReferral;
        }
        if (name.charAt(last = name.length() - 1) == '/') {
            name = name.substring(0, last);
        }
        this.unc = context.share == null ? "\\" : (context.unc.equals("\\") ? '\\' + name : context.unc + '\\' + name);
        this.type = type;
        this.attributes = attributes;
        this.createTime = createTime;
        this.lastModified = lastModified;
        this.size = size;
        this.isExists = true;
        this.attrExpiration = this.sizeExpiration = System.currentTimeMillis() + attrExpirationPeriod;
    }

    private SmbComBlankResponse blank_resp() {
        if (this.blank_resp == null) {
            this.blank_resp = new SmbComBlankResponse();
        }
        return this.blank_resp;
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        while (true) {
            this.connect0();
            if (this.tree.inDfs) {
                DfsReferral dr = this.tree.session.transport.lookupReferral(this.unc);
                if (dr != null) {
                    String dunc;
                    UniAddress addr;
                    try {
                        addr = UniAddress.getByName(dr.server);
                    }
                    catch (UnknownHostException uhe) {
                        throw new SmbException(dr.server, (Throwable)uhe);
                    }
                    SmbTransport trans = SmbTransport.getSmbTransport(addr, this.url.getPort());
                    this.tree = trans.getSmbSession(this.auth).getSmbTree(dr.share, null);
                    if (LogStream.level >= 3) {
                        log.println(dr);
                    }
                    this.dfsReferral = dr;
                    this.unc = dunc = this.dfsReferral.nodepath + this.unc.substring(this.dfsReferral.path.length());
                    if (request.path.endsWith("\\") && !dunc.endsWith("\\")) {
                        dunc = dunc + "\\";
                    }
                    request.path = dunc;
                }
                request.flags2 |= 0x1000;
            } else {
                request.flags2 &= 0xFFFFEFFF;
            }
            try {
                this.tree.send(request, response);
            }
            catch (DfsReferral dr) {
                if (dr.resolveHashes) {
                    throw dr;
                }
                request.reset();
                continue;
            }
            break;
        }
    }

    static String queryLookup(String query, String param) {
        String p;
        char[] in = query.toCharArray();
        int eq = 0;
        int st = 0;
        for (int i = 0; i < in.length; ++i) {
            char ch = in[i];
            if (ch == '&') {
                if (eq > st && (p = new String(in, st, eq - st)).equalsIgnoreCase(param)) {
                    return new String(in, ++eq, i - eq);
                }
                st = i + 1;
                continue;
            }
            if (ch != '=') continue;
            eq = i;
        }
        if (eq > st && (p = new String(in, st, eq - st)).equalsIgnoreCase(param)) {
            return new String(in, ++eq, in.length - eq);
        }
        return null;
    }

    UniAddress getAddress() throws UnknownHostException {
        if (this.addressIndex == 0) {
            return this.getFirstAddress();
        }
        return this.addresses[this.addressIndex - 1];
    }

    UniAddress getFirstAddress() throws UnknownHostException {
        String server;
        this.addressIndex = 0;
        String host = this.url.getHost();
        String path = this.url.getPath();
        String query = this.url.getQuery();
        if (query != null && (server = SmbFile.queryLookup(query, "server")) != null && server.length() > 0) {
            this.addresses = new UniAddress[1];
            this.addresses[0] = UniAddress.getByName(server);
            return this.getNextAddress();
        }
        if (host.length() == 0) {
            try {
                NbtAddress addr = NbtAddress.getByName("\u0001\u0002__MSBROWSE__\u0002", 1, null);
                this.addresses = new UniAddress[1];
                this.addresses[0] = UniAddress.getByName(addr.getHostAddress());
            }
            catch (UnknownHostException uhe) {
                NtlmPasswordAuthentication.initDefaults();
                if (NtlmPasswordAuthentication.DEFAULT_DOMAIN.equals("?")) {
                    throw uhe;
                }
                this.addresses = UniAddress.getAllByName(NtlmPasswordAuthentication.DEFAULT_DOMAIN, true);
            }
        } else {
            this.addresses = path.length() == 0 || path.equals("/") ? UniAddress.getAllByName(host, true) : UniAddress.getAllByName(host, false);
        }
        return this.getNextAddress();
    }

    UniAddress getNextAddress() {
        UniAddress addr = null;
        if (this.addressIndex < this.addresses.length) {
            addr = this.addresses[this.addressIndex++];
        }
        return addr;
    }

    boolean hasNextAddress() {
        return this.addressIndex < this.addresses.length;
    }

    void connect0() throws SmbException {
        try {
            this.connect();
        }
        catch (UnknownHostException uhe) {
            throw new SmbException("Failed to connect to server", (Throwable)uhe);
        }
        catch (SmbException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SmbException("Failed to connect to server", (Throwable)ioe);
        }
    }

    void doConnect() throws IOException {
        UniAddress addr = this.getAddress();
        SmbTransport trans = SmbTransport.getSmbTransport(addr, this.url.getPort());
        SmbSession ssn = trans.getSmbSession(this.auth);
        this.tree = ssn.getSmbTree(this.share, null);
        try {
            if (LogStream.level >= 3) {
                log.println("doConnect: " + addr);
            }
            this.tree.treeConnect(null, null);
        }
        catch (SmbAuthException sae) {
            if (this.share == null) {
                ssn = trans.getSmbSession(NtlmPasswordAuthentication.NULL);
                this.tree = ssn.getSmbTree(null, null);
                this.tree.treeConnect(null, null);
            }
            NtlmPasswordAuthentication a = NtlmAuthenticator.requestNtlmPasswordAuthentication(this.url.toString(), sae);
            if (a != null) {
                this.auth = a;
                ssn = trans.getSmbSession(this.auth);
                this.tree = ssn.getSmbTree(this.share, null);
                this.tree.treeConnect(null, null);
            }
            if (LogStream.level >= 1 && this.hasNextAddress()) {
                sae.printStackTrace(log);
            }
            throw sae;
        }
    }

    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.getUncPath0();
        this.getFirstAddress();
        while (true) {
            try {
                this.doConnect();
                return;
            }
            catch (SmbException se) {
                if (this.getNextAddress() == null) {
                    throw se;
                }
                if (LogStream.level < 3) continue;
                se.printStackTrace(log);
                continue;
            }
            break;
        }
    }

    boolean isConnected() {
        return this.tree != null && this.tree.treeConnected;
    }

    int open0(int flags, int access, int attrs, int options) throws SmbException {
        int f;
        this.connect0();
        if (LogStream.level >= 3) {
            log.println("open0: " + this.unc);
        }
        if (this.tree.session.transport.hasCapability(16)) {
            SmbComNTCreateAndXResponse response = new SmbComNTCreateAndXResponse();
            SmbComNTCreateAndX request = new SmbComNTCreateAndX(this.unc, flags, access, this.shareAccess, attrs, options, null);
            if (this instanceof SmbNamedPipe) {
                request.flags0 |= 0x16;
                request.desiredAccess |= 0x20000;
                response.isExtended = true;
            }
            this.send(request, response);
            f = response.fid;
            this.attributes = response.extFileAttributes & Short.MAX_VALUE;
            this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
            this.isExists = true;
        } else {
            SmbComOpenAndXResponse response = new SmbComOpenAndXResponse();
            this.send(new SmbComOpenAndX(this.unc, flags, access, null), response);
            f = response.fid;
        }
        return f;
    }

    void open(int flags, int access, int attrs, int options) throws SmbException {
        if (this.isOpen()) {
            return;
        }
        this.fid = this.open0(flags, access, attrs, options);
        this.opened = true;
        this.tree_num = this.tree.tree_num;
    }

    boolean isOpen() {
        boolean ans = this.opened && this.isConnected() && this.tree_num == this.tree.tree_num;
        return ans;
    }

    void close(int f, long lastWriteTime) throws SmbException {
        if (LogStream.level >= 3) {
            log.println("close: " + f);
        }
        this.send(new SmbComClose(f, lastWriteTime), this.blank_resp());
    }

    void close(long lastWriteTime) throws SmbException {
        if (!this.isOpen()) {
            return;
        }
        this.close(this.fid, lastWriteTime);
        this.opened = false;
    }

    void close() throws SmbException {
        this.close(0L);
    }

    public Principal getPrincipal() {
        return this.auth;
    }

    public String getName() {
        this.getUncPath0();
        if (this.canon.length() > 1) {
            int i = this.canon.length() - 2;
            while (this.canon.charAt(i) != '/') {
                --i;
            }
            return this.canon.substring(i + 1);
        }
        if (this.share != null) {
            return this.share + '/';
        }
        if (this.url.getHost().length() > 0) {
            return this.url.getHost() + '/';
        }
        return "smb://";
    }

    public String getParent() {
        String str = this.url.getAuthority();
        if (str.length() > 0) {
            StringBuffer sb = new StringBuffer("smb://");
            sb.append(str);
            this.getUncPath0();
            if (this.canon.length() > 1) {
                sb.append(this.canon);
            } else {
                sb.append('/');
            }
            str = sb.toString();
            int i = str.length() - 2;
            while (str.charAt(i) != '/') {
                --i;
            }
            return str.substring(0, i + 1);
        }
        return "smb://";
    }

    public String getPath() {
        return this.url.toString();
    }

    String getUncPath0() {
        if (this.unc == null) {
            int i;
            char[] in = this.url.getPath().toCharArray();
            char[] out = new char[in.length];
            int length = in.length;
            int state = 0;
            int o = 0;
            block5: for (i = 0; i < length; ++i) {
                switch (state) {
                    case 0: {
                        if (in[i] != '/') {
                            return null;
                        }
                        out[o++] = in[i];
                        state = 1;
                        continue block5;
                    }
                    case 1: {
                        if (in[i] == '/') continue block5;
                        if (in[i] == '.' && (i + 1 >= length || in[i + 1] == '/')) {
                            ++i;
                            continue block5;
                        }
                        if (i + 1 < length && in[i] == '.' && in[i + 1] == '.' && (i + 2 >= length || in[i + 2] == '/')) {
                            i += 2;
                            if (o == 1) continue block5;
                            while (--o > 1 && out[o - 1] != '/') {
                            }
                            continue block5;
                        }
                        state = 2;
                    }
                    case 2: {
                        if (in[i] == '/') {
                            state = 1;
                        }
                        out[o++] = in[i];
                    }
                }
            }
            this.canon = new String(out, 0, o);
            if (o > 1) {
                --o;
                i = this.canon.indexOf(47, 1);
                if (i < 0) {
                    this.share = this.canon.substring(1);
                    this.unc = "\\";
                } else if (i == o) {
                    this.share = this.canon.substring(1, i);
                    this.unc = "\\";
                } else {
                    this.share = this.canon.substring(1, i);
                    this.unc = this.canon.substring(i, out[o] == '/' ? o : o + 1);
                    this.unc = this.unc.replace('/', '\\');
                }
            } else {
                this.share = null;
                this.unc = "\\";
            }
        }
        return this.unc;
    }

    public String getUncPath() {
        this.getUncPath0();
        if (this.share == null) {
            return "\\\\" + this.url.getHost();
        }
        return "\\\\" + this.url.getHost() + this.canon.replace('/', '\\');
    }

    public String getCanonicalPath() {
        String str = this.url.getAuthority();
        this.getUncPath0();
        if (str.length() > 0) {
            return "smb://" + this.url.getAuthority() + this.canon;
        }
        return "smb://";
    }

    public String getShare() {
        return this.share;
    }

    String getServerWithDfs() {
        if (this.dfsReferral != null) {
            int end;
            int start;
            char[] server = this.dfsReferral.node.toCharArray();
            for (start = 0; start < server.length && server[start] == '\\'; ++start) {
            }
            for (end = start; end < server.length && server[end] != '\\'; ++end) {
            }
            return new String(server, start, end - start);
        }
        return this.getServer();
    }

    public String getServer() {
        String str = this.url.getHost();
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    public int getType() throws SmbException {
        if (this.type == 0) {
            if (this.getUncPath0().length() > 1) {
                this.type = 1;
            } else if (this.share != null) {
                this.connect0();
                this.type = this.share.equals("IPC$") ? 16 : (this.tree.service.equals("LPT1:") ? 32 : (this.tree.service.equals("COMM") ? 64 : 8));
            } else if (this.url.getAuthority() == null || this.url.getAuthority().length() == 0) {
                this.type = 2;
            } else {
                int code;
                UniAddress addr;
                try {
                    addr = this.getAddress();
                }
                catch (UnknownHostException uhe) {
                    throw new SmbException(this.url.toString(), (Throwable)uhe);
                }
                if (addr.getAddress() instanceof NbtAddress && ((code = ((NbtAddress)addr.getAddress()).getNameType()) == 29 || code == 27)) {
                    this.type = 2;
                    return this.type;
                }
                this.type = 4;
            }
        }
        return this.type;
    }

    boolean isWorkgroup0() throws UnknownHostException {
        if (this.type == 2 || this.url.getHost().length() == 0) {
            this.type = 2;
            return true;
        }
        this.getUncPath0();
        if (this.share == null) {
            int code;
            UniAddress addr = this.getAddress();
            if (addr.getAddress() instanceof NbtAddress && ((code = ((NbtAddress)addr.getAddress()).getNameType()) == 29 || code == 27)) {
                this.type = 2;
                return true;
            }
            this.type = 4;
        }
        return false;
    }

    Info queryPath(String path, int infoLevel) throws SmbException {
        this.connect0();
        if (LogStream.level >= 3) {
            log.println("queryPath: " + path);
        }
        if (this.tree.session.transport.hasCapability(16)) {
            Trans2QueryPathInformationResponse response = new Trans2QueryPathInformationResponse(infoLevel);
            this.send(new Trans2QueryPathInformation(path, infoLevel), response);
            return response.info;
        }
        SmbComQueryInformationResponse response = new SmbComQueryInformationResponse((long)(this.tree.session.transport.server.serverTimeZone * 1000) * 60L);
        this.send(new SmbComQueryInformation(path), response);
        return response;
    }

    public boolean exists() throws SmbException {
        if (this.attrExpiration > System.currentTimeMillis()) {
            return this.isExists;
        }
        this.attributes = 17;
        this.createTime = 0L;
        this.lastModified = 0L;
        this.isExists = false;
        try {
            if (this.url.getHost().length() != 0) {
                if (this.share == null) {
                    if (this.getType() == 2) {
                        UniAddress.getByName(this.url.getHost(), true);
                    } else {
                        UniAddress.getByName(this.url.getHost()).getHostName();
                    }
                } else if (this.getUncPath0().length() == 1 || this.share.equalsIgnoreCase("IPC$")) {
                    this.connect0();
                } else {
                    Info info = this.queryPath(this.getUncPath0(), 257);
                    this.attributes = info.getAttributes();
                    this.createTime = info.getCreateTime();
                    this.lastModified = info.getLastWriteTime();
                }
            }
            this.isExists = true;
        }
        catch (UnknownHostException uhe) {
        }
        catch (SmbException se) {
            switch (se.getNtStatus()) {
                case -1073741809: 
                case -1073741773: 
                case -1073741772: 
                case -1073741766: {
                    break;
                }
                default: {
                    throw se;
                }
            }
        }
        this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        return this.isExists;
    }

    public boolean canRead() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists();
    }

    public boolean canWrite() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists() && (this.attributes & 1) == 0;
    }

    public boolean isDirectory() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return true;
        }
        if (!this.exists()) {
            return false;
        }
        return (this.attributes & 0x10) == 16;
    }

    public boolean isFile() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return false;
        }
        this.exists();
        return (this.attributes & 0x10) == 0;
    }

    public boolean isHidden() throws SmbException {
        if (this.share == null) {
            return false;
        }
        if (this.getUncPath0().length() == 1) {
            return this.share.endsWith("$");
        }
        this.exists();
        return (this.attributes & 2) == 2;
    }

    public String getDfsPath() throws SmbException {
        this.connect0();
        if (this.tree.inDfs) {
            this.exists();
        }
        if (this.dfsReferral == null) {
            return null;
        }
        String path = "smb:/" + this.dfsReferral.node + this.unc;
        path = path.replace('\\', '/');
        if (this.isDirectory()) {
            path = path + '/';
        }
        return path;
    }

    public long createTime() throws SmbException {
        if (this.getUncPath0().length() > 1) {
            this.exists();
            return this.createTime;
        }
        return 0L;
    }

    public long lastModified() throws SmbException {
        if (this.getUncPath0().length() > 1) {
            this.exists();
            return this.lastModified;
        }
        return 0L;
    }

    public String[] list() throws SmbException {
        return this.list("*", 22, null, null);
    }

    public String[] list(SmbFilenameFilter filter) throws SmbException {
        return this.list("*", 22, filter, null);
    }

    public SmbFile[] listFiles() throws SmbException {
        return this.listFiles("*", 22, null, null);
    }

    public SmbFile[] listFiles(String wildcard) throws SmbException {
        return this.listFiles(wildcard, 22, null, null);
    }

    public SmbFile[] listFiles(SmbFilenameFilter filter) throws SmbException {
        return this.listFiles("*", 22, filter, null);
    }

    public SmbFile[] listFiles(SmbFileFilter filter) throws SmbException {
        return this.listFiles("*", 22, null, filter);
    }

    String[] list(String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        ArrayList list = new ArrayList();
        this.doEnum(list, false, wildcard, searchAttributes, fnf, ff);
        return list.toArray(new String[list.size()]);
    }

    SmbFile[] listFiles(String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        ArrayList list = new ArrayList();
        this.doEnum(list, true, wildcard, searchAttributes, fnf, ff);
        return list.toArray(new SmbFile[list.size()]);
    }

    void doEnum(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        if (ff != null && ff instanceof DosFileFilter) {
            DosFileFilter dff = (DosFileFilter)ff;
            if (dff.wildcard != null) {
                wildcard = dff.wildcard;
            }
            searchAttributes = dff.attributes;
        }
        try {
            int hostlen = this.url.getHost().length();
            if (hostlen == 0 || this.getType() == 2) {
                this.doNetServerEnum(list, files, wildcard, searchAttributes, fnf, ff);
            } else if (this.share == null) {
                this.doShareEnum(list, files, wildcard, searchAttributes, fnf, ff);
            } else {
                this.doFindFirstNext(list, files, wildcard, searchAttributes, fnf, ff);
            }
        }
        catch (UnknownHostException uhe) {
            throw new SmbException(this.url.toString(), (Throwable)uhe);
        }
        catch (MalformedURLException mue) {
            throw new SmbException(this.url.toString(), (Throwable)mue);
        }
    }

    void doShareEnum(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException, UnknownHostException, MalformedURLException {
        FileEntry e;
        String p = this.url.getPath();
        IOException last = null;
        if (p.lastIndexOf(47) != p.length() - 1) {
            throw new SmbException(this.url.toString() + " directory must end with '/'");
        }
        if (this.getType() != 4) {
            throw new SmbException("The requested list operations is invalid: " + this.url.toString());
        }
        HashMap<FileEntry, FileEntry> map = new HashMap<FileEntry, FileEntry>();
        UniAddress addr = this.getFirstAddress();
        while (addr != null) {
            try {
                FileEntry[] entries;
                this.doConnect();
                try {
                    entries = this.doMsrpcShareEnum();
                }
                catch (IOException ioe) {
                    if (LogStream.level >= 3) {
                        ioe.printStackTrace(log);
                    }
                    entries = this.doNetShareEnum();
                }
                for (int ei = 0; ei < entries.length; ++ei) {
                    e = entries[ei];
                    if (map.containsKey(e)) continue;
                    map.put(e, e);
                }
            }
            catch (IOException ioe) {
                if (LogStream.level >= 3) {
                    ioe.printStackTrace(log);
                }
                last = ioe;
            }
            addr = this.getNextAddress();
        }
        if (last != null && map.isEmpty()) {
            if (!(last instanceof SmbException)) {
                throw new SmbException(this.url.toString(), (Throwable)last);
            }
            throw (SmbException)last;
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            e = (FileEntry)iter.next();
            String name = e.getName();
            if (fnf != null && !fnf.accept(this, name) || name.length() <= 0) continue;
            SmbFile f = new SmbFile(this, name, e.getType(), 17, 0L, 0L, 0L);
            if (ff != null && !ff.accept(f)) continue;
            if (files) {
                list.add(f);
                continue;
            }
            list.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry[] doMsrpcShareEnum() throws IOException {
        MsrpcShareEnum rpc2 = new MsrpcShareEnum(this.url.getHost());
        DcerpcHandle handle = DcerpcHandle.getHandle("ncacn_np:" + this.getAddress().getHostAddress() + "[\\PIPE\\srvsvc]", this.auth);
        try {
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            FileEntry[] fileEntryArray = rpc2.getEntries();
            return fileEntryArray;
        }
        finally {
            block8: {
                try {
                    handle.close();
                }
                catch (IOException ioe) {
                    if (LogStream.level < 4) break block8;
                    ioe.printStackTrace(log);
                }
            }
        }
    }

    FileEntry[] doNetShareEnum() throws SmbException {
        NetShareEnum req = new NetShareEnum();
        NetShareEnumResponse resp = new NetShareEnumResponse();
        this.send(req, resp);
        if (resp.status != 0) {
            throw new SmbException(resp.status, true);
        }
        return resp.results;
    }

    void doNetServerEnum(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException, UnknownHostException, MalformedURLException {
        boolean more;
        NetServerEnum2Response resp;
        NetServerEnum2 req;
        int listType;
        int n = listType = this.url.getHost().length() == 0 ? 0 : this.getType();
        if (listType == 0) {
            this.connect0();
            req = new NetServerEnum2(this.tree.session.transport.server.oemDomainName, Integer.MIN_VALUE);
            resp = new NetServerEnum2Response();
        } else if (listType == 2) {
            req = new NetServerEnum2(this.url.getHost(), -1);
            resp = new NetServerEnum2Response();
        } else {
            throw new SmbException("The requested list operations is invalid: " + this.url.toString());
        }
        do {
            this.send(req, resp);
            if (resp.status != 0 && resp.status != 234) {
                throw new SmbException(resp.status, true);
            }
            more = resp.status == 234;
            int n2 = more ? resp.numEntries - 1 : resp.numEntries;
            for (int i = 0; i < n2; ++i) {
                FileEntry e = resp.results[i];
                String name = e.getName();
                if (fnf != null && !fnf.accept(this, name) || name.length() <= 0) continue;
                SmbFile f = new SmbFile(this, name, e.getType(), 17, 0L, 0L, 0L);
                if (ff != null && !ff.accept(f)) continue;
                if (files) {
                    list.add(f);
                    continue;
                }
                list.add(name);
            }
            if (this.getType() != 2) break;
            req.subCommand = (byte)-41;
            ((SmbComTransaction)req).reset(0, resp.lastName);
            resp.reset();
        } while (more);
    }

    void doNetEnumX(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException, UnknownHostException, MalformedURLException {
        boolean more;
        SmbComTransactionResponse resp;
        SmbComTransaction req;
        int listType = this.url.getHost().length() == 0 ? 0 : this.getType();
        String p = this.url.getPath();
        if (p.lastIndexOf(47) != p.length() - 1) {
            throw new SmbException(this.url.toString() + " directory must end with '/'");
        }
        switch (listType) {
            case 0: {
                this.connect0();
                req = new NetServerEnum2(this.tree.session.transport.server.oemDomainName, Integer.MIN_VALUE);
                resp = new NetServerEnum2Response();
                break;
            }
            case 2: {
                req = new NetServerEnum2(this.url.getHost(), -1);
                resp = new NetServerEnum2Response();
                break;
            }
            case 4: {
                req = new NetShareEnum();
                resp = new NetShareEnumResponse();
                break;
            }
            default: {
                throw new SmbException("The requested list operations is invalid: " + this.url.toString());
            }
        }
        do {
            this.send(req, resp);
            boolean bl = more = resp.status == 234;
            if (resp.status != 0 && resp.status != 234) {
                throw new SmbException(resp.status, true);
            }
            int n = more ? resp.numEntries - 1 : resp.numEntries;
            for (int i = 0; i < n; ++i) {
                FileEntry e = resp.results[i];
                String name = e.getName();
                if (fnf != null && !fnf.accept(this, name) || name.length() <= 0) continue;
                SmbFile f = new SmbFile(this, name, e.getType(), 17, 0L, 0L, 0L);
                if (ff != null && !ff.accept(f)) continue;
                if (files) {
                    list.add(f);
                    continue;
                }
                list.add(name);
            }
            if (listType != 0 && listType != 2) break;
            req.subCommand = (byte)-41;
            req.reset(0, ((NetServerEnum2Response)resp).lastName);
            resp.reset();
        } while (more);
    }

    void doFindFirstNext(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException, UnknownHostException, MalformedURLException {
        String path = this.getUncPath0();
        String p = this.url.getPath();
        if (p.lastIndexOf(47) != p.length() - 1) {
            throw new SmbException(this.url.toString() + " directory must end with '/'");
        }
        SmbComTransaction req = new Trans2FindFirst2(path, wildcard, searchAttributes);
        Trans2FindFirst2Response resp = new Trans2FindFirst2Response();
        if (LogStream.level >= 3) {
            log.println("doFindFirstNext: " + req.path);
        }
        this.send(req, resp);
        int sid = resp.sid;
        req = new Trans2FindNext2(sid, resp.resumeKey, resp.lastName);
        resp.subCommand = (byte)2;
        while (true) {
            for (int i = 0; i < resp.numEntries; ++i) {
                int h;
                FileEntry e = resp.results[i];
                String name = e.getName();
                if (name.length() < 3 && ((h = name.hashCode()) == HASH_DOT || h == HASH_DOT_DOT) && (name.equals(".") || name.equals("..")) || fnf != null && !fnf.accept(this, name) || name.length() <= 0) continue;
                SmbFile f = new SmbFile(this, name, 1, e.getAttributes(), e.createTime(), e.lastModified(), e.length());
                if (ff != null && !ff.accept(f)) continue;
                if (files) {
                    list.add(f);
                    continue;
                }
                list.add(name);
            }
            if (resp.isEndOfSearch || resp.numEntries == 0) break;
            req.reset(resp.resumeKey, resp.lastName);
            resp.reset();
            this.send(req, resp);
        }
        this.send(new SmbComFindClose2(sid), this.blank_resp());
    }

    public void renameTo(SmbFile dest) throws SmbException {
        if (this.getUncPath0().length() == 1 || dest.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.connect0();
        dest.connect0();
        if (this.tree.inDfs) {
            this.exists();
            dest.exists();
        }
        if (!this.tree.equals(dest.tree)) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (LogStream.level >= 3) {
            log.println("renameTo: " + this.unc + " -> " + dest.unc);
        }
        this.sizeExpiration = 0L;
        this.attrExpiration = 0L;
        dest.attrExpiration = 0L;
        this.send(new SmbComRename(this.unc, dest.unc), this.blank_resp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo0(SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbComReadAndX req, SmbComReadAndXResponse resp) throws SmbException {
        if (this.attrExpiration < System.currentTimeMillis()) {
            this.attributes = 17;
            this.createTime = 0L;
            this.lastModified = 0L;
            this.isExists = false;
            Info info = this.queryPath(this.getUncPath0(), 257);
            this.attributes = info.getAttributes();
            this.createTime = info.getCreateTime();
            this.lastModified = info.getLastWriteTime();
            this.isExists = true;
            this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        }
        if (this.isDirectory()) {
            block27: {
                String path = dest.getUncPath0();
                if (path.length() > 1) {
                    try {
                        dest.mkdir();
                        dest.setPathInformation(this.attributes, this.createTime, this.lastModified);
                    }
                    catch (SmbException se) {
                        if (se.getNtStatus() == -1073741790 || se.getNtStatus() == -1073741771) break block27;
                        throw se;
                    }
                }
            }
            SmbFile[] files = this.listFiles("*", 22, null, null);
            try {
                for (int i = 0; i < files.length; ++i) {
                    SmbFile ndest = new SmbFile(dest, files[i].getName(), files[i].type, files[i].attributes, files[i].createTime, files[i].lastModified, files[i].size);
                    files[i].copyTo0(ndest, b, bsize, w, req, resp);
                }
            }
            catch (UnknownHostException uhe) {
                throw new SmbException(this.url.toString(), (Throwable)uhe);
            }
            catch (MalformedURLException mue) {
                throw new SmbException(this.url.toString(), (Throwable)mue);
            }
        }
        try {
            this.open(1, 0, 128, 0);
            try {
                dest.open(82, 258, this.attributes, 0);
            }
            catch (SmbAuthException sae) {
                if ((dest.attributes & 1) != 0) {
                    dest.setPathInformation(dest.attributes & 0xFFFFFFFE, 0L, 0L);
                    dest.open(82, 258, this.attributes, 0);
                }
                throw sae;
            }
            int off = 0;
            int i = 0;
            while (true) {
                req.setParam(this.fid, off, bsize);
                resp.setParam(b[i], 0);
                this.send(req, resp);
                WriterThread sae = w;
                synchronized (sae) {
                    while (!w.ready) {
                        try {
                            w.wait();
                        }
                        catch (InterruptedException ie) {
                            throw new SmbException(dest.url.toString(), (Throwable)ie);
                        }
                    }
                    if (w.e != null) {
                        throw w.e;
                    }
                    if (resp.dataLength <= 0) {
                        break;
                    }
                    w.write(b[i], resp.dataLength, dest, off);
                }
                i = i == 1 ? 0 : 1;
                off += resp.dataLength;
            }
            dest.send(new Trans2SetFileInformation(dest.fid, this.attributes, this.createTime, this.lastModified), new Trans2SetFileInformationResponse());
            dest.close(0L);
        }
        catch (Exception ex) {
            if (LogStream.level > 1) {
                ex.printStackTrace(log);
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(SmbFile dest) throws SmbException {
        if (this.share == null || dest.share == null) {
            throw new SmbException("Invalid operation for workgroups or servers");
        }
        SmbComReadAndX req = new SmbComReadAndX();
        SmbComReadAndXResponse resp = new SmbComReadAndXResponse();
        this.connect0();
        dest.connect0();
        if (this.tree.inDfs) {
            this.exists();
            dest.exists();
        }
        try {
            if (this.getAddress().equals(dest.getAddress()) && this.canon.regionMatches(true, 0, dest.canon, 0, Math.min(this.canon.length(), dest.canon.length()))) {
                throw new SmbException("Source and destination paths overlap.");
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        WriterThread w = new WriterThread();
        w.setDaemon(true);
        w.start();
        SmbTransport t1 = this.tree.session.transport;
        SmbTransport t2 = dest.tree.session.transport;
        if (t1.snd_buf_size < t2.snd_buf_size) {
            t2.snd_buf_size = t1.snd_buf_size;
        } else {
            t1.snd_buf_size = t2.snd_buf_size;
        }
        int bsize = Math.min(t1.rcv_buf_size - 70, t1.snd_buf_size - 70);
        byte[][] b = new byte[2][bsize];
        try {
            this.copyTo0(dest, b, bsize, w, req, resp);
        }
        finally {
            w.write(null, -1, null, 0);
        }
    }

    public void delete() throws SmbException {
        if (this.tree == null || this.tree.inDfs) {
            this.exists();
        }
        this.getUncPath0();
        this.delete(this.unc);
    }

    void delete(String fileName) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (System.currentTimeMillis() > this.attrExpiration) {
            this.attributes = 17;
            this.createTime = 0L;
            this.lastModified = 0L;
            this.isExists = false;
            Info info = this.queryPath(this.getUncPath0(), 257);
            this.attributes = info.getAttributes();
            this.createTime = info.getCreateTime();
            this.lastModified = info.getLastWriteTime();
            this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
            this.isExists = true;
        }
        if ((this.attributes & 1) != 0) {
            this.setReadWrite();
        }
        if (LogStream.level >= 3) {
            log.println("delete: " + fileName);
        }
        if ((this.attributes & 0x10) != 0) {
            this.send(new SmbComDeleteDirectory(fileName), this.blank_resp());
        } else {
            this.send(new SmbComDelete(fileName), this.blank_resp());
        }
        this.sizeExpiration = 0L;
        this.attrExpiration = 0L;
    }

    public long length() throws SmbException {
        if (this.sizeExpiration > System.currentTimeMillis()) {
            return this.size;
        }
        if (this.getType() == 8) {
            int level = 1;
            Trans2QueryFSInformationResponse response = new Trans2QueryFSInformationResponse(level);
            this.send(new Trans2QueryFSInformation(level), response);
            this.size = response.info.getCapacity();
        } else if (this.getUncPath0().length() > 1 && this.type != 16) {
            Info info = this.queryPath(this.getUncPath0(), 258);
            this.size = info.getSize();
        } else {
            this.size = 0L;
        }
        this.sizeExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        return this.size;
    }

    public long getDiskFreeSpace() throws SmbException {
        if (this.getType() == 8 || this.type == 1) {
            int level = 1007;
            try {
                return this.queryFSInformation(level);
            }
            catch (SmbException ex) {
                switch (ex.getNtStatus()) {
                    case -1073741823: 
                    case -1073741821: {
                        level = 1;
                        return this.queryFSInformation(level);
                    }
                }
                throw ex;
            }
        }
        return 0L;
    }

    private long queryFSInformation(int level) throws SmbException {
        Trans2QueryFSInformationResponse response = new Trans2QueryFSInformationResponse(level);
        this.send(new Trans2QueryFSInformation(level), response);
        if (this.type == 8) {
            this.size = response.info.getCapacity();
            this.sizeExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        }
        return response.info.getFree();
    }

    public void mkdir() throws SmbException {
        String path = this.getUncPath0();
        if (path.length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (LogStream.level >= 3) {
            log.println("mkdir: " + path);
        }
        this.send(new SmbComCreateDirectory(path), this.blank_resp());
        this.sizeExpiration = 0L;
        this.attrExpiration = 0L;
    }

    public void mkdirs() throws SmbException {
        SmbFile parent;
        try {
            parent = new SmbFile(this.getParent(), this.auth);
        }
        catch (IOException ioe) {
            return;
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.mkdir();
    }

    public void createNewFile() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.close(this.open0(51, 0, 128, 0), 0L);
    }

    void setPathInformation(int attrs, long ctime, long mtime) throws SmbException {
        this.exists();
        int dir = this.attributes & 0x10;
        int f = this.open0(1, 256, dir, dir != 0 ? 1 : 64);
        this.send(new Trans2SetFileInformation(f, attrs | dir, ctime, mtime), new Trans2SetFileInformationResponse());
        this.close(f, 0L);
        this.attrExpiration = 0L;
    }

    public void setCreateTime(long time) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(0, time, 0L);
    }

    public void setLastModified(long time) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(0, 0L, time);
    }

    public int getAttributes() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return 0;
        }
        this.exists();
        return this.attributes & Short.MAX_VALUE;
    }

    public void setAttributes(int attrs) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(attrs & 0x30A7, 0L, 0L);
    }

    public void setReadOnly() throws SmbException {
        this.setAttributes(this.getAttributes() | 1);
    }

    public void setReadWrite() throws SmbException {
        this.setAttributes(this.getAttributes() & 0xFFFFFFFE);
    }

    public URL toURL() throws MalformedURLException {
        return this.url;
    }

    public int hashCode() {
        int hash;
        try {
            hash = this.getAddress().hashCode();
        }
        catch (UnknownHostException uhe) {
            hash = this.getServer().toUpperCase().hashCode();
        }
        this.getUncPath0();
        return hash + this.canon.toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SmbFile && obj.hashCode() == this.hashCode();
    }

    public String toString() {
        return this.url.toString();
    }

    public int getContentLength() {
        try {
            return (int)(this.length() & 0xFFFFFFFFL);
        }
        catch (SmbException smbException) {
            return 0;
        }
    }

    public long getDate() {
        try {
            return this.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public long getLastModified() {
        try {
            return this.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new SmbFileInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new SmbFileOutputStream(this);
    }

    private void processAces(ACE[] aces, boolean resolveSids) throws IOException {
        String server = this.getServerWithDfs();
        if (resolveSids) {
            SID[] sids = new SID[aces.length];
            Object names = null;
            for (int ai = 0; ai < aces.length; ++ai) {
                sids[ai] = aces[ai].sid;
            }
            SID.resolveSids(server, this.auth, sids);
        } else {
            for (int ai = 0; ai < aces.length; ++ai) {
                aces[ai].sid.origin_server = server;
                aces[ai].sid.origin_auth = this.auth;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACE[] getSecurity(boolean resolveSids) throws IOException {
        int f = this.open0(1, 131072, 0, this.isDirectory() ? 1 : 0);
        NtTransQuerySecurityDesc request = new NtTransQuerySecurityDesc(f, 4);
        NtTransQuerySecurityDescResponse response = new NtTransQuerySecurityDescResponse();
        try {
            this.send(request, response);
        }
        finally {
            this.close(f, 0L);
        }
        ACE[] aces = response.securityDescriptor.aces;
        this.processAces(aces, resolveSids);
        return aces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACE[] getShareSecurity(boolean resolveSids) throws IOException {
        ACE[] aces;
        String p = this.url.getPath();
        MsrpcShareGetInfo rpc2 = new MsrpcShareGetInfo(this.url.getHost(), this.getShare());
        DcerpcHandle handle = DcerpcHandle.getHandle("ncacn_np:" + this.url.getHost() + "[\\PIPE\\srvsvc]", this.auth);
        try {
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            aces = rpc2.getSecurity();
            this.processAces(aces, resolveSids);
        }
        finally {
            block9: {
                try {
                    handle.close();
                }
                catch (IOException ioe) {
                    if (LogStream.level < 1) break block9;
                    ioe.printStackTrace(log);
                }
            }
        }
        return aces;
    }

    public ACE[] getSecurity() throws IOException {
        return this.getSecurity(false);
    }

    static {
        try {
            Class.forName("jcifs.Config");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        attrExpirationPeriod = Config.getLong("jcifs.smb.client.attrExpirationPeriod", 5000L);
    }

    class WriterThread
    extends Thread {
        byte[] b;
        int n;
        int off;
        boolean ready;
        SmbFile dest;
        SmbException e;
        boolean useNTSmbs;
        SmbComWriteAndX reqx;
        SmbComWrite req;
        ServerMessageBlock resp;

        WriterThread() throws SmbException {
            super("JCIFS-WriterThread");
            this.e = null;
            this.useNTSmbs = SmbFile.this.tree.session.transport.hasCapability(16);
            if (this.useNTSmbs) {
                this.reqx = new SmbComWriteAndX();
                this.resp = new SmbComWriteAndXResponse();
            } else {
                this.req = new SmbComWrite();
                this.resp = new SmbComWriteResponse();
            }
            this.ready = false;
        }

        synchronized void write(byte[] b, int n, SmbFile dest, int off) {
            this.b = b;
            this.n = n;
            this.dest = dest;
            this.off = off;
            this.ready = false;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WriterThread writerThread = this;
            synchronized (writerThread) {
                try {
                    while (true) {
                        this.notify();
                        this.ready = true;
                        while (this.ready) {
                            this.wait();
                        }
                        if (this.n == -1) {
                            return;
                        }
                        if (this.useNTSmbs) {
                            this.reqx.setParam(this.dest.fid, this.off, this.n, this.b, 0, this.n);
                            this.dest.send(this.reqx, this.resp);
                            continue;
                        }
                        this.req.setParam(this.dest.fid, this.off, this.n, this.b, 0, this.n);
                        this.dest.send(this.req, this.resp);
                    }
                }
                catch (SmbException e) {
                    this.e = e;
                }
                catch (Exception x) {
                    this.e = new SmbException("WriterThread", (Throwable)x);
                }
                this.notify();
            }
        }
    }
}

