/*
 * Decompiled with CFR 0.152.
 */
package au.com.redhillconsulting.simian;

import au.com.redhillconsulting.simian.AuditListener;
import au.com.redhillconsulting.simian.Block;
import au.com.redhillconsulting.simian.BlockMarkers;
import au.com.redhillconsulting.simian.CheckSummary;
import au.com.redhillconsulting.simian.Checker;
import au.com.redhillconsulting.simian.FileLoader;
import au.com.redhillconsulting.simian.Language;
import au.com.redhillconsulting.simian.Option;
import au.com.redhillconsulting.simian.Options;
import au.com.redhillconsulting.simian.SourceFile;
import au.com.redhillconsulting.simian.StreamLoader;
import au.com.redhillconsulting.simian.V;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.io.IOException;

public class SimianCheck
extends AbstractFileSetCheck {
    private final Options A = new Options();

    public SimianCheck() {
        this.setFailOnDuplication(true);
    }

    public void setFailOnDuplication(boolean bl) {
        this.A.setOption(Option.FAIL_ON_DUPLICATION, bl);
    }

    public void setThreshold(int n2) {
        this.A.setThreshold(n2);
    }

    public void setIgnoreBlocks(String string) {
        this.A.setOption(Option.IGNORE_BLOCKS, BlockMarkers.A(string));
    }

    public void setLanguage(String string) {
        this.A.setOption(Option.LANGUAGE, Language.valueOf(string));
    }

    public void setIgnoreCurlyBraces(boolean bl) {
        this.A.setOption(Option.IGNORE_CURLY_BRACES, bl);
    }

    public void setIgnoreLiterals(boolean bl) {
        this.A.setOption(Option.IGNORE_LITERALS, bl);
    }

    public void setIgnoreCharacters(boolean bl) {
        this.A.setOption(Option.IGNORE_CHARACTERS, bl);
    }

    public void setIgnoreCharacterCase(boolean bl) {
        this.A.setOption(Option.IGNORE_CHARACTER_CASE, bl);
    }

    public void setIgnoreStrings(boolean bl) {
        this.A.setOption(Option.IGNORE_STRINGS, bl);
    }

    public void setIgnoreStringCase(boolean bl) {
        this.A.setOption(Option.IGNORE_STRING_CASE, bl);
    }

    public void setIgnoreNumbers(boolean bl) {
        this.A.setOption(Option.IGNORE_NUMBERS, bl);
    }

    public void setIgnoreSubtypeNames(boolean bl) {
        this.A.setOption(Option.IGNORE_SUBTYPE_NAMES, bl);
    }

    public void setIgnoreModifiers(boolean bl) {
        this.A.setOption(Option.IGNORE_MODIFIERS, bl);
    }

    public void setBalanceParentheses(boolean bl) {
        this.A.setOption(Option.BALANCE_PARENTHESES, bl);
    }

    public void setBalanceSquareBrackets(boolean bl) {
        this.A.setOption(Option.BALANCE_SQUARE_BRACKETS, bl);
    }

    public void setBalanceCurlyBraces(boolean bl) {
        this.A.setOption(Option.BALANCE_CURLY_BRACES, bl);
    }

    public void setIgnoreRegions(boolean bl) {
        this.A.setOption(Option.IGNORE_REGIONS, bl);
    }

    public void setIgnoreIdentifierCase(boolean bl) {
        this.A.setOption(Option.IGNORE_IDENTIFIER_CASE, bl);
    }

    public void setIgnoreVariableNames(boolean bl) {
        this.A.setOption(Option.IGNORE_VARIABLE_NAMES, bl);
    }

    public void setIgnoreIdentifiers(boolean bl) {
        this.A.setOption(Option.IGNORE_IDENTIFIERS, bl);
    }

    public void process(File[] fileArray) {
        V.A(fileArray, "files");
        this.setSeverity((this.A.hasOption(Option.FAIL_ON_DUPLICATION) ? SeverityLevel.ERROR : SeverityLevel.WARNING).getName());
        Checker checker = new Checker(new _A(), this.A);
        FileLoader fileLoader = new FileLoader(new StreamLoader(checker));
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                fileLoader.load(fileArray[i2]);
                continue;
            }
            catch (IOException iOException) {
                V.A(iOException);
            }
        }
        checker.check();
    }

    private final class _A
    implements AuditListener {
        private final MessageDispatcher M;
        private Integer L;
        private int O;
        private Integer P;
        private String N;

        private _A() {
            this.M = SimianCheck.this.getMessageDispatcher();
        }

        public void startCheck(Options options) {
            SimianCheck.this.getMessageCollector().reset();
        }

        public void fileProcessed(SourceFile sourceFile) {
        }

        public void startSet(int n2) {
            if (this.L == null || this.L != n2) {
                this.L = new Integer(n2);
            }
            this.N = null;
        }

        public void block(Block block) {
            V.A(block, "block");
            SourceFile sourceFile = block.getSourceFile();
            int n2 = block.getStartLineNumber();
            int n3 = block.getEndLineNumber();
            if (this.N != null) {
                SimianCheck.this.log(this.O, "check", new Object[]{this.L, this.P, sourceFile.getFilename(), new Integer(n2), new Integer(n3)});
                return;
            }
            this.N = sourceFile.getFilename();
            this.O = n2;
            this.P = new Integer(n3);
            this.M.fireFileStarted(this.N);
        }

        public void endSet(String string) {
            SimianCheck.this.fireErrors(this.N);
            this.M.fireFileFinished(this.N);
        }

        public void endCheck(CheckSummary checkSummary) {
        }
    }
}

