/*
 * Decompiled with CFR 0.152.
 */
package com.neuroning.antdoclet;

import com.neuroning.antdoclet.AntDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AntRoot {
    private RootDoc rootDoc;
    private SortedSet all;
    private SortedSet allTypes;
    private SortedSet allTasks;
    private SortedSet categories;

    public AntRoot(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        this.all = new TreeSet();
        this.allTypes = new TreeSet();
        this.allTasks = new TreeSet();
        this.categories = new TreeSet();
        ClassDoc[] classes = rootDoc.classes();
        for (int i = 0; i < classes.length; ++i) {
            AntDoc d = AntDoc.getInstance(classes[i].qualifiedName(), this.rootDoc);
            if (d == null) continue;
            this.all.add(d);
            if (d.getAntCategory() != null) {
                this.categories.add(d.getAntCategory());
            }
            if (d.isTask()) {
                this.allTasks.add(d);
                continue;
            }
            this.allTypes.add(d);
        }
    }

    public Iterator getCategories() {
        return this.categories.iterator();
    }

    public Iterator getAll() {
        return this.all.iterator();
    }

    public Iterator getTypes() {
        return this.allTypes.iterator();
    }

    public Iterator getTasks() {
        return this.allTasks.iterator();
    }

    public Iterator getAllByCategory(String category) {
        if ("all".equals(category)) {
            return this.getAll();
        }
        return this.getByCategory(category, this.all);
    }

    public Iterator getTypesByCategory(String category) {
        if ("all".equals(category)) {
            return this.getTypes();
        }
        return this.getByCategory(category, this.allTypes);
    }

    public Iterator getTasksByCategory(String category) {
        if ("all".equals(category)) {
            return this.getTasks();
        }
        return this.getByCategory(category, this.allTasks);
    }

    private Iterator getByCategory(String category, Set antdocs) {
        ArrayList<AntDoc> filtered = new ArrayList<AntDoc>();
        for (AntDoc d : antdocs) {
            if (!category.equals(d.getAntCategory())) continue;
            filtered.add(d);
        }
        return filtered.iterator();
    }
}

