/*
 * Decompiled with CFR 0.152.
 */
package com.neuroning.antdoclet;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;

public class VelocityFacade {
    private VelocityEngine velocity;
    private File outputDir;
    private Context context;

    public VelocityFacade(File outputDir, String templatesDir) throws Exception {
        this.initVelocityEngine(templatesDir);
        this.outputDir = outputDir;
        this.context = new VelocityContext();
    }

    private void initVelocityEngine(String templatesDir) throws Exception {
        this.velocity = new VelocityEngine();
        this.velocity.setProperty("resource.loader", (Object)"file, class");
        this.velocity.setProperty("file.resource.loader.path", (Object)(templatesDir != null ? ".," + templatesDir : "."));
        this.velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        this.velocity.init();
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outdir) {
        this.outputDir = outdir;
    }

    protected FileWriter getFileWriter(String fileName) throws IOException {
        File file = new File(this.getOutputDir(), fileName);
        file.getParentFile().mkdirs();
        return new FileWriter(file);
    }

    public Context getContext() {
        return this.context;
    }

    public void setAttribute(String key, Object value) {
        this.context.put(key, value);
    }

    void merge(String templateName, Writer writer, Context context) {
        try {
            Template template = this.velocity.getTemplate(templateName);
            template.merge(context, writer);
            writer.flush();
        }
        catch (MethodInvocationException e) {
            Throwable cause = e.getWrappedThrowable();
            if (cause == null) {
                cause = e;
            }
            throw new RuntimeException("Error invoking $" + e.getReferenceName() + "." + e.getMethodName() + "() in \"" + templateName + "\"", cause);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing \"" + templateName + "\"", e);
        }
    }

    public void eval(String templateName, Writer writer) throws IOException {
        this.merge(templateName, writer, this.getContext());
    }

    public void eval(String templateName, String fileName) throws IOException {
        FileWriter writer = this.getFileWriter(fileName);
        this.eval(templateName, writer);
        writer.close();
    }

    public Object create(String clazz) throws Exception {
        return Class.forName(clazz).newInstance();
    }
}

