/*
 * Decompiled with CFR 0.152.
 */
package com.neuroning.antdoclet.latex;

import com.neuroning.antdoclet.latex.TableInfo;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTML2Latex
extends HTMLEditorKit.ParserCallback {
    StringBuffer ret;
    Stack tblstk = new Stack();
    TableInfo tblinfo;
    int verbat = 0;
    int colIdx = 0;
    Hashtable colors = new Hashtable(10);
    String block = "";
    String refurl = null;
    String doNotPrintURL = null;
    String refname = null;
    String refimg = null;
    boolean notex = false;
    int imageindex = 0;
    boolean _hyperref = true;
    boolean escape = true;

    public HTML2Latex(StringBuffer ret) {
        this.ret = ret;
    }

    public HTML2Latex() {
    }

    @Override
    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
        if (tag.toString().equalsIgnoreCase("tex")) {
            if (attrSet.containsAttribute(HTML.Attribute.ENDTAG, "true")) {
                this.notex = false;
            } else {
                String tex = (String)attrSet.getAttribute("txt");
                this.ret.append(tex);
                this.notex = true;
            }
        } else {
            if (this.notex) {
                return;
            }
            if (tag != HTML.Tag.META) {
                if (tag == HTML.Tag.HR) {
                    this.ret.append("\\hspace*{3cm}\\hrulefill\\hspace*{3cm}\\newline\n\n");
                } else if (tag == HTML.Tag.BR) {
                    this.ret.append("\\mbox{}\\newline ");
                }
            }
        }
    }

    @Override
    public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
        if (this.notex) {
            return;
        }
        if (tag == HTML.Tag.PRE) {
            this.ret.append("\n\\begin{lstlisting}\n");
            this.escape = false;
        } else if (tag == HTML.Tag.H1) {
            this.ret.append("\\chapter*{");
        } else if (tag == HTML.Tag.H2) {
            this.ret.append("\\section*{");
        } else if (tag == HTML.Tag.H3) {
            this.ret.append("\\subsection*{");
        } else if (tag == HTML.Tag.H4) {
            this.ret.append("\\subsubsection*{");
        } else if (tag == HTML.Tag.H5) {
            this.ret.append("\\subsubsection*{");
        } else if (tag == HTML.Tag.H6) {
            this.ret.append("\\subsubsection*{");
        } else if (tag == HTML.Tag.SUB) {
            this.ret.append("$_{");
        } else if (tag == HTML.Tag.SUP) {
            this.ret.append("$^{");
        } else if (tag != HTML.Tag.HEAD) {
            if (tag == HTML.Tag.CENTER) {
                this.ret.append("\\makebox[\\hsize]{ ");
            } else if (tag == HTML.Tag.TITLE) {
                this.ret.append("\\chapter{");
            } else if (tag != HTML.Tag.FORM && tag != HTML.Tag.INPUT && tag != HTML.Tag.BODY) {
                if (tag == HTML.Tag.CODE) {
                    this.ret.append("{\\tt\\small ");
                } else if (tag == HTML.Tag.TT) {
                    this.ret.append("{\\tt ");
                } else if (tag == HTML.Tag.P) {
                    this.ret.append("\n\n");
                } else if (tag == HTML.Tag.B) {
                    this.ret.append("{\\bf ");
                } else if (tag == HTML.Tag.STRONG) {
                    this.ret.append("{\\bf ");
                } else if (tag == HTML.Tag.A) {
                    this.refurl = (String)attrSet.getAttribute(HTML.Attribute.HREF);
                    this.doNotPrintURL = (String)attrSet.getAttribute("donotprinturl");
                    if (this.refurl != null) {
                        if (this._hyperref) {
                            String sharp = "";
                            if (this.refurl.indexOf("#") >= 0) {
                                sharp = this.refurl.substring(this.refurl.indexOf("#") + 1, this.refurl.length());
                                if (sharp.indexOf("%") >= 0) {
                                    sharp = "";
                                }
                                this.refurl = this.refurl.substring(0, this.refurl.indexOf("#"));
                            }
                            this.ret.append("\\hyperref{" + this.refurl + "}{" + sharp + "}{}{");
                        } else {
                            this.ret.append("{\\bf ");
                        }
                    } else {
                        this.refname = (String)attrSet.getAttribute(HTML.Attribute.NAME);
                        if (this.refname != null && this._hyperref) {
                            this.ret.append("\\hyperdef{" + this.refname + "}{");
                        }
                    }
                } else if (tag == HTML.Tag.OL) {
                    this.ret.append("\n\\begin{enumerate}");
                } else if (tag == HTML.Tag.DL) {
                    this.ret.append("\n\\begin{itemize}");
                } else if (tag == HTML.Tag.LI) {
                    this.ret.append("\n\\item{\\vskip -.8ex ");
                } else if (tag == HTML.Tag.DT) {
                    this.ret.append("\\item[");
                } else if (tag == HTML.Tag.DD) {
                    this.ret.append("{");
                } else if (tag == HTML.Tag.UL) {
                    this.ret.append("\\begin{itemize}");
                } else if (tag == HTML.Tag.I) {
                    this.ret.append("{\\it ");
                } else if (tag == HTML.Tag.TABLE) {
                    this.tblstk.push(this.tblinfo);
                    this.tblinfo = new TableInfo();
                    this.ret = this.tblinfo.startTable(this.ret, attrSet);
                } else if (tag == HTML.Tag.TH) {
                    this.tblinfo.startHeadCol(attrSet);
                } else if (tag == HTML.Tag.TD) {
                    this.tblinfo.startCol(attrSet);
                } else if (tag == HTML.Tag.TR) {
                    this.tblinfo.startRow(attrSet);
                } else if (tag == HTML.Tag.FONT) {
                    String col = (String)attrSet.getAttribute(HTML.Attribute.COLOR);
                    this.ret.append("{");
                    if (col != null) {
                        if ("redgreenbluewhiteyellowblackcyanmagenta".indexOf(col) != -1) {
                            this.ret.append("\\color{" + col + "}");
                        } else if ("abcdefABCDEF0123456789".indexOf(col.charAt(0)) != -1) {
                            Color cc = new Color((int)Long.parseLong(col, 16));
                            String name = (String)this.colors.get("color" + cc.getRGB());
                            if (name == null) {
                                this.ret.append("\\definecolor{color" + this.colIdx + "}[rgb]{" + (double)cc.getRed() / 255.0 + "," + (double)cc.getBlue() / 255.0 + "," + (double)cc.getGreen() / 255.0 + "}");
                                name = "color" + this.colIdx;
                                ++this.colIdx;
                                this.colors.put("color" + cc.getRGB(), name);
                            }
                            this.ret.append("\\color{" + name + "}");
                            ++this.colIdx;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleEndTag(HTML.Tag tag, int pos) {
        if (this.notex) {
            return;
        }
        if (tag == HTML.Tag.PRE) {
            this.ret.append("\n\\end{lstlisting}\n");
            this.escape = true;
        } else if (tag == HTML.Tag.H1) {
            this.ret.append("}");
        } else if (tag == HTML.Tag.H2) {
            this.ret.append("}");
        } else if (tag == HTML.Tag.H3) {
            this.ret.append("}");
        } else if (tag == HTML.Tag.H4) {
            this.ret.append("}");
        } else if (tag == HTML.Tag.H5) {
            this.ret.append("}");
        } else if (tag == HTML.Tag.H6) {
            this.ret.append("}");
        } else if (tag == HTML.Tag.SUB) {
            this.ret.append("}$");
        } else if (tag == HTML.Tag.SUP) {
            this.ret.append("}$");
        } else if (tag != HTML.Tag.HEAD) {
            if (tag == HTML.Tag.CENTER) {
                this.ret.append("}");
            } else if (tag == HTML.Tag.TITLE) {
                this.ret.append("}{");
            } else if (tag != HTML.Tag.FORM && tag != HTML.Tag.INPUT && tag != HTML.Tag.BODY) {
                if (tag == HTML.Tag.CODE) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.TT) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.P) {
                    this.ret.append("\n\n");
                } else if (tag == HTML.Tag.B) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.STRONG) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.A) {
                    if (this.refurl != null) {
                        this.ret.append("} ");
                        if (this.doNotPrintURL == null && !this.refurl.equals("")) {
                            this.ret.append("(at ");
                            this.ret.append(HTML2Latex.fixText(this.refurl));
                            this.ret.append(")");
                        }
                    } else if (this.refname != null) {
                        this.ret.append("}");
                    }
                } else if (tag == HTML.Tag.LI) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.DT) {
                    this.ret.append("]");
                } else if (tag == HTML.Tag.DD) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.DL) {
                    this.ret.append("\n\\end{itemize}\n");
                } else if (tag == HTML.Tag.OL) {
                    this.ret.append("\n\\end{enumerate}\n");
                } else if (tag == HTML.Tag.UL) {
                    this.ret.append("\n\\end{itemize}\n");
                } else if (tag == HTML.Tag.I) {
                    this.ret.append("}");
                } else if (tag == HTML.Tag.TABLE) {
                    this.ret = this.tblinfo.endTable();
                    this.tblinfo = (TableInfo)this.tblstk.pop();
                } else if (tag == HTML.Tag.TH) {
                    this.tblinfo.endCol();
                } else if (tag == HTML.Tag.TD) {
                    this.tblinfo.endCol();
                } else if (tag == HTML.Tag.TR) {
                    this.tblinfo.endRow();
                } else if (tag == HTML.Tag.FONT) {
                    this.ret.append("}");
                }
            }
        }
    }

    @Override
    public void handleText(char[] data, int pos) {
        String str = new String(data);
        block19: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (this.notex) continue;
            if (!this.escape) {
                this.ret.append(c);
                continue;
            }
            switch (c) {
                case '\u00a0': {
                    this.ret.append("\\phantom{ }");
                    continue block19;
                }
                case ' ': {
                    if (this.verbat > 0) {
                        this.ret.append("\\phantom{ }");
                        continue block19;
                    }
                    this.ret.append(' ');
                    continue block19;
                }
                case '[': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\lbrack\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\lbrack ");
                    continue block19;
                }
                case ']': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\rbrack\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\rbrack ");
                    continue block19;
                }
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '_': 
                case '{': 
                case '}': {
                    this.ret.append('\\');
                    this.ret.append(c);
                    if (i >= str.length() - 1 || str.charAt(i + 1) != ' ') continue block19;
                    this.ret.append("\\ ");
                    ++i;
                    continue block19;
                }
                case '\u00e6': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\ae\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\ae ");
                    continue block19;
                }
                case '\u00c6': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\AE\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\AE ");
                    continue block19;
                }
                case '\u00e5': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\aa\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\aa ");
                    continue block19;
                }
                case '\u00c5': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\AA\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\AA ");
                    continue block19;
                }
                case '\u00f8': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\o\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\o ");
                    continue block19;
                }
                case '\u00d8': {
                    if (i < str.length() - 1 && str.charAt(i + 1) == ' ') {
                        this.ret.append("\\O\\ ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append("\\O ");
                    continue block19;
                }
                case '^': {
                    this.ret.append("$\\wedge$");
                    continue block19;
                }
                case '<': {
                    this.ret.append("\\textless ");
                    continue block19;
                }
                case '\n': 
                case '\r': {
                    if (this.tblstk.size() > 0) {
                        if (this.verbat > 0) {
                            this.ret.append("}\\mbox{}\\newline\n{\\tt\\small ");
                            continue block19;
                        }
                        this.ret.append(" ");
                        continue block19;
                    }
                    if (this.verbat > 0) {
                        this.ret.append("}\\mbox{}\\newline\n{\\tt\\small ");
                        continue block19;
                    }
                    if (i + 1 < str.length() && str.charAt(i + 1) == '\n') {
                        this.ret.append("\\bl ");
                        ++i;
                        continue block19;
                    }
                    this.ret.append(c);
                    continue block19;
                }
                case '/': {
                    this.ret.append("/");
                    continue block19;
                }
                case '>': {
                    this.ret.append("\\textgreater ");
                    continue block19;
                }
                case '\\': {
                    this.ret.append("\\textbackslash ");
                    continue block19;
                }
                default: {
                    this.ret.append(c);
                }
            }
        }
    }

    public static String fixText(String str) {
        StringBuffer result = new StringBuffer(str.length());
        HTML2Latex b = new HTML2Latex(result);
        StringReader reader = new StringReader(str);
        try {
            new ParserDelegator().parse(reader, b, false);
        }
        catch (IOException e) {
            // empty catch block
        }
        return new String(result);
    }
}

