/*
 * Decompiled with CFR 0.152.
 */
package com.neuroning.antdoclet.latex;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;

public class TableInfo {
    private StringBuffer originalBuffer;
    private StringBuffer ret;
    private int colcnt = 0;
    private int rowcnt = 0;
    private int totalcolcnt = 0;
    private boolean border = false;
    private int bordwid;
    private boolean parboxed;
    private double red = -1.0;
    private double blue = -1.0;
    private double green = -1.0;
    static int tblcnt;
    int tblno;
    String tc;
    HTML.Tag lastTag;

    int hasNumAttr(HTML.Attribute attr, MutableAttributeSet attrSet) {
        String val = (String)attrSet.getAttribute(attr);
        if (val == null) {
            return -1;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public StringBuffer startTable(StringBuffer org, MutableAttributeSet attrSet) {
        String bgcolor;
        this.originalBuffer = org;
        this.ret = new StringBuffer();
        this.tblno = tblcnt++;
        this.tc = "" + (char)(97 + this.tblno / 676) + (char)(this.tblno / 26 + 97) + (char)(this.tblno % 26 + 97);
        String val = (String)attrSet.getAttribute(HTML.Attribute.BORDER);
        this.border = false;
        if (val != null) {
            this.border = true;
            this.bordwid = 2;
            if (!val.equals("")) {
                try {
                    this.bordwid = Integer.parseInt(val);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.bordwid == 0) {
                    this.border = false;
                }
            }
        }
        if ((bgcolor = (String)attrSet.getAttribute(HTML.Attribute.BGCOLOR)) != null) {
            try {
                if (bgcolor.length() != 7 && bgcolor.charAt(0) == '#') {
                    throw new NumberFormatException();
                }
                this.red = Integer.decode("#" + bgcolor.substring(1, 3)).doubleValue();
                this.blue = Integer.decode("#" + bgcolor.substring(3, 5)).doubleValue();
                this.green = Integer.decode("#" + bgcolor.substring(5, 7)).doubleValue();
                this.red /= 255.0;
                this.blue /= 255.0;
                this.green /= 255.0;
            }
            catch (NumberFormatException e) {
                this.red = 1.0;
                this.blue = 1.0;
                this.green = 1.0;
            }
        }
        return this.ret;
    }

    public StringBuffer endTable() {
        String cc;
        int i;
        this.originalBuffer.append("\n% Table #" + this.tblno + "\n");
        int col = this.totalcolcnt;
        if (col == 0) {
            col = 1;
        }
        for (i = 0; i < col; ++i) {
            cc = "" + (char)(97 + i / 676) + (char)(i / 26 + 97) + (char)(i % 26 + 97);
            this.originalBuffer.append("\\newlength{\\tbl" + this.tc + "c" + cc + "w}\n");
            this.originalBuffer.append("\\setlength{\\tbl" + this.tc + "c" + cc + "w}{" + 1.0 / (double)col + "\\linewidth}\n");
        }
        if (this.red != -1.0 && this.green != -1.0 && this.blue != -1.0) {
            this.originalBuffer.append("\\colorbox[rgb]{" + Double.toString(this.red) + "," + Double.toString(this.blue) + "," + Double.toString(this.green) + "}{");
        }
        this.originalBuffer.append("\\begin{tabular}{");
        if (this.border) {
            this.originalBuffer.append("|");
        }
        for (i = 0; i < col; ++i) {
            cc = "" + (char)(97 + i / 676) + (char)(i / 26 + 97) + (char)(i % 26 + 97);
            this.originalBuffer.append("p{\\tbl" + this.tc + "c" + cc + "w}");
            if (!this.border) continue;
            this.originalBuffer.append("|");
        }
        this.originalBuffer.append("}\n");
        this.originalBuffer.append(this.ret);
        this.originalBuffer.append("\\end{tabular}\n");
        if (this.red != -1.0 && this.green != -1.0 && this.blue != -1.0) {
            this.originalBuffer.append("}\n");
        }
        return this.originalBuffer;
    }

    public void startCol(MutableAttributeSet attrSet) {
        String align;
        int span = this.hasNumAttr(HTML.Attribute.COLSPAN, attrSet);
        if (this.colcnt > 0) {
            this.ret.append(" & ");
        }
        if ((align = (String)attrSet.getAttribute(HTML.Attribute.ALIGN)) != null && span < 0) {
            span = 1;
        }
        if (span > 0) {
            this.ret.append("\\multicolumn{" + span + "}{");
            if (this.border && this.colcnt == 0) {
                this.ret.append("|");
            }
            String cc = "" + (char)(97 + this.colcnt / 676) + (char)(this.colcnt / 26 + 97) + (char)(this.colcnt % 26 + 97);
            if (align != null) {
                String h = align.substring(0, 1);
                if ("rR".indexOf(h) >= 0) {
                    this.ret.append("r");
                } else if ("lL".indexOf(h) >= 0) {
                    this.ret.append("p{\\tbl" + this.tc + "c" + cc + "w}");
                } else if ("cC".indexOf(h) >= 0) {
                    this.ret.append("p{\\tbl" + this.tc + "c" + cc + "w}");
                }
            } else {
                this.ret.append("p{\\tbl" + this.tc + "c" + cc + "w}");
            }
            if (this.border) {
                this.ret.append("|");
            }
            this.ret.append("}");
        }
        String wid = (String)attrSet.getAttribute("texwidth");
        this.ret.append("{");
        if (wid != null) {
            this.ret.append("\\parbox{" + wid + "}{\\vskip 1ex ");
            this.parboxed = true;
        }
        ++this.colcnt;
        this.totalcolcnt = this.totalcolcnt > this.colcnt ? this.totalcolcnt : this.colcnt;
    }

    public void startHeadCol(MutableAttributeSet attrSet) {
        this.startCol(attrSet);
        this.ret.append("\\bf ");
    }

    public void endCol() {
        if (this.parboxed) {
            this.ret.append("\\vskip 1ex}");
        }
        this.parboxed = false;
        this.ret.append("}");
    }

    public void startRow(MutableAttributeSet attrSet) {
        if (this.rowcnt == 0 && this.border) {
            this.ret.append(" \\hline ");
        }
        this.colcnt = 0;
        ++this.rowcnt;
    }

    public void endRow() {
        this.ret.append(" \\\\");
        if (this.border) {
            this.ret.append(" \\hline");
        }
        this.ret.append("\n");
    }
}

