/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.compression;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCompressionFactory {
    public static final String COMP_NONE = "none";
    private static String defaultAlgorithm;
    private static Map comps;
    private static Log log;

    protected SshCompressionFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCompression() {
        return defaultAlgorithm;
    }

    public static List getSupportedCompression() {
        return new ArrayList(comps.keySet());
    }

    public static SshCompression newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            if (string.equals(COMP_NONE)) {
                return null;
            }
            return (SshCompression)((Class)comps.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog((Class)SshCompressionFactory.class);
        comps = new HashMap();
        log.info((Object)"Loading compression methods");
        comps.put(COMP_NONE, "");
        defaultAlgorithm = COMP_NONE;
        try {
            Enumeration<URL> enumeration = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.compression");
            Properties properties = new Properties();
            while (enumeration != null && enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                IOUtil.closeStream(inputStream);
                int n = 1;
                String string = "";
                while (properties.getProperty("compression.name." + String.valueOf(n)) != null) {
                    try {
                        string = properties.getProperty("compression.name." + String.valueOf(n));
                        Class<?> clazz = ConfigurationLoader.getExtensionClassLoader().loadClass(properties.getProperty("compression.class." + String.valueOf(n)));
                        clazz.newInstance();
                        comps.put(string, clazz);
                        log.info((Object)("Installed " + string + " compression"));
                    }
                    catch (Throwable throwable) {
                        log.info((Object)("Could not install cipher class for " + string), throwable);
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

