/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicClassLoader
extends ClassLoader {
    private static Log log = LogFactory.getLog((Class)DynamicClassLoader.class);
    private static int generationCounter = 0;
    private Hashtable cache;
    private List classpath = new Vector();
    private int generation;
    private ClassLoader parent;

    public DynamicClassLoader(ClassLoader classLoader, List list) throws IllegalArgumentException {
        this.parent = classLoader;
        this.cache = new Hashtable();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            File file = null;
            if (e instanceof String) {
                file = new File((String)e);
            } else if (e instanceof File) {
                file = (File)e;
            } else {
                throw new IllegalArgumentException("Entries in classpath must be either a String or File object");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("Classpath " + file.getAbsolutePath() + " doesn't exist!");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("Don't have read access for file " + file.getAbsolutePath());
            }
            if (!file.isDirectory() && !this.isJarArchive(file)) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or jar file" + " or if it's a jar file then it is corrupted.");
            }
            this.classpath.add(file);
        }
        this.generation = generationCounter++;
    }

    public URL getResource(String string) {
        URL uRL = DynamicClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        Iterator iterator = this.classpath.iterator();
        while (iterator.hasNext()) {
            String string2;
            File file;
            File file2 = (File)iterator.next();
            if (!file2.isDirectory() || !(file = new File(file2, string2 = string.replace('/', File.separatorChar))).exists()) continue;
            try {
                return new URL("file://" + file.getAbsolutePath());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        block1: {
            File file;
            inputStream = DynamicClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) break block1;
            Iterator iterator = this.classpath.iterator();
            while (iterator.hasNext() && (inputStream = (file = (File)iterator.next()).isDirectory() ? this.loadResourceFromDirectory(file, string) : this.loadResourceFromZipfile(file, string)) == null) {
            }
        }
        return inputStream;
    }

    public DynamicClassLoader reinstantiate() {
        return new DynamicClassLoader(this.parent, this.classpath);
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() != classCacheEntry.lastModified;
        return bl;
    }

    public synchronized boolean shouldReload() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == 0L) {
                return true;
            }
            if (l == classCacheEntry.lastModified) continue;
            return true;
        }
        return false;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            clazz = classCacheEntry.loadedClass;
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!this.securityAllowsClass(string)) {
            return this.loadSystemClass(string, bl);
        }
        try {
            clazz = this.loadSystemClass(string, bl);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (Exception exception) {
            clazz = null;
        }
        Iterator iterator = this.classpath.iterator();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (iterator.hasNext()) {
            byte[] byArray;
            File file = (File)iterator.next();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray == null) continue;
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException zipException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = string.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byte[] byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                return byArray;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        String string2 = string.replace('.', '/') + ".class";
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry != null) {
                classCacheEntry.origin = file;
                byte[] byArray = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zipFile.close();
        }
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private InputStream loadResourceFromZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return zipFile.getInputStream(zipEntry);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Class loadSystemClass(String string, boolean bl) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> clazz = this.parent.loadClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(string, classCacheEntry);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return true;
            }
            int n = string.lastIndexOf(46);
            securityManager.checkPackageDefinition(n > -1 ? string.substring(0, n) : "");
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

