/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.ChannelBinding;
import com.sun.gssapi.DERParser;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSCredential;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GSSContext {
    public static final int INDEFINITE = Integer.MAX_VALUE;
    public static final int COMPLETE = 0;
    public static final int CONTINUE_NEEDED = 1;
    public static final int CRED_DELEG = 1;
    public static final int MUTUAL_AUTH = 2;
    public static final int REPLAY_DET = 4;
    public static final int SEQUENCE_DET = 8;
    public static final int ANON = 16;
    public static final int CONF = 32;
    public static final int INTG = 64;
    public static final int TRANS = 128;
    private static final int PRE_INIT = 1;
    private static final int IN_PROGRESS = 2;
    private static final int READY = 3;
    private static final int DELETED = 4;
    private C018FE95 m_mechCtxt;
    private int m_reqFlags;
    private GSSCredential m_myCred;
    private int m_reqLifetime;
    private int m_curState;
    private Oid m_mechOid;
    private GSSName m_targName;
    private ChannelBinding m_chB;

    public GSSContext(GSSCredential gSSCredential) throws GSSException {
        this.initialize();
        this.m_myCred = gSSCredential;
    }

    public GSSContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        this.initialize();
        this.m_myCred = gSSCredential;
        this.m_reqLifetime = n;
        this.m_targName = gSSName;
        this.m_mechOid = oid == null ? GSSManager.getDefaultMech() : oid;
    }

    public GSSContext(byte[] byArray) throws GSSException {
        this.initialize();
        try {
            int n = byArray[0] & 0xFF;
            int n2 = 1;
            while (n2 < 4) {
                n <<= 8;
                n += byArray[n2] & 0xFF;
                ++n2;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.m_mechCtxt = GSSManager._M4092FBA(Oid.getFromDEROctets(byteArrayInputStream, n));
            this.m_mechCtxt._S0AC8F9E(byArray);
            this.m_curState = 3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new GSSException(10);
        }
    }

    public int accept(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.m_mechCtxt == null) {
            Oid oid = this.getTokenMech(inputStream);
            this.m_mechCtxt = GSSManager._M4092FBA(oid);
            if (this.m_myCred != null) {
                this.m_mechCtxt._S90010CC(this.m_myCred.getMechCred(oid, true));
            }
            if (this.m_chB != null) {
                this.m_mechCtxt._S9B00AB2(this.m_chB);
            }
            this.m_curState = 2;
        }
        if (this.m_curState != 2) {
            throw new GSSException(11, -1, "wrong status in accept");
        }
        int n = this.m_mechCtxt._S80A2F2C(inputStream, outputStream);
        if (n == 0) {
            this.m_curState = 3;
        }
        return n;
    }

    public byte[] accept(byte[] byArray, int n, int n2) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.accept(byteArrayInputStream, byteArrayOutputStream);
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void checkState(int n) throws GSSException {
        if (this.m_curState < n) {
            throw new GSSException(12);
        }
        if (n > 1 && this.m_mechCtxt == null) {
            throw new GSSException(12, -1, "error in checkState");
        }
    }

    public void dispose() throws GSSException {
        this.checkState(2);
        this.m_mechCtxt._S020B957();
        this.m_curState = 4;
    }

    public byte[] export() throws GSSException {
        this.checkState(3);
        byte[] byArray = this.m_mechCtxt._S725B2DA();
        this.dispose();
        return byArray;
    }

    public boolean getAnonymityState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 0x10) == 16;
        }
        return (this.m_mechCtxt._S00027C3() & 0x10) == 16;
    }

    public boolean getConfState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 0x20) == 32;
        }
        return (this.m_mechCtxt._S00027C3() & 0x20) == 32;
    }

    public GSSCredential getDelegCred() throws GSSException {
        this.checkState(2);
        return new GSSCredential(this.m_mechCtxt._S0293FFA());
    }

    public boolean getDelegCredState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 1) == 1;
        }
        return (this.m_mechCtxt._S00027C3() & 1) == 1;
    }

    public boolean getIntegState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 0x40) == 64;
        }
        return (this.m_mechCtxt._S00027C3() & 0x40) == 64;
    }

    public int getLifetime() {
        if (this.m_curState < 3) {
            return this.m_reqLifetime;
        }
        return this.m_mechCtxt._S4080EED();
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        messageProp.resetStatusValues();
        this.checkState(3);
        this.m_mechCtxt._S1513DBA(inputStream, outputStream, messageProp);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getMIC(byteArrayInputStream, byteArrayOutputStream, messageProp);
        return byteArrayOutputStream.toByteArray();
    }

    public Oid getMech() throws GSSException {
        this.checkState(2);
        return this.m_mechCtxt._S0200735();
    }

    public boolean getMutualAuthState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 2) == 2;
        }
        return (this.m_mechCtxt._S00027C3() & 2) == 2;
    }

    public boolean getReplayDetState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 4) == 4;
        }
        return (this.m_mechCtxt._S00027C3() & 4) == 4;
    }

    public boolean getSequenceDetState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 8) == 8;
        }
        return (this.m_mechCtxt._S00027C3() & 8) == 8;
    }

    public GSSName getSrcName() throws GSSException {
        this.checkState(2);
        return new GSSName(this.m_mechCtxt._S000EEFF());
    }

    public GSSName getTargName() throws GSSException {
        this.checkState(2);
        return new GSSName(this.m_mechCtxt._S011CEF9());
    }

    private Oid getTokenMech(InputStream inputStream) throws GSSException {
        try {
            inputStream.mark(100);
            if (inputStream.read() != 96) {
                throw new GSSException(10);
            }
            DERParser.readLength(inputStream);
            Oid oid = new Oid(inputStream);
            inputStream.reset();
            return oid;
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        this.checkState(3);
        return this.m_mechCtxt._S808028B(n, bl, n2);
    }

    public int init(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.m_mechCtxt == null) {
            this.m_mechCtxt = GSSManager._M4092FBA(this.m_mechOid);
            GSSCredSpi gSSCredSpi = null;
            if (this.m_myCred != null) {
                gSSCredSpi = this.m_myCred.getMechCred(this.m_mechOid, true);
            }
            this.m_mechCtxt._S235D9C1(gSSCredSpi, this.m_targName.canonicalizeInPlace(this.m_mechOid), this.m_reqLifetime, this.m_reqFlags);
            if (this.m_chB != null) {
                this.m_mechCtxt._S9B00AB2(this.m_chB);
            }
            this.m_curState = 2;
        }
        if (this.m_curState != 2) {
            throw new GSSException(11, -1, "wrong status in init");
        }
        int n = this.m_mechCtxt._S0E039DB(inputStream, outputStream);
        if (n == 0) {
            this.m_curState = 3;
        }
        return n;
    }

    public byte[] init(byte[] byArray, int n, int n2) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (byArray != null) {
            byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.init(byteArrayInputStream, byteArrayOutputStream);
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void initialize() {
        this.m_reqFlags = 14;
        this.m_myCred = null;
        this.m_reqLifetime = Integer.MAX_VALUE;
        this.m_curState = 1;
        this.m_mechOid = null;
        this.m_targName = null;
        this.m_chB = null;
    }

    public boolean isEstablished() {
        return this.m_curState == 3;
    }

    public boolean isInitiator() throws GSSException {
        this.checkState(2);
        return this.m_mechCtxt._S123049E();
    }

    public boolean isProtReady() {
        if (this.m_mechCtxt == null) {
            return false;
        }
        return this.m_mechCtxt._S1116FAA();
    }

    public boolean isTransferable() throws GSSException {
        this.checkState(3);
        return (this.m_mechCtxt._S00027C3() & 0x80) == 128;
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 0x10) : (this.m_reqFlags ^= 0x10);
    }

    public void requestConf(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 0x20) : (this.m_reqFlags ^= 0x20);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 1) : (this.m_reqFlags ^= 1);
    }

    public void requestInteg(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 0x40) : (this.m_reqFlags ^= 0x40);
    }

    public void requestLifetime(int n) throws GSSException {
        this.checkState(1);
        this.m_reqLifetime = n;
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 2) : (this.m_reqFlags ^= 2);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 4) : (this.m_reqFlags ^= 4);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 8) : (this.m_reqFlags ^= 8);
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.checkState(1);
        this.m_chB = channelBinding;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new GSSException(11);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        throw new GSSException(11);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        messageProp.resetStatusValues();
        this.checkState(3);
        this.m_mechCtxt._S00256CF(inputStream, inputStream2, messageProp);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2, n3, n4);
        this.verifyMIC(byteArrayInputStream, byteArrayInputStream2, messageProp);
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new GSSException(11);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        throw new GSSException(11);
    }
}

