/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.gssapi.GSSContext;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.RpcException;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;

public class CredGss
extends Cred {
    public int serviceType;
    Oid mechOid;
    int qop;
    String serviceName;
    int seq_num_out;
    int seq_window;
    int control;
    GSSContext gssCtx;
    byte[] ctx_handle;
    public static final int RPCSEC_GSS = 6;
    public static final int RPCSEC_GSS_DATA = 0;
    public static final int RPCSEC_GSS_INIT = 1;
    public static final int RPCSEC_GSS_CONTINUE_INIT = 2;
    public static final int RPCSEC_GSS_DESTROY = 3;
    public static final int RPCSEC_GSS_VERS_1 = 1;
    private static final int RPCGSS_MAXSZ = 1024;
    private static final int PROC_NULL = 0;

    public CredGss(String string, Oid oid, int n, int n2) {
        this.mechOid = oid;
        this.serviceName = string;
        this.serviceType = n;
        this.qop = n2;
        this.seq_num_out = 0;
        this.ctx_handle = null;
        this.gssCtx = null;
        this.control = 1;
    }

    public CredGss(String string, String string2, int n, int n2) throws IOException {
        try {
            this.mechOid = new Oid(string2);
        }
        catch (GSSException gSSException) {
            throw new IOException("can not construct CredGss object");
        }
        this.serviceName = string;
        this.serviceType = n;
        this.qop = n2;
        this.seq_num_out = 0;
        this.ctx_handle = null;
        this.gssCtx = null;
        this.control = 1;
    }

    synchronized void destroy(Rpc rpc) throws RpcException {
        if (this.gssCtx != null) {
            try {
                Xdr xdr = new Xdr(1024);
                this.control = 3;
                rpc.rpc_header(xdr, 0);
                rpc.rpc_call(xdr, 30000, 5);
                this.gssCtx.dispose();
                this.mechOid = null;
                this.gssCtx = null;
                this.ctx_handle = null;
            }
            catch (IOException iOException) {
            }
            catch (GSSException gSSException) {
                return;
            }
        }
    }

    public void getCred(Xdr xdr) {
    }

    synchronized void init(Connection connection, int n, int n2) throws RpcException {
        byte[] byArray = new byte[]{};
        int n3 = 0;
        int n4 = 0;
        try {
            GSSContext gSSContext = new GSSContext(new GSSName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE), this.mechOid, null, 0);
            gSSContext.requestConf(true);
            gSSContext.requestInteg(true);
            gSSContext.requestMutualAuth(true);
            gSSContext.requestReplayDet(true);
            gSSContext.requestSequenceDet(true);
            CredGss credGss = new CredGss(this.serviceName, this.mechOid, this.serviceType, this.qop);
            Rpc rpc = new Rpc(connection, n, n2, credGss);
            Xdr xdr = new Xdr(1024);
            credGss.control = 1;
            int n5 = 2;
            do {
                byte[] byArray2;
                if ((byArray2 = gSSContext.init(byArray, 0, byArray.length)) != null) {
                    Xdr xdr2;
                    rpc.rpc_header(xdr, 0);
                    xdr.xdr_bytes(byArray2);
                    try {
                        xdr2 = this.rpc_send(rpc, xdr, 30000, 5);
                    }
                    catch (MsgRejectedException msgRejectedException) {
                        if (n5 > 0 && (msgRejectedException.why == 13 || msgRejectedException.why == 14)) {
                            byArray = new byte[]{};
                            gSSContext = new GSSContext(new GSSName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE), this.mechOid, null, 0);
                            gSSContext.requestConf(true);
                            gSSContext.requestInteg(true);
                            gSSContext.requestMutualAuth(true);
                            gSSContext.requestReplayDet(true);
                            gSSContext.requestSequenceDet(true);
                            credGss.gssCtx = null;
                            credGss.ctx_handle = null;
                            credGss.control = 1;
                            --n5;
                            continue;
                        }
                        throw msgRejectedException;
                    }
                    catch (RpcException rpcException) {
                        throw rpcException;
                    }
                    this.ctx_handle = xdr2.xdr_bytes();
                    n3 = xdr2.xdr_int();
                    n4 = xdr2.xdr_int();
                    if (n3 != 0 && n3 != 1) {
                        throw new RpcException("cred.init server failed");
                    }
                    this.seq_window = xdr2.xdr_int();
                    byArray = xdr2.xdr_bytes();
                    if (!gSSContext.isEstablished() && byArray == null) {
                        throw new RpcException("cred.init:bad token");
                    }
                } else if (n3 == 1) {
                    throw new RpcException("cred.init:server needs token");
                }
                credGss.control = 2;
                credGss.ctx_handle = this.ctx_handle;
            } while (!gSSContext.isEstablished());
            this.gssCtx = gSSContext;
            this.control = 0;
        }
        catch (IOException iOException) {
            throw new RpcException("cred.init: io errors ");
        }
        catch (GSSException gSSException) {
            throw new RpcException("cred.init: gss errors");
        }
    }

    synchronized void putCred(Xdr xdr) throws RpcException {
        MessageProp messageProp = new MessageProp(this.qop, false);
        xdr.xdr_int(6);
        if (this.control == 0 || this.control == 3) {
            ++this.seq_num_out;
        }
        if (this.ctx_handle != null) {
            xdr.xdr_int(20 + this.ctx_handle.length);
            xdr.xdr_int(1);
            xdr.xdr_int(this.control);
            xdr.xdr_int(this.seq_num_out);
            xdr.xdr_int(this.serviceType);
            xdr.xdr_bytes(this.ctx_handle);
        } else {
            xdr.xdr_int(20);
            xdr.xdr_int(1);
            xdr.xdr_int(this.control);
            xdr.xdr_int(this.seq_num_out);
            xdr.xdr_int(this.serviceType);
            xdr.xdr_int(0);
        }
        if (this.gssCtx != null) {
            try {
                byte[] byArray = this.gssCtx.getMIC(xdr.xdr_buf(), 0, xdr.xdr_offset(), messageProp);
                xdr.xdr_int(6);
                xdr.xdr_bytes(byArray);
            }
            catch (GSSException gSSException) {
                throw new RpcException("can not checksum the header");
            }
        } else {
            xdr.xdr_int(0);
            xdr.xdr_int(0);
        }
        xdr.xdr_wrap_offset(xdr.xdr_offset());
        if (this.control == 0 && this.serviceType != 1) {
            xdr.xdr_int(this.seq_num_out);
        }
    }

    synchronized boolean refresh(Connection connection, int n, int n2) {
        if (this.ctx_handle == null) {
            return false;
        }
        this.gssCtx = null;
        this.ctx_handle = null;
        try {
            this.init(connection, n, n2);
            return true;
        }
        catch (RpcException rpcException) {
            return false;
        }
    }

    private Xdr rpc_send(Rpc rpc, Xdr xdr, int n, int n2) throws RpcException, IOException {
        Xdr xdr2 = null;
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        int n3 = 0;
        while (n3 < n2) {
            try {
                xdr2 = rpc.rpc_call_one(xdr, null, n);
                break;
            }
            catch (RpcException rpcException) {
                throw rpcException;
            }
            catch (IOException iOException) {
                ++n3;
            }
        }
        if (xdr2 == null) {
            throw new InterruptedIOException();
        }
        return xdr2;
    }

    synchronized int unwrap(Xdr xdr) throws RpcException {
        int n = 0;
        MessageProp messageProp = new MessageProp();
        if (this.control != 0) {
            return 0;
        }
        int n2 = xdr.xdr_offset();
        switch (this.serviceType) {
            case 1: {
                return 0;
            }
            case 2: {
                int n3 = xdr.xdr_int();
                if (n3 <= 4) {
                    return 0;
                }
                int n4 = xdr.xdr_offset();
                n = xdr.xdr_int();
                if (n < this.seq_num_out - this.seq_window || n > this.seq_num_out) {
                    throw new RpcException("unwrap: bad sequence number");
                }
                byte[] byArray = xdr.xdr_raw(n3 - 4);
                int n5 = xdr.xdr_int();
                try {
                    this.gssCtx.verifyMIC(xdr.xdr_buf(), xdr.xdr_offset(), n5, xdr.xdr_buf(), n4, n3, messageProp);
                }
                catch (GSSException gSSException) {
                    throw new RpcException("unwrap: gss_verifyMIC failed");
                }
                if (messageProp.getQOP() != this.qop) {
                    throw new RpcException("unwrap: unexpected qop");
                }
                xdr.xdr_offset(n2);
                xdr.xdr_raw(byArray);
                xdr.xdr_offset(n2);
                break;
            }
            case 3: {
                byte[] byArray;
                int n6 = xdr.xdr_int();
                if (n6 == 0) {
                    return 0;
                }
                try {
                    byArray = this.gssCtx.unwrap(xdr.xdr_buf(), xdr.xdr_offset(), n6, messageProp);
                }
                catch (GSSException gSSException) {
                    throw new RpcException("unwrap: gss_unwrap failed");
                }
                if (messageProp.getQOP() != this.qop) {
                    throw new RpcException("unwrap: unexpected qop");
                }
                xdr.xdr_offset(n2);
                xdr.xdr_raw(byArray);
                xdr.xdr_offset(n2);
                n = xdr.xdr_int();
                if (n >= this.seq_num_out - this.seq_window && n <= this.seq_num_out) break;
                throw new RpcException("unwrap: bad sequence number");
            }
        }
        return n;
    }

    synchronized void validate(byte[] byArray, int n) throws RpcException {
        if (this.control != 0) {
            return;
        }
        MessageProp messageProp = new MessageProp();
        byte[] byArray2 = new byte[]{(byte)(n >>> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        try {
            this.gssCtx.verifyMIC(byArray, 0, byArray.length, byArray2, 0, byArray2.length, messageProp);
        }
        catch (GSSException gSSException) {
            throw new RpcException("CredGss: validate failed");
        }
    }

    synchronized void wrap(Xdr xdr, byte[] byArray) throws RpcException {
        MessageProp messageProp = new MessageProp(this.qop, false);
        if (this.control != 0) {
            return;
        }
        try {
            switch (this.serviceType) {
                case 2: {
                    byte[] byArray2 = this.gssCtx.getMIC(byArray, 0, byArray.length, messageProp);
                    xdr.xdr_offset(xdr.xdr_wrap_offset());
                    xdr.xdr_bytes(byArray);
                    xdr.xdr_bytes(byArray2);
                    break;
                }
                case 3: {
                    messageProp.setPrivacy(true);
                    byte[] byArray3 = this.gssCtx.wrap(byArray, 0, byArray.length, messageProp);
                    xdr.xdr_offset(xdr.xdr_wrap_offset());
                    xdr.xdr_bytes(byArray3);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (GSSException gSSException) {
            throw new RpcException("wrap: Can not wrap RPC arg");
        }
    }
}

