/*
 * This file is part of muCommander, http://www.mucommander.com
 * Copyright (C) 2002-2008 Maxence Bernard
 *
 * muCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * muCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.mucommander.io;

import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

/**
 * This class extends <code>java.security.DigestInputStream</code> and adds a convenience {@link #getChecksum()} method
 * that returns the digest expressed as an hexadecimal string.
 *
 * @see com.mucommander.io.ChecksumOutputStream
 * @author Maxence Bernard
 */
public class ChecksumInputStream extends DigestInputStream {

    public ChecksumInputStream(InputStream stream, MessageDigest digest) {
        super(stream, digest);
    }


    /**
     * Returns this stream's digest, expressed as an hexadecimal string.
     *
     * @return this stream's digest, expressed as an hexadecimal string
     */
    public String getChecksum() {
        return ByteUtils.toHexString(getMessageDigest().digest());
    }
}
