# ice.js

<p align="center">
  <a href="https://www.npmjs.com/package/ice.js"><img src="https://badgen.net/npm/dm/ice.js" alt="Downloads"></a>
  <a href="https://www.npmjs.com/package/@ice/app"><img src="https://badgen.net/npm/v/@ice/app" alt="Version"></a>
  <a href="/LICENSE"><img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="GitHub license" /></a>
  <a href="https://github.com/alibaba/ice/pulls"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg" alt="PRs Welcome" /></a>
  <a href="https://gitter.im/alibaba/ice"><img src="https://badges.gitter.im/alibaba/ice.svg" alt="Gitter" /></a>
  <a href="https://opensource.alibaba.com/contribution_leaderboard/details?projectValue=ice"><img src="https://img.shields.io/badge/ICE-Check%20Your%20Contribution-orange" alt="Leaderboard" /></a>
  <a href="https://opensumi.run/ide/alibaba/ice"><img src="https://custom-icon-badges.demolab.com/badge/opensumi-run-blue.svg?logo=opensumi" alt="Open with OpenSumi" /></a>
</p>

A universal framework based on React.js, [📚 Docs](https://ice.work/).

## Features

- 🐒 **Zero Config**: Out of the box support for ES6+, TypeScript, Less, Sass, CSS Modules，etc
- 🐯 **Practice**: Practice about file-system routing, state Management, request, etc
- 🦁 **Hybrid**: pre-render pages at build time (SSG) or request time (SSR) for default
- 🐌 **Plugin system**: The plugin system provides rich features and allow the community to build reusable solutions
- 🐂 **Multi-End**: Support both web, miniapp and Weex

## Quick start

We recommend creating a new ice.js app using create-ice, which sets up everything automatically for you. To create a project, run:

```bash
$ npm init ice ice-app --template @ice/lite-scaffold
```

`npm init <initializer>` is available in npm 6+

Start local server to launch project:

```bash
$ cd ice-app
$ npm install
$ npm run start # running on http://localhost:3000.
```

It's as simple as that!

## Contributing

Please see our [CONTRIBUTING.md](/.github/CONTRIBUTING.md)

## Contributors

Contributors can contact us to join the Contributor Group.

 <a href="https://github.com/alibaba/ice/graphs/contributors"><img src="https://alibaba.github.io/ice/ice.png" /></a>

## Community

- [Issues](https://github.com/alibaba/ice/issues)
- [Gitter](https://gitter.im/alibaba/ice)

## LICENSE

[MIT](https://github.com/alibaba/ice/blob/master/LICENSE)
