// Select part from https://github.com/facebook/react/blob/main/packages/react-dom/src/shared/possibleStandardNames.js#L11
const possibleStandardNames = [
  // Common
  'className',
  'innerHTML',
  'autoFocus',
  'inputMode',
  // script
  'crossOrigin',
  // input
  'autoPlay',
  'autoComplete',
  'defaultChecked',
  'defaultValue',
  'htmlFor',
  'maxLength',
  'minLength',
  'readOnly',
  // video
  'playsInline',
  // frame
  'marginWidth',
  'marginHeight',
  // meta
  'charSet',
  'dangerouslySetInnerHTML',
  'strokeWidth',
  // SVG
  'accentHeight',
  'accumulate',
  'additive',
  'alignmentBaseline',
  'allowReorder',
  'arabicForm',
  'attributeName',
  'attributeType',
  'autoReverse',
  'baseFrequency',
  'baselineShift',
  'baseProfile',
  'calcMode',
  'capHeight',
  'clipPath',
  'clipPathUnits',
  'clipRule',
  'colorInterpolation',
  'colorInterpolationFilters',
  'colorProfile',
  'colorRendering',
  'contentScriptType',
  'contentStyleType',
  'diffuseConstant',
  'dominantBaseline',
  'edgeMode',
  'enableBackground',
  'externalResourcesRequired',
  'fillOpacity',
  'fillRule',
  'filterRes',
  'filterUnits',
  'floodOpacity',
  'floodColor',
  'fontFamily',
  'fontSize',
  'fontSizeAdjust',
  'fontStretch',
  'fontStyle',
  'fontVariant',
  'fontWeight',
  'glyphName',
  'glyphOrientationHorizontal',
  'glyphOrientationVertical',
  'glyphRef',
  'gradientTransform',
  'gradientUnits',
  'hanging',
  'horizAdvX',
  'horizOriginX',
  'ideographic',
  'imageRendering',
  'kernelMatrix',
  'kernelUnitLength',
  'keyPoints',
  'keySplines',
  'keyTimes',
  'lengthAdjust',
  'letterSpacing',
  'lightingColor',
  'limitingConeAngle',
  'markerEnd',
  'markerHeight',
  'markerMid',
  'markerStart',
  'markerUnits',
  'markerWidth',
  'maskContentUnits',
  'maskUnits',
  'numOctaves',
  'overlinePosition',
  'overlineThickness',
  'paintOrder',
  'pathLength',
  'patternContentUnits',
  'patternTransform',
  'patternUnits',
  'pointerEvents',
  'pointsAtX',
  'pointsAtY',
  'pointsAtZ',
  'preserveAlpha',
  'preserveAspectRatio',
  'primitiveUnits',
  'refX',
  'refY',
  'renderingIntent',
  'repeatCount',
  'repeatDur',
  'requiredExtensions',
  'requiredFeatures',
  'shapeRendering',
  'specularConstant',
  'specularExponent',
  'spreadMethod',
  'startOffset',
  'stdDeviation',
  'stitchTiles',
  'stopColor',
  'stopOpacity',
  'strikethroughPosition',
  'strikethroughThickness',
  'strokeDasharray',
  'strokeDashoffset',
  'strokeLinecap',
  'strokeLinejoin',
  'strokeMiterlimit',
  'strokeWidth',
  'strokeOpacity',
  'suppressContentEditableWarning',
  'suppressHydrationWarning',
  'surfaceScale',
  'systemLanguage',
  'tableValues',
  'targetX',
  'targetY',
  'textAnchor',
  'textDecoration',
  'textLength',
  'textRendering',
  'underlinePosition',
  'underlineThickness',
  'unicodeBidi',
  'unicodeRange',
  'unitsPerEm',
  'vAlphabetic',
  'vectorEffect',
  'vertAdvY',
  'vertOriginX',
  'vertOriginY',
  'vHanging',
  'vIdeographic',
  'viewBox',
  'viewTarget',
  'visibility',
  'vMathematical',
  'wordSpacing',
  'writingMode',
  'xChannelSelector',
  'xHeight',
  'xlinkActuate',
  'xlinkArcrole',
  'xlinkHref',
  'xlinkRole',
  'xlinkShow',
  'xlinkTitle',
  'xlinkType',
  'xmlBase',
  'xmlLang',
  'xmlnsXlink',
  'xmlSpace',
  'yChannelSelector',
  'zoomAndPan',
].reduce((records: Record<string, string>, iter: string) => {
  records[iter.toLowerCase()] = iter;
  return records;
}, {
  // Special cases.
  class: 'className',
  for: 'htmlFor',
});

export default possibleStandardNames;
