# @ice/route-manifest

Generate route manifest based on the `src` directory in the project for ice.js 3.

## API

### `generateRouteManifest(rootDir: string)`

- rootDir: the project directory absolute path

Will scan the page files in the `rootDir` and generate the routeManifest. For example:

```ts
const routeManifest = generateRouteManifest(__dirname);
console.log(routeManifest);
/**
[
  layout: {
    path: "",
    id: "layout",
    componentName: "Layout",
    file: "layout.tsx",
  },
  "pages/About/index": {
    path: "/About",
    index: true,
    id: "pages/About/index",
    parentId: "layout",
    file: "pages/About/index.tsx",
    componentName: "PagesAboutIndex",
  },
}
*/
```

### `formatNestedRouteManifest(routeManifest: RouteManifest)`

- routeManifest: generated by the `generateRouteManifest` function

It will get the nested route by the routeManifest. For example:

routeManifest:

```ts
const routeManifest = [
  layout: {
    path: "",
    id: "layout",
    componentName: "Layout",
    file: "layout.tsx",
  },
  "pages/About/index": {
    path: "/About",
    index: true,
    id: "pages/About/index",
    parentId: "layout",
    file: "pages/About/index.tsx",
    componentName: "PagesAboutIndex",
  },
}

const nestedRouteManifest = formatNestedRouteManifest(routeManifest);

console.log(nestedRouteManifest);
/**
[
  {
    path: "",
    id: "layout",
    componentName: "Layout",
    file: "layout.tsx",
    children: [
      {
        path: "/About",
        index: true,
        id: "pages/About/index",
        parentId: "layout",
        file: "pages/About/index.tsx",
        componentName: "PagesAboutIndex",
      },
    ]
  }
]
*/
```
