---
name: Bug report
about: Create a report to help us improve
title: ''
labels: bug
assignees: ''

---

**Before submitting the issue**
- Check whether a bug report is the right format for your issue. For questions about using the `mice` package, see [Discussions](https://github.com/amices/mice/discussions). For theoretical background about the `mice` methods, see [Flexible Imputation of Missing Data](https://stefvanbuuren.name/fimd/).
- Please make sure that you are using the latest version of `mice` (e.g. with the `packageVersion()` or `sessionInfo()` function).
- Please verify whether the bug has already been addressed (e.g. on [GitHub](https://github.com/amices/mice/issues?q=is%3Aissue) or [Stack Overflow](https://stackoverflow.com/questions/tagged/r-mice).

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Create a **repr**oducible **ex**ample, see e.g. the [`reprex` package](https://reprex.tidyverse.org/). A good reprex uses simulated or public data to showcase the bug. We recommend using one of the incomplete datasets included in the `mice` package (e.g. `mice::boys`) and the `reprex()` function from the `reprex` package.

Paste the code and output of your reprex here.

**Expected behavior**
A clear and concise description of what you expect to happen without the bug.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Additional context**
Add any other context about the problem here.
