# Yaak API Client

Yaak is a desktop API client for interacting with REST, GraphQL, Server Sent Events (SSE), WebSocket, and gRPC
APIs. It's built using [Tauri](https://tauri.app), Rust, and ReactJS.

![screenshot](https://github.com/user-attachments/assets/f18e963f-0b68-4ecb-b8b8-cb71aa9aec02)

## Feature Overview

🪂 Import data from Postman, Insomnia, OpenAPI, Swagger, or Curl.<br/>
📤 Send requests via REST, GraphQL, Server Sent Events (SSE), WebSockets, or gRPC.<br/>
🔐 Automatically authorize requests with OAuth 2.0, JWT tokens, Basic Auth, and more.<br/>
🔎 Filter response bodies using JSONPath or XPath queries.<br/>
⛓️ Chain together multiple requests to dynamically reference values.<br/>
📂 Organize requests into workspaces and nested folders.<br/>
🧮 Use environment variables to easily switch between Prod and Dev.<br/>
🏷️ Send dynamic values like UUIDs or timestamps using template tags.<br/>
🎨 Choose from many of the included themes, or make your own.<br/>
💽 Mirror workspace data to a directory for integration with Git or Dropbox.<br/>
📜 View response history for each request.<br/>
🔌 Create your own plugins for authentication, template tags, and more!<br/>
🛜 Configure a proxy to access firewall-blocked APIs

## Feedback and Bug Reports

All feedback, bug reports, questions, and feature requests should be reported to
[feedback.yaak.app](https://feedback.yaak.app). Issues will be duplicated
in this repository if applicable.

## Community Projects

- [`yaak2postman`](https://github.com/BiteCraft/yaak2postman) CLI for converting Yaak data
  exports to Postman-compatible collections

## Contribution Policy

Yaak is open source, but only accepting contributions for bug fixes. See the
[`good first issue`](https://github.com/yaakapp/app/labels/good%20first%20issue) label for
issues that are more approachable for contribution.

To get started, visit [`DEVELOPMENT.md`](DEVELOPMENT.md) for tips on setting up your
environment.
