use std::collections::BTreeMap;

use KeyAndValueRef::{Ascii, Binary};

use yaak_grpc::{KeyAndValueRef, MetadataMap};

pub fn metadata_to_map(metadata: MetadataMap) -> BTreeMap<String, String> {
    let mut entries = BTreeMap::new();
    for r in metadata.iter() {
        match r {
            Ascii(k, v) => entries.insert(k.to_string(), v.to_str().unwrap().to_string()),
            Binary(k, v) => entries.insert(k.to_string(), format!("{:?}", v)),
        };
    }
    entries
}
