// This file was generated by [ts-rs](https://github.com/Aleph-Alpha/ts-rs). Do not edit this file manually.
import type { Environment } from "./gen_models.js";
import type { Folder } from "./gen_models.js";
import type { GrpcRequest } from "./gen_models.js";
import type { HttpRequest } from "./gen_models.js";
import type { HttpResponse } from "./gen_models.js";
import type { JsonValue } from "./serde_json/JsonValue.js";
import type { WebsocketRequest } from "./gen_models.js";
import type { Workspace } from "./gen_models.js";

export type BootRequest = { dir: string, watch: boolean, };

export type BootResponse = { name: string, version: string, };

export type CallHttpAuthenticationActionArgs = { contextId: string, values: { [key in string]?: JsonPrimitive }, };

export type CallHttpAuthenticationActionRequest = { index: number, pluginRefId: string, args: CallHttpAuthenticationActionArgs, };

export type CallHttpAuthenticationRequest = { contextId: string, values: { [key in string]?: JsonPrimitive }, method: string, url: string, headers: Array<HttpHeader>, };

export type CallHttpAuthenticationResponse = { 
/**
 * HTTP headers to add to the request. Existing headers will be replaced, while
 * new headers will be added.
 */
setHeaders: Array<HttpHeader>, };

export type CallHttpRequestActionArgs = { httpRequest: HttpRequest, };

export type CallHttpRequestActionRequest = { index: number, pluginRefId: string, args: CallHttpRequestActionArgs, };

export type CallTemplateFunctionArgs = { purpose: RenderPurpose, values: { [key in string]?: string }, };

export type CallTemplateFunctionRequest = { name: string, args: CallTemplateFunctionArgs, };

export type CallTemplateFunctionResponse = { value: string | null, };

export type CloseWindowRequest = { label: string, };

export type Color = "primary" | "secondary" | "info" | "success" | "notice" | "warning" | "danger";

export type CompletionOptionType = "constant" | "variable";

export type Content = { "type": "text", content: string, } | { "type": "markdown", content: string, };

export type CopyTextRequest = { text: string, };

export type DeleteKeyValueRequest = { key: string, };

export type DeleteKeyValueResponse = { deleted: boolean, };

export type EditorLanguage = "text" | "javascript" | "json" | "html" | "xml" | "graphql" | "markdown";

export type EmptyPayload = {};

export type ErrorResponse = { error: string, };

export type ExportHttpRequestRequest = { httpRequest: HttpRequest, };

export type ExportHttpRequestResponse = { content: string, };

export type FileFilter = { name: string, 
/**
 * File extensions to require
 */
extensions: Array<string>, };

export type FilterRequest = { content: string, filter: string, };

export type FilterResponse = { content: string, };

export type FindHttpResponsesRequest = { requestId: string, limit?: number, };

export type FindHttpResponsesResponse = { httpResponses: Array<HttpResponse>, };

export type FormInput = { "type": "text" } & FormInputText | { "type": "editor" } & FormInputEditor | { "type": "select" } & FormInputSelect | { "type": "checkbox" } & FormInputCheckbox | { "type": "file" } & FormInputFile | { "type": "http_request" } & FormInputHttpRequest | { "type": "accordion" } & FormInputAccordion | { "type": "banner" } & FormInputBanner | { "type": "markdown" } & FormInputMarkdown;

export type FormInputAccordion = { label: string, inputs?: Array<FormInput>, hidden?: boolean, };

export type FormInputBanner = { inputs?: Array<FormInput>, hidden?: boolean, color?: Color, };

export type FormInputBase = { 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type FormInputCheckbox = { 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type FormInputEditor = { 
/**
 * Placeholder for the text input
 */
placeholder?: string | null, 
/**
 * Don't show the editor gutter (line numbers, folds, etc.)
 */
hideGutter?: boolean, 
/**
 * Language for syntax highlighting
 */
language?: EditorLanguage, readOnly?: boolean, completionOptions?: Array<GenericCompletionOption>, 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type FormInputFile = { 
/**
 * The title of the file selection window
 */
title: string, 
/**
 * Allow selecting multiple files
 */
multiple?: boolean, directory?: boolean, defaultPath?: string, filters?: Array<FileFilter>, 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type FormInputHttpRequest = { 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type FormInputMarkdown = { content: string, hidden?: boolean, };

export type FormInputSelect = { 
/**
 * The options that will be available in the select input
 */
options: Array<FormInputSelectOption>, 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type FormInputSelectOption = { label: string, value: string, };

export type FormInputText = { 
/**
 * Placeholder for the text input
 */
placeholder?: string | null, 
/**
 * Placeholder for the text input
 */
password?: boolean, 
/**
 * Whether to allow newlines in the input, like a <textarea/>
 */
multiLine?: boolean, completionOptions?: Array<GenericCompletionOption>, 
/**
 * The name of the input. The value will be stored at this object attribute in the resulting data
 */
name: string, 
/**
 * Whether this input is visible for the given configuration. Use this to
 * make branching forms.
 */
hidden?: boolean, 
/**
 * Whether the user must fill in the argument
 */
optional?: boolean, 
/**
 * The label of the input
 */
label?: string, 
/**
 * Visually hide the label of the input
 */
hideLabel?: boolean, 
/**
 * The default value
 */
defaultValue?: string, disabled?: boolean, };

export type GenericCompletionOption = { label: string, detail?: string, info?: string, type?: CompletionOptionType, boost?: number, };

export type GetHttpAuthenticationConfigRequest = { contextId: string, values: { [key in string]?: JsonPrimitive }, };

export type GetHttpAuthenticationConfigResponse = { args: Array<FormInput>, pluginRefId: string, actions?: Array<HttpAuthenticationAction>, };

export type GetHttpAuthenticationSummaryResponse = { name: string, label: string, shortLabel: string, };

export type GetHttpRequestActionsRequest = Record<string, never>;

export type GetHttpRequestActionsResponse = { actions: Array<HttpRequestAction>, pluginRefId: string, };

export type GetHttpRequestByIdRequest = { id: string, };

export type GetHttpRequestByIdResponse = { httpRequest: HttpRequest | null, };

export type GetKeyValueRequest = { key: string, };

export type GetKeyValueResponse = { value?: string, };

export type GetTemplateFunctionsResponse = { functions: Array<TemplateFunction>, pluginRefId: string, };

export type HttpAuthenticationAction = { label: string, icon?: Icon, };

export type HttpHeader = { name: string, value: string, };

export type HttpRequestAction = { label: string, icon?: Icon, };

export type Icon = "alert_triangle" | "check" | "check_circle" | "chevron_down" | "copy" | "info" | "pin" | "search" | "trash" | "_unknown";

export type ImportRequest = { content: string, };

export type ImportResources = { workspaces: Array<Workspace>, environments: Array<Environment>, folders: Array<Folder>, httpRequests: Array<HttpRequest>, grpcRequests: Array<GrpcRequest>, websocketRequests: Array<WebsocketRequest>, };

export type ImportResponse = { resources: ImportResources, };

export type InternalEvent = { id: string, pluginRefId: string, pluginName: string, replyId: string | null, windowContext: WindowContext, payload: InternalEventPayload, };

export type InternalEventPayload = { "type": "boot_request" } & BootRequest | { "type": "boot_response" } & BootResponse | { "type": "reload_request" } & EmptyPayload | { "type": "reload_response" } & EmptyPayload | { "type": "terminate_request" } | { "type": "terminate_response" } | { "type": "import_request" } & ImportRequest | { "type": "import_response" } & ImportResponse | { "type": "filter_request" } & FilterRequest | { "type": "filter_response" } & FilterResponse | { "type": "export_http_request_request" } & ExportHttpRequestRequest | { "type": "export_http_request_response" } & ExportHttpRequestResponse | { "type": "send_http_request_request" } & SendHttpRequestRequest | { "type": "send_http_request_response" } & SendHttpRequestResponse | { "type": "get_http_request_actions_request" } & EmptyPayload | { "type": "get_http_request_actions_response" } & GetHttpRequestActionsResponse | { "type": "call_http_request_action_request" } & CallHttpRequestActionRequest | { "type": "get_template_functions_request" } | { "type": "get_template_functions_response" } & GetTemplateFunctionsResponse | { "type": "call_template_function_request" } & CallTemplateFunctionRequest | { "type": "call_template_function_response" } & CallTemplateFunctionResponse | { "type": "get_http_authentication_summary_request" } & EmptyPayload | { "type": "get_http_authentication_summary_response" } & GetHttpAuthenticationSummaryResponse | { "type": "get_http_authentication_config_request" } & GetHttpAuthenticationConfigRequest | { "type": "get_http_authentication_config_response" } & GetHttpAuthenticationConfigResponse | { "type": "call_http_authentication_request" } & CallHttpAuthenticationRequest | { "type": "call_http_authentication_response" } & CallHttpAuthenticationResponse | { "type": "call_http_authentication_action_request" } & CallHttpAuthenticationActionRequest | { "type": "call_http_authentication_action_response" } & EmptyPayload | { "type": "copy_text_request" } & CopyTextRequest | { "type": "copy_text_response" } & EmptyPayload | { "type": "render_http_request_request" } & RenderHttpRequestRequest | { "type": "render_http_request_response" } & RenderHttpRequestResponse | { "type": "get_key_value_request" } & GetKeyValueRequest | { "type": "get_key_value_response" } & GetKeyValueResponse | { "type": "set_key_value_request" } & SetKeyValueRequest | { "type": "set_key_value_response" } & SetKeyValueResponse | { "type": "delete_key_value_request" } & DeleteKeyValueRequest | { "type": "delete_key_value_response" } & DeleteKeyValueResponse | { "type": "open_window_request" } & OpenWindowRequest | { "type": "window_navigate_event" } & WindowNavigateEvent | { "type": "close_window_request" } & CloseWindowRequest | { "type": "template_render_request" } & TemplateRenderRequest | { "type": "template_render_response" } & TemplateRenderResponse | { "type": "show_toast_request" } & ShowToastRequest | { "type": "show_toast_response" } & EmptyPayload | { "type": "prompt_text_request" } & PromptTextRequest | { "type": "prompt_text_response" } & PromptTextResponse | { "type": "get_http_request_by_id_request" } & GetHttpRequestByIdRequest | { "type": "get_http_request_by_id_response" } & GetHttpRequestByIdResponse | { "type": "find_http_responses_request" } & FindHttpResponsesRequest | { "type": "find_http_responses_response" } & FindHttpResponsesResponse | { "type": "empty_response" } & EmptyPayload | { "type": "error_response" } & ErrorResponse;

export type JsonPrimitive = string | number | boolean | null;

export type OpenWindowRequest = { url: string, 
/**
 * Label for the window. If not provided, a random one will be generated.
 */
label: string, title?: string, size?: WindowSize, };

export type PromptTextRequest = { id: string, title: string, label: string, description?: string, defaultValue?: string, placeholder?: string, 
/**
 * Text to add to the confirmation button
 */
confirmText?: string, 
/**
 * Text to add to the cancel button
 */
cancelText?: string, 
/**
 * Require the user to enter a non-empty value
 */
required?: boolean, };

export type PromptTextResponse = { value: string | null, };

export type RenderHttpRequestRequest = { httpRequest: HttpRequest, purpose: RenderPurpose, };

export type RenderHttpRequestResponse = { httpRequest: HttpRequest, };

export type RenderPurpose = "send" | "preview";

export type SendHttpRequestRequest = { httpRequest: Partial<HttpRequest>, };

export type SendHttpRequestResponse = { httpResponse: HttpResponse, };

export type SetKeyValueRequest = { key: string, value: string, };

export type SetKeyValueResponse = {};

export type ShowToastRequest = { message: string, color?: Color, icon?: Icon, };

export type TemplateFunction = { name: string, description?: string, 
/**
 * Also support alternative names. This is useful for not breaking existing
 * tags when changing the `name` property
 */
aliases?: Array<string>, args: Array<FormInput>, };

export type TemplateRenderRequest = { data: JsonValue, purpose: RenderPurpose, };

export type TemplateRenderResponse = { data: JsonValue, };

export type WindowContext = { "type": "none" } | { "type": "label", label: string, };

export type WindowNavigateEvent = { url: string, };

export type WindowSize = { width: number, height: number, };
