import type { InvokeArgs } from '@tauri-apps/api/core';
import { invoke } from '@tauri-apps/api/core';

type TauriCmd =
  | 'cmd_call_http_authentication_action'
  | 'cmd_call_http_request_action'
  | 'cmd_check_for_updates'
  | 'cmd_create_cookie_jar'
  | 'cmd_create_environment'
  | 'cmd_create_grpc_request'
  | 'cmd_create_http_request'
  | 'cmd_curl_to_request'
  | 'cmd_delete_all_grpc_connections'
  | 'cmd_delete_all_http_responses'
  | 'cmd_delete_cookie_jar'
  | 'cmd_delete_environment'
  | 'cmd_delete_folder'
  | 'cmd_delete_grpc_connection'
  | 'cmd_delete_grpc_request'
  | 'cmd_delete_http_request'
  | 'cmd_delete_http_response'
  | 'cmd_delete_send_history'
  | 'cmd_delete_workspace'
  | 'cmd_dismiss_notification'
  | 'cmd_duplicate_folder'
  | 'cmd_duplicate_grpc_request'
  | 'cmd_duplicate_http_request'
  | 'cmd_export_data'
  | 'cmd_filter_response'
  | 'cmd_format_json'
  | 'cmd_get_cookie_jar'
  | 'cmd_get_environment'
  | 'cmd_get_folder'
  | 'cmd_get_grpc_request'
  | 'cmd_get_http_authentication_config'
  | 'cmd_get_http_authentication_summaries'
  | 'cmd_get_http_request'
  | 'cmd_get_key_value'
  | 'cmd_get_settings'
  | 'cmd_get_sse_events'
  | 'cmd_get_workspace'
  | 'cmd_get_workspace_meta'
  | 'cmd_grpc_go'
  | 'cmd_grpc_reflect'
  | 'cmd_http_request_actions'
  | 'cmd_import_data'
  | 'cmd_install_plugin'
  | 'cmd_list_cookie_jars'
  | 'cmd_list_environments'
  | 'cmd_list_folders'
  | 'cmd_list_grpc_connections'
  | 'cmd_list_grpc_events'
  | 'cmd_list_grpc_requests'
  | 'cmd_list_http_requests'
  | 'cmd_list_http_responses'
  | 'cmd_list_key_values'
  | 'cmd_list_plugins'
  | 'cmd_list_workspaces'
  | 'cmd_metadata'
  | 'cmd_new_child_window'
  | 'cmd_new_main_window'
  | 'cmd_parse_template'
  | 'cmd_plugin_info'
  | 'cmd_reload_plugins'
  | 'cmd_render_template'
  | 'cmd_save_response'
  | 'cmd_send_ephemeral_request'
  | 'cmd_send_http_request'
  | 'cmd_set_key_value'
  | 'cmd_set_update_mode'
  | 'cmd_template_functions'
  | 'cmd_template_tokens_to_string'
  | 'cmd_track_event'
  | 'cmd_uninstall_plugin'
  | 'cmd_update_cookie_jar'
  | 'cmd_update_environment'
  | 'cmd_update_folder'
  | 'cmd_update_grpc_request'
  | 'cmd_update_http_request'
  | 'cmd_update_settings'
  | 'cmd_update_workspace'
  | 'cmd_update_workspace_meta'
  | 'cmd_write_file_dev';

export async function invokeCmd<T>(cmd: TauriCmd, args?: InvokeArgs): Promise<T> {
  // console.log('RUN COMMAND', cmd, args);
  try {
    return await invoke(cmd, args);
  } catch (err) {
    console.warn('Tauri command error', cmd, err);
    throw err;
  }
}
