(function () {
	// Establish the root object, `window` in the browser, or `exports` on the server.
	var root = this;

	// Create a safe reference to the iran object for use below.
	var iran = function (obj) {
		if (obj instanceof iran) return obj;
		if (!(this instanceof iran)) return new iran(obj);
		this._wrapped = obj;
	};

	// Export the iran object for **Node.js**, with
	// backwards-compatibility for the old `require()` API. If we're in
	// the browser, add `iran` as a global object.
	if (typeof exports !== 'undefined') {
		if (typeof module !== 'undefined' && module.exports) {
			exports = module.exports = iran;
		}
		exports.iran = iran;
	} else {
		root.iran = iran;
	}

	// Current version.
	iran.VERSION = '0.0.1';

	iran.cities = JSON.parse('[{"id":"city_35fe02d01334725a543086e3bb4ba6e9160d7a6b","city_name":"آب بر","city_creation_date":"1375","city_division_code":"70622","district_name":"مرکزی","county_name":"طارم","province_name":"زنجان"},{"id":"city_4d516f1b824ce0df9a4773c58ed496f15ad56905","city_name":"آبادان","city_creation_date":"1303","city_division_code":"70014","district_name":"مرکزی","county_name":"آبادان","province_name":"خوزستان"},{"id":"city_fd17225d705a58b5f4a76e78a1477265e25b3c0b","city_name":"آباده","city_creation_date":"1304","city_division_code":"70024","district_name":"مرکزی","county_name":"آباده","province_name":"فارس"},{"id":"city_4b3be784cdae8e7f7ad0ff6e3467ab8a2b19b193","city_name":"آباده طشک","city_creation_date":"1374","city_division_code":"70601","district_name":"آباده طشک","county_name":"نی ریز","province_name":"فارس"},{"id":"city_c461e0b36e5b1841331ee99b82416f12bfb175b2","city_name":"آبپخش","city_creation_date":"1375","city_division_code":"70664","district_name":"آبپخش","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_badff11a4c9bc41bfb0f2ca34c43353d62f49369","city_name":"آبدان","city_creation_date":"1379","city_division_code":"70870","district_name":"مرکزی","county_name":"دیر","province_name":"بوشهر"},{"id":"city_b29fc48443bef246f47a771f6f47939731079122","city_name":"آبدانان","city_creation_date":"1343","city_division_code":"70372","district_name":"مرکزی","county_name":"آبدانان","province_name":"ایلام"},{"id":"city_1ada0d4aec226afeec1878c2d56edde4ea67493b","city_name":"آبسرد","city_creation_date":"1375","city_division_code":"70650","district_name":"مرکزی","county_name":"دماوند","province_name":"تهران"},{"id":"city_38cf4bf55edab94512c3b35302c5d876a1e4a66d","city_name":"آبش احمد","city_creation_date":"1381","city_division_code":"70905","district_name":"آبش احمد","county_name":"کلیبر","province_name":"آذربایجان شرقی"},{"id":"city_fbeaccfd9c88a2888162b337e7ffcecb3b50f751","city_name":"آبعلی","city_creation_date":"1383","city_division_code":"70983","district_name":"رودهن","county_name":"دماوند","province_name":"تهران"},{"id":"city_e775f15f2c6205f799aafcbd81e6a8e2e3434eb3","city_name":"آبگرم","city_creation_date":"1380","city_division_code":"70883","district_name":"آبگرم","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_ede774637165a044f2f0dc2d9f09826f6ff9f086","city_name":"آبی بیگلو","city_creation_date":"1379","city_division_code":"70767","district_name":"ویلکیج","county_name":"نمین","province_name":"اردبیل"},{"id":"city_5f65966882a5d1c8d6fafad9287ed794524a4c04","city_name":"آبیک","city_creation_date":"1342","city_division_code":"70357","district_name":"مرکزی","county_name":"آبیک","province_name":"قزوین"},{"id":"city_86a888c78f0b0a4a39414499304b5ea1d8af2ee1","city_name":"آذرشهر","city_creation_date":"1305","city_division_code":"70031","district_name":"حومه","county_name":"آذرشهر","province_name":"آذربایجان شرقی"},{"id":"city_38f9743378afcbddb8b43398d76e203d37eaf17f","city_name":"آرادان","city_creation_date":"1339","city_division_code":"70302","district_name":"آرادان","county_name":"گرمسار","province_name":"سمنان"},{"id":"city_fbd7bf6679f6cf2273699184d1b5adf40e6335c8","city_name":"آران و بیدگل","city_creation_date":"1354","city_division_code":"70439","district_name":"مرکزی","county_name":"آران و بیدگل","province_name":"اصفهان"},{"id":"city_04c9b3c75ca80c0b41ecd5d06871961075da22c7","city_name":"آرمرده","city_creation_date":"1379","city_division_code":"70808","district_name":"آرمرده","county_name":"بانه","province_name":"کردستان"},{"id":"city_958de358f31abd845ebad08cbd93fe52c77047c2","city_name":"آرین شهر","city_creation_date":"1383","city_division_code":"70956","district_name":"سده","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_f6544d2212bf3c78e0aeab10c75b0f627827c75c","city_name":"آزاد شهر","city_creation_date":"1342","city_division_code":"70362","district_name":"مرکزی","county_name":"آزاد شهر","province_name":"گلستان"},{"id":"city_088d40b2c6bf95a3da28d6da56572d1c5e8dcfe5","city_name":"آسارا","city_creation_date":"1387","city_division_code":"71076","district_name":"آسارا","county_name":"کرج","province_name":"البرز"},{"id":"city_6cf782c543f161b9e01527a449731b9556aecd58","city_name":"آستارا","city_creation_date":"1297","city_division_code":"70004","district_name":"مرکزی","county_name":"آستارا","province_name":"گیلان"},{"id":"city_0791eed58204a606286e3c7f97e5d119d4ba4fa5","city_name":"آستانه","city_creation_date":"1359","city_division_code":"70460","district_name":"مرکزی","county_name":"شازند","province_name":"مرکزی"},{"id":"city_f70f2b13fcd0522ffcf7208dc5dc85936eb14d53","city_name":"آستانه اشرفیه","city_creation_date":"1324","city_division_code":"70157","district_name":"مرکزی","county_name":"آستانه اشرفیه","province_name":"گیلان"},{"id":"city_40d571807e46d53f7e8b0cd75d6caa82830c93cd","city_name":"آسمان آباد","city_creation_date":"1383","city_division_code":"70967","district_name":"مرکزی","county_name":"شیروان و چرداول","province_name":"ایلام"},{"id":"city_0a08339e91f4638a2fad00791dd4c2ca9bed1d15","city_name":"آشتیان","city_creation_date":"1308","city_division_code":"70065","district_name":"مرکزی","county_name":"آشتیان","province_name":"مرکزی"},{"id":"city_ede5f5a443821ff9b5261efc0cad5e9436c41ba8","city_name":"آشخانه","city_creation_date":"1362","city_division_code":"70475","district_name":"مرکزی","county_name":"مانه و سملقان","province_name":"خراسان شمالی"},{"id":"city_c2ae199f7cf0a2da10cfc9c330640df6467df3e6","city_name":"آغاجاری","city_creation_date":"1338","city_division_code":"70289","district_name":"آغاجاری","county_name":"بهبهان","province_name":"خوزستان"},{"id":"city_826450e686bcd281f9cba3303f6bc2e60f45d892","city_name":"آق قلا","city_creation_date":"1332","city_division_code":"70214","district_name":"مرکزی","county_name":"آق قلا","province_name":"گلستان"},{"id":"city_2c6189001ceb47588f250fb88895cc4a3e96f96a","city_name":"آقکند","city_creation_date":"1379","city_division_code":"70760","district_name":"کاغذکنان","county_name":"میانه","province_name":"آذربایجان شرقی"},{"id":"city_285086bfc2022827ff9222d2a846e3b1c0f9ead3","city_name":"آلاشت","city_creation_date":"1353","city_division_code":"70438","district_name":"مرکزی","county_name":"سواد کوه","province_name":"مازندران"},{"id":"city_bca9c62a079ca8d71ce2dd2f99413b24d2b19921","city_name":"آلونی","city_creation_date":"1379","city_division_code":"70775","district_name":"خانمیرزا","county_name":"لردگان","province_name":"چهار محال و بختیاری"},{"id":"city_0035c415784fa65ae335d94181ee5d8fdb4a49ed","city_name":"آمل","city_creation_date":"1312","city_division_code":"70100","district_name":"مرکزی","county_name":"آمل","province_name":"مازندران"},{"id":"city_055a6f75114aa479e01c438edc80d2ba939ff319","city_name":"آواجیق","city_creation_date":"1381","city_division_code":"70897","district_name":"دشتک","county_name":"چالدران","province_name":"آذربایجان غربی"},{"id":"city_2f0e91ab342a0f95edd9317a26709a5a70ec0261","city_name":"آوج","city_creation_date":"1342","city_division_code":"70358","district_name":"آوج","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_ee2e613e8bff256ab4704158c85e62c35fde6c20","city_name":"آیسک","city_creation_date":"1378","city_division_code":"70743","district_name":"آیسک","county_name":"سرایان","province_name":"خراسان جنوبی"},{"id":"city_b7b38bed0fda7e8f16b02bb1693350599b66ee8f","city_name":"ابرکوه","city_creation_date":"1314","city_division_code":"70120","district_name":"مرکزی","county_name":"ابرکوه","province_name":"یزد"},{"id":"city_3f244e154fef20254c486886ea7071d35a07a096","city_name":"ابریشم","city_creation_date":"1375","city_division_code":"70634","district_name":"مرکزی","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_03799dd8aa7866b1348fe126b6bf142b3cd83fdf","city_name":"ابوزید آباد","city_creation_date":"1375","city_division_code":"70671","district_name":"کویرات","county_name":"آران و بیدگل","province_name":"اصفهان"},{"id":"city_1c65cd7632d52e4fb430605152aa02b01235b0d8","city_name":"ابوموسی","city_creation_date":"1341","city_division_code":"70342","district_name":"مرکزی","county_name":"ابوموسی","province_name":"هرمزگان"},{"id":"city_7d30a8b54a8bb1fd872bd6cd5fc0e271ee128c1b","city_name":"ابهر","city_creation_date":"1307","city_division_code":"70050","district_name":"مرکزی","county_name":"ابهر","province_name":"زنجان"},{"id":"city_089ba734689d4a056f307b8326643703a7dde559","city_name":"احمد آباد","city_creation_date":"1375","city_division_code":"70657","district_name":"مرکزی","county_name":"اردکان","province_name":"یزد"},{"id":"city_5376e3b2fe05e3134a95a5b64a94a19116d87222","city_name":"احمد سرگوراب","city_creation_date":"1379","city_division_code":"70834","district_name":"احمد سرگوراب","county_name":"شفت","province_name":"گیلان"},{"id":"city_5b078881957dbca8179c61b150b93c04e69ae41f","city_name":"احمدآباد صولت","city_creation_date":"1386","city_division_code":"71039","district_name":"بوژگان","county_name":"تربت جام","province_name":"خراسان رضوی"},{"id":"city_3a801e9e136ca43b3e19bc9fadd890ed05f2c682","city_name":"اختیار آباد","city_creation_date":"1379","city_division_code":"70757","district_name":"مرکزی","county_name":"کرمان","province_name":"کرمان"},{"id":"city_d708e537c9cec941bcfff7afecd8d894d773c77c","city_name":"ادیمی","city_creation_date":"1378","city_division_code":"70733","district_name":"پشت آب","county_name":"زابل","province_name":"سیستان و بلوچستان"},{"id":"city_ccc2fe9c96fc6cfba33c455a37b439b3492b9e10","city_name":"اراک","city_creation_date":"1306","city_division_code":"70041","district_name":"مرکزی","county_name":"اراک","province_name":"مرکزی"},{"id":"city_a1d2061d2db103df6e04b5ba569adcb031c7d2a2","city_name":"ارجمند","city_creation_date":"1384","city_division_code":"70986","district_name":"ارجمند","county_name":"فیروز کوه","province_name":"تهران"},{"id":"city_18a94b614815dfa90f93fb9c4fa068df23f44b20","city_name":"ارداق","city_creation_date":"1381","city_division_code":"70893","district_name":"دشتابی","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_512c4f3055bf1ade1202aae9101b8e27f344cd57","city_name":"اردبیل","city_creation_date":"1304","city_division_code":"70016","district_name":"مرکزی","county_name":"اردبیل","province_name":"اردبیل"},{"id":"city_4f29175de766fa9e119df9c51d4b8cc5e40f4d43","city_name":"اردستان","city_creation_date":"1316","city_division_code":"70129","district_name":"مرکزی","county_name":"اردستان","province_name":"اصفهان"},{"id":"city_156239cecd6c17eb472ab87c0f61411cfc162634","city_name":"اردکان","city_creation_date":"1312","city_division_code":"70101","district_name":"مرکزی","county_name":"اردکان","province_name":"یزد"},{"id":"city_3c92eb29aaee4ea3dbf3650e0ccb8618e9e6ce07","city_name":"اردکان","city_creation_date":"1331","city_division_code":"70200","district_name":"مرکزی","county_name":"سپیدان","province_name":"فارس"},{"id":"city_5a06c2df7abede70d9f6bda51ffd7964ebae2448","city_name":"اردل","city_creation_date":"1362","city_division_code":"70472","district_name":"مرکزی","county_name":"اردل","province_name":"چهار محال و بختیاری"},{"id":"city_455a076186b44641a32b8755fbb81ee5eee0850f","city_name":"ارزوئیه","city_creation_date":"1376","city_division_code":"70693","district_name":"مرکزی","county_name":"ارزوئیه","province_name":"کرمان"},{"id":"city_10d49138183794d7883b5161c17cfe1e808d7a77","city_name":"ارسک","city_creation_date":"1389","city_division_code":"71114","district_name":"ارسک","county_name":"بشرویه","province_name":"خراسان جنوبی"},{"id":"city_3ba490e6ab9b408e473c89ad0fee8507f2214f5a","city_name":"ارسنجان","city_creation_date":"1335","city_division_code":"70240","district_name":"مرکزی","county_name":"ارسنجان","province_name":"فارس"},{"id":"city_1fcebd9c379ffeec0fb017ebb254f54f78eb68e4","city_name":"ارکواز","city_creation_date":"1343","city_division_code":"70378","district_name":"مرکزی","county_name":"ملکشاهی","province_name":"ایلام"},{"id":"city_c2aea366fadb8df16be53fd52c486c060c57c9d1","city_name":"ارمخانخانه","city_creation_date":"1387","city_division_code":"71077","district_name":"قره پشتلو","county_name":"زنجان","province_name":"زنجان"},{"id":"city_7ecc23e1c159879e8b384e6fae8bfa48223b8c04","city_name":"ارومیه","city_creation_date":"1307","city_division_code":"70044","district_name":"مرکزی","county_name":"ارومیه","province_name":"آذربایجان غربی"},{"id":"city_d21f47300a41a767bf58589fa9c1500ed0283326","city_name":"اروند کنار","city_creation_date":"1338","city_division_code":"70287","district_name":"اروند کنار","county_name":"آبادان","province_name":"خوزستان"},{"id":"city_ce1d68c0a7981f423de971507b341c1db5ef32a6","city_name":"ازگله","city_creation_date":"1384","city_division_code":"70991","district_name":"ازگله","county_name":"ثلاث باباجانی","province_name":"کرمانشاه"},{"id":"city_e691ba802b574a0cf1bae9ed5cd30e8e211f23af","city_name":"ازنا","city_creation_date":"1342","city_division_code":"70363","district_name":"مرکزی","county_name":"ازنا","province_name":"لرستان"},{"id":"city_4aab95c19931e4970f8c8fb9be97ce3eb1ad7460","city_name":"ازندریان","city_creation_date":"1375","city_division_code":"70661","district_name":"جوکار","county_name":"ملایر","province_name":"همدان"},{"id":"city_a81b7fb8b77526396f4d242ede24e0465fe5cd68","city_name":"اژیه","city_creation_date":"1375","city_division_code":"70630","district_name":"جلگه","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_39e1f9fab91a58852359b35e7ba4f80b70600666","city_name":"اسالم","city_creation_date":"1379","city_division_code":"70835","district_name":"اسالم","county_name":"طوالش","province_name":"گیلان"},{"id":"city_79fa4c654ad916cfb324cdac0dd680f4093d5f5c","city_name":"اسپکه","city_creation_date":"1379","city_division_code":"70803","district_name":"لاشار","county_name":"نیک شهر","province_name":"سیستان و بلوچستان"},{"id":"city_7b2b9cf6e2799958cf2ba483fb021c31aa5d5c84","city_name":"استهبان","city_creation_date":"1307","city_division_code":"70052","district_name":"مرکزی","county_name":"استهبان","province_name":"فارس"},{"id":"city_6e17544b970ed516e9ba3ffa3d2c3ec74be43318","city_name":"اسد آباد","city_creation_date":"1310","city_division_code":"70090","district_name":"مرکزی","county_name":"اسد آباد","province_name":"همدان"},{"id":"city_bdbb478207d3cc2b32e563159121f99c75b9116f","city_name":"اسدیه","city_creation_date":"1375","city_division_code":"70637","district_name":"مرکزی","county_name":"درمیان","province_name":"خراسان جنوبی"},{"id":"city_93f405e0ee316b32341d926829fb111c1f84c361","city_name":"اسفدن","city_creation_date":"1383","city_division_code":"70957","district_name":"مرکزی","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_17f839de57fb8d194e6bdff988b1f80dff8ba479","city_name":"اسفراین","city_creation_date":"1316","city_division_code":"70132","district_name":"مرکزی","county_name":"اسفراین","province_name":"خراسان شمالی"},{"id":"city_a37f1dcb01eeeb514fa2de379138c37db8befe1b","city_name":"اسفرورین","city_creation_date":"1368","city_division_code":"70498","district_name":"اسفرورین","county_name":"تاکستان","province_name":"قزوین"},{"id":"city_d30f66bed49992f171efabfbab58abbb8e2414da","city_name":"اسکو","city_creation_date":"1311","city_division_code":"70093","district_name":"مرکزی","county_name":"اسکو","province_name":"آذربایجان شرقی"},{"id":"city_f08b3f2f390666b10924d6018e4a8436b5de8b63","city_name":"اسلام آباد غرب","city_creation_date":"1315","city_division_code":"70127","district_name":"مرکزی","county_name":"اسلام آباد غرب","province_name":"کرمانشاه"},{"id":"city_fd653216a93b9fd2045837a34661bdc46ec60290","city_name":"اسلامشهر","city_creation_date":"1357","city_division_code":"70454","district_name":"مرکزی","county_name":"اسلامشهر","province_name":"تهران"},{"id":"city_f0b70aa68821139958f93b27f3a7545d390dc3dd","city_name":"اسلامیه","city_creation_date":"1354","city_division_code":"70441","district_name":"مرکزی","county_name":"فردوس","province_name":"خراسان جنوبی"},{"id":"city_87ad08134bfb06e78278ad52a018ed11cb3afb3a","city_name":"اسیر","city_creation_date":"1389","city_division_code":"71109","district_name":"اسیر","county_name":"مهر","province_name":"فارس"},{"id":"city_5541968a1b3319d62be8ca0dad18b0571edced7f","city_name":"اشترینان","city_creation_date":"1335","city_division_code":"70245","district_name":"اشترینان","county_name":"بروجرد","province_name":"لرستان"},{"id":"city_2294f3c2c558376f6699f2af5c825ea1af86f215","city_name":"اشتهارد","city_creation_date":"1330","city_division_code":"70185","district_name":"اشتهارد","county_name":"کرج","province_name":"البرز"},{"id":"city_80422f9a702a6d8b2390e126ed3066d5dfa0afb7","city_name":"اشکذر","city_creation_date":"1343","city_division_code":"70384","district_name":"مرکزی","county_name":"صدوق","province_name":"یزد"},{"id":"city_63435e9fa2a6dde3669822a53bf50c5ab5aeb170","city_name":"اشکنان","city_creation_date":"1373","city_division_code":"70587","district_name":"اشکنان","county_name":"لامرد","province_name":"فارس"},{"id":"city_38fc3f3dd61c264c7ef67dcf815bc33008d8c266","city_name":"اشنویه","city_creation_date":"1332","city_division_code":"70206","district_name":"مرکزی","county_name":"اشنویه","province_name":"آذربایجان غربی"},{"id":"city_e6360a71b5ebc764492efc4954f463768120499e","city_name":"اصفهان","city_creation_date":"1307","city_division_code":"70046","district_name":"مرکزی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_4bdf560c5b8c098c351eef218558f0dc3ee00cc3","city_name":"اصلاندوز","city_creation_date":"1372","city_division_code":"70569","district_name":"اصلاندوز","county_name":"پارس آباد","province_name":"اردبیل"},{"id":"city_686631be357ef20bd0ee34c43af5c33938c10bd9","city_name":"اطاقور","city_creation_date":"1379","city_division_code":"70838","district_name":"اطاقور","county_name":"لنگرود","province_name":"گیلان"},{"id":"city_cbf7fc12de7d5a45da9ad5bf078fa318187cf186","city_name":"افزر","city_creation_date":"1384","city_division_code":"71003","district_name":"افزر","county_name":"قیروکارزین","province_name":"فارس"},{"id":"city_433b653994d3835a36291158a9559c8004b3d26d","city_name":"افوس","city_creation_date":"1375","city_division_code":"70632","district_name":"بوئین و میاندشت","county_name":"فریدن","province_name":"اصفهان"},{"id":"city_66c3e1f3439ba501953e018856ee1d161ed3f05a","city_name":"اقبالیه","city_creation_date":"1370","city_division_code":"70538","district_name":"مرکزی","county_name":"قزوین","province_name":"قزوین"},{"id":"city_3e5152c02c14ebba5339b85a52e187f8c291508c","city_name":"اقلید","city_creation_date":"1317","city_division_code":"70143","district_name":"مرکزی","county_name":"اقلید","province_name":"فارس"},{"id":"city_dea5e56c0e948e41c347c18fedabe65538f74b68","city_name":"الشتر","city_creation_date":"1340","city_division_code":"70319","district_name":"مرکزی","county_name":"سلسله","province_name":"لرستان"},{"id":"city_26198ecfdb073df4057490f5bfd652118a9de0ee","city_name":"الوان","city_creation_date":"1376","city_division_code":"70690","district_name":"شاوور","county_name":"شوش","province_name":"خوزستان"},{"id":"city_2a79c7d33eb41fd8c2bf86abd995edf2ef58918a","city_name":"الوند","city_creation_date":"1361","city_division_code":"70465","district_name":"مرکزی","county_name":"البرز","province_name":"قزوین"},{"id":"city_d06b1784db6d20a6803ccbc1c0b53f2e662a066a","city_name":"الیگودرز","city_creation_date":"1314","city_division_code":"70115","district_name":"مرکزی","county_name":"الیگودرز","province_name":"لرستان"},{"id":"city_25af7ec319b2be051306631fadc1fef7b6538ada","city_name":"امام حسن","city_creation_date":"1378","city_division_code":"70732","district_name":"امام حسن","county_name":"دیلم","province_name":"بوشهر"},{"id":"city_c0b1c539a42996962c5c256be9cd20207a05aa35","city_name":"امام شهر","city_creation_date":"1386","city_division_code":"71051","district_name":"مرکزی","county_name":"قیروکارزین","province_name":"فارس"},{"id":"city_fe90a29e98d7ca1192878331b912d8cea0df8fb2","city_name":"املش","city_creation_date":"1336","city_division_code":"70265","district_name":"مرکزی","county_name":"املش","province_name":"گیلان"},{"id":"city_a757d063f5210f4ea4baa987acfbfee0f9507dce","city_name":"امیدیه","city_creation_date":"1369","city_division_code":"70288","district_name":"مرکزی","county_name":"امیدیه","province_name":"خوزستان"},{"id":"city_8c6cf1c0f5c1c600e1f920380928e16af1a85883","city_name":"امیر کلا","city_creation_date":"1332","city_division_code":"70216","district_name":"مرکزی","county_name":"بابل","province_name":"مازندران"},{"id":"city_adb36df76e503e790b232de94ff1256469dc8719","city_name":"امیریه","city_creation_date":"1375","city_division_code":"70623","district_name":"امیر آباد","county_name":"دامغان","province_name":"سمنان"},{"id":"city_0ecf6c0c0a4bb30ad4852b1740c87a43d8ae362b","city_name":"امین شهر","city_creation_date":"1375","city_division_code":"70667","district_name":"انار","county_name":"انار","province_name":"کرمان"},{"id":"city_fbb67cce74a202394a1ac5bcf7eb5f63ebae66ce","city_name":"انابد","city_creation_date":"1379","city_division_code":"70777","district_name":"انابد","county_name":"بردسکن","province_name":"خراسان رضوی"},{"id":"city_9efeee7fd94457e690c9e0fd26f090f73cfe8aa4","city_name":"انار","city_creation_date":"1335","city_division_code":"70243","district_name":"انار","county_name":"انار","province_name":"کرمان"},{"id":"city_01209b5109dac87f223b148349d6f961085c4559","city_name":"انارستان","city_creation_date":"1388","city_division_code":"71095","district_name":"ریز","county_name":"جم","province_name":"بوشهر"},{"id":"city_35a4e37e69b70d84e0595dad69546920ccf476d0","city_name":"انارک","city_creation_date":"1337","city_division_code":"70271","district_name":"انارک","county_name":"نائین","province_name":"اصفهان"},{"id":"city_218f739a9783fe01c1c0115d2d8c68ea8df7b21e","city_name":"انبار آلوم","city_creation_date":"1380","city_division_code":"70886","district_name":"وشمگیر","county_name":"آق قلا","province_name":"گلستان"},{"id":"city_f7847bb2bbeeb77b9de4018317c889a8505d27f7","city_name":"اندوهجرد","city_creation_date":"1383","city_division_code":"70944","district_name":"شهداد","county_name":"کرمان","province_name":"کرمان"},{"id":"city_ab20b08a78d929fb935588f8283cb1bca3d88860","city_name":"اندیشه","city_creation_date":"1381","city_division_code":"70904","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_bc445772185ca02e0c11b3224aeaa1b7cff24f53","city_name":"اندیمشک","city_creation_date":"1335","city_division_code":"70239","district_name":"مرکزی","county_name":"اندیمشک","province_name":"خوزستان"},{"id":"city_0bd46a7d03498c928783244becaba79a04f27a68","city_name":"اورامان تخت","city_creation_date":"1390","city_division_code":"71145","district_name":"اورامان","county_name":"سروآباد","province_name":"کردستان"},{"id":"city_5cd1e21e543b2e31fb3bce9d0b7d5285c065fa4b","city_name":"اوز","city_creation_date":"1334","city_division_code":"70236","district_name":"اوز","county_name":"لارستان","province_name":"فارس"},{"id":"city_64ea4a5f3fae5a25b58403dc3e26689d0b54da85","city_name":"اهر","city_creation_date":"1351","city_division_code":"70436","district_name":"مرکزی","county_name":"اهر","province_name":"آذربایجان شرقی"},{"id":"city_33557f4f412343af108b5a6633ecc844100e3fcc","city_name":"اهرم","city_creation_date":"1344","city_division_code":"70393","district_name":"مرکزی","county_name":"تنگستان","province_name":"بوشهر"},{"id":"city_2ffb6b57ad291408f529b6a979bed42acd4fbb0c","city_name":"اهل","city_creation_date":"1375","city_division_code":"70641","district_name":"اشکنان","county_name":"لامرد","province_name":"فارس"},{"id":"city_aff27f96ed2f0bff8fc83e7a67234c2fd5f56984","city_name":"اهواز","city_creation_date":"1304","city_division_code":"70020","district_name":"مرکزی","county_name":"اهواز","province_name":"خوزستان"},{"id":"city_a78bef4ecba7bb8cfdb41d400d7466d00648bad1","city_name":"ایج","city_creation_date":"1381","city_division_code":"70924","district_name":"مرکزی","county_name":"استهبان","province_name":"فارس"},{"id":"city_10938011ce1ab642ef39454a7734144a886af5de","city_name":"ایذه","city_creation_date":"1337","city_division_code":"70276","district_name":"مرکزی","county_name":"ایذه","province_name":"خوزستان"},{"id":"city_e70177f0fc5aa6e7df618ffb10f8b93fc7fdf0f6","city_name":"ایرانشهر","city_creation_date":"1329","city_division_code":"70176","district_name":"مرکزی","county_name":"ایرانشهر","province_name":"سیستان و بلوچستان"},{"id":"city_43652c9435b8d75ad9087cb6ce8e98ac9b017d49","city_name":"ایزد خواست","city_creation_date":"1378","city_division_code":"70737","district_name":"مرکزی","county_name":"آباده","province_name":"فارس"},{"id":"city_5d5682a122ae58fed459c03220fa21d5cefc7255","city_name":"ایزد شهر","city_creation_date":"1384","city_division_code":"71000","district_name":"مرکزی","county_name":"نور","province_name":"مازندران"},{"id":"city_a4d878bbc6d72c888480d5de0844f3dbc0d56d3a","city_name":"ایلام","city_creation_date":"1315","city_division_code":"70123","district_name":"مرکزی","county_name":"ایلام","province_name":"ایلام"},{"id":"city_6f17c1a104edfce2d325cb735877c10b640aa56b","city_name":"ایلخچی","city_creation_date":"1340","city_division_code":"70310","district_name":"ایلخچی","county_name":"اسکو","province_name":"آذربایجان شرقی"},{"id":"city_54a92fe12c34a344a656289e3255393394a796af","city_name":"ایمانشهر","city_creation_date":"1379","city_division_code":"70862","district_name":"مرکزی","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_6ccae13a8d692c63b6fba1816719939367575b3a","city_name":"اینچه برون","city_creation_date":"1379","city_division_code":"70831","district_name":"داشلی برون","county_name":"گنبد کاووس","province_name":"گلستان"},{"id":"city_1d120866630bf055b1f2f207b731757bdf3533da","city_name":"ایوان","city_creation_date":"1343","city_division_code":"70373","district_name":"مرکزی","county_name":"ایوان","province_name":"ایلام"},{"id":"city_21a0cc71c4cbc88cee3679c1347108d331b2c7d7","city_name":"ایوانکی","city_creation_date":"1320","city_division_code":"70153","district_name":"ایوانکی","county_name":"گرمسار","province_name":"سمنان"},{"id":"city_4b158947a917b3d3a1fe79a21d1f141f122e9e66","city_name":"ایواوغلی","city_creation_date":"1379","city_division_code":"70753","district_name":"ایواوغلی","county_name":"خوی","province_name":"آذربایجان غربی"},{"id":"city_9810c1e201a0c24d8beb1ac6f92a760ea827bed0","city_name":"ایور","city_creation_date":"1386","city_division_code":"71030","district_name":"مرکزی","county_name":"گرمه","province_name":"خراسان شمالی"},{"id":"city_c1f05c41ced0a344ecde13f62721f997a0c9fd7b","city_name":"باب انار","city_creation_date":"1375","city_division_code":"70625","district_name":"خفر","county_name":"جهرم","province_name":"فارس"},{"id":"city_57e2d5753cb7376c7becca5f8607def1b4acf3a7","city_name":"باباحیدر","city_creation_date":"1370","city_division_code":"70542","district_name":"مرکزی","county_name":"فارسان","province_name":"چهار محال و بختیاری"},{"id":"city_790f088fb8f8e05ba63b287d7617404337fcdd7a","city_name":"بابارشانی","city_creation_date":"1379","city_division_code":"70811","district_name":"چنگ الماس","county_name":"بیجار","province_name":"کردستان"},{"id":"city_14f565e7246a99b1356729a5a74df7d72553d30d","city_name":"بابل","city_creation_date":"1335","city_division_code":"70246","district_name":"مرکزی","county_name":"بابل","province_name":"مازندران"},{"id":"city_2a064c01a72de837e4c61d5390001a26ae56be71","city_name":"بابلسر","city_creation_date":"1306","city_division_code":"70039","district_name":"مرکزی","county_name":"بابلسر","province_name":"مازندران"},{"id":"city_877e0bd6406536b8967a3083f969b7452b21e593","city_name":"باجگیران","city_creation_date":"1308","city_division_code":"70060","district_name":"باجگیران","county_name":"قوچان","province_name":"خراسان رضوی"},{"id":"city_6b56480b230c1e38352656f2c9785c4ae075007a","city_name":"باخرز","city_creation_date":"1369","city_division_code":"70521","district_name":"مرکزی","county_name":"باخرز","province_name":"خراسان رضوی"},{"id":"city_d68ff3242b325ca7642ef2c602a8bb1ec39ffdbb","city_name":"بادرود","city_creation_date":"1355","city_division_code":"70445","district_name":"امام زاده","county_name":"نطنز","province_name":"اصفهان"},{"id":"city_ad95a12a7c024ba11d1fc3a6681e60ae26b96d67","city_name":"بار","city_creation_date":"1386","city_division_code":"71029","district_name":"مرکزی","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_6ade18deee6be0bf1115915e719cf9c72b53895d","city_name":"باروق","city_creation_date":"1383","city_division_code":"70952","district_name":"باروق","county_name":"میاندوآب","province_name":"آذربایجان غربی"},{"id":"city_70c0a860d806989de2cebcb991bf213dac23f67e","city_name":"بازار جمعه","city_creation_date":"1378","city_division_code":"70728","district_name":"شاندرمن","county_name":"ماسال","province_name":"گیلان"},{"id":"city_8a4c50c566706933f6d5aca884053a4a1a927aeb","city_name":"بازرگان","city_creation_date":"1375","city_division_code":"70627","district_name":"بازرگان","county_name":"ماکو","province_name":"آذربایجان غربی"},{"id":"city_31f20b7db8cb51bbc7a2f495614ff9499a32bcc1","city_name":"باسمنج","city_creation_date":"1328","city_division_code":"70167","district_name":"مرکزی","county_name":"تبریز","province_name":"آذربایجان شرقی"},{"id":"city_256bcc35a76e2765ef77b566617137b25196e368","city_name":"باشت","city_creation_date":"1369","city_division_code":"70514","district_name":"مرکزی","county_name":"باشت","province_name":"کهگیلویه و بویراحمد"},{"id":"city_aad925c43d7003e3572d509f62d547d7c5bee044","city_name":"باغ بهادران","city_creation_date":"1341","city_division_code":"70325","district_name":"باغ بهادران","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_35caadc9d93259a07a960f9c0559b976ae4091fd","city_name":"باغ ملک","city_creation_date":"1362","city_division_code":"70484","district_name":"مرکزی","county_name":"باغ ملک","province_name":"خوزستان"},{"id":"city_bdf7804dae5e1f14958576679ca946b7bd2dcb2c","city_name":"باغستان","city_creation_date":"1383","city_division_code":"70962","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_ea4febc410fb8aac814e116579b1ebcd62708e66","city_name":"باغین","city_creation_date":"1375","city_division_code":"70644","district_name":"مرکزی","county_name":"کرمان","province_name":"کرمان"},{"id":"city_ae4ba9bacb997cdc91c499c17084c338ee1027cd","city_name":"بافت","city_creation_date":"1325","city_division_code":"70160","district_name":"مرکزی","county_name":"بافت","province_name":"کرمان"},{"id":"city_35028d158d1d8998c0b6a8356e860e99dc353b32","city_name":"بافران","city_creation_date":"1388","city_division_code":"71103","district_name":"مرکزی","county_name":"نائین","province_name":"اصفهان"},{"id":"city_bfb31c387a02c447e34a286ebbc3b5f89b56d2eb","city_name":"بافق","city_creation_date":"1332","city_division_code":"70217","district_name":"مرکزی","county_name":"بافق","province_name":"یزد"},{"id":"city_dfd7330f6ecc5dfda37ba9b49471af8bdcf90700","city_name":"باقرشهر","city_creation_date":"1375","city_division_code":"70635","district_name":"کهریزک","county_name":"ری","province_name":"تهران"},{"id":"city_27cffd1280c02e59d0b7211e514b30f5baebdeb9","city_name":"بالاده","city_creation_date":"1379","city_division_code":"70804","district_name":"جره و بالاده","county_name":"کازرون","province_name":"فارس"},{"id":"city_1a381cf8e14156ec32cf792534c8ce6a4a181e1c","city_name":"بانه","city_creation_date":"1327","city_division_code":"70166","district_name":"مرکزی","county_name":"بانه","province_name":"کردستان"},{"id":"city_fac3cbbfd638ffca5dd3ff5892248abfd1a3bf70","city_name":"بایک","city_creation_date":"1378","city_division_code":"70742","district_name":"بایک","county_name":"تربت حیدریه","province_name":"خراسان رضوی"},{"id":"city_716082c89c7e83dbb8a4934de36bfa1f62a9e9f5","city_name":"باینگان","city_creation_date":"1372","city_division_code":"70545","district_name":"باینگان","county_name":"پاوه","province_name":"کرمانشاه"},{"id":"city_908de3e73831398fd3013f93240a7a889a590449","city_name":"بجستان","city_creation_date":"1317","city_division_code":"70140","district_name":"مرکزی","county_name":"بجستان","province_name":"خراسان رضوی"},{"id":"city_a851e4eab61d85f8bbbe40599b3d9ebd47227ebd","city_name":"بجنورد","city_creation_date":"1310","city_division_code":"70081","district_name":"مرکزی","county_name":"بجنورد","province_name":"خراسان شمالی"},{"id":"city_c7c70d72f521cba4918174874510211c0d90dca0","city_name":"بخشایش","city_creation_date":"1375","city_division_code":"70616","district_name":"مرکزی","county_name":"هریس","province_name":"آذربایجان شرقی"},{"id":"city_8cea1a07ad9785b6806ec01ee24cedf5933f8374","city_name":"بدره","city_creation_date":"1343","city_division_code":"70374","district_name":"بدره","county_name":"دره شهر","province_name":"ایلام"},{"id":"city_2bb64bc70644d847fe7008a06fdc98e3a3f99d5f","city_name":"برازجان","city_creation_date":"1307","city_division_code":"70047","district_name":"مرکزی","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_45cb741febedea879a188f186870e43ec3ee88b0","city_name":"بردخون","city_creation_date":"1379","city_division_code":"70859","district_name":"بردخون","county_name":"دیر","province_name":"بوشهر"},{"id":"city_166e1ae3854ab127654610e41f5cd359c43e7f9e","city_name":"بردستان","city_creation_date":"1389","city_division_code":"71133","district_name":"مرکزی","county_name":"دیر","province_name":"بوشهر"},{"id":"city_b493ed5214a0f38ff1379d94cd66c5997836e753","city_name":"بردسکن","city_creation_date":"1340","city_division_code":"70314","district_name":"مرکزی","county_name":"بردسکن","province_name":"خراسان رضوی"},{"id":"city_0521cec6be376c82595213a6a1b10009200a2311","city_name":"بردسیر","city_creation_date":"1335","city_division_code":"70241","district_name":"مرکزی","county_name":"بردسیر","province_name":"کرمان"},{"id":"city_1fcb02db7a1202b066d74f49a78ec7c5602d5c3c","city_name":"برده رشه","city_creation_date":"1390","city_division_code":"71146","district_name":"خاوومیر آباد","county_name":"مریوان","province_name":"کردستان"},{"id":"city_e199ac6678d06814a96156df0c117f45767f5988","city_name":"برزک","city_creation_date":"1381","city_division_code":"70910","district_name":"برزک","county_name":"کاشان","province_name":"اصفهان"},{"id":"city_c9ae3c2cf06e338303b2cd2f2b91c5ed96279fbf","city_name":"برزول","city_creation_date":"1384","city_division_code":"71011","district_name":"زرین دشت","county_name":"نهاوند","province_name":"همدان"},{"id":"city_b8f0109f97dfe15882751c50afcd3bc52d4ad17b","city_name":"برف انبار","city_creation_date":"1381","city_division_code":"70909","district_name":"مرکزی","county_name":"فریدونشهر","province_name":"اصفهان"},{"id":"city_2e22a35352a04dc9b42dfcd8d9b97e9a60dfd69b","city_name":"بروات","city_creation_date":"1335","city_division_code":"70242","district_name":"مرکزی","county_name":"بم","province_name":"کرمان"},{"id":"city_893a1336ec09eb1b4a9636190e2f028619c9db65","city_name":"بروجرد","city_creation_date":"1314","city_division_code":"70116","district_name":"مرکزی","county_name":"بروجرد","province_name":"لرستان"},{"id":"city_f690fde752cd21de002cb29363ba1fe600886539","city_name":"بروجن","city_creation_date":"1312","city_division_code":"70099","district_name":"مرکزی","county_name":"بروجن","province_name":"چهار محال و بختیاری"},{"id":"city_367014f5d9f2418df40cfa2edf55804e6984f7fb","city_name":"بره سر","city_creation_date":"1379","city_division_code":"70833","district_name":"خورگام","county_name":"رودبار","province_name":"گیلان"},{"id":"city_2e287d92b2eeba6bd35512b3c98ad8d9078109eb","city_name":"بزمان","city_creation_date":"1379","city_division_code":"70795","district_name":"بزمان","county_name":"ایرانشهر","province_name":"سیستان و بلوچستان"},{"id":"city_dd4d7312bdff80a7b37242ba583f2d2340d584a6","city_name":"بزنجان","city_creation_date":"1374","city_division_code":"70602","district_name":"مرکزی","county_name":"بافت","province_name":"کرمان"},{"id":"city_d1bc6304236c8b553d66fe315b9819ddf0e40a37","city_name":"بستان","city_creation_date":"1334","city_division_code":"70234","district_name":"بستان","county_name":"دشت آزادگان","province_name":"خوزستان"},{"id":"city_c9014c240be8ae12e71940150e6b34d97c39c027","city_name":"بستان آباد","city_creation_date":"1331","city_division_code":"70197","district_name":"مرکزی","county_name":"بستان آباد","province_name":"آذربایجان شرقی"},{"id":"city_4d2129ab24d846e4e09e07a30f181c1bb24fa04b","city_name":"بستک","city_creation_date":"1331","city_division_code":"70203","district_name":"مرکزی","county_name":"بستک","province_name":"هرمزگان"},{"id":"city_c102700b8c556367f8a9c7ae49710c79b2c4b2f4","city_name":"بسطام","city_creation_date":"1339","city_division_code":"70301","district_name":"بسطام","county_name":"شاهرود","province_name":"سمنان"},{"id":"city_d2f5e596b6f01f73e56cccf2fd0a2a16fb1f9d4a","city_name":"بشرویه","city_creation_date":"1332","city_division_code":"70211","district_name":"مرکزی","county_name":"بشرویه","province_name":"خراسان جنوبی"},{"id":"city_dbc4943a7936c4e270d7528c0bf94682fa07693b","city_name":"بفروئیه","city_creation_date":"1386","city_division_code":"71061","district_name":"مرکزی","county_name":"میبد","province_name":"یزد"},{"id":"city_64b2cb167cd6599719e028722e4814fd185a5b3e","city_name":"بلبان آباد","city_creation_date":"1388","city_division_code":"71083","district_name":"بلبان آباد","county_name":"دهگلان","province_name":"کردستان"},{"id":"city_40933104a862aca94524d2e0889fa9786b20ecfc","city_name":"بلداجی","city_creation_date":"1362","city_division_code":"70473","district_name":"بلداجی","county_name":"بروجن","province_name":"چهار محال و بختیاری"},{"id":"city_ef9a2983450db3ddbf4db9f1018133a5844d102f","city_name":"بلده","city_creation_date":"1379","city_division_code":"70850","district_name":"بلده","county_name":"نور","province_name":"مازندران"},{"id":"city_fea059fc9ed64085d24116637fdac3621d6b637d","city_name":"بم","city_creation_date":"1314","city_division_code":"70113","district_name":"مرکزی","county_name":"بم","province_name":"کرمان"},{"id":"city_1876d9d9ddc6320b72e3b0662447249e3254e072","city_name":"بمپور","city_creation_date":"1369","city_division_code":"70510","district_name":"بمپور","county_name":"ایرانشهر","province_name":"سیستان و بلوچستان"},{"id":"city_4ca700566b57a775f7eb3bd36fce013996b17158","city_name":"بن","city_creation_date":"1355","city_division_code":"70447","district_name":"بن","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_10ae0b62261e746d01a70b2cc4e0ac59bcd54698","city_name":"بناب","city_creation_date":"1309","city_division_code":"70066","district_name":"مرکزی","county_name":"بناب","province_name":"آذربایجان شرقی"},{"id":"city_b12b9f3eef1890f8e68ba926a38c5961321d5fd2","city_name":"بناب جدید","city_creation_date":"1383","city_division_code":"70951","district_name":"مرکزی","county_name":"مرند","province_name":"آذربایجان شرقی"},{"id":"city_78a05d751d2c8cc565eb9f7d5a0856be3ec45853","city_name":"بنارویه","city_creation_date":"1372","city_division_code":"70550","district_name":"بنارویه","county_name":"لارستان","province_name":"فارس"},{"id":"city_bd9c04cd1b5f7bc821128fa9d7d46670ea179a99","city_name":"بنت","city_creation_date":"1379","city_division_code":"70802","district_name":"بنت","county_name":"نیک شهر","province_name":"سیستان و بلوچستان"},{"id":"city_ea6e7335c22b85df4574d970f217be7d01b92e43","city_name":"بنجار","city_creation_date":"1379","city_division_code":"70798","district_name":"مرکزی","county_name":"زابل","province_name":"سیستان و بلوچستان"},{"id":"city_64216a1d253ec4bb912b79af0963cfeb8c39e9a1","city_name":"بندر امام خمینی","city_creation_date":"1333","city_division_code":"70221","district_name":"بندر امام خمینی","county_name":"بندر ماهشهر","province_name":"خوزستان"},{"id":"city_a3d4e28797c50cbb37b88538a39aa1599592355f","city_name":"بندر انزلی","city_creation_date":"1301","city_division_code":"70010","district_name":"مرکزی","county_name":"بندر انزلی","province_name":"گیلان"},{"id":"city_afe625ad83c4e9a74db0cc9585dff02344abea6b","city_name":"بندر ترکمن","city_creation_date":"1311","city_division_code":"70096","district_name":"مرکزی","county_name":"ترکمن","province_name":"گلستان"},{"id":"city_30677523b1e4211471d3d068383e8dddd5107aca","city_name":"بندر جاسک","city_creation_date":"1339","city_division_code":"70309","district_name":"مرکزی","county_name":"جاسک","province_name":"هرمزگان"},{"id":"city_5b79e59800222bb01fa0c0d3482d16b920aff4bc","city_name":"بندر دیر","city_creation_date":"1345","city_division_code":"70411","district_name":"مرکزی","county_name":"دیر","province_name":"بوشهر"},{"id":"city_5189bc07bc6aef8bb0f14ccba2a956ff52ff8b83","city_name":"بندر دیلم","city_creation_date":"1337","city_division_code":"70273","district_name":"مرکزی","county_name":"دیلم","province_name":"بوشهر"},{"id":"city_bf64aef70c3100b2695e8ea7fb78543544febd4c","city_name":"بندر ریگ","city_creation_date":"1343","city_division_code":"70379","district_name":"ریگ","county_name":"گناوه","province_name":"بوشهر"},{"id":"city_6ad6df404b09e77aacb32ca08dc56cb0a80830bb","city_name":"بندر عباس","city_creation_date":"1304","city_division_code":"70030","district_name":"مرکزی","county_name":"بندرعباس","province_name":"هرمزگان"},{"id":"city_33c9924f4202475f93517e6f1ad8340a8883842d","city_name":"بندر کنگان","city_creation_date":"1341","city_division_code":"70327","district_name":"مرکزی","county_name":"کنگان","province_name":"بوشهر"},{"id":"city_b0666797496ce3504b739d898b085de892784e1c","city_name":"بندر گز","city_creation_date":"1310","city_division_code":"70086","district_name":"مرکزی","county_name":"بندر گز","province_name":"گلستان"},{"id":"city_7a2a048cfd55ffaa15639afd4da7793bd10636c5","city_name":"بندر گناوه","city_creation_date":"1341","city_division_code":"70328","district_name":"مرکزی","county_name":"گناوه","province_name":"بوشهر"},{"id":"city_1c47a55990352c7a12ed430614d296896b4083c6","city_name":"بندر لنگه","city_creation_date":"1314","city_division_code":"70119","district_name":"مرکزی","county_name":"بندرلنگه","province_name":"هرمزگان"},{"id":"city_22aa6ea39704b656c4e552a44022eb8d037047a2","city_name":"بندر ماهشهر","city_creation_date":"1333","city_division_code":"70222","district_name":"مرکزی","county_name":"بندر ماهشهر","province_name":"خوزستان"},{"id":"city_214f958dcbb005c6d45d0c92ea39774d6fd4f062","city_name":"بنک","city_creation_date":"1382","city_division_code":"70938","district_name":"مرکزی","county_name":"کنگان","province_name":"بوشهر"},{"id":"city_dcf3b6a0e58c76265822a4e8b8f083a4ceee031f","city_name":"بوانات","city_creation_date":"1342","city_division_code":"70356","district_name":"مرکزی","county_name":"بوانات","province_name":"فارس"},{"id":"city_cb84bc6e0de4d7dbd2fc2e20f290a929f66ed0bc","city_name":"بوشهر","city_creation_date":"1301","city_division_code":"70009","district_name":"مرکزی","county_name":"بوشهر","province_name":"بوشهر"},{"id":"city_be1fd0295c45b24a9a6f0e59d892d3412f12df9c","city_name":"بوکان","city_creation_date":"1327","city_division_code":"70163","district_name":"مرکزی","county_name":"بوکان","province_name":"آذربایجان غربی"},{"id":"city_3780db9d79fb8f6e0bbb34d8c1a97a2f641acd9b","city_name":"بومهن","city_creation_date":"1375","city_division_code":"70618","district_name":"مرکزی","county_name":"تهران","province_name":"تهران"},{"id":"city_147f7a10192e6587547c9377c249743c914b5c30","city_name":"بوئین زهرا","city_creation_date":"1355","city_division_code":"70450","district_name":"مرکزی","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_368683099748a13a9a5a4b7b3c82ca1f6ef53e91","city_name":"بوئین سفلی","city_creation_date":"1379","city_division_code":"70810","district_name":"ننور","county_name":"بانه","province_name":"کردستان"},{"id":"city_6091604286b3697fa258f8b8b14d1c6ff85d4667","city_name":"بوئین و میاندشت","city_creation_date":"1338","city_division_code":"70286","district_name":"بوئین و میاندشت","county_name":"فریدن","province_name":"اصفهان"},{"id":"city_a6c27dd6f724b3d7e37f20614ebadc2ce4d9ad14","city_name":"بهاباد","city_creation_date":"1362","city_division_code":"70492","district_name":"مرکزی","county_name":"بهاباد","province_name":"یزد"},{"id":"city_27f1173b3bf25d86bee7c60ef42ab95af88f2a9e","city_name":"بهار","city_creation_date":"1318","city_division_code":"70148","district_name":"مرکزی","county_name":"بهار","province_name":"همدان"},{"id":"city_c2a75ce8380fedf6459cc60118ce35e1909b4beb","city_name":"بهاران شهر","city_creation_date":"1379","city_division_code":"70861","district_name":"پیر بکران","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_faeb025fe990ba2133aced8404c61a081a0d8e4c","city_name":"بهارستان","city_creation_date":"1381","city_division_code":"70901","district_name":"مرکزی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_e561d1da357e415e45b9294ac6017f0e492cb891","city_name":"بهبهان","city_creation_date":"1313","city_division_code":"70103","district_name":"مرکزی","county_name":"بهبهان","province_name":"خوزستان"},{"id":"city_7724096af7ace6992ba3e173fa226783bbe16bb3","city_name":"بهرمان","city_creation_date":"1379","city_division_code":"70819","district_name":"نوق","county_name":"رفسنجان","province_name":"کرمان"},{"id":"city_b7647a2c487a3febe36977eb6d8767597bfd3337","city_name":"بهشهر","city_creation_date":"1307","city_division_code":"70056","district_name":"مرکزی","county_name":"بهشهر","province_name":"مازندران"},{"id":"city_539b99a4c9234d5e6e411380fd6e28af201ee7c3","city_name":"بهمن","city_creation_date":"1374","city_division_code":"70599","district_name":"مرکزی","county_name":"آباده","province_name":"فارس"},{"id":"city_70bed645aca0fce48b2c532408cde767fcc0f753","city_name":"بهنمیر","city_creation_date":"1379","city_division_code":"70846","district_name":"بهنمیر","county_name":"بابلسر","province_name":"مازندران"},{"id":"city_35fc5f99a7043b9c7db513e5a8933d1dc0e99efd","city_name":"بیارجمند","city_creation_date":"1372","city_division_code":"70556","district_name":"بیارجمند","county_name":"شاهرود","province_name":"سمنان"},{"id":"city_7b36202c1c4a736cfbc70b1f82e20ba822d47721","city_name":"بیجار","city_creation_date":"1315","city_division_code":"70125","district_name":"مرکزی","county_name":"بیجار","province_name":"کردستان"},{"id":"city_cf36429aa5a55b695b158182154c95d810e355c5","city_name":"بیدخت","city_creation_date":"1332","city_division_code":"70213","district_name":"مرکزی","county_name":"گناباد","province_name":"خراسان رضوی"},{"id":"city_4fcfef7c42858fbf091044235f2afe7ba702ed4c","city_name":"بیدستان","city_creation_date":"1381","city_division_code":"70899","district_name":"محمدیه","county_name":"البرز","province_name":"قزوین"},{"id":"city_cf25d7ff6bf8c674a65fa8c32b4c16f50b77deea","city_name":"بیرجند","city_creation_date":"1307","city_division_code":"70048","district_name":"مرکزی","county_name":"بیرجند","province_name":"خراسان جنوبی"},{"id":"city_97043d3f6e6c967a085d2101f4e70ba5829b05f9","city_name":"بیرم","city_creation_date":"1374","city_division_code":"70600","district_name":"بیرم","county_name":"لارستان","province_name":"فارس"},{"id":"city_830b49cb43d53f53d2681243d7f3bdbdc57043bb","city_name":"بیستون","city_creation_date":"1375","city_division_code":"70615","district_name":"بیستون","county_name":"هرسین","province_name":"کرمانشاه"},{"id":"city_cf565fcdbbb84cc74e7918fbeeaa1dee1dda9866","city_name":"بیضا","city_creation_date":"1378","city_division_code":"70724","district_name":"بیضا","county_name":"سپیدان","province_name":"فارس"},{"id":"city_82d867ce33087cceb3812e301b9cd875e7ca118f","city_name":"بیکاه","city_creation_date":"1386","city_division_code":"71033","district_name":"بیکاه","county_name":"رودان","province_name":"هرمزگان"},{"id":"city_a47b3c4aabfbce007fe68d5aea69eb88697c0146","city_name":"بیله سوار","city_creation_date":"1350","city_division_code":"70435","district_name":"مرکزی","county_name":"بیله سوار","province_name":"اردبیل"},{"id":"city_57f8522830bc4784c127e7934a03ff8430d9470e","city_name":"پاتاوه","city_creation_date":"1387","city_division_code":"71081","district_name":"پاتاوه","county_name":"دنا","province_name":"کهگیلویه و بویراحمد"},{"id":"city_9a54ce3b732724d383f6fca8c5574fb3f2787c73","city_name":"پارس آباد","city_creation_date":"1346","city_division_code":"70420","district_name":"مرکزی","county_name":"پارس آباد","province_name":"اردبیل"},{"id":"city_21fbd5f550751e8ba7ae59698a6888d920cff99c","city_name":"پارسیان","city_creation_date":"1345","city_division_code":"70417","district_name":"مرکزی","county_name":"پارسیان","province_name":"هرمزگان"},{"id":"city_8d3e8937aa6d05863eb405be7e8c20be7dfe9b66","city_name":"پاریز","city_creation_date":"1381","city_division_code":"70926","district_name":"پاریز","county_name":"سیرجان","province_name":"کرمان"},{"id":"city_e4607f4828582ff0251bf36f855e455018d8b6ed","city_name":"پاکدشت","city_creation_date":"1369","city_division_code":"70512","district_name":"مرکزی","county_name":"پاکدشت","province_name":"تهران"},{"id":"city_67d04550016e763cb8694896edbb8e88888f42de","city_name":"پاوه","city_creation_date":"1337","city_division_code":"70283","district_name":"مرکزی","county_name":"پاوه","province_name":"کرمانشاه"},{"id":"city_c351a4036e1c93b2d3e6f8690facc5cd11950de7","city_name":"پردنجان","city_creation_date":"1389","city_division_code":"71138","district_name":"مرکزی","county_name":"فارسان","province_name":"چهار محال و بختیاری"},{"id":"city_63c7bea85b76cc4cd549a93814fedb8864e74be8","city_name":"پردیس","city_creation_date":"1381","city_division_code":"70902","district_name":"مرکزی","county_name":"تهران","province_name":"تهران"},{"id":"city_f883671ea630f4671f61f7a0b4ac9a14e1d0780a","city_name":"پرندک","city_creation_date":"1375","city_division_code":"70647","district_name":"مرکزی","county_name":"زرندیه","province_name":"مرکزی"},{"id":"city_16eea20a85efab74336a750b1f248b5f7984c4f7","city_name":"پره سر","city_creation_date":"1341","city_division_code":"70336","district_name":"پره سر","county_name":"رضوانشهر","province_name":"گیلان"},{"id":"city_53f5360e8740419dc0693ccd4f79b6176156131f","city_name":"پل سفید","city_creation_date":"1335","city_division_code":"70250","district_name":"مرکزی","county_name":"سواد کوه","province_name":"مازندران"},{"id":"city_6aaceec46b67a2358081f60c7290da6f597398aa","city_name":"پلدختر","city_creation_date":"1342","city_division_code":"70364","district_name":"مرکزی","county_name":"پلدختر","province_name":"لرستان"},{"id":"city_eb9a39c7b535638aa827dbc3b2eed0f5ed5230be","city_name":"پلدشت","city_creation_date":"1343","city_division_code":"70369","district_name":"مرکزی","county_name":"پلدشت","province_name":"آذربایجان غربی"},{"id":"city_0874353f3fb058c62ce399b34de9874885bc38b3","city_name":"پول","city_creation_date":"1389","city_division_code":"71128","district_name":"کجور","county_name":"نوشهر","province_name":"مازندران"},{"id":"city_fa03235d4d5d460d7e0ada6675736d6918827564","city_name":"پهله","city_creation_date":"1369","city_division_code":"70520","district_name":"زرین آباد","county_name":"دهلران","province_name":"ایلام"},{"id":"city_435e43cd6948e88156318dff6fd226d9500af9e8","city_name":"پیر بکران","city_creation_date":"1373","city_division_code":"70590","district_name":"پیر بکران","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_67d1beb5156f1e803a4615d72606416ef2515319","city_name":"پیرانشهر","city_creation_date":"1339","city_division_code":"70294","district_name":"مرکزی","county_name":"پیرانشهر","province_name":"آذربایجان غربی"},{"id":"city_63edb905fd79ff7405ffece29c61a54a29a2520c","city_name":"پیش قلعه","city_creation_date":"1381","city_division_code":"70914","district_name":"مانه","county_name":"مانه و سملقان","province_name":"خراسان شمالی"},{"id":"city_74b6ea4a210892ea15dc8687ecb79b9fe6320f85","city_name":"پیشوا","city_creation_date":"1332","city_division_code":"70210","district_name":"مرکزی","county_name":"پیشوا","province_name":"تهران"},{"id":"city_251230f67954827d1fcf7ab321308ade702b1ce3","city_name":"پیشین","city_creation_date":"1378","city_division_code":"70736","district_name":"پیشین","county_name":"سرباز","province_name":"سیستان و بلوچستان"},{"id":"city_bd8dc90d69432e774d6cf4f95739ff92da279d02","city_name":"تازه آباد","city_creation_date":"1372","city_division_code":"70564","district_name":"مرکزی","county_name":"ثلاث باباجانی","province_name":"کرمانشاه"},{"id":"city_2b2b628b8b006821e257526ae40391e5cab272c6","city_name":"تازه شهر","city_creation_date":"1344","city_division_code":"70386","district_name":"مرکزی","county_name":"سلماس","province_name":"آذربایجان غربی"},{"id":"city_38c949259b715de4107dff98bcef2ce7fe1f8e0c","city_name":"تازه کند","city_creation_date":"1387","city_division_code":"71064","district_name":"تازه کند","county_name":"پارس آباد","province_name":"اردبیل"},{"id":"city_2691f7a7d2b3a47589ce4b290127594b9b15d9f6","city_name":"تازه کند انگوت","city_creation_date":"1379","city_division_code":"70766","district_name":"انگوت","county_name":"گرمی","province_name":"اردبیل"},{"id":"city_c7ecf02634f24c68d3d8dae602245aaa20b94f0f","city_name":"تاکستان","city_creation_date":"1337","city_division_code":"70279","district_name":"مرکزی","county_name":"تاکستان","province_name":"قزوین"},{"id":"city_e015c94ea08f09d00378029dd334e1a0f4d0a14a","city_name":"تایباد","city_creation_date":"1330","city_division_code":"70187","district_name":"مرکزی","county_name":"تایباد","province_name":"خراسان رضوی"},{"id":"city_29bbc1cca340b85b654093c7bda2da1b4bfaee46","city_name":"تبریز","city_creation_date":"1296","city_division_code":"70002","district_name":"مرکزی","county_name":"تبریز","province_name":"آذربایجان شرقی"},{"id":"city_5e676d9454e2026340fdb8b7f6b195b591f4c13f","city_name":"تجریش","city_creation_date":"1336","city_division_code":"70259","district_name":"لواسانات","county_name":"شمیرانات","province_name":"تهران"},{"id":"city_39781a290a85f603ea604ab2e844f0a608a3e86b","city_name":"تخت","city_creation_date":"1388","city_division_code":"71099","district_name":"تخت","county_name":"بندرعباس","province_name":"هرمزگان"},{"id":"city_d721d8c75434810e76437c2dc11011b90c32ed60","city_name":"تربت جام","city_creation_date":"1311","city_division_code":"70095","district_name":"مرکزی","county_name":"تربت جام","province_name":"خراسان رضوی"},{"id":"city_e21a2abc8e812a80b88fbc8a762bbe54cd01737c","city_name":"تربت حیدریه","city_creation_date":"1307","city_division_code":"70049","district_name":"مرکزی","county_name":"تربت حیدریه","province_name":"خراسان رضوی"},{"id":"city_4c82582ffe03980f650e13e68b8662e3ac2ad16b","city_name":"ترکالکی","city_creation_date":"1386","city_division_code":"71024","district_name":"عقیلی","county_name":"گتوند","province_name":"خوزستان"},{"id":"city_0ac66d1ae58518bda4b9c5191fb275b1209a461e","city_name":"ترک","city_creation_date":"1379","city_division_code":"70761","district_name":"کندوان","county_name":"میانه","province_name":"آذربایجان شرقی"},{"id":"city_3607271cda651ebab4e092c197fb31b24d01c110","city_name":"ترکمانچای","city_creation_date":"1369","city_division_code":"70525","district_name":"ترکمانچای","county_name":"میانه","province_name":"آذربایجان شرقی"},{"id":"city_c1331594f0f9207c78cb71e46da5b7a7ad65aa4c","city_name":"تسوج","city_creation_date":"1336","city_division_code":"70255","district_name":"تسوج","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_a9162ef83f05a09a36506b1fd5ed70c6f28af715","city_name":"تفت","city_creation_date":"1331","city_division_code":"70204","district_name":"مرکزی","county_name":"تفت","province_name":"یزد"},{"id":"city_4b1f5005466890976746fc7782feb3be1efaf559","city_name":"تفرش","city_creation_date":"1333","city_division_code":"70231","district_name":"مرکزی","county_name":"تفرش","province_name":"مرکزی"},{"id":"city_0c439406053e5f48beeb0c440216277bfb2a027f","city_name":"تکاب","city_creation_date":"1307","city_division_code":"70045","district_name":"مرکزی","county_name":"تکاب","province_name":"آذربایجان غربی"},{"id":"city_653eb11b0e0a92b293ce37743abdba2cb4432095","city_name":"تنکابن","city_creation_date":"1335","city_division_code":"70248","district_name":"مرکزی","county_name":"تنکابن","province_name":"مازندران"},{"id":"city_5ef6f8a53005f6f91f1c1180296344fefebe9240","city_name":"تنکمان","city_creation_date":"1386","city_division_code":"71026","district_name":"تنکمان","county_name":"نظر آباد","province_name":"البرز"},{"id":"city_815961c4401fc165bdf0db0222b17e38ba7f8e05","city_name":"تنگ ارم","city_creation_date":"1383","city_division_code":"70953","district_name":"ارم","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_157ef93e8cbb763742ceccc13d837110dc2cfd6b","city_name":"توتکابن","city_creation_date":"1375","city_division_code":"70646","district_name":"رحمت آباد و بلوکات","county_name":"رودبار","province_name":"گیلان"},{"id":"city_a759c6eca55b7ccbf83bb5f0fa6c7b24a0ba13e0","city_name":"توحید","city_creation_date":"1381","city_division_code":"70912","district_name":"هلیلان","county_name":"شیروان و چرداول","province_name":"ایلام"},{"id":"city_1dfc05a280cd3aa58cf52429cb38f6c2ad4460c2","city_name":"تودشک","city_creation_date":"1380","city_division_code":"70880","district_name":"کوهپایه","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_3ff94dc3b22abc00cf7067ce1307eaf36b695517","city_name":"توره","city_creation_date":"1382","city_division_code":"70940","district_name":"زالیان","county_name":"شازند","province_name":"مرکزی"},{"id":"city_1b8f4feda67d39bc9ecc2335d114a02db3a6b925","city_name":"تویسرکان","city_creation_date":"1310","city_division_code":"70091","district_name":"مرکزی","county_name":"تویسرکان","province_name":"همدان"},{"id":"city_42c3caa37201c806158039b1761055fb97dfc01b","city_name":"تهران","city_creation_date":"1304","city_division_code":"70017","district_name":"مرکزی","county_name":"تهران","province_name":"تهران"},{"id":"city_e0dbb3e05fbcc62905db71638e3f5119f9aeeef6","city_name":"تیتکانلو","city_creation_date":"1388","city_division_code":"71096","district_name":"خبوشان","county_name":"فاروج","province_name":"خراسان شمالی"},{"id":"city_8a1f4eaabec2974c2621e8d18f2c6f182af2d8c6","city_name":"تیران","city_creation_date":"1345","city_division_code":"70408","district_name":"مرکزی","county_name":"تیران و کرون","province_name":"اصفهان"},{"id":"city_fbae185d63928f6c91ec97ce7260db877bc43f09","city_name":"تیکمه داش","city_creation_date":"1376","city_division_code":"70678","district_name":"تیکمه داش","county_name":"بستان آباد","province_name":"آذربایجان شرقی"},{"id":"city_136ca444f941a6b434f0d1c2fa5a90743732fc6d","city_name":"جاجرم","city_creation_date":"1377","city_division_code":"70716","district_name":"مرکزی","county_name":"جاجرم","province_name":"خراسان شمالی"},{"id":"city_c9095af635e8117f25672bab880bcbd4bec3c145","city_name":"جالق","city_creation_date":"1369","city_division_code":"70528","district_name":"جالق","county_name":"سراوان","province_name":"سیستان و بلوچستان"},{"id":"city_41a5bcf5c4aefea35e6171a9bf836ef37abbcadf","city_name":"جاورسیان","city_creation_date":"1388","city_division_code":"71100","district_name":"قره چای","county_name":"خنداب","province_name":"مرکزی"},{"id":"city_a8d865b76cefdebb8cd33317eb52d5ab9fabfd03","city_name":"جایزان","city_creation_date":"1379","city_division_code":"70789","district_name":"جایزان","county_name":"امیدیه","province_name":"خوزستان"},{"id":"city_5612ae57f2e19adb550cfb81aba0e3c1dc7421ab","city_name":"جبالبارز","city_creation_date":"1375","city_division_code":"70642","district_name":"جبالبارز","county_name":"جیرفت","province_name":"کرمان"},{"id":"city_b97529d0a1644f9d7bc721cffd8b20050aa93b3e","city_name":"جعفر آباد","city_creation_date":"1374","city_division_code":"70592","district_name":"قشلاق دشت","county_name":"بیله سوار","province_name":"اردبیل"},{"id":"city_42bc4a86918d710dde1c8823b5bdb191511f3730","city_name":"جعفریه","city_creation_date":"1375","city_division_code":"70651","district_name":"جعفر آباد","county_name":"قم","province_name":"قم"},{"id":"city_b5a23691b31b180a221536150a2268a69167dc21","city_name":"جغتای","city_creation_date":"1339","city_division_code":"70299","district_name":"مرکزی","county_name":"جغتای","province_name":"خراسان رضوی"},{"id":"city_b4a796fbed776b30a4d1c433e654ab198a5316f1","city_name":"جلفا","city_creation_date":"1334","city_division_code":"70232","district_name":"مرکزی","county_name":"جلفا","province_name":"آذربایجان شرقی"},{"id":"city_ef2fd19d51a456d93046ac6a211a39c1135ab358","city_name":"جلین","city_creation_date":"1386","city_division_code":"71057","district_name":"مرکزی","county_name":"گرگان","province_name":"گلستان"},{"id":"city_4a92645cf4b3c0e89696d2a79813919254ec8b56","city_name":"جم","city_creation_date":"1375","city_division_code":"70617","district_name":"مرکزی","county_name":"جم","province_name":"بوشهر"},{"id":"city_b989baec2d53f64b89cc1a7700267a0d6aa6d034","city_name":"جناح","city_creation_date":"1383","city_division_code":"70969","district_name":"جناح","county_name":"بستک","province_name":"هرمزگان"},{"id":"city_e1f6759ad8ef6a8748f024d73248ff49948e2003","city_name":"جنت شهر","city_creation_date":"1372","city_division_code":"70578","district_name":"مرکزی","county_name":"داراب","province_name":"فارس"},{"id":"city_d05d0e6de386340d6a20fbfaf6ce79e15eb9e9af","city_name":"جنت مکان","city_creation_date":"1389","city_division_code":"71110","district_name":"مرکزی","county_name":"گتوند","province_name":"خوزستان"},{"id":"city_54f38af18d12309014368ce5ae5afc28bb21dcc4","city_name":"جندق","city_creation_date":"1374","city_division_code":"70607","district_name":"مرکزی","county_name":"خور و بیابانک","province_name":"اصفهان"},{"id":"city_a7522b06be35d07a08db8b51cfc490846746519f","city_name":"جنگل","city_creation_date":"1383","city_division_code":"70947","district_name":"جنگل","county_name":"رشتخوار","province_name":"خراسان رضوی"},{"id":"city_540d4985c6a53b8e585d3f0f8e40ba106db72f80","city_name":"جواد آباد","city_creation_date":"1372","city_division_code":"70577","district_name":"جواد آباد","county_name":"ورامین","province_name":"تهران"},{"id":"city_bde3dc7bd80f9878e5cd1cf262356db6974f9e3b","city_name":"جوانرود","city_creation_date":"1339","city_division_code":"70306","district_name":"مرکزی","county_name":"جوانرود","province_name":"کرمانشاه"},{"id":"city_e5ef761c1ae453883e3ffbbb1fa7a13100825dca","city_name":"جوپار","city_creation_date":"1339","city_division_code":"70304","district_name":"ماهان","county_name":"کرمان","province_name":"کرمان"},{"id":"city_97867453b861a04da912c8d81887339ce29ca2a6","city_name":"جورقان","city_creation_date":"1375","city_division_code":"70662","district_name":"مرکزی","county_name":"همدان","province_name":"همدان"},{"id":"city_c78c722ac44f6e3f98e616600b62d74f9a5eed50","city_name":"جوزدان","city_creation_date":"1386","city_division_code":"71036","district_name":"مرکزی","county_name":"نجف آباد","province_name":"اصفهان"},{"id":"city_6c5de33514f233958887777871693148546c2916","city_name":"جوزم","city_creation_date":"1386","city_division_code":"71054","district_name":"دهج","county_name":"شهر بابک","province_name":"کرمان"},{"id":"city_7f926e18d3aaa68abc7a207e8670aeed1c04a05d","city_name":"جوشقان و کامو","city_creation_date":"1379","city_division_code":"70863","district_name":"قمصر","county_name":"کاشان","province_name":"اصفهان"},{"id":"city_67cb634f1ecd402747073cb3d1de728cb526e419","city_name":"جوکار","city_creation_date":"1379","city_division_code":"70857","district_name":"جوکار","county_name":"ملایر","province_name":"همدان"},{"id":"city_986c023ebe0dbed667fa06086216661fd8331cd2","city_name":"جونقان","city_creation_date":"1355","city_division_code":"70449","district_name":"مرکزی","county_name":"فارسان","province_name":"چهار محال و بختیاری"},{"id":"city_e93c0555ec3044956da3a0a438d22ce3c682259f","city_name":"جویبار","city_creation_date":"1340","city_division_code":"70320","district_name":"مرکزی","county_name":"جویبار","province_name":"مازندران"},{"id":"city_cd1f1a89c8604279c60a5b3eb19cd8eacb40319c","city_name":"جویم","city_creation_date":"1369","city_division_code":"70529","district_name":"جویم","county_name":"لارستان","province_name":"فارس"},{"id":"city_85f599d9227b46031d5c59ff08614bf9f3986527","city_name":"جهرم","city_creation_date":"1304","city_division_code":"70025","district_name":"مرکزی","county_name":"جهرم","province_name":"فارس"},{"id":"city_fcabbb31599696a2a93c8fa6bcf13998cae91b98","city_name":"جیرفت","city_creation_date":"1330","city_division_code":"70191","district_name":"مرکزی","county_name":"جیرفت","province_name":"کرمان"},{"id":"city_ee2a597c6644b280e379918c271a0d487b38ebe0","city_name":"جیرنده","city_creation_date":"1372","city_division_code":"70551","district_name":"عمارلو","county_name":"رودبار","province_name":"گیلان"},{"id":"city_0eb0e48c0397152ef4684e82ec39e9d2d2fc6aa1","city_name":"چابکسر","city_creation_date":"1340","city_division_code":"70317","district_name":"چابکسر","county_name":"رودسر","province_name":"گیلان"},{"id":"city_ea2cd9da612e179b237752c99e95706d970f2611","city_name":"چاپشلو","city_creation_date":"1374","city_division_code":"70598","district_name":"چاپشلو","county_name":"درگز","province_name":"خراسان رضوی"},{"id":"city_465556ab9ac6ae8cae9e770b02734f7d699856f2","city_name":"چادگان","city_creation_date":"1342","city_division_code":"70349","district_name":"مرکزی","county_name":"چادگان","province_name":"اصفهان"},{"id":"city_9ea5101f83aba40d019149d0ed00cb16135b11cf","city_name":"چارک","city_creation_date":"1375","city_division_code":"70648","district_name":"شیبکوه","county_name":"بندرلنگه","province_name":"هرمزگان"},{"id":"city_ac2a8c6b335b51162838fbe71469ee09d22ce854","city_name":"چاف و چمخاله","city_creation_date":"1388","city_division_code":"71092","district_name":"مرکزی","county_name":"لنگرود","province_name":"گیلان"},{"id":"city_edf260d702b5b90dfbab25cb2d4a3a46587f029c","city_name":"چالانچولان","city_creation_date":"1377","city_division_code":"70714","district_name":"سیلاخور","county_name":"دورود","province_name":"لرستان"},{"id":"city_7e11d628bb8c2df048268dee0336dc27aa548978","city_name":"چالوس","city_creation_date":"1330","city_division_code":"70194","district_name":"مرکزی","county_name":"چالوس","province_name":"مازندران"},{"id":"city_a2ad4224ac5eb28faa1dd6eb20428d5e54e41c67","city_name":"چاه بهار","city_creation_date":"1329","city_division_code":"70177","district_name":"مرکزی","county_name":"چاه بهار","province_name":"سیستان و بلوچستان"},{"id":"city_d9af82a5dc88984035b768581b69eca7703fc198","city_name":"چترود","city_creation_date":"1351","city_division_code":"70437","district_name":"چترود","county_name":"کرمان","province_name":"کرمان"},{"id":"city_855a0b581111bf8fe225168989767655c99e70f3","city_name":"چرام","city_creation_date":"1355","city_division_code":"70451","district_name":"مرکزی","county_name":"چرام","province_name":"کهگیلویه و بویراحمد"},{"id":"city_a1d746d8ef05915a9a49d1126756a3c7f9b610c5","city_name":"چرمهین","city_creation_date":"1370","city_division_code":"70539","district_name":"باغ بهادران","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_e95ad7ceaf1dac3b8bce079b683cfbf8da2e22f6","city_name":"چغادک","city_creation_date":"1379","city_division_code":"70868","district_name":"مرکزی","county_name":"بوشهر","province_name":"بوشهر"},{"id":"city_6dcf52f7b874703de6be20172e6ec1c57095d90a","city_name":"چغامیش","city_creation_date":"1389","city_division_code":"71115","district_name":"چغامیش","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_5f3dfbd9ac6b04b3acb1269ad4eceed338ffc802","city_name":"چغلوندی","city_creation_date":"1379","city_division_code":"70840","district_name":"چغلوندی","county_name":"خرم آباد","province_name":"لرستان"},{"id":"city_68bdd4e08b58a65807c3e0dd5ca6e14451bfc587","city_name":"چقابل","city_creation_date":"1375","city_division_code":"70655","district_name":"رومشکان","county_name":"کوهدشت","province_name":"لرستان"},{"id":"city_7a59ca86f15f834e7b5bb49b87a550a6885f2171","city_name":"چکنه","city_creation_date":"1381","city_division_code":"70891","district_name":"سرولایت","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_1ab20b549c648a017c05f6a6370829d6fbd6f496","city_name":"چلگرد","city_creation_date":"1378","city_division_code":"70727","district_name":"مرکزی","county_name":"کوهرنگ","province_name":"چهار محال و بختیاری"},{"id":"city_d93b21465cdf212e27d6c99015c397ab438e211d","city_name":"چمران","city_creation_date":"1376","city_division_code":"70689","district_name":"مرکزی","county_name":"بندر ماهشهر","province_name":"خوزستان"},{"id":"city_8400e38c48e22810ab074813c739b9b22f5ab335","city_name":"چمستان","city_creation_date":"1369","city_division_code":"70530","district_name":"چمستان","county_name":"نور","province_name":"مازندران"},{"id":"city_e27884ec36f5190f3fc92247d5708cf412da342b","city_name":"چمگردان","city_creation_date":"1362","city_division_code":"70483","district_name":"مرکزی","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_6ca60916b7955377e90b865fdc029d4cfcf12f3d","city_name":"چناران","city_creation_date":"1346","city_division_code":"70422","district_name":"مرکزی","county_name":"چناران","province_name":"خراسان رضوی"},{"id":"city_49ef81af47429526ecc6422b31c4a89e83ac42a3","city_name":"چناره","city_creation_date":"1379","city_division_code":"70818","district_name":"سرشیو","county_name":"مریوان","province_name":"کردستان"},{"id":"city_89552017f6e9fe9b731c18ac7775c801f4dbde34","city_name":"چوار","city_creation_date":"1344","city_division_code":"70389","district_name":"چوار","county_name":"ایلام","province_name":"ایلام"},{"id":"city_7806c99a6655aa91ec67e058e7c5d2b823fc1da4","city_name":"چوبر","city_creation_date":"1383","city_division_code":"70966","district_name":"حویق","county_name":"طوالش","province_name":"گیلان"},{"id":"city_fc67d580a4a054180b3f339f417fb27da752444d","city_name":"چورزق","city_creation_date":"1379","city_division_code":"70794","district_name":"چورزق","county_name":"طارم","province_name":"زنجان"},{"id":"city_37edf21cdff01c02365390e5a05f0ab77a9bbd94","city_name":"چوئبده","city_creation_date":"1386","city_division_code":"71022","district_name":"مرکزی","county_name":"آبادان","province_name":"خوزستان"},{"id":"city_b38e3019ba1eab199d1d877297fea29f84c49420","city_name":"چهار برج","city_creation_date":"1375","city_division_code":"70628","district_name":"مرحمت آباد","county_name":"میاندوآب","province_name":"آذربایجان غربی"},{"id":"city_26801259d3f548da562174f425cb8b798d3107df","city_name":"چهارباغ","city_creation_date":"1384","city_division_code":"70984","district_name":"چهار باغ","county_name":"ساوجبلاغ","province_name":"البرز"},{"id":"city_4869c7cec165c7e1a5fb4b0e8aa5944ebf4f9b66","city_name":"چهاردانگه","city_creation_date":"1379","city_division_code":"70771","district_name":"چهاردانگه","county_name":"اسلامشهر","province_name":"تهران"},{"id":"city_5992600b3feea01ff43af4b6258915825dbad4a5","city_name":"چیتاب","city_creation_date":"1387","city_division_code":"71082","district_name":"کبگیان","county_name":"دنا","province_name":"کهگیلویه و بویراحمد"},{"id":"city_52b07125216c23a1d4f63056e7a310c239bf8909","city_name":"حاجی آباد","city_creation_date":"1378","city_division_code":"70744","district_name":"زیر کوه","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_8203c0bc454314a14ded27d31c4f5b02da8e2481","city_name":"حاجی آباد","city_creation_date":"1344","city_division_code":"70401","district_name":"مرکزی","county_name":"حاجی آباد","province_name":"هرمزگان"},{"id":"city_7c8c60a06217a697051fae6637cae4c7275e94e9","city_name":"حاجی آباد","city_creation_date":"1362","city_division_code":"70487","district_name":"مرکزی","county_name":"زرین دشت","province_name":"فارس"},{"id":"city_6d48f02731650f31f9432e698c47681bf9d8381b","city_name":"حبیب آباد","city_creation_date":"1345","city_division_code":"70404","district_name":"حبیب آباد","county_name":"برخوار","province_name":"اصفهان"},{"id":"city_2976c3c7dc1e11ce9a8eb079114e7d6d0a56716c","city_name":"حر","city_creation_date":"1384","city_division_code":"71008","district_name":"مرکزی","county_name":"شوش","province_name":"خوزستان"},{"id":"city_34d2b30d57222b31af88800d57f8059e0019efbe","city_name":"حسامی","city_creation_date":"1389","city_division_code":"71130","district_name":"سرچهان","county_name":"بوانات","province_name":"فارس"},{"id":"city_6a45b83130ae1dde97be613a1a14259438fa8d24","city_name":"حسن آباد","city_creation_date":"1372","city_division_code":"70575","district_name":"جرقویه علیا","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_70fa6b90cc441996404ab1173e4f86968e06891d","city_name":"حسن آباد","city_creation_date":"1388","city_division_code":"71101","district_name":"حسن آباد","county_name":"اقلید","province_name":"فارس"},{"id":"city_2370e0dab89f7cc8bdf9a8d3d712c4549ded7e4b","city_name":"حسن آباد","city_creation_date":"1369","city_division_code":"70527","district_name":"فشاپویه","county_name":"ری","province_name":"تهران"},{"id":"city_a6f808d06f2b51ec58c95dabe205445c118ec21b","city_name":"حسینیه","city_creation_date":"1383","city_division_code":"70949","district_name":"الوار گرمسیری","county_name":"اندیمشک","province_name":"خوزستان"},{"id":"city_a7dac47a450804b51acfcf38d844bb422526ef1d","city_name":"حصارگرمخان","city_creation_date":"1379","city_division_code":"70785","district_name":"گرمخان","county_name":"بجنورد","province_name":"خراسان شمالی"},{"id":"city_880f87d9f7a9d3fad44eaab2f54447c81f1d6a1e","city_name":"حلب","city_creation_date":"1379","city_division_code":"70793","district_name":"حلب","county_name":"ایجرود","province_name":"زنجان"},{"id":"city_ea067d4b808f283186c62878d79459acd349f71d","city_name":"حمزه","city_creation_date":"1386","city_division_code":"71041","district_name":"سردشت","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_1b410d607ac413d184bfdb4945c068464b697289","city_name":"حمیدیا","city_creation_date":"1372","city_division_code":"70560","district_name":"مرکزی","county_name":"یزد","province_name":"یزد"},{"id":"city_e6193b3ec8265f24839691bcd928c63ca7a00cf2","city_name":"حمیدیه","city_creation_date":"1370","city_division_code":"70534","district_name":"حمیدیه","county_name":"اهواز","province_name":"خوزستان"},{"id":"city_6632ad2de8436a7739c41e70e9a869e3993d7711","city_name":"حمیل","city_creation_date":"1379","city_division_code":"70821","district_name":"حمیل","county_name":"اسلام آباد غرب","province_name":"کرمانشاه"},{"id":"city_a49d8cd39add71f0d6ca83bb3f03c8a47e452e8c","city_name":"حنا","city_creation_date":"1375","city_division_code":"70631","district_name":"مرکزی","county_name":"سمیرم","province_name":"اصفهان"},{"id":"city_d054206f12e2a55cc8483b3aad6f923433e7b150","city_name":"حویق","city_creation_date":"1382","city_division_code":"70935","district_name":"حویق","county_name":"طوالش","province_name":"گیلان"},{"id":"city_54202304296ed56ddc93a1cffe1b88a8c00b00ca","city_name":"خاتون آباد","city_creation_date":"1388","city_division_code":"71093","district_name":"مرکزی","county_name":"شهر بابک","province_name":"کرمان"},{"id":"city_0e781e49a85259de1bfb130d1763e42bd9709648","city_name":"خارک","city_creation_date":"1348","city_division_code":"70431","district_name":"خارک","county_name":"بوشهر","province_name":"بوشهر"},{"id":"city_f59483d0737a42eda4ff6ed2a2314c62f409d9d9","city_name":"خاروانا","city_creation_date":"1379","city_division_code":"70762","district_name":"خاروانا","county_name":"ورزقان","province_name":"آذربایجان شرقی"},{"id":"city_19ad678580b4fdb90b7f844a1c3152f5dc46d972","city_name":"خاش","city_creation_date":"1326","city_division_code":"70162","district_name":"مرکزی","county_name":"خاش","province_name":"سیستان و بلوچستان"},{"id":"city_d9d7f216f21d6de1e23c8ebec070868f694210b8","city_name":"خاکعلی","city_creation_date":"1383","city_division_code":"70964","district_name":"بشاریات","county_name":"آبیک","province_name":"قزوین"},{"id":"city_332272c78ec5a4d8d1583fb9fa65d12031079ea6","city_name":"خالد آباد","city_creation_date":"1383","city_division_code":"70972","district_name":"امام زاده","county_name":"نطنز","province_name":"اصفهان"},{"id":"city_ada776417bda043e174804835cec3d50001fcb7b","city_name":"خامنه","city_creation_date":"1314","city_division_code":"70107","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_43b9925ce60b8117521fe5a8270a8d55554281df","city_name":"خان ببین","city_creation_date":"1341","city_division_code":"70334","district_name":"فندرسک","county_name":"رامیان","province_name":"گلستان"},{"id":"city_78e78572de3e797b1f166ad256c13a170f5952bb","city_name":"خانوک","city_creation_date":"1374","city_division_code":"70603","district_name":"مرکزی","county_name":"زرند","province_name":"کرمان"},{"id":"city_904bb66e57d07eb60f45b86f1f9c479c6bb927bf","city_name":"خانه زنیان","city_creation_date":"1387","city_division_code":"71075","district_name":"ارژن","county_name":"شیراز","province_name":"فارس"},{"id":"city_427efe6cdfe4b1b475a1010878ab4ea39cb461c3","city_name":"خاوران","city_creation_date":"1361","city_division_code":"70461","district_name":"خفر","county_name":"جهرم","province_name":"فارس"},{"id":"city_003f7b24e05270ccbce11d0fde403400f6032348","city_name":"خداجو","city_creation_date":"1377","city_division_code":"70703","district_name":"سراجو","county_name":"مراغه","province_name":"آذربایجان شرقی"},{"id":"city_689bb5ab3d743e97a140c6c815a5886a0e07f9a6","city_name":"خرامه","city_creation_date":"1336","city_division_code":"70262","district_name":"مرکزی","county_name":"خرامه","province_name":"فارس"},{"id":"city_4255b699057f2ce046bbd93fb97131167e284064","city_name":"خرم آباد","city_creation_date":"1330","city_division_code":"70193","district_name":"خرم آباد","county_name":"تنکابن","province_name":"مازندران"},{"id":"city_c39de65b08f2fac979ff5dd3a6543bf6e8b65baa","city_name":"خرم آباد","city_creation_date":"1310","city_division_code":"70088","district_name":"مرکزی","county_name":"خرم آباد","province_name":"لرستان"},{"id":"city_161a74dbff02b1c9fbfadb3098da2a30d8a258d5","city_name":"خرمدره","city_creation_date":"1316","city_division_code":"70133","district_name":"مرکزی","county_name":"خرمدره","province_name":"زنجان"},{"id":"city_8f6515f8d47c713fa37a73da64c55bd22580a483","city_name":"خرمدشت","city_creation_date":"1378","city_division_code":"70726","district_name":"خرمدشت","county_name":"تاکستان","province_name":"قزوین"},{"id":"city_ed9a6eb59a21069f017723b8cffc34af58c112cb","city_name":"خرمشهر","city_creation_date":"1304","city_division_code":"70021","district_name":"مرکزی","county_name":"خرمشهر","province_name":"خوزستان"},{"id":"city_22e524548be901a297ce6d72d25314aadb288184","city_name":"خرو","city_creation_date":"1378","city_division_code":"70725","district_name":"زبرخان","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_b5ed9d9f43ff068080a85aa324ad856a9592dd76","city_name":"خسرو شهر","city_creation_date":"1333","city_division_code":"70218","district_name":"خسرو شهر","county_name":"تبریز","province_name":"آذربایجان شرقی"},{"id":"city_76f2ab12ad076a7b05dc390379b6efc3efb02129","city_name":"خشت","city_creation_date":"1370","city_division_code":"70532","district_name":"خشت","county_name":"کازرون","province_name":"فارس"},{"id":"city_347e2bb0eac63eb4deb864855e6554dc024c3614","city_name":"خشکرود","city_creation_date":"1386","city_division_code":"71032","district_name":"مرکزی","county_name":"زرندیه","province_name":"مرکزی"},{"id":"city_4ca4b55ba30423046c4aa4f9b522f446b4deb6b6","city_name":"خشکبیجار","city_creation_date":"1340","city_division_code":"70316","district_name":"خشکبیجار","county_name":"رشت","province_name":"گیلان"},{"id":"city_82a3a0a682a4c2992f3109351ad4bfcc4ff80926","city_name":"خضر آباد","city_creation_date":"1379","city_division_code":"70858","district_name":"خضرآباد","county_name":"صدوق","province_name":"یزد"},{"id":"city_0b2b386294ff2d7b5ad190d206f55ac469174224","city_name":"خضری دشت بیاض","city_creation_date":"1362","city_division_code":"70486","district_name":"نیمبلوک","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_f774b85d6e694fcb1ff516b7944e3a29cebb0f99","city_name":"خلخال","city_creation_date":"1326","city_division_code":"70161","district_name":"مرکزی","county_name":"خلخال","province_name":"اردبیل"},{"id":"city_d85dbba2639cafbed3a276a3af5646871da55055","city_name":"خلیفان","city_creation_date":"1389","city_division_code":"71132","district_name":"خلیفان","county_name":"مهاباد","province_name":"آذربایجان غربی"},{"id":"city_5565878a9db184ea9506b4b372e46dd46a77016b","city_name":"خلیل آباد","city_creation_date":"1346","city_division_code":"70423","district_name":"مرکزی","county_name":"خلیل آباد","province_name":"خراسان رضوی"},{"id":"city_22bfff59c7e44d2424280880c7979423e7f6edcd","city_name":"خلیل شهر","city_creation_date":"1384","city_division_code":"70996","district_name":"مرکزی","county_name":"بهشهر","province_name":"مازندران"},{"id":"city_4d613d32c6e4a20bb08d2a423203bfe4e756fd80","city_name":"خمارلو","city_creation_date":"1377","city_division_code":"70713","district_name":"مرکزی","county_name":"خدا آفرین","province_name":"آذربایجان شرقی"},{"id":"city_9e5b2a166cbeeab9351d77dca4b4ae042c07af8e","city_name":"خمام","city_creation_date":"1329","city_division_code":"70181","district_name":"خمام","county_name":"رشت","province_name":"گیلان"},{"id":"city_8dc4aecdf86edaf72bfa08ba242019d301cafa6c","city_name":"خمیر","city_creation_date":"1345","city_division_code":"70418","district_name":"مرکزی","county_name":"خمیر","province_name":"هرمزگان"},{"id":"city_3c9e82c238b00046e9049a65941005ef3fe0cff2","city_name":"خمین","city_creation_date":"1330","city_division_code":"70196","district_name":"مرکزی","county_name":"خمین","province_name":"مرکزی"},{"id":"city_792387f4df5279fd6a765f4836b669eb5bc83e0a","city_name":"خمینی شهر","city_creation_date":"1311","city_division_code":"70094","district_name":"مرکزی","county_name":"خمینی شهر","province_name":"اصفهان"},{"id":"city_cff371fe89ea082a25c1e6b9a8b1141ba762f910","city_name":"خنج","city_creation_date":"1345","city_division_code":"70413","district_name":"مرکزی","county_name":"خنج","province_name":"فارس"},{"id":"city_334234c275136f5b9ac6967eb7f4942a4e65a530","city_name":"خنداب","city_creation_date":"1376","city_division_code":"70684","district_name":"مرکزی","county_name":"خنداب","province_name":"مرکزی"},{"id":"city_c649c0db1ce31c2a047302338bcf00cf6454300d","city_name":"خواجه","city_creation_date":"1373","city_division_code":"70582","district_name":"خواجه","county_name":"هریس","province_name":"آذربایجان شرقی"},{"id":"city_4ccd3f6d0da5d612c8e7edea3e2b4386bcb4040b","city_name":"خواف","city_creation_date":"1314","city_division_code":"70110","district_name":"مرکزی","county_name":"خواف","province_name":"خراسان رضوی"},{"id":"city_906737e4547e1f68218c0ba3d6df9d80bfa04401","city_name":"خوانسار","city_creation_date":"1309","city_division_code":"70067","district_name":"مرکزی","county_name":"خوانسار","province_name":"اصفهان"},{"id":"city_198b5f36afcad238773b05cc4660432d2132f3d5","city_name":"خور","city_creation_date":"1341","city_division_code":"70326","district_name":"مرکزی","county_name":"خور و بیابانک","province_name":"اصفهان"},{"id":"city_67f44ee626e781d3cd16307232a4954dcf94986c","city_name":"خور","city_creation_date":"1381","city_division_code":"70917","district_name":"مرکزی","county_name":"لارستان","province_name":"فارس"},{"id":"city_bd9689aa4aa705858078fd8a9c98c5ab076da1e2","city_name":"خوراسگان","city_creation_date":"1342","city_division_code":"70348","district_name":"مرکزی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_f5122f42c98c0fec5ae7484fd3263ebaf42bf379","city_name":"خورزوق","city_creation_date":"1345","city_division_code":"70406","district_name":"مرکزی","county_name":"برخوار","province_name":"اصفهان"},{"id":"city_63009933d888b7403c0419f8dbde4c6bcbe5cb79","city_name":"خورسند","city_creation_date":"1386","city_division_code":"71055","district_name":"مرکزی","county_name":"شهر بابک","province_name":"کرمان"},{"id":"city_c9f9879a62c08245fb2fbbd8c1d08b46ecfd3a9e","city_name":"خورموج","city_creation_date":"1337","city_division_code":"70272","district_name":"مرکزی","county_name":"دشتی","province_name":"بوشهر"},{"id":"city_4ad493946e13f15c41b9725d0f238927bcbb4253","city_name":"خوسف","city_creation_date":"1375","city_division_code":"70636","district_name":"خوسف","county_name":"بیرجند","province_name":"خراسان جنوبی"},{"id":"city_cbbb8e044878205c33d04119f10ff0af4285020e","city_name":"خوش رودپی","city_creation_date":"1379","city_division_code":"70844","district_name":"بند پی غربی","county_name":"بابل","province_name":"مازندران"},{"id":"city_29c2559354966a2e2b21ae7fe7e4882667377171","city_name":"خومه زار","city_creation_date":"1389","city_division_code":"71120","district_name":"مرکزی","county_name":"ممسنی","province_name":"فارس"},{"id":"city_2e1277096b5e3bcd93130b0c14381dc6e065814d","city_name":"خوی","city_creation_date":"1302","city_division_code":"70011","district_name":"مرکزی","county_name":"خوی","province_name":"آذربایجان غربی"},{"id":"city_adfb10616815d706c45ea67636ccc2eea87ba584","city_name":"دابودشت","city_creation_date":"1384","city_division_code":"70993","district_name":"دابودشت","county_name":"آمل","province_name":"مازندران"},{"id":"city_77e7b25f722632c49a30488e02e064622fef38db","city_name":"داراب","city_creation_date":"1309","city_division_code":"70071","district_name":"مرکزی","county_name":"داراب","province_name":"فارس"},{"id":"city_c37c520f27bb7f9025539df10ee933503270ed41","city_name":"داران","city_creation_date":"1329","city_division_code":"70175","district_name":"مرکزی","county_name":"فریدن","province_name":"اصفهان"},{"id":"city_3dcf8177d08c98bc01b7636475d06a1bdad4df25","city_name":"دارخوین","city_creation_date":"1386","city_division_code":"71023","district_name":"مرکزی","county_name":"شادگان","province_name":"خوزستان"},{"id":"city_6dab462bed66555cd6efd79f8cf97513038ff810","city_name":"داریان","city_creation_date":"1376","city_division_code":"70682","district_name":"مرکزی","county_name":"شیراز","province_name":"فارس"},{"id":"city_0cb086b4c7e2c48dd900fe25470381863257cd4d","city_name":"دالکی","city_creation_date":"1378","city_division_code":"70731","district_name":"مرکزی","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_49a5ccbe5ed46b41eedd13dcfec774262d97b423","city_name":"دامغان","city_creation_date":"1309","city_division_code":"70070","district_name":"مرکزی","county_name":"دامغان","province_name":"سمنان"},{"id":"city_b9751d2c99f0e946e71ab93f3a9d030267c28f30","city_name":"دامنه","city_creation_date":"1375","city_division_code":"70633","district_name":"مرکزی","county_name":"فریدن","province_name":"اصفهان"},{"id":"city_403719e49b115d05da9cfd514483e2857561907c","city_name":"دانسفهان","city_creation_date":"1372","city_division_code":"70580","district_name":"رامند","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_220e3f4638c0571177aeaf588f54f507ef546ea2","city_name":"داود آباد","city_creation_date":"1381","city_division_code":"70927","district_name":"مرکزی","county_name":"اراک","province_name":"مرکزی"},{"id":"city_66e8e26a4be4bfc85f550be5fc35cc7510b6366f","city_name":"داورزن","city_creation_date":"1375","city_division_code":"70659","district_name":"داورزن","county_name":"سبزوار","province_name":"خراسان رضوی"},{"id":"city_7ec9b403e2d2c1a5d3710cade9085e893b854802","city_name":"دبیران","city_creation_date":"1384","city_division_code":"71001","district_name":"مرکزی","county_name":"زرین دشت","province_name":"فارس"},{"id":"city_552e5ca08e704efc53f3c1d59cb576db94754ce0","city_name":"درب بهشت","city_creation_date":"1377","city_division_code":"70712","district_name":"ساردوئیه","county_name":"جیرفت","province_name":"کرمان"},{"id":"city_52c89f9169228dccbc7facbc055edf5b5900fbe5","city_name":"درب گنبد","city_creation_date":"1383","city_division_code":"70960","district_name":"درب گنبد","county_name":"کوهدشت","province_name":"لرستان"},{"id":"city_ba98f9b04b56f67134e94de45933be2bc40325bf","city_name":"درجزین","city_creation_date":"1386","city_division_code":"71045","district_name":"مرکزی","county_name":"مهدی شهر","province_name":"سمنان"},{"id":"city_1e5e4b11ae14b174e276076b43692059288a1919","city_name":"درچه پیاز","city_creation_date":"1345","city_division_code":"70409","district_name":"مرکزی","county_name":"خمینی شهر","province_name":"اصفهان"},{"id":"city_443c75b7cb586a425ce4e54fa617d2108d49b716","city_name":"درق","city_creation_date":"1384","city_division_code":"70989","district_name":"مرکزی","county_name":"گرمه","province_name":"خراسان شمالی"},{"id":"city_5b0bf8461b20da7fa2600e7db3f074114a159a65","city_name":"درگز","city_creation_date":"1320","city_division_code":"70152","district_name":"مرکزی","county_name":"درگز","province_name":"خراسان رضوی"},{"id":"city_a76ddd76f46c80ab50f9dadcff4d4343c9f913e2","city_name":"درگهان","city_creation_date":"1383","city_division_code":"70971","district_name":"مرکزی","county_name":"قشم","province_name":"هرمزگان"},{"id":"city_4e479da68bfdae85c922205ec44312075ed6f4cd","city_name":"درود","city_creation_date":"1342","city_division_code":"70352","district_name":"زبرخان","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_da5676315552d3e3db72164f66cdc5f7e7d4d768","city_name":"دره شهر","city_creation_date":"1344","city_division_code":"70390","district_name":"مرکزی","county_name":"دره شهر","province_name":"ایلام"},{"id":"city_0e3e5c82b14bafe7f158d27e32a40b9036fd33c7","city_name":"دزآب","city_creation_date":"1379","city_division_code":"70877","district_name":"مرکزی","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_fa454f1917c76ea0e132e5c27a179197335d5831","city_name":"دزج","city_creation_date":"1379","city_division_code":"70815","district_name":"چهاردولی","county_name":"قروه","province_name":"کردستان"},{"id":"city_4bb03bad6bae43329a74b80d893f69897a2b4727","city_name":"دزفول","city_creation_date":"1299","city_division_code":"70005","district_name":"مرکزی","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_11a227339ed9c579e2cb5604cb27e28ee20c7870","city_name":"دژکرد","city_creation_date":"1386","city_division_code":"71049","district_name":"سده","county_name":"اقلید","province_name":"فارس"},{"id":"city_f4f4e4f700c0ae246190f7a8555428672c080415","city_name":"دستجرد","city_creation_date":"1379","city_division_code":"70875","district_name":"خلجستان","county_name":"قم","province_name":"قم"},{"id":"city_39b888caaf2cd6ceef87f6f794dd4907107946ef","city_name":"دستگرد","city_creation_date":"1345","city_division_code":"70407","district_name":"مرکزی","county_name":"برخوار","province_name":"اصفهان"},{"id":"city_b751ecc089b3e04f086496aea6f44db3c986e3b2","city_name":"دستناء","city_creation_date":"1389","city_division_code":"71139","district_name":"مرکزی","county_name":"کیار","province_name":"چهار محال و بختیاری"},{"id":"city_dc409701064bd55c08b2e1f88f3538179a09137d","city_name":"دلبران","city_creation_date":"1379","city_division_code":"70816","district_name":"مرکزی","county_name":"قروه","province_name":"کردستان"},{"id":"city_1c13505fcd01e4705f2a580f81bbb7a51553f2d6","city_name":"دلگشا","city_creation_date":"1386","city_division_code":"71027","district_name":"گچی","county_name":"ملکشاهی","province_name":"ایلام"},{"id":"city_9c57da2e12d6aba213d034aee2ce738a04de3f26","city_name":"دلند","city_creation_date":"1374","city_division_code":"70610","district_name":"مرکزی","county_name":"رامیان","province_name":"گلستان"},{"id":"city_2bbccf29a433adbcc3fbdf7bfa1e906ecb63b950","city_name":"دلوار","city_creation_date":"1375","city_division_code":"70649","district_name":"دلوار","county_name":"تنگستان","province_name":"بوشهر"},{"id":"city_e8096b0749abfe038175348c43953e9d5a3d8c1c","city_name":"دلیجان","city_creation_date":"1316","city_division_code":"70137","district_name":"مرکزی","county_name":"دلیجان","province_name":"مرکزی"},{"id":"city_2619dbb77ef49aa501ea0873801bb96f0f39a583","city_name":"دماوند","city_creation_date":"1314","city_division_code":"70109","district_name":"مرکزی","county_name":"دماوند","province_name":"تهران"},{"id":"city_d0cf48df239e5c4683f419dfb9d54f638102b186","city_name":"دمق","city_creation_date":"1375","city_division_code":"70666","district_name":"سردرود","county_name":"رزن","province_name":"همدان"},{"id":"city_5662d61241477d4da6691410cd377483fb345f8c","city_name":"دندی","city_creation_date":"1375","city_division_code":"70640","district_name":"انگوران","county_name":"ماهنشان","province_name":"زنجان"},{"id":"city_3040739127639ba7545aae36ba1f80cd3466569c","city_name":"دوبرجی","city_creation_date":"1388","city_division_code":"71098","district_name":"فورگ","county_name":"داراب","province_name":"فارس"},{"id":"city_053c39e1360875dcfbfd7c238eb666c7d7ce5cd6","city_name":"دورود","city_creation_date":"1328","city_division_code":"70173","district_name":"مرکزی","county_name":"دورود","province_name":"لرستان"},{"id":"city_21361bd2e3eeca400e3012ae98604803ebbfb046","city_name":"دوزدوزان","city_creation_date":"1379","city_division_code":"70866","district_name":"مهربان","county_name":"سراب","province_name":"آذربایجان شرقی"},{"id":"city_f99f85cb6661dbcba6acfa0729bf499709ab324a","city_name":"دوزه","city_creation_date":"1389","city_division_code":"71111","district_name":"سیمکان","county_name":"جهرم","province_name":"فارس"},{"id":"city_f2ae212a215f3543b8276b6a9d59e542484f0bc9","city_name":"دوساری","city_creation_date":"1389","city_division_code":"71113","district_name":"مرکزی","county_name":"عنبر آباد","province_name":"کرمان"},{"id":"city_b25a70a655eaf24e0726334bb2ce721a88dd5214","city_name":"دوست محمد","city_creation_date":"1380","city_division_code":"70882","district_name":"مرکزی","county_name":"هیرمند","province_name":"سیستان و بلوچستان"},{"id":"city_68eaab80e1c5d60a19ce18d45555da717bfd7a50","city_name":"دوگنبدان","city_creation_date":"1343","city_division_code":"70381","district_name":"مرکزی","county_name":"گچساران","province_name":"کهگیلویه و بویراحمد"},{"id":"city_1cc74368af0806057b0a33a3a8731aac321e4363","city_name":"دولت آباد","city_creation_date":"1345","city_division_code":"70405","district_name":"مرکزی","county_name":"برخوار","province_name":"اصفهان"},{"id":"city_0fdcd6a03a869dd169546a1da65443290653350c","city_name":"دولت آباد","city_creation_date":"1369","city_division_code":"70522","district_name":"مرکزی","county_name":"زاوه","province_name":"خراسان رضوی"},{"id":"city_02a971f339c49879177270dd8dad101434392dd0","city_name":"دهاقان","city_creation_date":"1344","city_division_code":"70387","district_name":"مرکزی","county_name":"دهاقان","province_name":"اصفهان"},{"id":"city_beaec855432b779692137f26ba1b8d65268cf37a","city_name":"دهبارز","city_creation_date":"1361","city_division_code":"70464","district_name":"مرکزی","county_name":"رودان","province_name":"هرمزگان"},{"id":"city_e558b7690c700c991afb7c9fccf9fc9129d1a8c5","city_name":"دهج","city_creation_date":"1375","city_division_code":"70643","district_name":"دهج","county_name":"شهر بابک","province_name":"کرمان"},{"id":"city_aed2d8ca5ac7ec2340d1c7f8aecf96caaeb0e7fa","city_name":"دهدز","city_creation_date":"1379","city_division_code":"70790","district_name":"دهدز","county_name":"ایذه","province_name":"خوزستان"},{"id":"city_b0ae294a974384fa0e2dd42e583acd3b5c169bc3","city_name":"دهدشت","city_creation_date":"1342","city_division_code":"70361","district_name":"مرکزی","county_name":"کهگیلویه","province_name":"کهگیلویه و بویراحمد"},{"id":"city_17e2350e4cb1e8db69bd8744c738169fe9dfa923","city_name":"دهرم","city_creation_date":"1388","city_division_code":"71088","district_name":"دهرم","county_name":"فراشبند","province_name":"فارس"},{"id":"city_7742beb0afa7bb35158de1cbdbfb07adc0fdaff5","city_name":"دهق","city_creation_date":"1345","city_division_code":"70410","district_name":"مهردشت","county_name":"نجف آباد","province_name":"اصفهان"},{"id":"city_e40b0844710dd117254f58a8268c95f5ffc27213","city_name":"دهگلان","city_creation_date":"1361","city_division_code":"70462","district_name":"مرکزی","county_name":"دهگلان","province_name":"کردستان"},{"id":"city_bb78be5b844a6430ecf760346d2cafd4d17d2e6c","city_name":"دهلران","city_creation_date":"1342","city_division_code":"70350","district_name":"مرکزی","county_name":"دهلران","province_name":"ایلام"},{"id":"city_5c2a28fec30570284b5d783a11e9c256f90f4085","city_name":"دیباج","city_creation_date":"1375","city_division_code":"70624","district_name":"مرکزی","county_name":"دامغان","province_name":"سمنان"},{"id":"city_52102f8bc1945602ca21ed9202dc0d866d8183ac","city_name":"دیزج دیز","city_creation_date":"1386","city_division_code":"71035","district_name":"مرکزی","county_name":"خوی","province_name":"آذربایجان غربی"},{"id":"city_c386ef6d5a82289fe7ef9485a2ffb8c3e69b6540","city_name":"دیزیچه","city_creation_date":"1372","city_division_code":"70563","district_name":"مرکزی","county_name":"مبارکه","province_name":"اصفهان"},{"id":"city_9c0d7690d07294c22dc2cb1de73a3d29758179b3","city_name":"دیشموک","city_creation_date":"1379","city_division_code":"70830","district_name":"دیشموک","county_name":"کهگیلویه","province_name":"کهگیلویه و بویراحمد"},{"id":"city_31954df49c9c9781b460cfb18d743da3ba1610bd","city_name":"دیلمان","city_creation_date":"1378","city_division_code":"70750","district_name":"دیلمان","county_name":"سیاهکل","province_name":"گیلان"},{"id":"city_dcb80592a76c5918d06e6683a42e4e80949f3b08","city_name":"دیواندره","city_creation_date":"1337","city_division_code":"70280","district_name":"مرکزی","county_name":"دیواندره","province_name":"کردستان"},{"id":"city_8d398b16db62bf3c00d1e682300a672eac66d4ab","city_name":"دیهوک","city_creation_date":"1383","city_division_code":"70978","district_name":"دیهوک","county_name":"طبس","province_name":"یزد"},{"id":"city_a9d7daae8f9d1ad2b010df240cc82b0cc8efe557","city_name":"رابر","city_creation_date":"1342","city_division_code":"70359","district_name":"مرکزی","county_name":"رابر","province_name":"کرمان"},{"id":"city_a6d38190c382e2c76c60430de3e277bbee273cf1","city_name":"راز","city_creation_date":"1369","city_division_code":"70524","district_name":"راز و جرگلان","county_name":"بجنورد","province_name":"خراسان شمالی"},{"id":"city_e32772b1022c34429d674f7c24527c882b80aa01","city_name":"رازقان","city_creation_date":"1379","city_division_code":"70851","district_name":"خرقان","county_name":"زرندیه","province_name":"مرکزی"},{"id":"city_e48d897d4fbee3019b4876425b284b0a9d2125f0","city_name":"رازمیان","city_creation_date":"1379","city_division_code":"70807","district_name":"رودبار شهرستان","county_name":"قزوین","province_name":"قزوین"},{"id":"city_faf9dbff3eaebef7e2ea0fe5b7e75fda9a441be6","city_name":"راسک","city_creation_date":"1379","city_division_code":"70756","district_name":"مرکزی","county_name":"سرباز","province_name":"سیستان و بلوچستان"},{"id":"city_0964716015eaefdd895c631397081a114ef3b1e0","city_name":"رامجرد","city_creation_date":"1388","city_division_code":"71085","district_name":"درودزن","county_name":"مرودشت","province_name":"فارس"},{"id":"city_8e064359685c5f4062457abcd4bea269ced7f583","city_name":"رامسر","city_creation_date":"1330","city_division_code":"70195","district_name":"مرکزی","county_name":"رامسر","province_name":"مازندران"},{"id":"city_ae993c14d824ab1d6330c4dcf4adda717bcd2013","city_name":"رامشیر","city_creation_date":"1346","city_division_code":"70424","district_name":"مرکزی","county_name":"رامشیر","province_name":"خوزستان"},{"id":"city_fe0b7474c9d8a1cf775743eb737ee51b44323450","city_name":"رامهرمز","city_creation_date":"1310","city_division_code":"70082","district_name":"مرکزی","county_name":"رامهرمز","province_name":"خوزستان"},{"id":"city_602f494495a980a80a395411d489e939a13d6aa8","city_name":"رامیان","city_creation_date":"1333","city_division_code":"70225","district_name":"مرکزی","county_name":"رامیان","province_name":"گلستان"},{"id":"city_b20217f74c608e7f1a180fe6d814411d5037b777","city_name":"رانکوه","city_creation_date":"1382","city_division_code":"70934","district_name":"رانکوه","county_name":"املش","province_name":"گیلان"},{"id":"city_6ced1189eb2326d5bc2b5ecdcc5a3a5c07331618","city_name":"راور","city_creation_date":"1336","city_division_code":"70264","district_name":"مرکزی","county_name":"راور","province_name":"کرمان"},{"id":"city_6c37ed266e2be3cc43eaabb900b852eb638d1ff5","city_name":"راین","city_creation_date":"1337","city_division_code":"70281","district_name":"راین","county_name":"کرمان","province_name":"کرمان"},{"id":"city_aaa03db1943476059571fcacf305b91507173d5b","city_name":"رباط","city_creation_date":"1374","city_division_code":"70609","district_name":"ماهیدشت","county_name":"کرمانشاه","province_name":"کرمانشاه"},{"id":"city_c79d769e7f8030f130ed476d5ab6c0840b842ea0","city_name":"رباط سنگ","city_creation_date":"1379","city_division_code":"70778","district_name":"جلگه رخ","county_name":"تربت حیدریه","province_name":"خراسان رضوی"},{"id":"city_ab12834840ca6704eab6bc416483ab8f88f57513","city_name":"رباط کریم","city_creation_date":"1361","city_division_code":"70471","district_name":"مرکزی","county_name":"رباط کریم","province_name":"تهران"},{"id":"city_1674c5e03b89e31d22bb62c097f4a4701ae62c57","city_name":"ربط","city_creation_date":"1381","city_division_code":"70906","district_name":"مرکزی","county_name":"سر دشت","province_name":"آذربایجان غربی"},{"id":"city_b9e6bb13cf72ec78f204978081a026d12529c357","city_name":"رحیم آباد","city_creation_date":"1341","city_division_code":"70337","district_name":"رحیم آباد","county_name":"رودسر","province_name":"گیلان"},{"id":"city_9d09a333ab533b7bba3f1fd235045877021147a5","city_name":"رزن","city_creation_date":"1369","city_division_code":"70506","district_name":"مرکزی","county_name":"رزن","province_name":"همدان"},{"id":"city_7f1c51572b7aa9c1c8c83b977c7315b24952a1e0","city_name":"رزوه","city_creation_date":"1377","city_division_code":"70704","district_name":"مرکزی","county_name":"چادگان","province_name":"اصفهان"},{"id":"city_d93403a977cebd8a8048224342e2d2fd4bd22ea3","city_name":"رستم آباد","city_creation_date":"1372","city_division_code":"70546","district_name":"مرکزی","county_name":"رودبار","province_name":"گیلان"},{"id":"city_a297a725abe0250b58d5eb79ee25062dd5aaa9b3","city_name":"رستمکلا","city_creation_date":"1356","city_division_code":"70453","district_name":"مرکزی","county_name":"بهشهر","province_name":"مازندران"},{"id":"city_4fa16d1631a4f395c46be0f794ac13a9c76d495a","city_name":"رشت","city_creation_date":"1304","city_division_code":"70027","district_name":"مرکزی","county_name":"رشت","province_name":"گیلان"},{"id":"city_d6be1e27e815cba9e87dd45ce2d7617973e77543","city_name":"رشتخوار","city_creation_date":"1318","city_division_code":"70146","district_name":"مرکزی","county_name":"رشتخوار","province_name":"خراسان رضوی"},{"id":"city_4cafeebcae7590f7547c735e49211fb3ac3008d5","city_name":"رضوانشهر","city_creation_date":"1381","city_division_code":"70895","district_name":"مرکزی","county_name":"تیران و کرون","province_name":"اصفهان"},{"id":"city_c1591a195fd39680386df8dd91e3ca01c5144d7a","city_name":"رضوانشهر","city_creation_date":"1332","city_division_code":"70215","district_name":"مرکزی","county_name":"رضوانشهر","province_name":"گیلان"},{"id":"city_0f3a4a9f139755633c2e2e24f5f728bd2af5526d","city_name":"رضویه","city_creation_date":"1379","city_division_code":"70782","district_name":"رضویه","county_name":"مشهد","province_name":"خراسان رضوی"},{"id":"city_f5d0e02a814f76687e9e79189c9cc77a4680f98c","city_name":"رضی","city_creation_date":"1375","city_division_code":"70673","district_name":"ارشق","county_name":"مشگین شهر","province_name":"اردبیل"},{"id":"city_00dcc837a6576d98fbde2d882926890728e09619","city_name":"رفسنجان","city_creation_date":"1314","city_division_code":"70114","district_name":"مرکزی","county_name":"رفسنجان","province_name":"کرمان"},{"id":"city_11299484ed51bb79f4e74890d4d101980829eddf","city_name":"رفیع","city_creation_date":"1376","city_division_code":"70691","district_name":"نیسان","county_name":"هویزه","province_name":"خوزستان"},{"id":"city_b5ccadf0a0655cf9f260bd2ec35cdfda07cc9f0e","city_name":"روانسر","city_creation_date":"1369","city_division_code":"70504","district_name":"مرکزی","county_name":"روانسر","province_name":"کرمانشاه"},{"id":"city_d4b2fb0358cca145b44a57917d4c6f59f222127e","city_name":"روداب","city_creation_date":"1375","city_division_code":"70639","district_name":"روداب","county_name":"سبزوار","province_name":"خراسان رضوی"},{"id":"city_3ac1ac08f6d510343d213c41008649e4822e84f7","city_name":"رودبار","city_creation_date":"1311","city_division_code":"70097","district_name":"مرکزی","county_name":"رودبار","province_name":"گیلان"},{"id":"city_ab1d2f4a1f9b033ef7282b7c82e72ffc88d68f7c","city_name":"رودبار","city_creation_date":"1375","city_division_code":"70676","district_name":"مرکزی","county_name":"رودبار جنوب","province_name":"کرمان"},{"id":"city_acb3ceb7848d85e5edfffb036801756b7778ab99","city_name":"رودبنه","city_creation_date":"1379","city_division_code":"70837","district_name":"رودبنه","county_name":"لاهیجان","province_name":"گیلان"},{"id":"city_534c62290fb5b6a03aaa3bbfbd37394fff2d6dce","city_name":"رودسر","city_creation_date":"1305","city_division_code":"70034","district_name":"مرکزی","county_name":"رودسر","province_name":"گیلان"},{"id":"city_c3ec3b9693d771464bcdadd047a4d73affe8d731","city_name":"رودهن","city_creation_date":"1344","city_division_code":"70394","district_name":"رودهن","county_name":"دماوند","province_name":"تهران"},{"id":"city_4e0a35ff8742b2620483cef6ef2a1605d32491ba","city_name":"رونیز","city_creation_date":"1369","city_division_code":"70516","district_name":"رونیز","county_name":"استهبان","province_name":"فارس"},{"id":"city_fab6ba9ec9d6828784e6be97f7c820387cfa5680","city_name":"رویان","city_creation_date":"1333","city_division_code":"70230","district_name":"مرکزی","county_name":"نور","province_name":"مازندران"},{"id":"city_b4756446acfadee7345f15379bb3ee6fe10e359d","city_name":"رویدر","city_creation_date":"1386","city_division_code":"71059","district_name":"رویدر","county_name":"خمیر","province_name":"هرمزگان"},{"id":"city_b9dd2408add859b487ebafb428e8995111e2f63a","city_name":"ری","city_creation_date":"1336","city_division_code":"70258","district_name":"مرکزی","county_name":"ری","province_name":"تهران"},{"id":"city_0c10917b0f16ddde877166a40cc81506ccb5ee8a","city_name":"ریحان","city_creation_date":"1383","city_division_code":"70942","district_name":"مرکزی","county_name":"زرند","province_name":"کرمان"},{"id":"city_0e877fe22ce90dfad662cdb9c208b715c6312f69","city_name":"ریز","city_creation_date":"1384","city_division_code":"71006","district_name":"ریز","county_name":"جم","province_name":"بوشهر"},{"id":"city_0003a4b3225142b07dc595a0b2df5de877a56ee4","city_name":"رینه","city_creation_date":"1342","city_division_code":"70366","district_name":"لاریجان","county_name":"آمل","province_name":"مازندران"},{"id":"city_d7f13298f0c01a35b0fd9e9b592ddf278257850b","city_name":"ریوش","city_creation_date":"1378","city_division_code":"70748","district_name":"کوهسرخ","county_name":"کاشمر","province_name":"خراسان رضوی"},{"id":"city_0e800d4a87e00708436df22e64922f6d07dda6ff","city_name":"زابل","city_creation_date":"1307","city_division_code":"70051","district_name":"مرکزی","county_name":"زابل","province_name":"سیستان و بلوچستان"},{"id":"city_ead256eb40841015d13674adcde16e54b772f3d8","city_name":"زابلی","city_creation_date":"1378","city_division_code":"70735","district_name":"مرکزی","county_name":"زابلی","province_name":"سیستان و بلوچستان"},{"id":"city_60e1c1b05e486f89d0e090faa826c40759072891","city_name":"زارچ","city_creation_date":"1343","city_division_code":"70385","district_name":"زارچ","county_name":"یزد","province_name":"یزد"},{"id":"city_44a5b98b1f19682c1ebeb1860ad5242c31c1f26a","city_name":"زاغه","city_creation_date":"1378","city_division_code":"70730","district_name":"زاغه","county_name":"خرم آباد","province_name":"لرستان"},{"id":"city_9802a2e3bce11b159fb1c2d047cb8b74fb5ee1bf","city_name":"زاویه","city_creation_date":"1362","city_division_code":"70481","district_name":"مرکزی","county_name":"زرندیه","province_name":"مرکزی"},{"id":"city_8a1a4fac34d0ab33757cdf2289cd68e0eba6cc7c","city_name":"زاهد شهر","city_creation_date":"1370","city_division_code":"70537","district_name":"شیبکوه","county_name":"فسا","province_name":"فارس"},{"id":"city_8d1a15c0d24d06f06fdddb10b4c8782067f7d09c","city_name":"زاهدان","city_creation_date":"1317","city_division_code":"70142","district_name":"مرکزی","county_name":"زاهدان","province_name":"سیستان و بلوچستان"},{"id":"city_d3ac4a2b9647e047a76e8507c3ed0e1b3686fb91","city_name":"زاینده رود","city_creation_date":"1379","city_division_code":"70864","district_name":"مرکزی","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_69e6f55b1cc424f7ad31c89e0dadfa7eaaeca5f5","city_name":"زرآباد","city_creation_date":"1387","city_division_code":"71073","district_name":"زرآباد","county_name":"کنارک","province_name":"سیستان و بلوچستان"},{"id":"city_e05268c3980e7ab7d146dc2c617db512e2823cb5","city_name":"زرآباد","city_creation_date":"1389","city_division_code":"71135","district_name":"صفائیه","county_name":"خوی","province_name":"آذربایجان غربی"},{"id":"city_14a721e1e1029548deff569758a36fbc250d6783","city_name":"زرقان","city_creation_date":"1318","city_division_code":"70147","district_name":"زرقان","county_name":"شیراز","province_name":"فارس"},{"id":"city_53f0c5248920bdb561c5fc317d1fdcc716ef7e5a","city_name":"زرگر محله","city_creation_date":"1379","city_division_code":"70845","district_name":"لاله آباد","county_name":"بابل","province_name":"مازندران"},{"id":"city_0fe5ca623055bef6f9709a945e51767dd3d2b2ec","city_name":"زرند","city_creation_date":"1328","city_division_code":"70172","district_name":"مرکزی","county_name":"زرند","province_name":"کرمان"},{"id":"city_e9062f8a5fb9c1a61b59d8108527bd99cb23ea30","city_name":"زرنق","city_creation_date":"1373","city_division_code":"70583","district_name":"مرکزی","county_name":"هریس","province_name":"آذربایجان شرقی"},{"id":"city_f5fcff56d784bacfa9f671258437ae2da4265c89","city_name":"زرنه","city_creation_date":"1379","city_division_code":"70770","district_name":"زرنه","county_name":"ایوان","province_name":"ایلام"},{"id":"city_2686da690d490a9c7839c89b511a13cb2333b3ab","city_name":"زرین آباد","city_creation_date":"1376","city_division_code":"70681","district_name":"مرکزی","county_name":"ایجرود","province_name":"زنجان"},{"id":"city_20a899e0949e00a71c951bebce8dedddf49586b2","city_name":"زرین رود","city_creation_date":"1378","city_division_code":"70722","district_name":"بزینه رود","county_name":"خدابنده","province_name":"زنجان"},{"id":"city_c6b60a770b0f0adee79035c1d28e2e2c8eb16684","city_name":"زرین شهر","city_creation_date":"1325","city_division_code":"70159","district_name":"مرکزی","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_8ccf9e23bc926822e4a6186fa14b10ee4471c471","city_name":"زرینه","city_creation_date":"1379","city_division_code":"70812","district_name":"کرفتو","county_name":"دیواندره","province_name":"کردستان"},{"id":"city_738d3840c2cfdb2d1734cdb5c15fe7869385924e","city_name":"زنجان","city_creation_date":"1302","city_division_code":"70013","district_name":"مرکزی","county_name":"زنجان","province_name":"زنجان"},{"id":"city_9ada1544f7e32b2dae0fdf6c77edeced68ac9a1d","city_name":"زنگنه","city_creation_date":"1384","city_division_code":"71010","district_name":"زند","county_name":"ملایر","province_name":"همدان"},{"id":"city_c759a3e22ab5577ece0511cec99a68fcda8a0d71","city_name":"زنگی آباد","city_creation_date":"1375","city_division_code":"70670","district_name":"مرکزی","county_name":"کرمان","province_name":"کرمان"},{"id":"city_bf7c8909691894392d5463a1b1a2a1bbb53fc7dd","city_name":"زنوز","city_creation_date":"1332","city_division_code":"70205","district_name":"مرکزی","county_name":"مرند","province_name":"آذربایجان شرقی"},{"id":"city_a307dae7d864b9bf0af906d205b45b1e244afd21","city_name":"زواره","city_creation_date":"1332","city_division_code":"70207","district_name":"زواره","county_name":"اردستان","province_name":"اصفهان"},{"id":"city_b5e93c4d80ce2548a30a55dcb90ba23f7a941f06","city_name":"زهان","city_creation_date":"1383","city_division_code":"70955","district_name":"زهان","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_ab7e80a735370ece56413df1e9da487918d05b4c","city_name":"زهره","city_creation_date":"1384","city_division_code":"71009","district_name":"چم خلف عیسی","county_name":"هندیجان","province_name":"خوزستان"},{"id":"city_1491bbd1ac3ba3aac31c67fb64ca1d4ac2ca20d1","city_name":"زهک","city_creation_date":"1369","city_division_code":"70511","district_name":"مرکزی","county_name":"زهک","province_name":"سیستان و بلوچستان"},{"id":"city_2caaa33e7ca093d38412a392706ec95f7c324dc2","city_name":"زیارتعلی","city_creation_date":"1384","city_division_code":"71004","district_name":"رودخانه","county_name":"رودان","province_name":"هرمزگان"},{"id":"city_b7f77b622c4261c7889d167ddd34d33d1be77d91","city_name":"زیباشهر","city_creation_date":"1381","city_division_code":"70889","district_name":"گرکن جنوبی","county_name":"مبارکه","province_name":"اصفهان"},{"id":"city_48df7dd154b6c20157b369acd80b65cb9031a75a","city_name":"زید آباد","city_creation_date":"1375","city_division_code":"70677","district_name":"مرکزی","county_name":"سیرجان","province_name":"کرمان"},{"id":"city_05ca37a02197f6c4f6a1875ab32099841e053b95","city_name":"زیرآب","city_creation_date":"1335","city_division_code":"70249","district_name":"مرکزی","county_name":"سواد کوه","province_name":"مازندران"},{"id":"city_08b40ce18f5a2a43091f5cb92e941567141e8e5f","city_name":"ساروق","city_creation_date":"1388","city_division_code":"71102","district_name":"ساروق","county_name":"اراک","province_name":"مرکزی"},{"id":"city_81f177ece206e3fd90c8a0981e415fc3cf1f1af5","city_name":"ساری","city_creation_date":"1306","city_division_code":"70040","district_name":"مرکزی","county_name":"ساری","province_name":"مازندران"},{"id":"city_af9975e43a95d44222c31779a2ef5d1af0bc72d2","city_name":"سالند","city_creation_date":"1379","city_division_code":"70792","district_name":"سردشت","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_3a3888b327871763c66aaa97e4da0d8f3bb82240","city_name":"سامان","city_creation_date":"1347","city_division_code":"70429","district_name":"سامان","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_bd8a68ec4fcab0ae150009cf1f6670c14cfa0126","city_name":"سامن","city_creation_date":"1338","city_division_code":"70293","district_name":"سامن","county_name":"ملایر","province_name":"همدان"},{"id":"city_7d1608902f1edc5d42a6d302bf022c600a58adaf","city_name":"ساوه","city_creation_date":"1310","city_division_code":"70089","district_name":"مرکزی","county_name":"ساوه","province_name":"مرکزی"},{"id":"city_14e36fbf92cc539b4f668543f3ec181f750cd264","city_name":"سبزوار","city_creation_date":"1315","city_division_code":"70124","district_name":"مرکزی","county_name":"سبزوار","province_name":"خراسان رضوی"},{"id":"city_c7b8efea5731eb868e389f598afa15aa283d6f9a","city_name":"سپید دشت","city_creation_date":"1379","city_division_code":"70839","district_name":"پاپی","county_name":"خرم آباد","province_name":"لرستان"},{"id":"city_7f0a1bac68c9ff8201b588eb980370ce2526421e","city_name":"سجاس","city_creation_date":"1377","city_division_code":"70706","district_name":"سجاس رود","county_name":"خدابنده","province_name":"زنجان"},{"id":"city_a23317355d1ca6c1a0ebb7f55d4cd7c278057ef2","city_name":"سده","city_creation_date":"1376","city_division_code":"70692","district_name":"سده","county_name":"اقلید","province_name":"فارس"},{"id":"city_bd357f217e6710351866747078dabb4621d84c08","city_name":"سده لنجان","city_creation_date":"1362","city_division_code":"70482","district_name":"مرکزی","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_9a8fe11a2eb25b36ec53c7ea719c4764c56d6312","city_name":"سر پل ذهاب","city_creation_date":"1329","city_division_code":"70180","district_name":"مرکزی","county_name":"سر پل ذهاب","province_name":"کرمانشاه"},{"id":"city_22b35010eec3c484e1a8bafe1ec00f364d9b5800","city_name":"سراب","city_creation_date":"1314","city_division_code":"70106","district_name":"مرکزی","county_name":"سراب","province_name":"آذربایجان شرقی"},{"id":"city_76d7ad6bf27f6b883c52236a72da848985d6755a","city_name":"سراب باغ","city_creation_date":"1387","city_division_code":"71065","district_name":"سراب باغ","county_name":"آبدانان","province_name":"ایلام"},{"id":"city_1be6df81638b69b04dba65ae4a06e8939de6abdb","city_name":"سراب دوره","city_creation_date":"1375","city_division_code":"70654","district_name":"چگنی","county_name":"دوره","province_name":"لرستان"},{"id":"city_d5690be57735c406c1f782778545b7a0d42f79b9","city_name":"سرابله","city_creation_date":"1343","city_division_code":"70376","district_name":"مرکزی","county_name":"شیروان و چرداول","province_name":"ایلام"},{"id":"city_fd3c23892adc99d95b7324df80e36f20209f533c","city_name":"سراوان","city_creation_date":"1333","city_division_code":"70223","district_name":"مرکزی","county_name":"سراوان","province_name":"سیستان و بلوچستان"},{"id":"city_29631ee3316c8b352cee7d2217d0ae72c2f3ee68","city_name":"سرایان","city_creation_date":"1330","city_division_code":"70186","district_name":"آیسک","county_name":"سرایان","province_name":"خراسان جنوبی"},{"id":"city_b1e8dde840592a8872dba2242ab758ba4f5e79e0","city_name":"سرباز","city_creation_date":"1379","city_division_code":"70801","district_name":"سرباز","county_name":"سرباز","province_name":"سیستان و بلوچستان"},{"id":"city_ec1169637e0b435d64cb9e7788194c80b477ccb3","city_name":"سربیشه","city_creation_date":"1341","city_division_code":"70329","district_name":"مرکزی","county_name":"سربیشه","province_name":"خراسان جنوبی"},{"id":"city_4a4caf2e562dd817b3603ad9742aa8a135769cc4","city_name":"سرخرود","city_creation_date":"1379","city_division_code":"70849","district_name":"سرخرود","county_name":"محمود آباد","province_name":"مازندران"},{"id":"city_6d94d4f79e3330c14648ef717baf6d67482beaf7","city_name":"سرخس","city_creation_date":"1328","city_division_code":"70170","district_name":"مرکزی","county_name":"سرخس","province_name":"خراسان رضوی"},{"id":"city_8f005d7f7754999d95779a9b265e085941f0a9f0","city_name":"سرخنکلاته","city_creation_date":"1380","city_division_code":"70888","district_name":"بهاران","county_name":"گرگان","province_name":"گلستان"},{"id":"city_5dcc6f8a077efcdf05cd14d05cd744c64e5c5019","city_name":"سرخه","city_creation_date":"1342","city_division_code":"70354","district_name":"سرخه","county_name":"سمنان","province_name":"سمنان"},{"id":"city_d770d2668bc4fda46e6fe4ab30d1beba80cfa08a","city_name":"سردرود","city_creation_date":"1336","city_division_code":"70254","district_name":"مرکزی","county_name":"تبریز","province_name":"آذربایجان شرقی"},{"id":"city_24d3b1e8e568f88dfebabe05a02a4ee66c9ca739","city_name":"سردشت","city_creation_date":"1379","city_division_code":"70791","district_name":"زیدون","county_name":"بهبهان","province_name":"خوزستان"},{"id":"city_e06fa34e356b5d5706eaa982466ab8125331dc96","city_name":"سردشت","city_creation_date":"1387","city_division_code":"71070","district_name":"مرکزی","county_name":"بشاگرد","province_name":"هرمزگان"},{"id":"city_d6fe4b8954c80511d70c5c5f2e95e938067be92f","city_name":"سردشت","city_creation_date":"1327","city_division_code":"70164","district_name":"مرکزی","county_name":"سر دشت","province_name":"آذربایجان غربی"},{"id":"city_cfd6978944c1687690d95da15c8849c14a42ea92","city_name":"سرعین","city_creation_date":"1350","city_division_code":"70434","district_name":"مرکزی","county_name":"سرعین","province_name":"اردبیل"},{"id":"city_0def34749d0176e44a8aa5bf82f769b665ff55ba","city_name":"سرکان","city_creation_date":"1342","city_division_code":"70368","district_name":"مرکزی","county_name":"تویسرکان","province_name":"همدان"},{"id":"city_7b3d2f52b23835c3a231823f2d31d0454c4cff96","city_name":"سرگز","city_creation_date":"1389","city_division_code":"71105","district_name":"احمدی","county_name":"حاجی آباد","province_name":"هرمزگان"},{"id":"city_79422316e8cd83fa1d5f7927e9791c035f1212cd","city_name":"سرمست","city_creation_date":"1379","city_division_code":"70826","district_name":"گواور","county_name":"گیلانغرب","province_name":"کرمانشاه"},{"id":"city_84c18252feb65d5cf8a0142f4d6d4769a5da35d1","city_name":"سرو","city_creation_date":"1379","city_division_code":"70752","district_name":"صومای برادوست","county_name":"ارومیه","province_name":"آذربایجان غربی"},{"id":"city_21a92ac4c04409d23347894edbb78c783e614e24","city_name":"سرو آباد","city_creation_date":"1374","city_division_code":"70608","district_name":"مرکزی","county_name":"سروآباد","province_name":"کردستان"},{"id":"city_e9da1d03f814fe3831a5864251241a5e2933e558","city_name":"سروستان","city_creation_date":"1333","city_division_code":"70224","district_name":"مرکزی","county_name":"سروستان","province_name":"فارس"},{"id":"city_8413eeaf80e9b86c741d9df86c4aa1ee9e6f4bd8","city_name":"سریش آباد","city_creation_date":"1361","city_division_code":"70463","district_name":"سریش آباد","county_name":"قروه","province_name":"کردستان"},{"id":"city_c01a02f535ebccb2485fd2969faf64b72faa458a","city_name":"سطر","city_creation_date":"1384","city_division_code":"70992","district_name":"کلیائی","county_name":"سنقر","province_name":"کرمانشاه"},{"id":"city_cf51013035d52bba752a5e06f35382f8eefe2bd9","city_name":"سعادت شهر","city_creation_date":"1343","city_division_code":"70380","district_name":"مرکزی","county_name":"پاسارگاد","province_name":"فارس"},{"id":"city_b966e3ee7b0b1f4dc32b53ab6560ae1fe409a31b","city_name":"سعد آباد","city_creation_date":"1354","city_division_code":"70440","district_name":"سعد آباد","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_e933494bedad1852ac0d9fb0cc291675990f8b23","city_name":"سفید دشت","city_creation_date":"1376","city_division_code":"70686","district_name":"مرکزی","county_name":"بروجن","province_name":"چهار محال و بختیاری"},{"id":"city_3670d5053c9d132da8a54b94ff7f0357efdcbabd","city_name":"سفید سنگ","city_creation_date":"1383","city_division_code":"70968","district_name":"قلندر آباد","county_name":"فریمان","province_name":"خراسان رضوی"},{"id":"city_5b928c96873c24bea6a65b5aa194b6d8bd2e8540","city_name":"سفید شهر","city_creation_date":"1381","city_division_code":"70922","district_name":"مرکزی","county_name":"آران و بیدگل","province_name":"اصفهان"},{"id":"city_38a4bb10979ead71e0e9aead351e209c7651cbad","city_name":"سقز","city_creation_date":"1314","city_division_code":"70112","district_name":"مرکزی","county_name":"سقز","province_name":"کردستان"},{"id":"city_223d6ac6e6154d9393389cf34d55da264046c5d6","city_name":"سگز آباد","city_creation_date":"1383","city_division_code":"70976","district_name":"مرکزی","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_7045887ff6b7962efce64fb26ffa21022cc5403b","city_name":"سگزی","city_creation_date":"1377","city_division_code":"70710","district_name":"کوهپایه","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_c239e5b60d589a57d073ebb2f27b7c6ceae034ca","city_name":"سلامی","city_creation_date":"1383","city_division_code":"70946","district_name":"سلامی","county_name":"خواف","province_name":"خراسان رضوی"},{"id":"city_89454fb17d0f80892d6e261a47b215a344872175","city_name":"سلطان آباد","city_creation_date":"1378","city_division_code":"70746","district_name":"مرکزی","county_name":"خوشاب","province_name":"خراسان رضوی"},{"id":"city_efd743561a3a9011f02af2395d3401c859a117ec","city_name":"سلطانیه","city_creation_date":"1340","city_division_code":"70315","district_name":"سلطانیه","county_name":"ابهر","province_name":"زنجان"},{"id":"city_3edde1ccd53b23600cd53166921e1d20389d33cb","city_name":"سلفچگان","city_creation_date":"1387","city_division_code":"71062","district_name":"سلفچگان","county_name":"قم","province_name":"قم"},{"id":"city_25c6f43d29a576b41eee061df8bcc81fe9167d0c","city_name":"سلماس","city_creation_date":"1339","city_division_code":"70297","district_name":"مرکزی","county_name":"سلماس","province_name":"آذربایجان غربی"},{"id":"city_0afe35ae2d2d3ee5c4131121e3bf5ad3f5bcbdb9","city_name":"سلمان شهر","city_creation_date":"1341","city_division_code":"70340","district_name":"کلارآباد","county_name":"عباس آباد","province_name":"مازندران"},{"id":"city_500f8f882c786db8a8cdc868cedffec5d770284f","city_name":"سماله","city_creation_date":"1389","city_division_code":"71116","district_name":"عقیلی","county_name":"گتوند","province_name":"خوزستان"},{"id":"city_a7bb63f6ce64b2f2a3dab54d0c32bd605170b18c","city_name":"سمنان","city_creation_date":"1304","city_division_code":"70022","district_name":"مرکزی","county_name":"سمنان","province_name":"سمنان"},{"id":"city_6ba55a87f7d58431ab5cfd22abc38e70ad3a6a30","city_name":"سمیرم","city_creation_date":"1339","city_division_code":"70298","district_name":"مرکزی","county_name":"سمیرم","province_name":"اصفهان"},{"id":"city_2a75a4dc1022de6f9767dfebb13efae6680a87a3","city_name":"سنجان","city_creation_date":"1373","city_division_code":"70591","district_name":"مرکزی","county_name":"اراک","province_name":"مرکزی"},{"id":"city_f88feb69ee3167208829bcba8c507a61aa898263","city_name":"سنخواست","city_creation_date":"1379","city_division_code":"70786","district_name":"جلگه سنخواست","county_name":"جاجرم","province_name":"خراسان شمالی"},{"id":"city_9c510c64d78bfee076bc22b37f9d88c17c0e2650","city_name":"سندرک","city_creation_date":"1388","city_division_code":"71086","district_name":"سندرک","county_name":"میناب","province_name":"هرمزگان"},{"id":"city_21866171d5085fdb1ed322a2fde903d33b90500b","city_name":"سنقر","city_creation_date":"1309","city_division_code":"70073","district_name":"مرکزی","county_name":"سنقر","province_name":"کرمانشاه"},{"id":"city_2862a0565572684e24c189ce2f9a19eabbc5c960","city_name":"سنگان","city_creation_date":"1369","city_division_code":"70523","district_name":"سنگان","county_name":"خواف","province_name":"خراسان رضوی"},{"id":"city_d382928de8fe8f6c644342754cfb57d44a2d77c3","city_name":"سنگر","city_creation_date":"1308","city_division_code":"70062","district_name":"سنگر","county_name":"رشت","province_name":"گیلان"},{"id":"city_8ca273d858239fcf26d4624023078e7d75a6d7b7","city_name":"سنندج","city_creation_date":"1307","city_division_code":"70053","district_name":"مرکزی","county_name":"سنندج","province_name":"کردستان"},{"id":"city_6a74575769e8f84a3bda9bb42b3dd855fba36a8e","city_name":"سودجان","city_creation_date":"1382","city_division_code":"70939","district_name":"لاران","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_0d8113e61eec07ddcbf4f9c63730886114e344bc","city_name":"سوران","city_creation_date":"1369","city_division_code":"70508","district_name":"مرکزی","county_name":"سیب سوران","province_name":"سیستان و بلوچستان"},{"id":"city_24f66130598ed953b4579d1665ce898eff9d1f1c","city_name":"سورشجان","city_creation_date":"1368","city_division_code":"70499","district_name":"لاران","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_a7db2818b33ea87ecfa772984b9e1b0d6b01e9c0","city_name":"سورک","city_creation_date":"1375","city_division_code":"70665","district_name":"مرکزی","county_name":"میاندورود","province_name":"مازندران"},{"id":"city_979de17eeca27d7de229df87d7480443bd1de58d","city_name":"سورمق","city_creation_date":"1384","city_division_code":"70990","district_name":"مرکزی","county_name":"آباده","province_name":"فارس"},{"id":"city_ae4001bb0dcbb65f2f95374e268901a6c38cf05c","city_name":"سوزا","city_creation_date":"1379","city_division_code":"70853","district_name":"شهاب","county_name":"قشم","province_name":"هرمزگان"},{"id":"city_f0bc4594929d1ed737f35e22f22ac1ca52aa25e6","city_name":"سوسنگرد","city_creation_date":"1317","city_division_code":"70141","district_name":"مرکزی","county_name":"دشت آزادگان","province_name":"خوزستان"},{"id":"city_81f11d8186736dfc3f80ed8eac0e97edb523a60e","city_name":"سوق","city_creation_date":"1372","city_division_code":"70572","district_name":"مرکزی","county_name":"کهگیلویه","province_name":"کهگیلویه و بویراحمد"},{"id":"city_dcc411210310d5f787d267c153116c9c22eb309c","city_name":"سومار","city_creation_date":"1374","city_division_code":"70604","district_name":"سومار","county_name":"قصر شیرین","province_name":"کرمانشاه"},{"id":"city_c80b726b470aa874db51be8727fcb16492a24bec","city_name":"سه قلعه","city_creation_date":"1381","city_division_code":"70890","district_name":"سه قلعه","county_name":"سرایان","province_name":"خراسان جنوبی"},{"id":"city_fa08933345552a5174694099e1b8a74540bb76dd","city_name":"سهرورد","city_creation_date":"1386","city_division_code":"71044","district_name":"مرکزی","county_name":"خدابنده","province_name":"زنجان"},{"id":"city_5cc5ca06bd9a367b3262114c7a69d3667017557e","city_name":"سی سخت","city_creation_date":"1362","city_division_code":"70478","district_name":"مرکزی","county_name":"دنا","province_name":"کهگیلویه و بویراحمد"},{"id":"city_de72b0020c78361c78e4af8437e4709915315173","city_name":"سیاهکل","city_creation_date":"1308","city_division_code":"70064","district_name":"مرکزی","county_name":"سیاهکل","province_name":"گیلان"},{"id":"city_04a4dbfac52251cd104b96d8e4c3442232af47cc","city_name":"سیدان","city_creation_date":"1377","city_division_code":"70711","district_name":"سیدان","county_name":"مرودشت","province_name":"فارس"},{"id":"city_2a4d24b454dd90d73fea99c5b016106de1c3e4bc","city_name":"سیراف","city_creation_date":"1384","city_division_code":"71007","district_name":"مرکزی","county_name":"کنگان","province_name":"بوشهر"},{"id":"city_ca293234f83e0050f859e40b20d58fdd71690c62","city_name":"سیرجان","city_creation_date":"1315","city_division_code":"70126","district_name":"مرکزی","county_name":"سیرجان","province_name":"کرمان"},{"id":"city_750dd18ee36c3c952f6de411118275405b7531d8","city_name":"سیردان","city_creation_date":"1384","city_division_code":"70999","district_name":"طارم سفلی","county_name":"قزوین","province_name":"قزوین"},{"id":"city_6fc2d3bb689897c01cb8138d4b90cf29e915474b","city_name":"سیرکان","city_creation_date":"1379","city_division_code":"70800","district_name":"بم پشت","county_name":"سراوان","province_name":"سیستان و بلوچستان"},{"id":"city_60ff8c3914ad3676b36dab932c8f28b2ac5664fa","city_name":"سیریک","city_creation_date":"1375","city_division_code":"70626","district_name":"مرکزی","county_name":"سیریک","province_name":"هرمزگان"},{"id":"city_b98ae71f0dc698e2a7bc115390b3acfebee5764a","city_name":"سیس","city_creation_date":"1372","city_division_code":"70547","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_3c7a706db6d1a193a67010326520467f9ccf0c54","city_name":"سیلوانه","city_creation_date":"1379","city_division_code":"70763","district_name":"سیلوانه","county_name":"ارومیه","province_name":"آذربایجان غربی"},{"id":"city_03499e8280fbe6c9f3909e60f691b95250edc246","city_name":"سیمین شهر","city_creation_date":"1381","city_division_code":"70894","district_name":"گلدشت","county_name":"گمیشان","province_name":"گلستان"},{"id":"city_4d13debe4700c2280e8a7bf38987beb60aa407f8","city_name":"سیمینه","city_creation_date":"1381","city_division_code":"70896","district_name":"سیمینه","county_name":"بوکان","province_name":"آذربایجان غربی"},{"id":"city_044c468b04edb8c39728cc662301b0a673342b10","city_name":"سیه چشمه","city_creation_date":"1339","city_division_code":"70295","district_name":"مرکزی","county_name":"چالدران","province_name":"آذربایجان غربی"},{"id":"city_c6e366a0079ff0e56d3f4d218733a6e50446e082","city_name":"سیه رود","city_creation_date":"1379","city_division_code":"70758","district_name":"سیه رود","county_name":"جلفا","province_name":"آذربایجان شرقی"},{"id":"city_d1734db9d72f15d44b1c7335b0df06f42f0963c2","city_name":"شاپورآباد","city_creation_date":"1389","city_division_code":"71126","district_name":"حبیب آباد","county_name":"برخوار","province_name":"اصفهان"},{"id":"city_22b426dcbe5fc6b9b7c904277abe0fbed0898c20","city_name":"شادگان","city_creation_date":"1309","city_division_code":"70069","district_name":"مرکزی","county_name":"شادگان","province_name":"خوزستان"},{"id":"city_678c9111e75592f6b3eabf390690f1921597a20c","city_name":"شادمهر","city_creation_date":"1387","city_division_code":"71079","district_name":"شادمهر","county_name":"مه ولات","province_name":"خراسان رضوی"},{"id":"city_48e1e5b562353c1de7a15cb8abac18bf42a42a8d","city_name":"شازند","city_creation_date":"1343","city_division_code":"70383","district_name":"مرکزی","county_name":"شازند","province_name":"مرکزی"},{"id":"city_3b811fc1488cd49e3adf74690873a0c4d6920343","city_name":"شال","city_creation_date":"1361","city_division_code":"70469","district_name":"شال","county_name":"بوئین زهرا","province_name":"قزوین"},{"id":"city_4448f27b4722ede770c5d9d1dd545e9a57f1b7a2","city_name":"شاندیز","city_creation_date":"1336","city_division_code":"70261","district_name":"شاندیز","county_name":"بینالود","province_name":"خراسان رضوی"},{"id":"city_783e23acfb74864ee62ccee0640758a0f80c9306","city_name":"شاوور","city_creation_date":"1387","city_division_code":"71072","district_name":"شاوور","county_name":"شوش","province_name":"خوزستان"},{"id":"city_5c78a0f0c80791130747fd37e8074c3ea6a6c76c","city_name":"شاهدشهر","city_creation_date":"1376","city_division_code":"70696","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_b6d205d411033f7f587c854c4f254b6889c9a127","city_name":"شاهدیه","city_creation_date":"1370","city_division_code":"70543","district_name":"مرکزی","county_name":"یزد","province_name":"یزد"},{"id":"city_67ac1cfdea4a580e23a4f9a54e94b9f2dcbe741e","city_name":"شاهرود","city_creation_date":"1304","city_division_code":"70023","district_name":"مرکزی","county_name":"شاهرود","province_name":"سمنان"},{"id":"city_1adac1abbf54ddb44d4fbbe0ea524f6d0ac900bc","city_name":"شاهو","city_creation_date":"1387","city_division_code":"71066","district_name":"شاهو","county_name":"روانسر","province_name":"کرمانشاه"},{"id":"city_aa5e9a9af186070256b0eafebe00abbfa604609c","city_name":"شاهین دژ","city_creation_date":"1318","city_division_code":"70145","district_name":"مرکزی","county_name":"شاهین دژ","province_name":"آذربایجان غربی"},{"id":"city_aa2c3a007df48cde67f45c77008c047df9253fcb","city_name":"شاهین شهر","city_creation_date":"1355","city_division_code":"70444","district_name":"مرکزی","county_name":"شاهین شهر و میمه","province_name":"اصفهان"},{"id":"city_d4da86aeaf73a23d91a6a5a25136d8de10fc7ef8","city_name":"شبانکاره","city_creation_date":"1369","city_division_code":"70518","district_name":"شبانکاره","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_f0543289942687aed58612460414071089c61449","city_name":"شبستر","city_creation_date":"1307","city_division_code":"70043","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_36220f78f0f041aa595912134bf16da62158fee8","city_name":"شرافت","city_creation_date":"1386","city_division_code":"71042","district_name":"مرکزی","county_name":"شوشتر","province_name":"خوزستان"},{"id":"city_74e9aa6cb9ccb8628662da546b86ee48029fa6c6","city_name":"شربیان","city_creation_date":"1378","city_division_code":"70717","district_name":"مهربان","county_name":"سراب","province_name":"آذربایجان شرقی"},{"id":"city_8d75b8d77ca8f6f194cf18840ebb462e531f8a88","city_name":"شرفخانه","city_creation_date":"1340","city_division_code":"70311","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_70eb8e7442902e0965cab022b7b7ca52f0768151","city_name":"شریف آباد","city_creation_date":"1379","city_division_code":"70772","district_name":"شریف آباد","county_name":"پاکدشت","province_name":"تهران"},{"id":"city_eee144b5120e0be2a438d6b6c43f1f9d260ba115","city_name":"شریفیه","city_creation_date":"1386","city_division_code":"71053","district_name":"محمدیه","county_name":"البرز","province_name":"قزوین"},{"id":"city_39447d70aa73212ae93ed970dfabb2377db6b463","city_name":"ششتمد","city_creation_date":"1378","city_division_code":"70747","district_name":"ششتمد","county_name":"سبزوار","province_name":"خراسان رضوی"},{"id":"city_2c9b1ff909a3ede3c9f4083ba6e416bacd874608","city_name":"ششده","city_creation_date":"1369","city_division_code":"70519","district_name":"ششده و قره بلاغ","county_name":"فسا","province_name":"فارس"},{"id":"city_fe277b67f35f38faf1cc6b477b94111783a006a2","city_name":"شفت","city_creation_date":"1331","city_division_code":"70202","district_name":"مرکزی","county_name":"شفت","province_name":"گیلان"},{"id":"city_d31be49a813756fc952ca96d88c8bcc0571d2b69","city_name":"شلمان","city_creation_date":"1372","city_division_code":"70566","district_name":"کومله","county_name":"لنگرود","province_name":"گیلان"},{"id":"city_c72d82b731bd8523b94ca025dacc52078ae271e1","city_name":"شلمزار","city_creation_date":"1369","city_division_code":"70507","district_name":"مرکزی","county_name":"کیار","province_name":"چهار محال و بختیاری"},{"id":"city_e69fd1d458846d6c08f5a3585b270e384c8ea4a4","city_name":"شمس آباد","city_creation_date":"1389","city_division_code":"71147","district_name":"مرکزی","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_a8cec840b9e4d74d9813847d02df3a8255f1439c","city_name":"شنبه","city_creation_date":"1387","city_division_code":"71080","district_name":"شنبه و طسوج","county_name":"دشتی","province_name":"بوشهر"},{"id":"city_787bab965cb115647b5f4e5fa54bd0346c3b822b","city_name":"شند آباد","city_creation_date":"1358","city_division_code":"70456","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_b03f884ab8157fd977f291a90a0c89e048935956","city_name":"شوسف","city_creation_date":"1379","city_division_code":"70776","district_name":"شوسف","county_name":"نهبندان","province_name":"خراسان جنوبی"},{"id":"city_e3d69095f84e65d0cebb30d9375c6a324142abcd","city_name":"شوش","city_creation_date":"1334","city_division_code":"70235","district_name":"مرکزی","county_name":"شوش","province_name":"خوزستان"},{"id":"city_314a3d3de04886537ad365fb2cf3245067fe499b","city_name":"شوشتر","city_creation_date":"1306","city_division_code":"70038","district_name":"مرکزی","county_name":"شوشتر","province_name":"خوزستان"},{"id":"city_17a54575c225d9def3caff04681fba113e9a8dac","city_name":"شوط","city_creation_date":"1335","city_division_code":"70238","district_name":"مرکزی","county_name":"شوط","province_name":"آذربایجان غربی"},{"id":"city_a6078f6dbe64207f527c73b422730185c541d32b","city_name":"شوقان","city_creation_date":"1379","city_division_code":"70787","district_name":"جلگه شوقان","county_name":"جاجرم","province_name":"خراسان شمالی"},{"id":"city_8af0c63ccc77d0ed0c3296d37ee99d185c9cc2f1","city_name":"شول آباد","city_creation_date":"1389","city_division_code":"71121","district_name":"زز و ماهرو","county_name":"الیگودرز","province_name":"لرستان"},{"id":"city_73a650cecb2c7f080d485df9d2e2c4a15dfa9d0a","city_name":"شویشه","city_creation_date":"1379","city_division_code":"70814","district_name":"کلاترزان","county_name":"سنندج","province_name":"کردستان"},{"id":"city_1aff4b75063cf595ebb17124157c62282364be4e","city_name":"شهداد","city_creation_date":"1337","city_division_code":"70282","district_name":"شهداد","county_name":"کرمان","province_name":"کرمان"},{"id":"city_4c490903d49163f5ffe2bc3e63c87bae5c22faa4","city_name":"شهر بابک","city_creation_date":"1331","city_division_code":"70201","district_name":"مرکزی","county_name":"شهر بابک","province_name":"کرمان"},{"id":"city_edd92d8043470633e46414d14b3b2b3deebd2123","city_name":"شهر پیر","city_creation_date":"1381","city_division_code":"70916","district_name":"ایزد خواست","county_name":"زرین دشت","province_name":"فارس"},{"id":"city_f918c344c88f68e699d85ee381c4e3f441e6d473","city_name":"شهر جدید سهند","city_creation_date":"1386","city_division_code":"71019","district_name":"مرکزی","county_name":"اسکو","province_name":"آذربایجان شرقی"},{"id":"city_55b32725abe8d2607aead6a87d118bca18e27482","city_name":"شهر جدید صدرا","city_creation_date":"1388","city_division_code":"71108","district_name":"مرکزی","county_name":"شیراز","province_name":"فارس"},{"id":"city_d3b0614f3964815293ddd195bfb3f82a91bd520e","city_name":"شهر جدید مهاجران","city_creation_date":"1385","city_division_code":"71016","district_name":"زالیان","county_name":"شازند","province_name":"مرکزی"},{"id":"city_26ddaac737197499965a90c917ca2bc981606a1b","city_name":"شهر جدید هشتگرد","city_creation_date":"1381","city_division_code":"70903","district_name":"مرکزی","county_name":"ساوجبلاغ","province_name":"البرز"},{"id":"city_df13e9fff1a89cd005080c406d77009cb4a07cde","city_name":"شهر زو","city_creation_date":"1384","city_division_code":"70988","district_name":"زاوین","county_name":"کلات","province_name":"خراسان رضوی"},{"id":"city_1eb86b48faefb282474b313bd2a076b616faf41c","city_name":"شهرآباد","city_creation_date":"1388","city_division_code":"71094","district_name":"شهرآباد","county_name":"بردسکن","province_name":"خراسان رضوی"},{"id":"city_44e41383aa3d180b021b556db3a7402bbaf05bca","city_name":"شهرضا","city_creation_date":"1308","city_division_code":"70059","district_name":"مرکزی","county_name":"شهرضا","province_name":"اصفهان"},{"id":"city_005888d91ffd4685b20887fcbab7ec2da3bfa119","city_name":"شهرکرد","city_creation_date":"1310","city_division_code":"70079","district_name":"مرکزی","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_005d81c44356188ac17b2ea1879f114238705458","city_name":"شهریار","city_creation_date":"1331","city_division_code":"70198","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_8cf892854c6be1f06af9b592a9b98e2fba00f558","city_name":"شهمیرزاد","city_creation_date":"1331","city_division_code":"70199","district_name":"شهمیرزاد","county_name":"مهدی شهر","province_name":"سمنان"},{"id":"city_879c0b775cc8503e7130bb436ab9ea2f81a348bc","city_name":"شیبان","city_creation_date":"1376","city_division_code":"70687","district_name":"مرکزی","county_name":"باوی","province_name":"خوزستان"},{"id":"city_f4b97d884c66253d649f44f3cbf3fd78a4117d85","city_name":"شیراز","city_creation_date":"1329","city_division_code":"70178","district_name":"مرکزی","county_name":"شیراز","province_name":"فارس"},{"id":"city_4625c4e98c691e2534501aeaca538c3415f5f9c7","city_name":"شیرگاه","city_creation_date":"1342","city_division_code":"70367","district_name":"شیرگاه","county_name":"سواد کوه","province_name":"مازندران"},{"id":"city_ba7037eb1974f25deb462a4fc344a17c33127a0f","city_name":"شیروان","city_creation_date":"1306","city_division_code":"70037","district_name":"مرکزی","county_name":"شیروان","province_name":"خراسان شمالی"},{"id":"city_bc103b8d89c930f123c8eecaa81c1f7aba9e6a67","city_name":"شیرود","city_creation_date":"1387","city_division_code":"71063","district_name":"مرکزی","county_name":"تنکابن","province_name":"مازندران"},{"id":"city_7dcdda888bbf862d2e0c54351e05dab8f6cb6ecd","city_name":"شیرین سو","city_creation_date":"1379","city_division_code":"70855","district_name":"شیرین سو","county_name":"کبودرآهنگ","province_name":"همدان"},{"id":"city_5b03f954ed347e66de995aee7cdcee54763204d1","city_name":"صاحب","city_creation_date":"1379","city_division_code":"70813","district_name":"زیویه","county_name":"سقز","province_name":"کردستان"},{"id":"city_be88fa03b458d4cdf054a32272ac4012e763509a","city_name":"صالح آباد","city_creation_date":"1373","city_division_code":"70589","district_name":"صالح آباد","county_name":"بهار","province_name":"همدان"},{"id":"city_680dddd965a50122ab7735b8efd8a13ac9b923e4","city_name":"صالح آباد","city_creation_date":"1342","city_division_code":"70351","district_name":"صالح آباد","county_name":"تربت جام","province_name":"خراسان رضوی"},{"id":"city_e12ebf34fb94f40456019fb016a749a92ae7b817","city_name":"صالح آباد","city_creation_date":"1344","city_division_code":"70392","district_name":"صالح آباد","county_name":"مهران","province_name":"ایلام"},{"id":"city_f11682194f535ebec64163db97b26e1fa17d30e2","city_name":"صالح آباد","city_creation_date":"1384","city_division_code":"70998","district_name":"گلستان","county_name":"رباط کریم","province_name":"تهران"},{"id":"city_482ecbe27330e9ad3f0f2ff8f27d427a1ac5436f","city_name":"صالح شهر","city_creation_date":"1386","city_division_code":"71043","district_name":"مرکزی","county_name":"گتوند","province_name":"خوزستان"},{"id":"city_790e309690f9d94423cf801c3e6a7f83a94c601b","city_name":"صالح مشطت","city_creation_date":"1389","city_division_code":"71122","district_name":"فتح المبین","county_name":"شوش","province_name":"خوزستان"},{"id":"city_a659b8dca516e3eab3c2d08b7e262a4b71e41827","city_name":"صائین قلعه","city_creation_date":"1362","city_division_code":"70476","district_name":"مرکزی","county_name":"ابهر","province_name":"زنجان"},{"id":"city_8ce3ae90fa0bbd2db4c942f39862081dd9a8f24b","city_name":"صبا شهر","city_creation_date":"1375","city_division_code":"70658","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_506e1f936861d6c150e97678c01718a2d681fc03","city_name":"صحنه","city_creation_date":"1309","city_division_code":"70074","district_name":"مرکزی","county_name":"صحنه","province_name":"کرمانشاه"},{"id":"city_55ac713a52a15428c0edb7e1fd10e8c2d5b15134","city_name":"صغاد","city_creation_date":"1356","city_division_code":"70452","district_name":"مرکزی","county_name":"آباده","province_name":"فارس"},{"id":"city_38fd2186255c27682121ed0ead864b59d5cf8ac7","city_name":"صفا شهر","city_creation_date":"1370","city_division_code":"70535","district_name":"مرکزی","county_name":"خرم بید","province_name":"فارس"},{"id":"city_ae60706de7a2da6edcb376378ea923aff80eb979","city_name":"صفادشت","city_creation_date":"1377","city_division_code":"70705","district_name":"صفادشت","county_name":"ملارد","province_name":"تهران"},{"id":"city_dcba9b04ce63ff4b1b4ce40acf9397d704aeed68","city_name":"صفائیه","city_creation_date":"1388","city_division_code":"71087","district_name":"فردوس","county_name":"رفسنجان","province_name":"کرمان"},{"id":"city_f53b55fdceb919492b6c375a34717221e97af643","city_name":"صفی آباد","city_creation_date":"1379","city_division_code":"70784","district_name":"بام وصفی آباد","county_name":"اسفراین","province_name":"خراسان شمالی"},{"id":"city_8e9a1454165fd1e2c061466c771f363971a9e188","city_name":"صفی آباد","city_creation_date":"1379","city_division_code":"70879","district_name":"مرکزی","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_fe351bc1ea0c4adac9571d3bff375d24a5536236","city_name":"صوفیان","city_creation_date":"1341","city_division_code":"70324","district_name":"صوفیان","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_942999802e87eed8a7fc52cc62475005cf03cb1d","city_name":"صومعه سرا","city_creation_date":"1319","city_division_code":"70150","district_name":"مرکزی","county_name":"صومعه سرا","province_name":"گیلان"},{"id":"city_15fada19f59d6d136547d9fb10fa8f9b70fd686c","city_name":"صیدون","city_creation_date":"1383","city_division_code":"70950","district_name":"صیدون","county_name":"باغ ملک","province_name":"خوزستان"},{"id":"city_edbd4c36955b39d18fb594decbb5ae00120a8576","city_name":"ضیاء آباد","city_creation_date":"1369","city_division_code":"70502","district_name":"ضیاء آباد","county_name":"تاکستان","province_name":"قزوین"},{"id":"city_6d3cff3722edf596ddb515646df41aefae884230","city_name":"طاقانک","city_creation_date":"1378","city_division_code":"70718","district_name":"مرکزی","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_c1540bfa1471737982cb8430871bbc652929691b","city_name":"طالخونچه","city_creation_date":"1374","city_division_code":"70606","district_name":"مرکزی","county_name":"مبارکه","province_name":"اصفهان"},{"id":"city_33f58d0bc08ab12a43c07322ec68c1255f4b579a","city_name":"طالقان","city_creation_date":"1372","city_division_code":"70576","district_name":"مرکزی","county_name":"طالقان","province_name":"البرز"},{"id":"city_4f13d9af2091a5e62b2efd11af9d346208fb61fb","city_name":"طبس","city_creation_date":"1310","city_division_code":"70092","district_name":"مرکزی","county_name":"طبس","province_name":"یزد"},{"id":"city_616d7a12832ca01f8064b087ea202dede0dff1c8","city_name":"طبس مسینا","city_creation_date":"1387","city_division_code":"71068","district_name":"گزیک","county_name":"درمیان","province_name":"خراسان جنوبی"},{"id":"city_4f4dd8ecc33b545d6f832c9fc52626b4c5853d4d","city_name":"طرقبه","city_creation_date":"1332","city_division_code":"70212","district_name":"طرقبه","county_name":"بینالود","province_name":"خراسان رضوی"},{"id":"city_70883eb5194136ed8caadad3e43f819f6b744bd3","city_name":"عباس آباد","city_creation_date":"1335","city_division_code":"70247","district_name":"مرکزی","county_name":"عباس آباد","province_name":"مازندران"},{"id":"city_2e26b1444e7dbeb3dee7e434cf8abf77e8553cfd","city_name":"عجب شیر","city_creation_date":"1316","city_division_code":"70128","district_name":"مرکزی","county_name":"عجب شیر","province_name":"آذربایجان شرقی"},{"id":"city_03b817ac4821894fe7b409ef7c79f18785bf8824","city_name":"عسگران","city_creation_date":"1379","city_division_code":"70768","district_name":"کرون","county_name":"تیران و کرون","province_name":"اصفهان"},{"id":"city_696423584adce85f02fa01c9130beb690502e64d","city_name":"عسلویه","city_creation_date":"1382","city_division_code":"70936","district_name":"عسلویه","county_name":"کنگان","province_name":"بوشهر"},{"id":"city_06c4da4d54e3d050aed58131d1f2cb9f6c55c529","city_name":"عشق آباد","city_creation_date":"1378","city_division_code":"70741","district_name":"دستگردان","county_name":"طبس","province_name":"یزد"},{"id":"city_3c748d1f08d74aec91165c9e7445c8f941e8d1b5","city_name":"عشق آباد","city_creation_date":"1379","city_division_code":"70783","district_name":"میان جلگه","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_6278bc856988f9a15fd1e67c84b1a502b618cf8c","city_name":"عقدا","city_creation_date":"1383","city_division_code":"70977","district_name":"عقدا","county_name":"اردکان","province_name":"یزد"},{"id":"city_f6b7fa6199a7e198a4142924f4aa77c0c0f6701d","city_name":"علامرودشت","city_creation_date":"1375","city_division_code":"70653","district_name":"علامرودشت","county_name":"لامرد","province_name":"فارس"},{"id":"city_7dd6339113c5260d1d6f06a3f8d03100ca5211e4","city_name":"علویچه","city_creation_date":"1344","city_division_code":"70388","district_name":"مهردشت","county_name":"نجف آباد","province_name":"اصفهان"},{"id":"city_f310e439b4fb051973d11790b96f55569b7fe13e","city_name":"علی آباد","city_creation_date":"1333","city_division_code":"70226","district_name":"مرکزی","county_name":"علی آباد","province_name":"گلستان"},{"id":"city_8d04fb64f2dc1ca44377255d812744097270e906","city_name":"علی اکبر","city_creation_date":"1386","city_division_code":"71046","district_name":"شیب آب","county_name":"زابل","province_name":"سیستان و بلوچستان"},{"id":"city_32127a7cac47985a57953939037cbef486bf02df","city_name":"عماد ده","city_creation_date":"1389","city_division_code":"71106","district_name":"صحرای باغ","county_name":"لارستان","province_name":"فارس"},{"id":"city_a16e1fdfc9bc4949935642c3dbf50b04b545e7f7","city_name":"عنبر آباد","city_creation_date":"1362","city_division_code":"70488","district_name":"مرکزی","county_name":"عنبر آباد","province_name":"کرمان"},{"id":"city_595d2c03dccd453917cd696724f00d4c2fc5053d","city_name":"عنبران","city_creation_date":"1381","city_division_code":"70907","district_name":"عنبران","county_name":"نمین","province_name":"اردبیل"},{"id":"city_3e79862bb083ee493a9748f65d9f56c2c131cb21","city_name":"غرق آباد","city_creation_date":"1362","city_division_code":"70489","district_name":"نوبران","county_name":"ساوه","province_name":"مرکزی"},{"id":"city_bd9f7b3b9f0db151d36f4b26db5f696892587152","city_name":"فارسان","city_creation_date":"1347","city_division_code":"70430","district_name":"مرکزی","county_name":"فارسان","province_name":"چهار محال و بختیاری"},{"id":"city_5c9256cd07e0f93795f4c9b6c75efb70d52d301d","city_name":"فارغان","city_creation_date":"1383","city_division_code":"70970","district_name":"فارغان","county_name":"حاجی آباد","province_name":"هرمزگان"},{"id":"city_fbfbc6d4af3e3463179fae3a2449181ce93dcb10","city_name":"فاروج","city_creation_date":"1330","city_division_code":"70189","district_name":"مرکزی","county_name":"فاروج","province_name":"خراسان شمالی"},{"id":"city_1f9c42aad454c8eebb386d9b647227dec8102ba2","city_name":"فاریاب","city_creation_date":"1379","city_division_code":"70820","district_name":"مرکزی","county_name":"فاریاب","province_name":"کرمان"},{"id":"city_2c24efb9bde902c4e7a4c98359976183d407155f","city_name":"فاضل آباد","city_creation_date":"1380","city_division_code":"70887","district_name":"کمالان","county_name":"علی آباد","province_name":"گلستان"},{"id":"city_ebe9fdb19e5fa5b986922899e50a4463212582b2","city_name":"فامنین","city_creation_date":"1369","city_division_code":"70505","district_name":"مرکزی","county_name":"فامنین","province_name":"همدان"},{"id":"city_87a39b9d9a301814c5cdc3ead0c6637e6cbe3e8f","city_name":"فخرآباد","city_creation_date":"1386","city_division_code":"71018","district_name":"مشگین شرقی","county_name":"مشگین شهر","province_name":"اردبیل"},{"id":"city_9a78380e1c2c1ddfdb01fb34668e20e55229ed39","city_name":"فدامی","city_creation_date":"1386","city_division_code":"71050","district_name":"فورگ","county_name":"داراب","province_name":"فارس"},{"id":"city_77c54eea0c18d1f0a00ed148bfd78603815900e9","city_name":"فرادنبه","city_creation_date":"1362","city_division_code":"70474","district_name":"مرکزی","county_name":"بروجن","province_name":"چهار محال و بختیاری"},{"id":"city_74ece9b757379aec81e02ca63f4f05a540befa03","city_name":"فراشبند","city_creation_date":"1361","city_division_code":"70470","district_name":"مرکزی","county_name":"فراشبند","province_name":"فارس"},{"id":"city_373b3560cbc500c67b226f64d955f3feabc95581","city_name":"فرخ شهر","city_creation_date":"1336","city_division_code":"70260","district_name":"مرکزی","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_4ee9bfb6d58766922fdcd726e8d47af06acffe4d","city_name":"فرخی","city_creation_date":"1388","city_division_code":"71104","district_name":"مرکزی","county_name":"خور و بیابانک","province_name":"اصفهان"},{"id":"city_e9bd395d9b3c26df127004dfd2078dbc4249b110","city_name":"فردوس","city_creation_date":"1304","city_division_code":"70018","district_name":"مرکزی","county_name":"فردوس","province_name":"خراسان جنوبی"},{"id":"city_c2779915b0ac203278ab4ad6691a78df0b014652","city_name":"فردوسیه","city_creation_date":"1379","city_division_code":"70871","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_d513b121ea4832b45245e5d2dd81b3d4a70cd2a3","city_name":"فرسفج","city_creation_date":"1379","city_division_code":"70854","district_name":"قلقل رود","county_name":"تویسرکان","province_name":"همدان"},{"id":"city_5f02bbcb645cc97b4a2d48eaabebf2dbeacfeed4","city_name":"فرمهین","city_creation_date":"1372","city_division_code":"70558","district_name":"مرکزی","county_name":"فراهان","province_name":"مرکزی"},{"id":"city_aaaa44cbd45cc583449068e5ad96448837d15681","city_name":"فرون آباد","city_creation_date":"1389","city_division_code":"71123","district_name":"مرکزی","county_name":"پاکدشت","province_name":"تهران"},{"id":"city_0a78d16a213994926981ee802047ed2f8a82ca9b","city_name":"فرهاد گرد","city_creation_date":"1382","city_division_code":"70932","district_name":"مرکزی","county_name":"فریمان","province_name":"خراسان رضوی"},{"id":"city_6120b04678f1ef2ba7a1158783eae473241b9013","city_name":"فریدونشهر","city_creation_date":"1334","city_division_code":"70233","district_name":"مرکزی","county_name":"فریدونشهر","province_name":"اصفهان"},{"id":"city_9adfe616a8a9f061446e57c04d702bb10c342500","city_name":"فریدونکنار","city_creation_date":"1316","city_division_code":"70136","district_name":"مرکزی","county_name":"فریدونکنار","province_name":"مازندران"},{"id":"city_e37ad77aba836cccaa81f2b24cabc89c14dc9c73","city_name":"فریم","city_creation_date":"1384","city_division_code":"70995","district_name":"دودانگه","county_name":"ساری","province_name":"مازندران"},{"id":"city_47c21998623862eb90e4b64637ec7101bdcad7e4","city_name":"فریمان","city_creation_date":"1316","city_division_code":"70130","district_name":"مرکزی","county_name":"فریمان","province_name":"خراسان رضوی"},{"id":"city_9006d5a7fe4c53222f9ee102d2ac70abd952d0dc","city_name":"فسا","city_creation_date":"1305","city_division_code":"70032","district_name":"مرکزی","county_name":"فسا","province_name":"فارس"},{"id":"city_728adff7c54a3b191780aa3718e9c5dd6004f11d","city_name":"فشم","city_creation_date":"1337","city_division_code":"70274","district_name":"رودبار قصران","county_name":"شمیرانات","province_name":"تهران"},{"id":"city_94adeb25c00bb9676481247d1c456f2549ed4ba0","city_name":"فلاورجان","city_creation_date":"1333","city_division_code":"70220","district_name":"مرکزی","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_8b811bf56f4ba2985f97adaf47629789c79dee95","city_name":"فنوج","city_creation_date":"1369","city_division_code":"70509","district_name":"فنوج","county_name":"نیک شهر","province_name":"سیستان و بلوچستان"},{"id":"city_95f69703253ae9bf2db628a5aa9d607a88d2d6af","city_name":"فولاد شهر","city_creation_date":"1372","city_division_code":"70544","district_name":"مرکزی","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_f89ceac452375951ec0370e121bb404e9e8e735a","city_name":"فومن","city_creation_date":"1307","city_division_code":"70054","district_name":"مرکزی","county_name":"فومن","province_name":"گیلان"},{"id":"city_2702bf2277fe3d2ff7c19da0489525528fdbb67f","city_name":"فهرج","city_creation_date":"1376","city_division_code":"70683","district_name":"مرکزی","county_name":"فهرج","province_name":"کرمان"},{"id":"city_a02e6f19c550693563d94d0af9f41681d7046676","city_name":"فیرورق","city_creation_date":"1346","city_division_code":"70419","district_name":"مرکزی","county_name":"خوی","province_name":"آذربایجان غربی"},{"id":"city_83ea51f746a6f059377a5cbcd22e0f12b15bc416","city_name":"فیروزآباد","city_creation_date":"1378","city_division_code":"70740","district_name":"فیروز آباد","county_name":"سلسله","province_name":"لرستان"},{"id":"city_2431dc4fdd2580820ccc82ee44cb20d4b82b79d8","city_name":"فیروزآباد","city_creation_date":"1323","city_division_code":"70155","district_name":"مرکزی","county_name":"فیروز آباد","province_name":"فارس"},{"id":"city_16edbb26230fdb620bc700cbfdb039988d63ae47","city_name":"فیروزان","city_creation_date":"1374","city_division_code":"70605","district_name":"خزل","county_name":"نهاوند","province_name":"همدان"},{"id":"city_2c7dd6854c5c82dc7f2fd87ead83f6cf59605a6e","city_name":"فیروزکوه","city_creation_date":"1302","city_division_code":"70012","district_name":"مرکزی","county_name":"فیروز کوه","province_name":"تهران"},{"id":"city_0ed320328fb2dbebf26ec4f01089dcf499d85be3","city_name":"فیروزه","city_creation_date":"1373","city_division_code":"70586","district_name":"مرکزی","county_name":"تخت جلگه","province_name":"خراسان رضوی"},{"id":"city_b55d568aa2b6095487afc170dee1d0a402af7228","city_name":"فیض آباد","city_creation_date":"1337","city_division_code":"70275","district_name":"مرکزی","county_name":"مه ولات","province_name":"خراسان رضوی"},{"id":"city_e7a94956b4b9f93cdcb3f12f7d38438721d8aa16","city_name":"فین","city_creation_date":"1376","city_division_code":"70701","district_name":"فین","county_name":"بندرعباس","province_name":"هرمزگان"},{"id":"city_312d1250d73baf67342aaa2f5f1e4ca0265cd3d5","city_name":"قادرآباد","city_creation_date":"1361","city_division_code":"70468","district_name":"مشهد مرغاب","county_name":"خرم بید","province_name":"فارس"},{"id":"city_4f54e623d5af2e4ec0a35268498d7f234c0373a6","city_name":"قاسم آباد","city_creation_date":"1379","city_division_code":"70779","district_name":"جلگه زوزن","county_name":"خواف","province_name":"خراسان رضوی"},{"id":"city_c876271ee4f0c24185d490eb5b36730b02a915f6","city_name":"قاضی","city_creation_date":"1381","city_division_code":"70913","district_name":"سملقان","county_name":"مانه و سملقان","province_name":"خراسان شمالی"},{"id":"city_3373d394ca0bdb2e1a7ce5590db55be5e14a5c62","city_name":"قائم شهر","city_creation_date":"1314","city_division_code":"70117","district_name":"مرکزی","county_name":"قائم شهر","province_name":"مازندران"},{"id":"city_3301bcd58fa586182c96ca2a124823f2cdc0eb98","city_name":"قائمیه","city_creation_date":"1370","city_division_code":"70531","district_name":"چنار شاهیجان","county_name":"کازرون","province_name":"فارس"},{"id":"city_ddc8597d6d2c6a3f94f22fbb19b12cec0a65afce","city_name":"قائن","city_creation_date":"1328","city_division_code":"70169","district_name":"مرکزی","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_f90976f34295c57ac1ebcbbe9e7f909ee428f915","city_name":"قدس","city_creation_date":"1368","city_division_code":"70497","district_name":"مرکزی","county_name":"قدس","province_name":"تهران"},{"id":"city_8d0c1b7c713a2480f996dc23c6730caceda0afbf","city_name":"قدمگاه","city_creation_date":"1375","city_division_code":"70620","district_name":"زبرخان","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_a0a6bf0f2b63aad42bc8bdb81c0d1d8043c24e1b","city_name":"قرچک","city_creation_date":"1355","city_division_code":"70446","district_name":"قرچک","county_name":"ورامین","province_name":"تهران"},{"id":"city_8643a25067faf8e54776944f25b1e5f6baa47bcb","city_name":"قروه","city_creation_date":"1330","city_division_code":"70190","district_name":"مرکزی","county_name":"قروه","province_name":"کردستان"},{"id":"city_88784182d25ac9b2467bcba01ff663859b6d5d70","city_name":"قروه در جزین","city_creation_date":"1361","city_division_code":"70466","district_name":"قروه در جزین","county_name":"رزن","province_name":"همدان"},{"id":"city_477e2b703cb34c42a22526cdd5c88e70a7f29bf4","city_name":"قره آغاج","city_creation_date":"1373","city_division_code":"70581","district_name":"مرکزی","county_name":"چاراویماق","province_name":"آذربایجان شرقی"},{"id":"city_9e62cc69ca2107233ccbaa379f97fba6ca23f206","city_name":"قره بلاغ","city_creation_date":"1390","city_division_code":"71148","district_name":"ششده و قره بلاغ","county_name":"فسا","province_name":"فارس"},{"id":"city_ef621c69f325903021f252350096ee865b991415","city_name":"قره ضیاء الدین","city_creation_date":"1339","city_division_code":"70296","district_name":"مرکزی","county_name":"چایپاره","province_name":"آذربایجان غربی"},{"id":"city_ed2e66aae2825e3d9e27432e9130a67fec0ba9f5","city_name":"قزوین","city_creation_date":"1303","city_division_code":"70015","district_name":"مرکزی","county_name":"قزوین","province_name":"قزوین"},{"id":"city_ea32d3f66ccdeccf340752882cae15d9704aa651","city_name":"قشم","city_creation_date":"1340","city_division_code":"70322","district_name":"مرکزی","county_name":"قشم","province_name":"هرمزگان"},{"id":"city_4768b8f9526ced3308e0590c61fd45594b9dd7d7","city_name":"قصر شیرین","city_creation_date":"1310","city_division_code":"70085","district_name":"مرکزی","county_name":"قصر شیرین","province_name":"کرمانشاه"},{"id":"city_2cba9079c8a1473f196e3d387f5646cdb3d5b256","city_name":"قصر قند","city_creation_date":"1344","city_division_code":"70395","district_name":"قصر قند","county_name":"نیک شهر","province_name":"سیستان و بلوچستان"},{"id":"city_bef35b49bb24965be8af0a771457a508523f2754","city_name":"قطب آباد","city_creation_date":"1372","city_division_code":"70561","district_name":"کردیان","county_name":"جهرم","province_name":"فارس"},{"id":"city_7381d028497bbd63494741af691e26931a5176b1","city_name":"قطرویه","city_creation_date":"1388","city_division_code":"71089","district_name":"قطرویه","county_name":"نی ریز","province_name":"فارس"},{"id":"city_1f79e55c0c19c1116603b0207979781b6ee9b6c6","city_name":"قطور","city_creation_date":"1386","city_division_code":"71034","district_name":"قطور","county_name":"خوی","province_name":"آذربایجان غربی"},{"id":"city_abcfc8d6d93612da376753c838a3c39f665eb0af","city_name":"قلعه تل","city_creation_date":"1381","city_division_code":"70892","district_name":"مرکزی","county_name":"باغ ملک","province_name":"خوزستان"},{"id":"city_8c8e044a6124a41a807c2ca336aa751906d30e4f","city_name":"قلعه خواجه","city_creation_date":"1381","city_division_code":"70923","district_name":"مرکزی","county_name":"اندیکا","province_name":"خوزستان"},{"id":"city_dcbc2cbbfa47aded8c8e45e01495aff3eeefff09","city_name":"قلعه رئیسی","city_creation_date":"1379","city_division_code":"70829","district_name":"چاروسا","county_name":"کهگیلویه","province_name":"کهگیلویه و بویراحمد"},{"id":"city_b6eb3cbc677fd987ff78662d9cb6ef7df833dec4","city_name":"قلعه قاضی","city_creation_date":"1388","city_division_code":"71084","district_name":"قلعه قاضی","county_name":"بندرعباس","province_name":"هرمزگان"},{"id":"city_99860eb2dbda7334110af564d263f2404386ca64","city_name":"قلعه گنج","city_creation_date":"1372","city_division_code":"70579","district_name":"مرکزی","county_name":"قلعه گنج","province_name":"کرمان"},{"id":"city_cbff1d755813a90fae5136870a75f0363ecc26af","city_name":"قلندر آباد","city_creation_date":"1379","city_division_code":"70780","district_name":"قلندر آباد","county_name":"فریمان","province_name":"خراسان رضوی"},{"id":"city_6d43009e8fe02019c535203ca72d3910899d3d0d","city_name":"قم","city_creation_date":"1305","city_division_code":"70033","district_name":"مرکزی","county_name":"قم","province_name":"قم"},{"id":"city_cce3a208589b651341399cc31f679146cddc6c59","city_name":"قمصر","city_creation_date":"1336","city_division_code":"70257","district_name":"قمصر","county_name":"کاشان","province_name":"اصفهان"},{"id":"city_526bfbd7f5f68cb3e474d01f9255162d5690a284","city_name":"قنوات","city_creation_date":"1379","city_division_code":"70876","district_name":"مرکزی","county_name":"قم","province_name":"قم"},{"id":"city_02d7ee1c6ebb33aa8136c58298f73b08e99d7e30","city_name":"قوچان","city_creation_date":"1304","city_division_code":"70019","district_name":"مرکزی","county_name":"قوچان","province_name":"خراسان رضوی"},{"id":"city_668c8ca8b507c19a4342594c4bbe08b3503d47d2","city_name":"قورچی باشی","city_creation_date":"1381","city_division_code":"70928","district_name":"کمره","county_name":"خمین","province_name":"مرکزی"},{"id":"city_b7900e2d2dd5c39829ff38572088dbb7a88a4b67","city_name":"قوشچی","city_creation_date":"1369","city_division_code":"70515","district_name":"انزل","county_name":"ارومیه","province_name":"آذربایجان غربی"},{"id":"city_ade7e3c877e93bbebd9b056b055f4c69f4e625ce","city_name":"قهاوند","city_creation_date":"1376","city_division_code":"70695","district_name":"شراء","county_name":"همدان","province_name":"همدان"},{"id":"city_3a9e10f400ace192501ee75077838771a3cf0662","city_name":"قهجاورستان","city_creation_date":"1386","city_division_code":"71028","district_name":"مرکزی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_38d4c1ad56a22be127f10ecb046140a8bb828090","city_name":"قهدریجان","city_creation_date":"1347","city_division_code":"70428","district_name":"مرکزی","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_c4b60468b37990d035f122b17ba9433b23c852f5","city_name":"قهستان","city_creation_date":"1387","city_division_code":"71067","district_name":"قهستان","county_name":"درمیان","province_name":"خراسان جنوبی"},{"id":"city_0145f470f60d310cb56f13a88f1a29250a739f03","city_name":"قیدار","city_creation_date":"1342","city_division_code":"70353","district_name":"مرکزی","county_name":"خدابنده","province_name":"زنجان"},{"id":"city_c6c3a0549d34e506171d82a12c4bc6704b348827","city_name":"قیر","city_creation_date":"1337","city_division_code":"70278","district_name":"مرکزی","county_name":"قیروکارزین","province_name":"فارس"},{"id":"city_09e41d955961e67646d65f34553aa14346d35e31","city_name":"کوشکنار","city_creation_date":"1386","city_division_code":"71058","district_name":"کوشکنار","county_name":"پارسیان","province_name":"هرمزگان"},{"id":"city_5a50f36aa30e754458eb4880ed40a9d04364d74e","city_name":"کاخک","city_creation_date":"1328","city_division_code":"70171","district_name":"کاخک","county_name":"گناباد","province_name":"خراسان رضوی"},{"id":"city_67da432e4148082e6a11dca389da9f2de3083772","city_name":"کارچان","city_creation_date":"1388","city_division_code":"71142","district_name":"معصومیه","county_name":"اراک","province_name":"مرکزی"},{"id":"city_9bf81f075bb2098610da0e32ac38042cefef8cd1","city_name":"کارزین","city_creation_date":"1379","city_division_code":"70874","district_name":"مرکزی","county_name":"قیروکارزین","province_name":"فارس"},{"id":"city_39367cc7cc8f28e97fc9e46f4b99829ea6a509cf","city_name":"کاریز","city_creation_date":"1382","city_division_code":"70930","district_name":"مرکزی","county_name":"تایباد","province_name":"خراسان رضوی"},{"id":"city_a93740cd6dab90463300cedb8a7108ecf43815eb","city_name":"کازرون","city_creation_date":"1310","city_division_code":"70083","district_name":"مرکزی","county_name":"کازرون","province_name":"فارس"},{"id":"city_86c0280c07882b90dd0e50e16bddae23aa517e13","city_name":"کاشان","city_creation_date":"1309","city_division_code":"70068","district_name":"مرکزی","county_name":"کاشان","province_name":"اصفهان"},{"id":"city_f592a5629762b91ec76f049288d60eff874b86a5","city_name":"کاشمر","city_creation_date":"1308","city_division_code":"70061","district_name":"مرکزی","county_name":"کاشمر","province_name":"خراسان رضوی"},{"id":"city_da236f72734de94bcc94219af3bbbfdaceceffe5","city_name":"کاظم آباد","city_creation_date":"1375","city_division_code":"70668","district_name":"چترود","county_name":"کرمان","province_name":"کرمان"},{"id":"city_b00463015ccb91ff659c93babe6b58c04fb2be4f","city_name":"کاکی","city_creation_date":"1369","city_division_code":"70526","district_name":"کاکی","county_name":"دشتی","province_name":"بوشهر"},{"id":"city_4862cfc4aa7c2cc23426d467dd3add45a0ff2a6d","city_name":"کامفیروز","city_creation_date":"1381","city_division_code":"70925","district_name":"کامفیروز","county_name":"مرودشت","province_name":"فارس"},{"id":"city_06b744b9732f9de6aded1a68edf1c6e02fd26042","city_name":"کامیاران","city_creation_date":"1344","city_division_code":"70399","district_name":"مرکزی","county_name":"کامیاران","province_name":"کردستان"},{"id":"city_3ef61f8a90b753a21e3fa647089e937ed72e8a69","city_name":"کانی دینار","city_creation_date":"1388","city_division_code":"71090","district_name":"مرکزی","county_name":"مریوان","province_name":"کردستان"},{"id":"city_0c8ca0ab524d69aaf2937a8e1e20f26cfb61e25d","city_name":"کانی سور","city_creation_date":"1379","city_division_code":"70809","district_name":"نمشیر","county_name":"بانه","province_name":"کردستان"},{"id":"city_f1e857f0c459ee7fa91c950d350d601b64e7e948","city_name":"کبودر آهنگ","city_creation_date":"1337","city_division_code":"70285","district_name":"مرکزی","county_name":"کبودرآهنگ","province_name":"همدان"},{"id":"city_eb0b653ef693af76699fbf5923e06b696a19910e","city_name":"کتالم و سادات شهر","city_creation_date":"1340","city_division_code":"70321","district_name":"مرکزی","county_name":"رامسر","province_name":"مازندران"},{"id":"city_e69204a1a0887fcf7d9c0a98a08c7a6b3b385348","city_name":"کدکن","city_creation_date":"1375","city_division_code":"70638","district_name":"کدکن","county_name":"تربت حیدریه","province_name":"خراسان رضوی"},{"id":"city_c475dce406d9d6a20474f62c64405f08a42fb699","city_name":"کرج","city_creation_date":"1313","city_division_code":"70102","district_name":"مرکزی","county_name":"کرج","province_name":"البرز"},{"id":"city_43f261b1622c3d2f1fbf847e1bbb40a2a57c3397","city_name":"کرد کوی","city_creation_date":"1339","city_division_code":"70307","district_name":"مرکزی","county_name":"کردکوی","province_name":"گلستان"},{"id":"city_8410440b90a2ad7849337274f4abbe3c35c28c04","city_name":"کرکوند","city_creation_date":"1379","city_division_code":"70865","district_name":"مرکزی","county_name":"مبارکه","province_name":"اصفهان"},{"id":"city_efb1d4a254a6566d8bf38220a5afc2ad17b33678","city_name":"کرمان","city_creation_date":"1300","city_division_code":"70008","district_name":"مرکزی","county_name":"کرمان","province_name":"کرمان"},{"id":"city_9031acdd5ccd55c43ea77f0ac806eff9748eee03","city_name":"کرمانشاه","city_creation_date":"1309","city_division_code":"70075","district_name":"مرکزی","county_name":"کرمانشاه","province_name":"کرمانشاه"},{"id":"city_a365b6b13557f8e31b96aca87ae9b4e5fdef78d1","city_name":"کرند غرب","city_creation_date":"1309","city_division_code":"70072","district_name":"مرکزی","county_name":"دالاهو","province_name":"کرمانشاه"},{"id":"city_fded1f7102889f76a247fca490188a95497300c5","city_name":"کره ای","city_creation_date":"1381","city_division_code":"70915","district_name":"سرچهان","county_name":"بوانات","province_name":"فارس"},{"id":"city_6ef508c449fa1c134bfd32937e460f81b93320b1","city_name":"کرهرود","city_creation_date":"1381","city_division_code":"70920","district_name":"مرکزی","county_name":"اراک","province_name":"مرکزی"},{"id":"city_f6d1e89d3ac19bb3a43dd39f57f2e47b343a2e37","city_name":"کشاورز","city_creation_date":"1379","city_division_code":"70754","district_name":"کشاورز","county_name":"شاهین دژ","province_name":"آذربایجان غربی"},{"id":"city_c95c8468973a368f45d232fae60a0651332a9a52","city_name":"کشکسرای","city_creation_date":"1337","city_division_code":"70268","district_name":"مرکزی","county_name":"مرند","province_name":"آذربایجان شرقی"},{"id":"city_ca323d597ede2aec18aee63909a4acb6e96c6472","city_name":"کشکوئیه","city_creation_date":"1376","city_division_code":"70697","district_name":"کشکوئیه","county_name":"رفسنجان","province_name":"کرمان"},{"id":"city_76e655a2fcc3c6194206f84e3831f1d1fba3221c","city_name":"کلات","city_creation_date":"1330","city_division_code":"70188","district_name":"مرکزی","county_name":"کلات","province_name":"خراسان رضوی"},{"id":"city_1dc02da7b09d73bd7a0926f3279e976c20724aef","city_name":"کلاته","city_creation_date":"1390","city_division_code":"71143","district_name":"مرکزی","county_name":"دامغان","province_name":"سمنان"},{"id":"city_868d5a7a8d3f534c679211be2c433004c4fe7bda","city_name":"کلاته خیج","city_creation_date":"1372","city_division_code":"70555","district_name":"بسطام","county_name":"شاهرود","province_name":"سمنان"},{"id":"city_156cfccf80a181d00f130a8c4e64232029705a93","city_name":"کلاچای","city_creation_date":"1333","city_division_code":"70228","district_name":"کلاچای","county_name":"رودسر","province_name":"گیلان"},{"id":"city_73cae04a9ab703952f092caf89615519cb7391fd","city_name":"کلارآباد","city_creation_date":"1354","city_division_code":"70443","district_name":"کلارآباد","county_name":"عباس آباد","province_name":"مازندران"},{"id":"city_cd9c76c3249aeb96e5a3af653279c0c1003204a0","city_name":"کلاردشت","city_creation_date":"1336","city_division_code":"70267","district_name":"کلاردشت","county_name":"چالوس","province_name":"مازندران"},{"id":"city_a5b3ebf5ff18820259787a2dacb5968968d70d9e","city_name":"کلاله","city_creation_date":"1333","city_division_code":"70227","district_name":"مرکزی","county_name":"کلاله","province_name":"گلستان"},{"id":"city_2e643b16f887ff7e8d658648fda337f386b2935c","city_name":"کلمه","city_creation_date":"1383","city_division_code":"70954","district_name":"بوشکان","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_609d56fcc4702fdcc35ac872af6318025f6830a1","city_name":"کلوانق","city_creation_date":"1377","city_division_code":"70709","district_name":"مرکزی","county_name":"هریس","province_name":"آذربایجان شرقی"},{"id":"city_fdae5a2d6403c804d69ba7c9a94f435b1a76d061","city_name":"کلور","city_creation_date":"1372","city_division_code":"70553","district_name":"شاهرود","county_name":"خلخال","province_name":"اردبیل"},{"id":"city_bf24d8066a8290abd0fa23b28ba84611d3e15efd","city_name":"کله بست","city_creation_date":"1379","city_division_code":"70847","district_name":"رودبست","county_name":"بابلسر","province_name":"مازندران"},{"id":"city_ff665e7c424411e307d7dfd7a6780796a036780a","city_name":"کلیبر","city_creation_date":"1342","city_division_code":"70345","district_name":"مرکزی","county_name":"کلیبر","province_name":"آذربایجان شرقی"},{"id":"city_43a4cf38a02370926f02a3dd8d943d92dcd668e3","city_name":"کلیشاد و سودرجان","city_creation_date":"1337","city_division_code":"70270","district_name":"مرکزی","county_name":"فلاورجان","province_name":"اصفهان"},{"id":"city_5bd57341d653adedbf85408a314033cd5cfcf961","city_name":"کمال شهر","city_creation_date":"1375","city_division_code":"70612","district_name":"مرکزی","county_name":"کرج","province_name":"البرز"},{"id":"city_1ed3485c36390db2168adf7c5e1a2f2b416c1820","city_name":"کمشجه","city_creation_date":"1381","city_division_code":"70908","district_name":"حبیب آباد","county_name":"برخوار","province_name":"اصفهان"},{"id":"city_a065045dedfd83d0f13fa399a2b6bfcfe609dba9","city_name":"کمه","city_creation_date":"1379","city_division_code":"70769","district_name":"پادنا","county_name":"سمیرم","province_name":"اصفهان"},{"id":"city_4983103df1789095bca5082a3b1b3e36c0703278","city_name":"کمیجان","city_creation_date":"1362","city_division_code":"70490","district_name":"مرکزی","county_name":"کمیجان","province_name":"مرکزی"},{"id":"city_395294226d6a8496631fecd19184bd3f9e0cd77d","city_name":"کنار تخته","city_creation_date":"1369","city_division_code":"70503","district_name":"کنار تخته و کمارج","county_name":"کازرون","province_name":"فارس"},{"id":"city_d8c5410a59f7c9929ec5e424cfc19ee1ee20f404","city_name":"کنارک","city_creation_date":"1341","city_division_code":"70332","district_name":"مرکزی","county_name":"کنارک","province_name":"سیستان و بلوچستان"},{"id":"city_3d12306690e903287ae618649dbc194e87dae103","city_name":"کندر","city_creation_date":"1384","city_division_code":"71015","district_name":"ششطراز","county_name":"خلیل آباد","province_name":"خراسان رضوی"},{"id":"city_b9d0cd08eb1b1681571f00e22575881a01f6d0e7","city_name":"کنگ","city_creation_date":"1345","city_division_code":"70416","district_name":"مرکزی","county_name":"بندرلنگه","province_name":"هرمزگان"},{"id":"city_1a56af917d77070fef5316198fc7e824affee98f","city_name":"کنگاور","city_creation_date":"1335","city_division_code":"70244","district_name":"مرکزی","county_name":"کنگاور","province_name":"کرمانشاه"},{"id":"city_99c02e8e3eafc85b73eedc19f7ed1470cf78d7c6","city_name":"کوار","city_creation_date":"1345","city_division_code":"70414","district_name":"مرکزی","county_name":"کوار","province_name":"فارس"},{"id":"city_3b7e1ecb9439df27d0ab35b5d6de49bccf9f09d6","city_name":"کوچصفهان","city_creation_date":"1308","city_division_code":"70063","district_name":"کوچصفهان","county_name":"رشت","province_name":"گیلان"},{"id":"city_6039a8bc893fb6b8d64b9c298f2567dee17fdc5c","city_name":"کورائیم","city_creation_date":"1383","city_division_code":"70961","district_name":"کورائیم","county_name":"نیر","province_name":"اردبیل"},{"id":"city_81283065271909212e6eeff7e411c0316a8c0174","city_name":"کوزران","city_creation_date":"1379","city_division_code":"70825","district_name":"کوزران","county_name":"کرمانشاه","province_name":"کرمانشاه"},{"id":"city_3f3f71bdfe3d44a51270f271c2c8a6b107aadf3e","city_name":"کوزه کنان","city_creation_date":"1381","city_division_code":"70921","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_1e176047798122919cf367bff11ded1e46df5a1a","city_name":"کوشک","city_creation_date":"1372","city_division_code":"70562","district_name":"مرکزی","county_name":"خمینی شهر","province_name":"اصفهان"},{"id":"city_4c67e1eef9ad69fa83a0ee87c875cf75bc123cf0","city_name":"کومله","city_creation_date":"1341","city_division_code":"70339","district_name":"کومله","county_name":"لنگرود","province_name":"گیلان"},{"id":"city_fc7b79647cd94214d5a75a0856f322cff7418617","city_name":"کونانی","city_creation_date":"1377","city_division_code":"70715","district_name":"کونانی","county_name":"کوهدشت","province_name":"لرستان"},{"id":"city_4ca27b2255f6d948c854414797631f30a0edc699","city_name":"کوهبنان","city_creation_date":"1342","city_division_code":"70360","district_name":"مرکزی","county_name":"کوهبنان","province_name":"کرمان"},{"id":"city_77d8fc4c7bcc1ac0ce45fcfb03bc105d6ce6f3a4","city_name":"کوهپایه","city_creation_date":"1342","city_division_code":"70347","district_name":"کوهپایه","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_d5f4185f5e667ac820cd17ececdcdd18b5c5e4e8","city_name":"کوهدشت","city_creation_date":"1334","city_division_code":"70237","district_name":"مرکزی","county_name":"کوهدشت","province_name":"لرستان"},{"id":"city_d1b87c96dc5de2bca445322d6f2f3debbf7cdede","city_name":"کوهسار","city_creation_date":"1383","city_division_code":"70941","district_name":"چندار","county_name":"ساوجبلاغ","province_name":"البرز"},{"id":"city_44ab7da5a4c03a51b5cb37ff1738948e5c0b4746","city_name":"کوهنجان","city_creation_date":"1389","city_division_code":"71107","district_name":"کوهنجان","county_name":"سروستان","province_name":"فارس"},{"id":"city_2a86a5422042997de0ee6f20adb6de86356e94cf","city_name":"کوهی خیل","city_creation_date":"1379","city_division_code":"70848","district_name":"گیل خوران","county_name":"جویبار","province_name":"مازندران"},{"id":"city_a403b3e0759b5e7325bb9ad3dbfc59b3e2ddcf85","city_name":"کوهین","city_creation_date":"1381","city_division_code":"70900","district_name":"کوهین","county_name":"قزوین","province_name":"قزوین"},{"id":"city_601b22f15c550b062cb65c6169ba42c6739ffd5a","city_name":"کهریزسنگ","city_creation_date":"1381","city_division_code":"70911","district_name":"مرکزی","county_name":"نجف آباد","province_name":"اصفهان"},{"id":"city_64acc69158b67a9f6cbeeb52e3cbabb538da9814","city_name":"کهریزک","city_creation_date":"1379","city_division_code":"70773","district_name":"کهریزک","county_name":"ری","province_name":"تهران"},{"id":"city_3f79eed232549bf6a2d6670370b5598aac15ba3b","city_name":"کهک","city_creation_date":"1375","city_division_code":"70652","district_name":"نوفل لوشاتو","county_name":"قم","province_name":"قم"},{"id":"city_4fd1dafcdd8280c9c3361260c5670f179b8c4e44","city_name":"کهنوج","city_creation_date":"1354","city_division_code":"70442","district_name":"مرکزی","county_name":"کهنوج","province_name":"کرمان"},{"id":"city_cec9445dd2aad1865291561b04b3a78a55fc6958","city_name":"کیاسر","city_creation_date":"1372","city_division_code":"70567","district_name":"چهاردانگه","county_name":"ساری","province_name":"مازندران"},{"id":"city_fd2f070560d3426e5b49053e1b84f8f8dd9233a3","city_name":"کیاشهر","city_creation_date":"1309","city_division_code":"70076","district_name":"کیاشهر","county_name":"آستانه اشرفیه","province_name":"گیلان"},{"id":"city_46f0ccad3e74a400810a2dd22cb77fd5f2fb9d20","city_name":"کیاکلا","city_creation_date":"1339","city_division_code":"70308","district_name":"کیاکلا","county_name":"قائم شهر","province_name":"مازندران"},{"id":"city_57d7ac3546e669949c6b29d3ed5afde19b3aca2d","city_name":"کیان","city_creation_date":"1370","city_division_code":"70541","district_name":"مرکزی","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_635ca0e118230248604c24b69eaab84ab89c472d","city_name":"کیانشهر","city_creation_date":"1369","city_division_code":"70501","district_name":"طغرالجرد","county_name":"کوهبنان","province_name":"کرمان"},{"id":"city_494eaa85a0826925c669b1019ff530024c3a71b7","city_name":"کیش","city_creation_date":"1372","city_division_code":"70571","district_name":"کیش","county_name":"بندرلنگه","province_name":"هرمزگان"},{"id":"city_e1e5ba8acc582ec44e672e8bae04d6b9eafbc902","city_name":"کیلان","city_creation_date":"1332","city_division_code":"70209","district_name":"مرکزی","county_name":"دماوند","province_name":"تهران"},{"id":"city_3928621eedb9d81720d572f3fa84d3a2fb343c84","city_name":"گالیکش","city_creation_date":"1362","city_division_code":"70479","district_name":"مرکزی","county_name":"گالیکش","province_name":"گلستان"},{"id":"city_d59fb1fa13f6556bbc4371d12028881981d54edd","city_name":"گتاب","city_creation_date":"1384","city_division_code":"70994","district_name":"گتاب","county_name":"بابل","province_name":"مازندران"},{"id":"city_6eb67eb6d481ae0114d1e391680af499d037f34d","city_name":"گتوند","city_creation_date":"1362","city_division_code":"70485","district_name":"مرکزی","county_name":"گتوند","province_name":"خوزستان"},{"id":"city_aaf449eee08aeffeb3353460697a560b37d89c58","city_name":"گراب","city_creation_date":"1375","city_division_code":"70656","district_name":"طرهان","county_name":"کوهدشت","province_name":"لرستان"},{"id":"city_532519f474bd39db463278b0d7731dacb3bdd027","city_name":"گراب سفلی","city_creation_date":"1379","city_division_code":"70827","district_name":"لوداب","county_name":"بویر احمد","province_name":"کهگیلویه و بویراحمد"},{"id":"city_d91d85baa6009b7c8ba71777e07f33872bba940e","city_name":"گراش","city_creation_date":"1344","city_division_code":"70398","district_name":"مرکزی","county_name":"گراش","province_name":"فارس"},{"id":"city_5d17517f22b6f899695a1d443f836ef6f3900b12","city_name":"گردکشانه","city_creation_date":"1382","city_division_code":"70929","district_name":"لاجان","county_name":"پیرانشهر","province_name":"آذربایجان غربی"},{"id":"city_6422951e79101f7513c4b33f398acb60ecab47a8","city_name":"گرگاب","city_creation_date":"1386","city_division_code":"71020","district_name":"مرکزی","county_name":"شاهین شهر و میمه","province_name":"اصفهان"},{"id":"city_640581c40cee6fd9021d0f31c7c27de39cdf85b0","city_name":"گرگان","city_creation_date":"1304","city_division_code":"70026","district_name":"مرکزی","county_name":"گرگان","province_name":"گلستان"},{"id":"city_0f083ece1f1a50b3b038d3849d246ba697e936d7","city_name":"گرماب","city_creation_date":"1375","city_division_code":"70621","district_name":"افشار","county_name":"خدابنده","province_name":"زنجان"},{"id":"city_af8d97b76cb0c027b7fc0bf61f9bc049ea67ccfc","city_name":"گرمدره","city_creation_date":"1383","city_division_code":"70963","district_name":"مرکزی","county_name":"کرج","province_name":"البرز"},{"id":"city_8c16a091b1b26fcf98f26f28f927b3e68dde6f54","city_name":"گرمسار","city_creation_date":"1316","city_division_code":"70134","district_name":"مرکزی","county_name":"گرمسار","province_name":"سمنان"},{"id":"city_012be58a6d40990284e6c2633970a4926d68cc94","city_name":"گرمه","city_creation_date":"1377","city_division_code":"71069","district_name":"مرکزی","county_name":"گرمه","province_name":"خراسان شمالی"},{"id":"city_a98a4cd1ca8539d41b31f13fe674ad116bd367c0","city_name":"گرمی","city_creation_date":"1328","city_division_code":"70168","district_name":"مرکزی","county_name":"گرمی","province_name":"اردبیل"},{"id":"city_db98e2809556df56fb8b6432b783af3834c9f43d","city_name":"گروک","city_creation_date":"1389","city_division_code":"71144","district_name":"مرکزی","county_name":"سیریک","province_name":"هرمزگان"},{"id":"city_12919045f4cf7849c3ae25aa32c2c13db0f9536e","city_name":"گز برخوار","city_creation_date":"1343","city_division_code":"70370","district_name":"مرکزی","county_name":"شاهین شهر و میمه","province_name":"اصفهان"},{"id":"city_e026ac7197f4e88d697fea480fdc63b376c1f352","city_name":"گزنک","city_creation_date":"1379","city_division_code":"70841","district_name":"لاریجان","county_name":"آمل","province_name":"مازندران"},{"id":"city_2bf973aa933b41647ea416d6483c94733a4d6868","city_name":"گزیک","city_creation_date":"1389","city_division_code":"71117","district_name":"گزیک","county_name":"درمیان","province_name":"خراسان جنوبی"},{"id":"city_803b79f6a34c06565546592a032a579cc87218c5","city_name":"گشت","city_creation_date":"1386","city_division_code":"71047","district_name":"مرکزی","county_name":"سراوان","province_name":"سیستان و بلوچستان"},{"id":"city_158c0b940661145ca8acbc2a3a1f40381f844001","city_name":"گل تپه","city_creation_date":"1379","city_division_code":"70856","district_name":"گل تپه","county_name":"کبودرآهنگ","province_name":"همدان"},{"id":"city_f72a620e4e0ffb86c5d87b372080eaaaab81a590","city_name":"گلباف","city_creation_date":"1339","city_division_code":"70303","district_name":"گلباف","county_name":"کرمان","province_name":"کرمان"},{"id":"city_c2e08f6ef67457b3e33cd3514c42eee96abd603f","city_name":"گلپایگان","city_creation_date":"1306","city_division_code":"70036","district_name":"مرکزی","county_name":"گلپایگان","province_name":"اصفهان"},{"id":"city_159f18117db14c3eed83117e7b33cbeacd2ee761","city_name":"گلدشت","city_creation_date":"1370","city_division_code":"70540","district_name":"مرکزی","county_name":"نجف آباد","province_name":"اصفهان"},{"id":"city_e7407721ebe414f5c7495659eb565c7b61e90996","city_name":"گلزار","city_creation_date":"1375","city_division_code":"70660","district_name":"مرکزی","county_name":"بردسیر","province_name":"کرمان"},{"id":"city_6f3ed2e55367a0846ac880d4afd17f4fbf9df793","city_name":"گلسار","city_creation_date":"1386","city_division_code":"71037","district_name":"مرکزی","county_name":"ساوجبلاغ","province_name":"البرز"},{"id":"city_d6a25903d21bf31483a1e91b94fbe2223753b624","city_name":"گلستان","city_creation_date":"1375","city_division_code":"70663","district_name":"گلستان","county_name":"رباط کریم","province_name":"تهران"},{"id":"city_3f79fbb35ba79351fe17ce09c6df23e40fc0a90a","city_name":"گلشن","city_creation_date":"1389","city_division_code":"71127","district_name":"مرکزی","county_name":"دهاقان","province_name":"اصفهان"},{"id":"city_bf38c5c86a6b5c587ab66d1a506e9ff92e07760c","city_name":"گلشهر","city_creation_date":"1380","city_division_code":"70881","district_name":"مرکزی","county_name":"گلپایگان","province_name":"اصفهان"},{"id":"city_0772d65ebaa8f8a103d77f6781304b0a86c703fa","city_name":"گلمکان","city_creation_date":"1386","city_division_code":"71040","district_name":"گلبهار","county_name":"چناران","province_name":"خراسان رضوی"},{"id":"city_97aec924f7d3be57f49fe7a7667423831cb9fad9","city_name":"گلمورتی","city_creation_date":"1379","city_division_code":"70797","district_name":"مرکزی","county_name":"دلگان","province_name":"سیستان و بلوچستان"},{"id":"city_271616ab5e723b320010329fd26d88de0bcf9236","city_name":"گلوگاه","city_creation_date":"1379","city_division_code":"70843","district_name":"بند پی شرقی","county_name":"بابل","province_name":"مازندران"},{"id":"city_30e2925fc62647ebf39d569818269ede7f7b76bc","city_name":"گلوگاه","city_creation_date":"1335","city_division_code":"70251","district_name":"مرکزی","county_name":"گلوگاه","province_name":"مازندران"},{"id":"city_10db7a8109ad383f5b985e493e97ca446b0e0ebc","city_name":"گله دار","city_creation_date":"1379","city_division_code":"70867","district_name":"گله دار","county_name":"مهر","province_name":"فارس"},{"id":"city_4ca6edbc9d1c6f732aff619d1f9fc9ec4c74dfeb","city_name":"گمیش تپه","city_creation_date":"1310","city_division_code":"70087","district_name":"مرکزی","county_name":"گمیشان","province_name":"گلستان"},{"id":"city_cd593edafc0c354d7d432b63ed81f653a24584af","city_name":"گناباد","city_creation_date":"1316","city_division_code":"70131","district_name":"مرکزی","county_name":"گناباد","province_name":"خراسان رضوی"},{"id":"city_6a6c7443a325cb15dc492c15bf8a643067e0a877","city_name":"گنبدکاووس","city_creation_date":"1313","city_division_code":"70104","district_name":"مرکزی","county_name":"گنبد کاووس","province_name":"گلستان"},{"id":"city_1364842b72f890db8f3df327f4ddaac45ac0c92b","city_name":"گندمان","city_creation_date":"1369","city_division_code":"70517","district_name":"گندمان","county_name":"بروجن","province_name":"چهار محال و بختیاری"},{"id":"city_09ee66124b61787dafc1ee288ef04f668d6a3b3c","city_name":"گوراب زرمیخ","city_creation_date":"1378","city_division_code":"70751","district_name":"میرزا کوچک جنگلی","county_name":"صومعه سرا","province_name":"گیلان"},{"id":"city_55723e2749129ba7be1aa21320df91def73af73b","city_name":"گوریه","city_creation_date":"1389","city_division_code":"71118","district_name":"شعیبیه","county_name":"شوشتر","province_name":"خوزستان"},{"id":"city_8ddb9bda40d2bc01b2acb995bdf63766a882e716","city_name":"گوگان","city_creation_date":"1336","city_division_code":"70252","district_name":"گوگان","county_name":"آذرشهر","province_name":"آذربایجان شرقی"},{"id":"city_a8b3292e550698b76ccebce3b3a9e07ec1b97c72","city_name":"گوگد","city_creation_date":"1343","city_division_code":"70371","district_name":"مرکزی","county_name":"گلپایگان","province_name":"اصفهان"},{"id":"city_54442a4adf11bf7ae363a54517501793cb1b65c1","city_name":"گوهران","city_creation_date":"1387","city_division_code":"71071","district_name":"گوهران","county_name":"بشاگرد","province_name":"هرمزگان"},{"id":"city_93b786359383b78c0bc71205683dc95199787db2","city_name":"گهرو","city_creation_date":"1378","city_division_code":"70721","district_name":"مرکزی","county_name":"کیار","province_name":"چهار محال و بختیاری"},{"id":"city_cea0c78f0749d9fcf2cfc4c52403472e4e947d72","city_name":"گهواره","city_creation_date":"1379","city_division_code":"70822","district_name":"گهواره","county_name":"دالاهو","province_name":"کرمانشاه"},{"id":"city_0a37e85b191b0c2ce89f212f20403b4a8dff3c62","city_name":"گیان","city_creation_date":"1384","city_division_code":"71012","district_name":"گیان","county_name":"نهاوند","province_name":"همدان"},{"id":"city_3347002cd3bafd845d7238382598a78ec2e0ee60","city_name":"گیلانغرب","city_creation_date":"1337","city_division_code":"70284","district_name":"مرکزی","county_name":"گیلانغرب","province_name":"کرمانشاه"},{"id":"city_9fd6b0b6f97bcc474d56f8e51ea7740a3b0e326a","city_name":"گیوی","city_creation_date":"1336","city_division_code":"70256","district_name":"مرکزی","county_name":"کوثر","province_name":"اردبیل"},{"id":"city_ddc4332ffa3938abf193a65d028dbb23748c04a9","city_name":"لار","city_creation_date":"1317","city_division_code":"70144","district_name":"مرکزی","county_name":"لارستان","province_name":"فارس"},{"id":"city_9fa6520d5ba57c843d66f094b523377b6a538423","city_name":"لالجین","city_creation_date":"1357","city_division_code":"70455","district_name":"لالجین","county_name":"بهار","province_name":"همدان"},{"id":"city_87f20ec9aca3ddced28868c877417375a5deeaf6","city_name":"لاله زار","city_creation_date":"1387","city_division_code":"71074","district_name":"لاله زار","county_name":"بردسیر","province_name":"کرمان"},{"id":"city_57f081518d5b050bf4334022107c73a98b21d5ba","city_name":"لالی","city_creation_date":"1368","city_division_code":"70500","district_name":"مرکزی","county_name":"لالی","province_name":"خوزستان"},{"id":"city_ae2edfe6bdb1d8cb876aa7bbe4f0545b930d1da6","city_name":"لامرد","city_creation_date":"1362","city_division_code":"70477","district_name":"مرکزی","county_name":"لامرد","province_name":"فارس"},{"id":"city_690b3364b429f2ab6fdfc6609ca409ba84d1dc3d","city_name":"لاهرود","city_creation_date":"1375","city_division_code":"70674","district_name":"مشگین شرقی","county_name":"مشگین شهر","province_name":"اردبیل"},{"id":"city_70cef17c82b7061e95612446f0c9c4a717588391","city_name":"لاهیجان","city_creation_date":"1307","city_division_code":"70055","district_name":"مرکزی","county_name":"لاهیجان","province_name":"گیلان"},{"id":"city_8cbd129a8b9d8c758fb72fbc476d81db05000102","city_name":"لای بید","city_creation_date":"1386","city_division_code":"71021","district_name":"میمه","county_name":"شاهین شهر و میمه","province_name":"اصفهان"},{"id":"city_93ba948243aaf4adcdb7e9b4bf6f884b4abcae37","city_name":"لپوئی","city_creation_date":"1379","city_division_code":"70873","district_name":"زرقان","county_name":"شیراز","province_name":"فارس"},{"id":"city_2695bc1af423c63f2dd9d681d204ab10807c66de","city_name":"لردگان","city_creation_date":"1340","city_division_code":"70312","district_name":"مرکزی","county_name":"لردگان","province_name":"چهار محال و بختیاری"},{"id":"city_070e43dcf77052f2ba2a3da29d34e1fa77db3728","city_name":"لشت نشاء","city_creation_date":"1341","city_division_code":"70335","district_name":"لشت نشاء","county_name":"رشت","province_name":"گیلان"},{"id":"city_70dfac3bee51830e9dcf917a58d17b137fc6c5d3","city_name":"لطف آباد","city_creation_date":"1341","city_division_code":"70330","district_name":"لطف آباد","county_name":"درگز","province_name":"خراسان رضوی"},{"id":"city_194a52613b8f05d41d0e72ee0bb0a305b2730c57","city_name":"لطیفی","city_creation_date":"1386","city_division_code":"71025","district_name":"مرکزی","county_name":"لارستان","province_name":"فارس"},{"id":"city_190adda6a663edced180d8af8a308cc82339594a","city_name":"لنده","city_creation_date":"1369","city_division_code":"70513","district_name":"لنده","county_name":"کهگیلویه","province_name":"کهگیلویه و بویراحمد"},{"id":"city_cb960d3247b6c906aefc32adb7f6bca0fd4f1216","city_name":"لنگرود","city_creation_date":"1304","city_division_code":"70028","district_name":"مرکزی","county_name":"لنگرود","province_name":"گیلان"},{"id":"city_c87bff273cac6fed5c44c51e61fca020010e25c3","city_name":"لواسان","city_creation_date":"1349","city_division_code":"70433","district_name":"لواسانات","county_name":"شمیرانات","province_name":"تهران"},{"id":"city_7f5d8fa247ce8b91d72b47e5942d0507b0866c3d","city_name":"لوجلی","city_creation_date":"1379","city_division_code":"70788","district_name":"سرحد","county_name":"شیروان","province_name":"خراسان شمالی"},{"id":"city_cb7b97bc6a6fa6dcda0cd5ffced546479ff1d75a","city_name":"لوشان","city_creation_date":"1362","city_division_code":"70480","district_name":"مرکزی","county_name":"رودبار","province_name":"گیلان"},{"id":"city_fac0603c438ac44f11186335fe14423934ab38fa","city_name":"لولمان","city_creation_date":"1388","city_division_code":"71097","district_name":"کوچصفهان","county_name":"رشت","province_name":"گیلان"},{"id":"city_ef29fd928abfff2bb018cea762af83a7714000ab","city_name":"لومار","city_creation_date":"1372","city_division_code":"70554","district_name":"شیروان","county_name":"شیروان و چرداول","province_name":"ایلام"},{"id":"city_fc8136f7253a283b2479a0f497f84ec0b70bc8b8","city_name":"لوندویل","city_creation_date":"1382","city_division_code":"70933","district_name":"لوندویل","county_name":"آستارا","province_name":"گیلان"},{"id":"city_0ec0db7ed673076a9e1371487b23923d648bc038","city_name":"لیسار","city_creation_date":"1379","city_division_code":"70836","district_name":"کرگانرود","county_name":"طوالش","province_name":"گیلان"},{"id":"city_d903237f3c23f73ae91de19df6df2fdcbf6f901b","city_name":"لیکک","city_creation_date":"1378","city_division_code":"70749","district_name":"مرکزی","county_name":"بهمئی","province_name":"کهگیلویه و بویراحمد"},{"id":"city_a6469a013c34aba11316e023cc3d57d90c5bf3de","city_name":"لیلان","city_creation_date":"1376","city_division_code":"70699","district_name":"لیلان","county_name":"ملکان","province_name":"آذربایجان شرقی"},{"id":"city_b740cc00d932412c486746ebd254217f1f3232b7","city_name":"مادوان","city_creation_date":"1386","city_division_code":"71056","district_name":"مرکزی","county_name":"بویر احمد","province_name":"کهگیلویه و بویراحمد"},{"id":"city_e7cf686a59269877f35909e8bcd99169ee46e66c","city_name":"مارگون","city_creation_date":"1379","city_division_code":"70828","district_name":"مارگون","county_name":"بویر احمد","province_name":"کهگیلویه و بویراحمد"},{"id":"city_d375144a43046b787587c503bb46ea9255d3f4d2","city_name":"ماسال","city_creation_date":"1340","city_division_code":"70318","district_name":"مرکزی","county_name":"ماسال","province_name":"گیلان"},{"id":"city_38c758c1ad2ede4b2cf2685e227b01c4335d4f24","city_name":"ماسوله","city_creation_date":"1341","city_division_code":"70338","district_name":"مرکزی","county_name":"فومن","province_name":"گیلان"},{"id":"city_560ae8cb1809e4d3f0adadea45f1d9fc11b11a4d","city_name":"ماکو","city_creation_date":"1300","city_division_code":"70007","district_name":"مرکزی","county_name":"ماکو","province_name":"آذربایجان غربی"},{"id":"city_1c47ca882ab9db7652a7e800a5ce5ec0049dba3a","city_name":"مال خلیفه","city_creation_date":"1379","city_division_code":"70774","district_name":"فلارد","county_name":"لردگان","province_name":"چهار محال و بختیاری"},{"id":"city_14e50bd56cbfc90d055987b20da6b38438cfef9c","city_name":"مامونیه","city_creation_date":"1341","city_division_code":"70341","district_name":"مرکزی","county_name":"زرندیه","province_name":"مرکزی"},{"id":"city_3c23d567d0d1c800c6527f05134357e37ddf14f4","city_name":"ماه نشان","city_creation_date":"1374","city_division_code":"70597","district_name":"مرکزی","county_name":"ماهنشان","province_name":"زنجان"},{"id":"city_e80365f8780e82f5b6de163b3fb2bcc1be018016","city_name":"ماهان","city_creation_date":"1329","city_division_code":"70179","district_name":"ماهان","county_name":"کرمان","province_name":"کرمان"},{"id":"city_58f051fed2dd86c5b246d53f72177bd9b6ebb3d0","city_name":"ماهدشت","city_creation_date":"1370","city_division_code":"70536","district_name":"مرکزی","county_name":"کرج","province_name":"البرز"},{"id":"city_cf554b56e01e6a0a2e11a57ea562b4054204efdb","city_name":"مبارک آباد","city_creation_date":"1386","city_division_code":"71052","district_name":"مرکزی","county_name":"قیروکارزین","province_name":"فارس"},{"id":"city_bed570d0b0fb7d7d8d7e265a7ae5559b0d0a03e7","city_name":"مبارکه","city_creation_date":"1332","city_division_code":"70208","district_name":"مرکزی","county_name":"مبارکه","province_name":"اصفهان"},{"id":"city_92f3e83e5f623079def1df269794384b32f05ab8","city_name":"مجن","city_creation_date":"1342","city_division_code":"70355","district_name":"بسطام","county_name":"شاهرود","province_name":"سمنان"},{"id":"city_f05b0aab9bbfea964cbf1c522f3b37d26fa69ac3","city_name":"محلات","city_creation_date":"1307","city_division_code":"70057","district_name":"مرکزی","county_name":"محلات","province_name":"مرکزی"},{"id":"city_b64773b41640c2e79697b2c562cbe827e052fefa","city_name":"محمد آباد","city_creation_date":"1375","city_division_code":"70629","district_name":"جرقویه سفلی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_b8b5956f59c873c6c7012c4a4fa0141fd286f0f9","city_name":"محمد آباد","city_creation_date":"1378","city_division_code":"70734","district_name":"شیب آب","county_name":"زابل","province_name":"سیستان و بلوچستان"},{"id":"city_28e0cea077c9f5f8c62766dc9e29201b82115e5c","city_name":"محمد آباد","city_creation_date":"1376","city_division_code":"70698","district_name":"مرکزی","county_name":"ریگان","province_name":"کرمان"},{"id":"city_e7530fd6a5a773c5a05a43481b3b66888186054e","city_name":"محمد شهر","city_creation_date":"1375","city_division_code":"70611","district_name":"مرکزی","county_name":"کرج","province_name":"البرز"},{"id":"city_ef4e8ded0f879910efc346864a52219993d6c489","city_name":"محمد یار","city_creation_date":"1347","city_division_code":"70426","district_name":"محمدیار","county_name":"نقده","province_name":"آذربایجان غربی"},{"id":"city_74d1f80238a5597ec6b4f98ed26eaf3b466f6823","city_name":"محمدان","city_creation_date":"1386","city_division_code":"71031","district_name":"بمپور","county_name":"ایرانشهر","province_name":"سیستان و بلوچستان"},{"id":"city_1f659e78805bbe28395bd2335197808ed7d336fb","city_name":"محمدشهر","city_creation_date":"1386","city_division_code":"71038","district_name":"خوسف","county_name":"بیرجند","province_name":"خراسان جنوبی"},{"id":"city_26ffa1b8e84f6a7ba839ba57ef1dd34b092e6717","city_name":"محمدی","city_creation_date":"1386","city_division_code":"71048","district_name":"مرکزی","county_name":"سراوان","province_name":"سیستان و بلوچستان"},{"id":"city_eba683cf95c6730225ecccfcc4548dfc1a11b742","city_name":"محمدیه","city_creation_date":"1374","city_division_code":"70596","district_name":"محمدیه","county_name":"البرز","province_name":"قزوین"},{"id":"city_f4db3f59d88c029c1539268361f82b3a1e968d94","city_name":"محمود آباد","city_creation_date":"1384","city_division_code":"70985","district_name":"مرکزی","county_name":"شاهین دژ","province_name":"آذربایجان غربی"},{"id":"city_dd5cbfafc2ddc5cc70371f022eee1eb369a7eab9","city_name":"محمود آباد","city_creation_date":"1304","city_division_code":"70029","district_name":"مرکزی","county_name":"محمود آباد","province_name":"مازندران"},{"id":"city_679f6fb7c1ada4ef00fd39e85d56e28cb7e0b84d","city_name":"محمود آباد نمونه","city_creation_date":"1378","city_division_code":"70720","district_name":"مرکزی","county_name":"قزوین","province_name":"قزوین"},{"id":"city_164a7622dc212772b0336fe720bc437fc7fe51a5","city_name":"محی آباد","city_creation_date":"1375","city_division_code":"70669","district_name":"ماهان","county_name":"کرمان","province_name":"کرمان"},{"id":"city_5510c2b759841ff7f7c5b519f76b6c63e71224dc","city_name":"مرادلو","city_creation_date":"1389","city_division_code":"71129","district_name":"مرادلو","county_name":"مشگین شهر","province_name":"اردبیل"},{"id":"city_6e32dfb1c2231f8be001f44d86715bbcf62a58b0","city_name":"مراغه","city_creation_date":"1300","city_division_code":"70006","district_name":"مرکزی","county_name":"مراغه","province_name":"آذربایجان شرقی"},{"id":"city_d8eba7bc83461015cd864efb444c623af9bf3e92","city_name":"مراوه تپه","city_creation_date":"1379","city_division_code":"70832","district_name":"مرکزی","county_name":"مراوه تپه","province_name":"گلستان"},{"id":"city_2dc315c5776286fb88e1e42d1dd2493c8dcc0a4e","city_name":"مرجقل","city_creation_date":"1372","city_division_code":"70565","district_name":"تولم","county_name":"صومعه سرا","province_name":"گیلان"},{"id":"city_0aa7c5bb3735f6b201f68a46383042c19292dd95","city_name":"مردهک","city_creation_date":"1383","city_division_code":"70981","district_name":"جبالبارز جنوبی","county_name":"عنبر آباد","province_name":"کرمان"},{"id":"city_6cecf0ce26de342b1710319e286241b68535ca8b","city_name":"مرزن آباد","city_creation_date":"1336","city_division_code":"70266","district_name":"کلاردشت","county_name":"چالوس","province_name":"مازندران"},{"id":"city_69fc9fc62afdbd053bd7f7bee45190de96a2effc","city_name":"مرزیکلا","city_creation_date":"1379","city_division_code":"70842","district_name":"بابل کنار","county_name":"بابل","province_name":"مازندران"},{"id":"city_0fb480e491df261d15f022f8afdc3b789fe2a73b","city_name":"مرگنلر","city_creation_date":"1389","city_division_code":"71136","district_name":"قره قویون","county_name":"شوط","province_name":"آذربایجان غربی"},{"id":"city_f18ebc2ab49cf911b7e85aa8c465f22b3307874e","city_name":"مرند","city_creation_date":"1308","city_division_code":"70058","district_name":"مرکزی","county_name":"مرند","province_name":"آذربایجان شرقی"},{"id":"city_d7a2f797c7745daa11c15b9b0a33b402db1d2ae7","city_name":"مرودشت","city_creation_date":"1319","city_division_code":"70149","district_name":"مرکزی","county_name":"مرودشت","province_name":"فارس"},{"id":"city_b867b69b50b48ae2a6c6ea499e2f266e77dd1e6f","city_name":"مروست","city_creation_date":"1362","city_division_code":"70495","district_name":"مروست","county_name":"خاتم","province_name":"یزد"},{"id":"city_bedea22be709e9e69295c37b38869e8eb5cf9ab2","city_name":"مریانج","city_creation_date":"1341","city_division_code":"70343","district_name":"مرکزی","county_name":"همدان","province_name":"همدان"},{"id":"city_8335689e47e26bb9e5bef2184d2ddea06c99a990","city_name":"مریوان","city_creation_date":"1336","city_division_code":"70263","district_name":"مرکزی","county_name":"مریوان","province_name":"کردستان"},{"id":"city_fa486ef39c62e999c9e1f1c480f8e74af8508836","city_name":"مزدآوند","city_creation_date":"1383","city_division_code":"70948","district_name":"مرزداران","county_name":"سرخس","province_name":"خراسان رضوی"},{"id":"city_450290ccf9397c30d72bf1f8a46c68956f1eab39","city_name":"مس سرچشمه","city_creation_date":"1375","city_division_code":"70614","district_name":"مرکزی","county_name":"رفسنجان","province_name":"کرمان"},{"id":"city_f8d587276b4cf8f85ebd4830d114f80892911c33","city_name":"مسجد سلیمان","city_creation_date":"1338","city_division_code":"70290","district_name":"مرکزی","county_name":"مسجد سلیمان","province_name":"خوزستان"},{"id":"city_860d091acd3e990acf0adab5be27cb9e67a5291d","city_name":"مشراگه","city_creation_date":"1389","city_division_code":"71124","district_name":"مشراگه","county_name":"رامشیر","province_name":"خوزستان"},{"id":"city_686c5cb21c0e87d5b2ae6062d55bd0f29044e3a0","city_name":"مشکات","city_creation_date":"1384","city_division_code":"71005","district_name":"مرکزی","county_name":"کاشان","province_name":"اصفهان"},{"id":"city_d319bf2b9037f625898472a10f4a43594ad3e20d","city_name":"مشکان","city_creation_date":"1381","city_division_code":"70898","district_name":"پشتکوه","county_name":"نی ریز","province_name":"فارس"},{"id":"city_cc235d3fbd8725459b751ff845f09a8d4b4b4c98","city_name":"مشکین دشت","city_creation_date":"1375","city_division_code":"70613","district_name":"مرکزی","county_name":"کرج","province_name":"البرز"},{"id":"city_7e887ceb64203d0732178ebce159a2c9df51efcf","city_name":"مشگین شهر","city_creation_date":"1315","city_division_code":"70122","district_name":"مرکزی","county_name":"مشگین شهر","province_name":"اردبیل"},{"id":"city_e5c38b77a94f2d19953fa7e64ca2161d9e77ffbd","city_name":"مشهد","city_creation_date":"1297","city_division_code":"70003","district_name":"مرکزی","county_name":"مشهد","province_name":"خراسان رضوی"},{"id":"city_a0ff31b0338a49ad048d42fb8f6beae09935bfb8","city_name":"مشهدریزه","city_creation_date":"1384","city_division_code":"71013","district_name":"میان ولایت","county_name":"تایباد","province_name":"خراسان رضوی"},{"id":"city_72e42d452ffa3a3d6b6e79323b23b49407f00a32","city_name":"مصیری","city_creation_date":"1378","city_division_code":"70738","district_name":"مرکزی","county_name":"رستم","province_name":"فارس"},{"id":"city_9e6fedc7a1f07795392546a38bdd8d70cf4f76ce","city_name":"معلم کلایه","city_creation_date":"1379","city_division_code":"70806","district_name":"رودبار الموت","county_name":"قزوین","province_name":"قزوین"},{"id":"city_663da2e2136b5e474b02851dc32b69ca8cd376b0","city_name":"معمولان","city_creation_date":"1378","city_division_code":"70729","district_name":"معمولان","county_name":"پلدختر","province_name":"لرستان"},{"id":"city_6fde9292f7919ed5a2a034d6f6afa1067fc3de91","city_name":"مقاومت","city_creation_date":"1376","city_division_code":"70700","district_name":"مرکزی","county_name":"خرمشهر","province_name":"خوزستان"},{"id":"city_d9e5185aad0ae560b0a26be44ec35241a43aa64a","city_name":"ملاثانی","city_creation_date":"1370","city_division_code":"70533","district_name":"مرکزی","county_name":"باوی","province_name":"خوزستان"},{"id":"city_3817f800327c5ed84266181b1c8fe479108862ef","city_name":"ملارد","city_creation_date":"1374","city_division_code":"70595","district_name":"مرکزی","county_name":"ملارد","province_name":"تهران"},{"id":"city_7f9c18af24078d0894e647ca6a99e62ed4494ff5","city_name":"ملایر","city_creation_date":"1313","city_division_code":"70105","district_name":"مرکزی","county_name":"ملایر","province_name":"همدان"},{"id":"city_1e65d4b0e7eef750a609a28c7099cab6061949b6","city_name":"ملک آباد","city_creation_date":"1379","city_division_code":"70781","district_name":"احمد آباد","county_name":"مشهد","province_name":"خراسان رضوی"},{"id":"city_710f3f8cab28ad9594047d9685e051b9a86323ab","city_name":"ملکان","city_creation_date":"1329","city_division_code":"70174","district_name":"مرکزی","county_name":"ملکان","province_name":"آذربایجان شرقی"},{"id":"city_aa7cfc1700abce740252014c73d4bc6afc721151","city_name":"ممقان","city_creation_date":"1336","city_division_code":"70253","district_name":"ممقان","county_name":"آذرشهر","province_name":"آذربایجان شرقی"},{"id":"city_b2790d655e4b35f87dcc62b1211864f3d950ca96","city_name":"منج","city_creation_date":"1389","city_division_code":"71140","district_name":"منج","county_name":"لردگان","province_name":"چهار محال و بختیاری"},{"id":"city_e25c5169a2f018d1ef4d1097b16f73af2bcac5fc","city_name":"منجیل","city_creation_date":"1343","city_division_code":"70382","district_name":"مرکزی","county_name":"رودبار","province_name":"گیلان"},{"id":"city_aaabbc446bfcc70811e0d363c9ff45a0cffed270","city_name":"منظریه","city_creation_date":"1379","city_division_code":"70860","district_name":"مرکزی","county_name":"شهرضا","province_name":"اصفهان"},{"id":"city_0463cf1a6cb79182ba25cbcb6ccbf5da041cc6c3","city_name":"منوجان","city_creation_date":"1375","city_division_code":"70645","district_name":"مرکزی","county_name":"منوجان","province_name":"کرمان"},{"id":"city_58bb9a0a6ee4f60d66db26909330fe2da46ce2af","city_name":"موچش","city_creation_date":"1379","city_division_code":"70817","district_name":"موچش","county_name":"کامیاران","province_name":"کردستان"},{"id":"city_09ad66b0aa8e65fb559711b76ad439b805a28223","city_name":"مود","city_creation_date":"1384","city_division_code":"70987","district_name":"مود","county_name":"سربیشه","province_name":"خراسان جنوبی"},{"id":"city_1142e4a45fbf031771afa79259c4a0942618b3dd","city_name":"مورموری","city_creation_date":"1383","city_division_code":"70975","district_name":"کلات","county_name":"آبدانان","province_name":"ایلام"},{"id":"city_cc4287579dd5b580e21c446403ace6ca48c77b71","city_name":"موسیان","city_creation_date":"1343","city_division_code":"70375","district_name":"موسیان","county_name":"دهلران","province_name":"ایلام"},{"id":"city_0a070887a8982724fbac549d4c552a37569e9257","city_name":"مومن آباد","city_creation_date":"1378","city_division_code":"70739","district_name":"جاپلق","county_name":"ازنا","province_name":"لرستان"},{"id":"city_bc6f8bf00dad26aae056f3f795bfffa190169daa","city_name":"مهاباد","city_creation_date":"1374","city_division_code":"70593","district_name":"مرکزی","county_name":"اردستان","province_name":"اصفهان"},{"id":"city_3a4f3a62ff09ede3552d7ed4fe5e49e9dad1d587","city_name":"مهاباد","city_creation_date":"1310","city_division_code":"70077","district_name":"مرکزی","county_name":"مهاباد","province_name":"آذربایجان غربی"},{"id":"city_d3d5727de801db23e34c8f3dbcd7868ed25d7805","city_name":"مهدی شهر","city_creation_date":"1314","city_division_code":"70111","district_name":"مرکزی","county_name":"مهدی شهر","province_name":"سمنان"},{"id":"city_55d83437353dd39ede5aa4324f4e14b22848e66d","city_name":"مهر","city_creation_date":"1389","city_division_code":"71134","district_name":"گچی","county_name":"ملکشاهی","province_name":"ایلام"},{"id":"city_6ab66bd5f444d47ee2a43176beb67c515a710085","city_name":"مهر","city_creation_date":"1373","city_division_code":"70588","district_name":"مرکزی","county_name":"مهر","province_name":"فارس"},{"id":"city_e1c025378348e529cdde446c31134f66e9cff81f","city_name":"مهران","city_creation_date":"1343","city_division_code":"70377","district_name":"مرکزی","county_name":"مهران","province_name":"ایلام"},{"id":"city_f65441926abd9444c2c1bd97e5e01838381d8016","city_name":"مهربان","city_creation_date":"1341","city_division_code":"70323","district_name":"مهربان","county_name":"سراب","province_name":"آذربایجان شرقی"},{"id":"city_8187b745d968a5f84badda86503349bf381e7b67","city_name":"مهردشت","city_creation_date":"1378","city_division_code":"70723","district_name":"بهمن","county_name":"ابرکوه","province_name":"یزد"},{"id":"city_0ed0310d8300d1feac9b8a7c1497970beeeccc57","city_name":"مهریز","city_creation_date":"1341","city_division_code":"70344","district_name":"مرکزی","county_name":"مهریز","province_name":"یزد"},{"id":"city_bf26023a4f15c43d9e6d8c3e207408a38b83e55d","city_name":"میامی","city_creation_date":"1372","city_division_code":"70557","district_name":"میامی","county_name":"شاهرود","province_name":"سمنان"},{"id":"city_6ee1d51f6f1720d45aa3d2c2340090ea8c3e0e74","city_name":"میان راهان","city_creation_date":"1379","city_division_code":"70823","district_name":"دینور","county_name":"صحنه","province_name":"کرمانشاه"},{"id":"city_5710c668a089ef8d81882cdad7d73908921a8436","city_name":"میاندوآب","city_creation_date":"1314","city_division_code":"70108","district_name":"مرکزی","county_name":"میاندوآب","province_name":"آذربایجان غربی"},{"id":"city_8e6690eabb409415103a88f5d6d466f29f499733","city_name":"میانرود","city_creation_date":"1379","city_division_code":"70878","district_name":"مرکزی","county_name":"دزفول","province_name":"خوزستان"},{"id":"city_f8b414a534f676f4be3517b181178b64240fa13a","city_name":"میانه","city_creation_date":"1315","city_division_code":"70121","district_name":"مرکزی","county_name":"میانه","province_name":"آذربایجان شرقی"},{"id":"city_2c2a06b6c06b412507f65bfed9183ec1fe751824","city_name":"میبد","city_creation_date":"1344","city_division_code":"70402","district_name":"مرکزی","county_name":"میبد","province_name":"یزد"},{"id":"city_d9e951dcdc8c8490eca73cd59b0fe965197db82c","city_name":"میداود","city_creation_date":"1389","city_division_code":"71119","district_name":"میداود","county_name":"باغ ملک","province_name":"خوزستان"},{"id":"city_7be435b4d4241aa0a2c2b1a7f45a9179733d8e21","city_name":"میرآباد","city_creation_date":"1379","city_division_code":"70765","district_name":"وزینه","county_name":"سر دشت","province_name":"آذربایجان غربی"},{"id":"city_949c323f54d2d18186e5728ba9773029900857be","city_name":"میرجاوه","city_creation_date":"1341","city_division_code":"70331","district_name":"میرجاوه","county_name":"زاهدان","province_name":"سیستان و بلوچستان"},{"id":"city_783f9ca8b24a34f0bb8509914989bcc684756e9d","city_name":"میلاجرد","city_creation_date":"1379","city_division_code":"70755","district_name":"میلاجرد","county_name":"کمیجان","province_name":"مرکزی"},{"id":"city_b4667fb9fe224297e82d7bbe121a28c83e0dafe8","city_name":"میمند","city_creation_date":"1344","city_division_code":"70397","district_name":"میمند","county_name":"فیروز آباد","province_name":"فارس"},{"id":"city_a9fef9d6105cb8e8bda40b1fec0d79b3382f849a","city_name":"میمه","city_creation_date":"1344","city_division_code":"70391","district_name":"زرین آباد","county_name":"دهلران","province_name":"ایلام"},{"id":"city_21eaf27f37fe23b982359b7d3bea4b4bbd915bdf","city_name":"میمه","city_creation_date":"1325","city_division_code":"70158","district_name":"میمه","county_name":"شاهین شهر و میمه","province_name":"اصفهان"},{"id":"city_6f0145479398181622303a5a59638212305f06c0","city_name":"میناب","city_creation_date":"1316","city_division_code":"70138","district_name":"مرکزی","county_name":"میناب","province_name":"هرمزگان"},{"id":"city_9bd38ab4f7f041693f6df598f2ebce773582543f","city_name":"مینودشت","city_creation_date":"1323","city_division_code":"70156","district_name":"مرکزی","county_name":"مینودشت","province_name":"گلستان"},{"id":"city_3f0f40027885db52b25b46efe0cb3276f639ff3e","city_name":"مینوشهر","city_creation_date":"1375","city_division_code":"70675","district_name":"مینو","county_name":"خرمشهر","province_name":"خوزستان"},{"id":"city_559a3db12bd0d1c49a861322eb0829c98389e4b3","city_name":"نازک علیا","city_creation_date":"1389","city_division_code":"71137","district_name":"ارس","county_name":"پلدشت","province_name":"آذربایجان غربی"},{"id":"city_f7f4efb3bb22e8e0a8493c148baf9a9628964c60","city_name":"ناغان","city_creation_date":"1373","city_division_code":"70584","district_name":"ناغان","county_name":"کیار","province_name":"چهار محال و بختیاری"},{"id":"city_6fea711cf6944fe09b75d0c3c1928012ee981a31","city_name":"نافچ","city_creation_date":"1379","city_division_code":"70872","district_name":"مرکزی","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_b1931513a542871a80cb9447da1629037eb11c39","city_name":"نالوس","city_creation_date":"1379","city_division_code":"70764","district_name":"نالوس","county_name":"اشنویه","province_name":"آذربایجان غربی"},{"id":"city_fcd11a8e41d18004288f28c5b1b614b1e8600d41","city_name":"نائین","city_creation_date":"1312","city_division_code":"70098","district_name":"مرکزی","county_name":"نائین","province_name":"اصفهان"},{"id":"city_ac880332918fd4b28179b49660be3cb7b81a820f","city_name":"نجف آباد","city_creation_date":"1310","city_division_code":"70078","district_name":"مرکزی","county_name":"نجف آباد","province_name":"اصفهان"},{"id":"city_94bfb9fd2bf19337be5b5bedf6ad9ba947f1d7dc","city_name":"نجف شهر","city_creation_date":"1376","city_division_code":"70679","district_name":"مرکزی","county_name":"سیرجان","province_name":"کرمان"},{"id":"city_d344a4bec7e71f88a7077caef93b470977765da4","city_name":"نخل تقی","city_creation_date":"1382","city_division_code":"70937","district_name":"عسلویه","county_name":"کنگان","province_name":"بوشهر"},{"id":"city_2e650289de35f0c57e34372a9cdde94a09013be0","city_name":"ندوشن","city_creation_date":"1376","city_division_code":"70702","district_name":"خضرآباد","county_name":"صدوق","province_name":"یزد"},{"id":"city_2378fd1217ce10e930ccf180fb4b13aea523621b","city_name":"نراق","city_creation_date":"1338","city_division_code":"70292","district_name":"مرکزی","county_name":"دلیجان","province_name":"مرکزی"},{"id":"city_94f6be478738ceb007b3a9356a34a2b7b408bdc5","city_name":"نرجه","city_creation_date":"1383","city_division_code":"70965","district_name":"مرکزی","county_name":"تاکستان","province_name":"قزوین"},{"id":"city_c0995a29a4cf18b5f6f4bd21364845f52fb7da11","city_name":"نرماشیر","city_creation_date":"1377","city_division_code":"70707","district_name":"مرکزی","county_name":"نرماشیر","province_name":"کرمان"},{"id":"city_3ba241d100c0abab180d01cdbf52e745cf225e37","city_name":"نسیم شهر","city_creation_date":"1374","city_division_code":"70594","district_name":"بوستان","county_name":"رباط کریم","province_name":"تهران"},{"id":"city_aa3094efbcd7085e137a7f53de3286b8f138ecc0","city_name":"نشتارود","city_creation_date":"1338","city_division_code":"70291","district_name":"نشتا","county_name":"تنکابن","province_name":"مازندران"},{"id":"city_ea6ed9d89ea45dbdde6a3c6c0c9774422fa4bf51","city_name":"نشتیفان","city_creation_date":"1382","city_division_code":"70931","district_name":"مرکزی","county_name":"خواف","province_name":"خراسان رضوی"},{"id":"city_a47ce47d0cfd3051292502df244ba9fadc39f6ac","city_name":"نصرآباد","city_creation_date":"1380","city_division_code":"70884","district_name":"جرقویه سفلی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_ff109d743f82fe7853ca20fc9e38d4c95bfaf301","city_name":"نصرآباد","city_creation_date":"1378","city_division_code":"70745","district_name":"نصر آباد","county_name":"تربت جام","province_name":"خراسان رضوی"},{"id":"city_521ea60f52702af41ab755396d2e802c6d960eb7","city_name":"نصرت آباد","city_creation_date":"1379","city_division_code":"70799","district_name":"نصرت آباد","county_name":"زاهدان","province_name":"سیستان و بلوچستان"},{"id":"city_b61173a7cbcfcc018aaefec3b9da9c12ab8615a7","city_name":"نصیرآباد","city_creation_date":"1384","city_division_code":"70997","district_name":"گلستان","county_name":"رباط کریم","province_name":"تهران"},{"id":"city_f05525daecadef38ae35790716db34345d27e3e3","city_name":"نظام شهر","city_creation_date":"1383","city_division_code":"70979","district_name":"روداب","county_name":"نرماشیر","province_name":"کرمان"},{"id":"city_1921d13c2b517461090386094a79093ab527fca0","city_name":"نظر آباد","city_creation_date":"1358","city_division_code":"70458","district_name":"مرکزی","county_name":"نظر آباد","province_name":"البرز"},{"id":"city_63beb52f7d034cade019a136b7ac78c9378a0f09","city_name":"نظرکهریزی","city_creation_date":"1383","city_division_code":"70974","district_name":"نظرکهریزی","county_name":"هشترود","province_name":"آذربایجان شرقی"},{"id":"city_99ad9b42eb3f75af44979a28890e0cf43f02d7e4","city_name":"نظنز","city_creation_date":"1317","city_division_code":"70139","district_name":"مرکزی","county_name":"نطنز","province_name":"اصفهان"},{"id":"city_05b191c8f096679adc42089a45c415dd14c34fb2","city_name":"نقاب","city_creation_date":"1373","city_division_code":"70585","district_name":"مرکزی","county_name":"جوین","province_name":"خراسان رضوی"},{"id":"city_92f020b2b9e0bec28955c2b9274f4eb30e246c92","city_name":"نقده","city_creation_date":"1330","city_division_code":"70184","district_name":"مرکزی","county_name":"نقده","province_name":"آذربایجان غربی"},{"id":"city_e26c76422da2b6978d663ad2c53436dd50e727ad","city_name":"نقنه","city_creation_date":"1386","city_division_code":"71017","district_name":"مرکزی","county_name":"بروجن","province_name":"چهار محال و بختیاری"},{"id":"city_1fc0be58034c5047bc2d19b87fa7b535bbdc6b1a","city_name":"نکا","city_creation_date":"1329","city_division_code":"70182","district_name":"مرکزی","county_name":"نکا","province_name":"مازندران"},{"id":"city_4495c32d4ff94716b7fbe524a1fae3f5044d00cb","city_name":"نگار","city_creation_date":"1376","city_division_code":"70694","district_name":"مرکزی","county_name":"بردسیر","province_name":"کرمان"},{"id":"city_1d3b5d7bedeba1d9de93bad4ed7243eabab65b1d","city_name":"نگور","city_creation_date":"1345","city_division_code":"70412","district_name":"دشتیاری","county_name":"چاه بهار","province_name":"سیستان و بلوچستان"},{"id":"city_f186bbcfbc8a51e433dded85b4058e849f07c5d0","city_name":"نگین شهر","city_creation_date":"1383","city_division_code":"70973","district_name":"مرکزی","county_name":"آزاد شهر","province_name":"گلستان"},{"id":"city_291a80c8caff50d17d641ba0d92c465b81458f9f","city_name":"نمین","city_creation_date":"1337","city_division_code":"70269","district_name":"مرکزی","county_name":"نمین","province_name":"اردبیل"},{"id":"city_38a62813741f8a0093a3262aceba31303654e4f8","city_name":"نوبران","city_creation_date":"1372","city_division_code":"70559","district_name":"نوبران","county_name":"ساوه","province_name":"مرکزی"},{"id":"city_3ce3c7fc08b51050531019dd8c1fe67a424b41f8","city_name":"نوبندگان","city_creation_date":"1384","city_division_code":"71002","district_name":"نوبندگان","county_name":"فسا","province_name":"فارس"},{"id":"city_da84dfc2a9921bdacdeb9b2444beb8d1f7a636af","city_name":"نوجین","city_creation_date":"1388","city_division_code":"71091","district_name":"مرکزی","county_name":"فراشبند","province_name":"فارس"},{"id":"city_a3af902342189e98a8a80126e64976b4ccdf1ad9","city_name":"نوخندان","city_creation_date":"1339","city_division_code":"70300","district_name":"نوخندان","county_name":"درگز","province_name":"خراسان رضوی"},{"id":"city_3c9f65f2984af515db93e4b89105fa14f57ea62b","city_name":"نودان","city_creation_date":"1379","city_division_code":"70805","district_name":"کوهمره","county_name":"کازرون","province_name":"فارس"},{"id":"city_de8eebd953e64c19e389c605ee2a840de1d8df62","city_name":"نودژ","city_creation_date":"1383","city_division_code":"70982","district_name":"آسمینون","county_name":"منوجان","province_name":"کرمان"},{"id":"city_19b211cf3c42357855dfff6f2eb2929b4c804cae","city_name":"نودشه","city_creation_date":"1322","city_division_code":"70154","district_name":"نوسود","county_name":"پاوه","province_name":"کرمانشاه"},{"id":"city_ebeddecc9c261aeafcf9fd47a779f085fc53f700","city_name":"نوده خاندوز","city_creation_date":"1381","city_division_code":"70919","district_name":"چشمه ساران","county_name":"آزاد شهر","province_name":"گلستان"},{"id":"city_f4b29e150ab6586717e4b9b04441f5343a85736a","city_name":"نور","city_creation_date":"1333","city_division_code":"70229","district_name":"مرکزی","county_name":"نور","province_name":"مازندران"},{"id":"city_256da6abc4d77fd9f8713bce7ffebd459b2614f9","city_name":"نورآباد","city_creation_date":"1342","city_division_code":"70365","district_name":"مرکزی","county_name":"دلفان","province_name":"لرستان"},{"id":"city_495d148cdf7714fe1437654fde9755de91f55a05","city_name":"نورآباد","city_creation_date":"1341","city_division_code":"70333","district_name":"مرکزی","county_name":"ممسنی","province_name":"فارس"},{"id":"city_9f7971f81567e435e8f16237d0eefa4fc30bc4d8","city_name":"نوسود","city_creation_date":"1339","city_division_code":"70305","district_name":"نوسود","county_name":"پاوه","province_name":"کرمانشاه"},{"id":"city_d75bbc954888bd498fbd007786c7bc106aee03d7","city_name":"نوش آباد","city_creation_date":"1380","city_division_code":"70885","district_name":"مرکزی","county_name":"آران و بیدگل","province_name":"اصفهان"},{"id":"city_f9da2b321d06bc1c6206813f49e726c64dd5991a","city_name":"نوشهر","city_creation_date":"1314","city_division_code":"70118","district_name":"مرکزی","county_name":"نوشهر","province_name":"مازندران"},{"id":"city_d87c4d7faf6bcc0fbcb8ee3f0b3e55a7c3514052","city_name":"نوشین","city_creation_date":"1372","city_division_code":"70549","district_name":"نازلو","county_name":"ارومیه","province_name":"آذربایجان غربی"},{"id":"city_720063f02684318446b280067cd05aa402886903","city_name":"نوک آباد","city_creation_date":"1379","city_division_code":"70796","district_name":"نوک آباد","county_name":"خاش","province_name":"سیستان و بلوچستان"},{"id":"city_2a425336b998402bf6d83c5564fea4a7ea439224","city_name":"نوکنده","city_creation_date":"1372","city_division_code":"70570","district_name":"نوکنده","county_name":"بندر گز","province_name":"گلستان"},{"id":"city_49855ad3dc91cb850757fd5a26b2316b44c61bfe","city_name":"نهاوند","city_creation_date":"1306","city_division_code":"70042","district_name":"مرکزی","county_name":"نهاوند","province_name":"همدان"},{"id":"city_5a5a1f3ccac56193dff3348c49d8e877b2877e3e","city_name":"نهبندان","city_creation_date":"1340","city_division_code":"70313","district_name":"مرکزی","county_name":"نهبندان","province_name":"خراسان جنوبی"},{"id":"city_25360a40810eddba02767862981652df81df540b","city_name":"نی ریز","city_creation_date":"1310","city_division_code":"70084","district_name":"مرکزی","county_name":"نی ریز","province_name":"فارس"},{"id":"city_1163e2b05fbf96046ebd3ba85f48a326c6fe75f9","city_name":"نیاسر","city_creation_date":"1376","city_division_code":"70685","district_name":"نیاسر","county_name":"کاشان","province_name":"اصفهان"},{"id":"city_daa8884b6eed2c804927ecb0a24eb5b8a0897e21","city_name":"نیر","city_creation_date":"1342","city_division_code":"70346","district_name":"مرکزی","county_name":"نیر","province_name":"اردبیل"},{"id":"city_ad0d0c74db3d7387c91969f55bb537ea4af85a7d","city_name":"نیر","city_creation_date":"1362","city_division_code":"70493","district_name":"نیر","county_name":"تفت","province_name":"یزد"},{"id":"city_a47cbe817c9c373c58fd2d9f541f46e21b30e347","city_name":"نیشابور","city_creation_date":"1310","city_division_code":"70080","district_name":"مرکزی","county_name":"نیشابور","province_name":"خراسان رضوی"},{"id":"city_db34c7c6a2a766d77e456333c16bfd42b637c8de","city_name":"نیک آباد","city_creation_date":"1372","city_division_code":"70573","district_name":"جرقویه سفلی","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_f724569186297ea32252515ecf86a7603f2f6bbc","city_name":"نیک شهر","city_creation_date":"1344","city_division_code":"70396","district_name":"مرکزی","county_name":"نیک شهر","province_name":"سیستان و بلوچستان"},{"id":"city_70b3aa7512833f88dea44c4f7620cfd87456c71a","city_name":"نیل شهر","city_creation_date":"1384","city_division_code":"71014","district_name":"بوژگان","county_name":"تربت جام","province_name":"خراسان رضوی"},{"id":"city_59a11323fde51d6d5a6b4284e81cf2ed099519b4","city_name":"نیمبلوک","city_creation_date":"1383","city_division_code":"70958","district_name":"نیمبلوک","county_name":"قائنات","province_name":"خراسان جنوبی"},{"id":"city_63c563f949f90e8501c4f28bac4c177867ce79d1","city_name":"نیمور","city_creation_date":"1359","city_division_code":"70459","district_name":"مرکزی","county_name":"محلات","province_name":"مرکزی"},{"id":"city_6390bcc21f158968345dc71bf499350a25017d7c","city_name":"واجارگاه","city_creation_date":"1344","city_division_code":"70400","district_name":"کلاچای","county_name":"رودسر","province_name":"گیلان"},{"id":"city_e8eda3914b36534f4a6fe410f6e95ad9bd0ac68a","city_name":"وایقان","city_creation_date":"1372","city_division_code":"70548","district_name":"مرکزی","county_name":"شبستر","province_name":"آذربایجان شرقی"},{"id":"city_62873ef1ef9be30dc58187ced2c7a85dab2c479e","city_name":"وحدتیه","city_creation_date":"1379","city_division_code":"70869","district_name":"سعد آباد","county_name":"دشتستان","province_name":"بوشهر"},{"id":"city_53cd39ca6c7f88fef31f0f4ebbc2be3acc409d26","city_name":"وحیدیه","city_creation_date":"1375","city_division_code":"70619","district_name":"مرکزی","county_name":"شهریار","province_name":"تهران"},{"id":"city_aae4750a52193872523224a89c0324ca9a5365d3","city_name":"ورامین","city_creation_date":"1320","city_division_code":"70151","district_name":"مرکزی","county_name":"ورامین","province_name":"تهران"},{"id":"city_24957bff797929d69c1edfd0ac4e94f513228297","city_name":"وراوی","city_creation_date":"1381","city_division_code":"70918","district_name":"وراوی","county_name":"مهر","province_name":"فارس"},{"id":"city_6230f5294314ad9b0ae1a43b594702942d7bcb5a","city_name":"وردنجان","city_creation_date":"1389","city_division_code":"71141","district_name":"بن","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_cdd74d92f550524998cf8fa1296dc8403fc5f01d","city_name":"ورزقان","city_creation_date":"1372","city_division_code":"70568","district_name":"مرکزی","county_name":"ورزقان","province_name":"آذربایجان شرقی"},{"id":"city_69a620013df7f4504eac38671db730de69830529","city_name":"ورزنه","city_creation_date":"1347","city_division_code":"70427","district_name":"بن رود","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_1bc77f1d8c981af2d90beeefb422625676af51d3","city_name":"ورنامخواست","city_creation_date":"1368","city_division_code":"70496","district_name":"مرکزی","county_name":"لنجان","province_name":"اصفهان"},{"id":"city_fdbfa8dced111df350ba7cefe8e441a46e1daf13","city_name":"وزوان","city_creation_date":"1346","city_division_code":"70421","district_name":"میمه","county_name":"شاهین شهر و میمه","province_name":"اصفهان"},{"id":"city_985f4e08faf3c43a74e0bf3c3826cb47f73c9390","city_name":"ونک","city_creation_date":"1377","city_division_code":"70708","district_name":"مرکزی","county_name":"سمیرم","province_name":"اصفهان"},{"id":"city_371a6605ed827c8a2740f6bdac34f2404b1d098a","city_name":"ویس","city_creation_date":"1376","city_division_code":"70688","district_name":"ویس","county_name":"باوی","province_name":"خوزستان"},{"id":"city_a2e506e93fb3aeb0bd333b9635b41554e7e3550a","city_name":"ویسیان","city_creation_date":"1378","city_division_code":"70719","district_name":"ویسیان","county_name":"دوره","province_name":"لرستان"},{"id":"city_04c0100dde8afa14516ba61b41401c2939ea0af9","city_name":"هادیشهر","city_creation_date":"1349","city_division_code":"70432","district_name":"مرکزی","county_name":"جلفا","province_name":"آذربایجان شرقی"},{"id":"city_e90d4e3dc2772f2fe39bbe09afaa5ff5d5cb604a","city_name":"هجدک","city_creation_date":"1383","city_division_code":"70980","district_name":"کوهساران","county_name":"راور","province_name":"کرمان"},{"id":"city_392046b7721f61911afa6c981388c22a2293f7d2","city_name":"هرات","city_creation_date":"1362","city_division_code":"70494","district_name":"مرکزی","county_name":"خاتم","province_name":"یزد"},{"id":"city_c331788bf9b7c6a6948b6dc8a1b7809df3f91896","city_name":"هرسین","city_creation_date":"1316","city_division_code":"70135","district_name":"مرکزی","county_name":"هرسین","province_name":"کرمانشاه"},{"id":"city_627b346cad2d78e656f4f7dd344a329fbdcab8c9","city_name":"هرمز","city_creation_date":"1362","city_division_code":"70491","district_name":"هرمز","county_name":"قشم","province_name":"هرمزگان"},{"id":"city_0aff59356be4d43e49f43c29c72266b8f227cd74","city_name":"هرند","city_creation_date":"1345","city_division_code":"70403","district_name":"جلگه","county_name":"اصفهان","province_name":"اصفهان"},{"id":"city_9e6e54178fed6ec5c4f80f5fef0ac023fd4671c5","city_name":"هریس","city_creation_date":"1333","city_division_code":"70219","district_name":"مرکزی","county_name":"هریس","province_name":"آذربایجان شرقی"},{"id":"city_e71a2dffc24697e8d263587704be3856cbe952f1","city_name":"هشتبندی","city_creation_date":"1386","city_division_code":"71060","district_name":"توکهور","county_name":"میناب","province_name":"هرمزگان"},{"id":"city_b726a9c370f6b8edbcaab35e822a46d1bd346f43","city_name":"هشتپر","city_creation_date":"1330","city_division_code":"70192","district_name":"مرکزی","county_name":"طوالش","province_name":"گیلان"},{"id":"city_65b89b03f2f3a335ba43afa3a9847712a70c3f79","city_name":"هشتجین","city_creation_date":"1372","city_division_code":"70552","district_name":"خورش رستم","county_name":"خلخال","province_name":"اردبیل"},{"id":"city_b773ae2f4933f58002d47a61dac97ddc13b96021","city_name":"هشترود","city_creation_date":"1330","city_division_code":"70183","district_name":"مرکزی","county_name":"هشترود","province_name":"آذربایجان شرقی"},{"id":"city_e688ad1a315eac37bdb47c11db227233e0da4e03","city_name":"هشتگرد","city_creation_date":"1358","city_division_code":"70457","district_name":"مرکزی","county_name":"ساوجبلاغ","province_name":"البرز"},{"id":"city_fcfb308c2658fb42973c96b9a61dacb3ee5cbbeb","city_name":"هفت چشمه","city_creation_date":"1389","city_division_code":"71125","district_name":"کاکاوند","county_name":"دلفان","province_name":"لرستان"},{"id":"city_b7a7876c7af8f07fec0b8dddecae68a423f859fc","city_name":"هفتگل","city_creation_date":"1346","city_division_code":"70425","district_name":"مرکزی","county_name":"هفتگل","province_name":"خوزستان"},{"id":"city_9351ab88ab9fb767bee9086c3683fbbc32ca3c87","city_name":"هفشجان","city_creation_date":"1355","city_division_code":"70448","district_name":"مرکزی","county_name":"شهر کرد","province_name":"چهار محال و بختیاری"},{"id":"city_9d53cc41b185eb9ce4e7ef45fd73276062143ee9","city_name":"هلشی","city_creation_date":"1379","city_division_code":"70824","district_name":"فیروز آباد","county_name":"کرمانشاه","province_name":"کرمانشاه"},{"id":"city_6db371c763989ca9897120f801585a169ccdd3f4","city_name":"هماشهر","city_creation_date":"1389","city_division_code":"71131","district_name":"پاریز","county_name":"سیرجان","province_name":"کرمان"},{"id":"city_cac1d2bde772cb19631803cd2480aeb904cda20c","city_name":"هماشهر","city_creation_date":"1389","city_division_code":"71112","district_name":"همایجان","county_name":"سپیدان","province_name":"فارس"},{"id":"city_7d69d8ec30586996f046bbf544bc6277c9225011","city_name":"همت آباد","city_creation_date":"1387","city_division_code":"71078","district_name":"طاغنکوه","county_name":"تخت جلگه","province_name":"خراسان رضوی"},{"id":"city_e0ea52ea9e943871801a70c65b09d3b81f2fc5dc","city_name":"همدان","city_creation_date":"1290","city_division_code":"70001","district_name":"مرکزی","county_name":"همدان","province_name":"همدان"},{"id":"city_17808ffa5b3e8d30ae19224aed499d2edb218d5c","city_name":"هندودر","city_creation_date":"1379","city_division_code":"70852","district_name":"سربند","county_name":"شازند","province_name":"مرکزی"},{"id":"city_ed3b010138987ca958ab2e04adda685126cb0aee","city_name":"هندیجان","city_creation_date":"1337","city_division_code":"70277","district_name":"مرکزی","county_name":"هندیجان","province_name":"خوزستان"},{"id":"city_75869b5aa2c54367888a150f3a5d8d5b2733f3db","city_name":"هوراند","city_creation_date":"1376","city_division_code":"70680","district_name":"هوراند","county_name":"اهر","province_name":"آذربایجان شرقی"},{"id":"city_aee9de3e675ba7ca0bc467b76a5a9fd9daf3ca35","city_name":"هویزه","city_creation_date":"1327","city_division_code":"70165","district_name":"مرکزی","county_name":"هویزه","province_name":"خوزستان"},{"id":"city_bd45bf9423cca82c14a4175ff2d2baf1234a1a20","city_name":"هیدج","city_creation_date":"1361","city_division_code":"70467","district_name":"مرکزی","county_name":"ابهر","province_name":"زنجان"},{"id":"city_cb4184593242b8be34febe047bcea13db26696de","city_name":"هیدوچ","city_creation_date":"1383","city_division_code":"70945","district_name":"هیدوچ","county_name":"سیب سوران","province_name":"سیستان و بلوچستان"},{"id":"city_3b749ce395d1d0db6f72f2d0fa5c29200c3340dc","city_name":"هیر","city_creation_date":"1375","city_division_code":"70672","district_name":"هیر","county_name":"اردبیل","province_name":"اردبیل"},{"id":"city_efcab28234607ea44dff85e8fdafc53401376f1e","city_name":"یاسوج","city_creation_date":"1345","city_division_code":"70415","district_name":"مرکزی","county_name":"بویر احمد","province_name":"کهگیلویه و بویراحمد"},{"id":"city_b3df06f9c8f9835397140a0f76bf2bff70c5aafe","city_name":"یاسوکند","city_creation_date":"1372","city_division_code":"70574","district_name":"کرانی","county_name":"بیجار","province_name":"کردستان"},{"id":"city_d8b9a708c03cdd1425bb20ca61647a8720a57e43","city_name":"یامچی","city_creation_date":"1379","city_division_code":"70759","district_name":"یامچی","county_name":"مرند","province_name":"آذربایجان شرقی"},{"id":"city_91bf2b12fc292c09b28dff7d60fc34edd3e78f11","city_name":"یزد","city_creation_date":"1305","city_division_code":"70035","district_name":"مرکزی","county_name":"یزد","province_name":"یزد"},{"id":"city_75bd52561acee6ecbc8f67083f3dac9e21e5a3c4","city_name":"یزدان شهر","city_creation_date":"1383","city_division_code":"70943","district_name":"یزدان آباد","county_name":"زرند","province_name":"کرمان"},{"id":"city_2718b80a9957080a2f9152905d3925b3cc80c7fc","city_name":"یونسی","city_creation_date":"1383","city_division_code":"70959","district_name":"یونسی","county_name":"بجستان","province_name":"خراسان رضوی"}]')


	// Register iran angular module
	// iran service avilable
	if (typeof angular === 'object') {
		angular.module('iran', [])
		.service('iran', function () {
			return iran;
		});
	}

	// AMD registration happens at the end for compatibility with AMD loaders
	// that may not enforce next-turn semantics on modules. Even though general
	// practice for AMD registration is to be anonymous, iran registers
	// as a named module because, like jQuery, it is a base library that is
	// popular enough to be bundled in a third party lib, but not be part of
	// an AMD load request. Those cases could generate an error when an
	// anonymous define() is called outside of a loader request.
	if (typeof define === 'function' && define.amd) {
		define('iran', [], function() {
			return iran;
		});
	}
}.call(this));