use ark_ff::{
    fields::fp3::{Fp3, Fp3Config},
    AdditiveGroup, Field, MontFp,
};

use crate::Fq;

pub type Fq3 = Fp3<Fq3Config>;

pub struct Fq3Config;

impl Fp3Config for Fq3Config {
    type Fp = Fq;

    /// NONRESIDUE = 3
    // Fq3 = Fq\[u\]/u^3-3
    const NONRESIDUE: Fq = MontFp!("3");

    // (MODULUS^3 - 1) % 2^TWO_ADICITY == 0
    const TWO_ADICITY: u32 = 1;

    // (T-1)/2 with T = (MODULUS^3-1) / 2^TWO_ADICITY
    #[rustfmt::skip]
    const TRACE_MINUS_ONE_DIV_TWO: &'static [u64] = &[
        0x22d18a101ce54f7d,
        0x354335b0e7c460e8,
        0x8014efd2b7ade04d,
        0x3a3c62ab52e0a2c1,
        0x79ce8405b95dd2ee,
        0x24f75cbd8559a2b6,
        0x2519d1267e548214,
        0xea0034421965f6c8,
        0xbbaa92b6aca7d134,
        0x9ec0892af11e70cc,
        0x06e6ab40a2fd09ec,
        0xd333987617c1542a,
        0xdcb52167b1f0ae0f,
        0xeffa098d77a86e52,
        0x9fe0d744c24ed062,
        0x7df249c9ef981da1,
        0x01337d754cef36fa,
        0xf84c4f79c259bd8b,
        0x6552e19d7dc57335,
        0x9f2cab11727d9c89,
        0xe5cc4da17a684263,
        0xaab0632027470c14,
        0xb841a2fe447f48a3,
        0x6e705db09cb2c6c9,
        0x51d3c82bd5de018d,
        0xf0bb21ffbef26bd1,
        0x294ce678e6a4c0ff,
        0x130ad731f57d4c85,
        0xa1e367e5eb70a85b,
        0xd1b2d73d567515cd,
        0x0527dddbc3e9f165,
        0x1d9c04e0098344e7,
        0x5db616f391729475,
        0xd2834b1fae1c2c1b,
        0x7cf1b8c728557851,
        0x218325db61d6ebd,
    ];

    // NONRESIDUE^T % q
    const QUADRATIC_NONRESIDUE_TO_T: Fq3 = Fq3::new(Fq::ONE, Fq::ZERO, Fq::ZERO);

    // NQR ^ (MODULUS^i - 1)/3, i=0,1,2 with NQR = u = (0,1,0)
    const FROBENIUS_COEFF_FP3_C1: &'static [Fq] = &[
        Fq::ONE,
        MontFp!("451452499708746243421442696394275804592767119751118962106882058158528025766103643615697202253207413006991058800455542766924935899310685166148099708594514571753800103096705086912881023032622324847956780035251378028187894066092550170"),
        MontFp!("45145249970874624351989341074938425649635187579061891330552522940808608853609996870081473355016347159316471246898921838485114512270394210846704144343327596979902763990851861938135223607962336094530115195266656782121333243874349260"),
    ];

    // NQR ^ (2*MODULUS^i - 2)/3, i=0,1,2 with NQR = u = (0,1,0)
    const FROBENIUS_COEFF_FP3_C2: &'static [Fq] = &[
        Fq::ONE,
        MontFp!("45145249970874624351989341074938425649635187579061891330552522940808608853609996870081473355016347159316471246898921838485114512270394210846704144343327596979902763990851861938135223607962336094530115195266656782121333243874349260"),
        MontFp!("451452499708746243421442696394275804592767119751118962106882058158528025766103643615697202253207413006991058800455542766924935899310685166148099708594514571753800103096705086912881023032622324847956780035251378028187894066092550170"),
    ];
}
