use ark_ff::{
    fields::fp4::{Fp4, Fp4Config},
    AdditiveGroup, Field, MontFp,
};

use crate::{Fq, Fq2, Fq2Config};

pub type Fq4 = Fp4<Fq4Config>;

pub struct Fq4Config;

impl Fp4Config for Fq4Config {
    type Fp2Config = Fq2Config;

    const NONRESIDUE: Fq2 = Fq2::new(Fq::ZERO, Fq::ONE);

    // Coefficients for the Frobenius automorphism.
    // c1[0] = 1,
    // c1[1] = 7684163245453501615621351552473337069301082060976805004625011694147890954040864167002308
    // c1[2] = 475922286169261325753349249653048451545124879242694725395555128576210262817955800483758080
    // c1[3] = 468238122923807824137727898100575114475823797181717920390930116882062371863914936316755773
    //
    // These are calculated as
    // `FROBENIUS_COEFF_FP4_C1[i] = Fp2Config::NONRESIDUE^((q^i - 1) / 4)`.
    const FROBENIUS_COEFF_FP4_C1: &'static [Fq] = &[
        Fq::ONE,
        MontFp!("7684163245453501615621351552473337069301082060976805004625011694147890954040864167002308"),
        MontFp!("475922286169261325753349249653048451545124879242694725395555128576210262817955800483758080"),
        MontFp!("468238122923807824137727898100575114475823797181717920390930116882062371863914936316755773"),
    ];
}
