## 开发注意事项

目前 scss 里大量使用了 css 自定义变量，它和之前的 scss 变量明显不同，需要注意一下几点：

- 目前依然有使用 scss 变量，因为有大量颜色计算，这些计算没法在自定义变量中使用，是所以目前是用两者结合的方式，想修改颜色最好的方式还是 scss 变量，但其他都能方便使用自定义变量修改，后续有可能基于 hsl 的方式来使得颜色也动态计算。
- components 内的组件不要使用 @if、lighten、darken 等函数，这些功能无法支持自定义变量，解决办法是新增变量，放 `_properties.scss` 里，这样也能支持用户自定义。
- 负数需要使用 `calc(var(--xxx) * -1)`。
- 在变量中使用 sass 功能需要用 `#{}` 包裹，比如 `--borderColorLight: #{lighten($borderColor, 5%)}`;
- 在 Chrome 开发工具中点变量会没反应，是因为我们的变量太多了，得先在开发工具里点一下显示全部变量。
