/**
 * 统计一下目前实现函数的数量
 */

import {functions} from '../src/excel/formula/functions/functions';
import {FormulaVisitor} from '../src/excel/formula/eval/FormulaVisitor';
import {
  FunctionName,
  builtinFunctionSet
} from '../src/excel/formula/builtinFunctions';
import {specialFunctions} from '../src/excel/formula/functions/special';

const mockEnv = {} as any;

const formulaVisitor = new FormulaVisitor(mockEnv);

console.log(`functions count: ${functions.size + specialFunctions.size}`);

const formulsjs = new Set([
  'ABS',
  'ACCRINT',
  'ACOS',
  'ACOSH',
  'ACOT',
  'ACOTH',
  'AGGREGATE',
  'AND',
  'ARABIC',
  'ASIN',
  'ASINH',
  'ATAN',
  'ATAN2',
  'ATANH',
  'AVEDEV',
  'AVERAGE',
  'AVERAGEA',
  'AVERAGEIF',
  'AVERAGEIFS',
  'BASE',
  'BESSELI',
  'BESSELJ',
  'BESSELK',
  'BESSELY',
  'BETADIST',
  'BETAINV',
  'BIN2DEC',
  'BIN2HEX',
  'BIN2OCT',
  'BINOMDIST',
  'BITAND',
  'BITLSHIFT',
  'BITOR',
  'BITRSHIFT',
  'BITXOR',
  'CEILING',
  'CEILINGMATH',
  'CEILINGPRECISE',
  'CHAR',
  'CHIDIST',
  'CHIDISTRT',
  'CHIINV',
  'CHIINVRT',
  'CHITEST',
  'CHOOSE',
  'CLEAN',
  'CODE',
  'COLUMN',
  'COLUMNS',
  'COMBIN',
  'COMBINA',
  'COMPLEX',
  'CONCAT',
  'CONCATENATE',
  'CONVERT',
  'CORREL',
  'COS',
  'COSH',
  'COT',
  'COTH',
  'COUNT',
  'COUNTA',
  'COUNTBLANK',
  'COUNTIF',
  'COUNTIFS',
  'COUPDAYS',
  'COVAR',
  'COVARIANCEP',
  'COVARIANCES',
  'CRITBINOM',
  'CSC',
  'CSCH',
  'CUMIPMT',
  'CUMPRINC',
  'DATE',
  'DATEDIF',
  'DATEVALUE',
  'DAVERAGE',
  'DAY',
  'DAYS',
  'DAYS360',
  'DB',
  'DCOUNT',
  'DCOUNTA',
  'DDB',
  'DEC2BIN',
  'DEC2HEX',
  'DEC2OCT',
  'DECIMAL',
  'DEGREES',
  'DELTA',
  'DEVSQ',
  'DGET',
  'DISC',
  'DMAX',
  'DMIN',
  'DOLLAR',
  'DOLLARDE',
  'DOLLARFR',
  'DPRODUCT',
  'DSTDEV',
  'DSTDEVP',
  'DSUM',
  'DVAR',
  'DVARP',
  'EDATE',
  'EFFECT',
  'EOMONTH',
  'ERF',
  'ERFC',
  'EVEN',
  'EXACT',
  'EXP',
  'EXPONDIST',
  'FACT',
  'FACTDOUBLE',
  'FALSE',
  'FDIST',
  'FDISTRT',
  'FIND',
  'FINV',
  'FINVRT',
  'FISHER',
  'FISHERINV',
  'FIXED',
  'FLOOR',
  'FLOORMATH',
  'FLOORPRECISE',
  'FORECAST',
  'FREQUENCY',
  'FTEST',
  'FV',
  'FVSCHEDULE',
  'GAMMA',
  'GAMMADIST',
  'GAMMAINV',
  'GAMMALN',
  'GAMMALNPRECISE',
  'GAUSS',
  'GCD',
  'GEOMEAN',
  'GESTEP',
  'GROWTH',
  'HARMEAN',
  'HEX2BIN',
  'HEX2DEC',
  'HEX2OCT',
  'HLOOKUP',
  'HOUR',
  'HYPGEOMDIST',
  'IF',
  'IFERROR',
  'IFNA',
  'IFS',
  'IMABS',
  'IMAGINARY',
  'IMARGUMENT',
  'IMCONJUGATE',
  'IMCOS',
  'IMCOSH',
  'IMCOT',
  'IMCSC',
  'IMCSCH',
  'IMDIV',
  'IMEXP',
  'IMLN',
  'IMLOG10',
  'IMLOG2',
  'IMPOWER',
  'IMPRODUCT',
  'IMREAL',
  'IMSEC',
  'IMSECH',
  'IMSIN',
  'IMSINH',
  'IMSQRT',
  'IMSUB',
  'IMSUM',
  'IMTAN',
  'INDEX',
  'INT',
  'INTERCEPT',
  'IPMT',
  'IRR',
  'ISBLANK',
  'ISERR',
  'ISERROR',
  'ISEVEN',
  'ISLOGICAL',
  'ISNA',
  'ISNONTEXT',
  'ISNUMBER',
  'ISODD',
  'ISOWEEKNUM',
  'ISPMT',
  'ISTEXT',
  'KURT',
  'LARGE',
  'LCM',
  'LEFT',
  'LEN',
  'LINEST',
  'LN',
  'LOG',
  'LOG10',
  'LOGEST',
  'LOGINV',
  'LOGNORMDIST',
  'LOGNORMINV',
  'LOOKUP',
  'LOWER',
  'MATCH',
  'MAX',
  'MAXA',
  'MAXIFS',
  'MEDIAN',
  'MID',
  'MIN',
  'MINA',
  'MINIFS',
  'MINUTE',
  'MIRR',
  'MMULT',
  'MOD',
  'MODEMULT',
  'MODESNGL',
  'MONTH',
  'MROUND',
  'MULTINOMIAL',
  'MUNIT',
  'N',
  'NA',
  'NEGBINOMDIST',
  'NETWORKDAYS',
  'NETWORKDAYSINTL',
  'NOMINAL',
  'NORMDIST',
  'NORMINV',
  'NORMSDIST',
  'NORMSINV',
  'NOT',
  'NOW',
  'NPER',
  'NPV',
  'NUMBERVALUE',
  'OCT2BIN',
  'OCT2DEC',
  'OCT2HEX',
  'ODD',
  'OR',
  'PDURATION',
  'PEARSON',
  'PERCENTILEEXC',
  'PERCENTILEINC',
  'PERCENTRANKEXC',
  'PERCENTRANKINC',
  'PERMUT',
  'PERMUTATIONA',
  'PHI',
  'PI',
  'PMT',
  'POISSONDIST',
  'POWER',
  'PPMT',
  'PRICEDISC',
  'PROB',
  'PRODUCT',
  'PROPER',
  'PV',
  'QUARTILEEXC',
  'QUARTILEINC',
  'QUOTIENT',
  'RADIANS',
  'RAND',
  'RANDBETWEEN',
  'RANKAVG',
  'RANKEQ',
  'RATE',
  'REPLACE',
  'REPT',
  'RIGHT',
  'ROMAN',
  'ROUND',
  'ROUNDDOWN',
  'ROUNDUP',
  'ROW',
  'ROWS',
  'RRI',
  'RSQ',
  'SEARCH',
  'SEC',
  'SECH',
  'SECOND',
  'SERIESSUM',
  'SIGN',
  'SIN',
  'SINH',
  'SKEW',
  'SKEWP',
  'SLN',
  'SLOPE',
  'SMALL',
  'SORT',
  'SQRT',
  'SQRTPI',
  'STANDARDIZE',
  'STDEVA',
  'STDEVP',
  'STDEVPA',
  'STDEVS',
  'STEYX',
  'SUBSTITUTE',
  'SUBTOTAL',
  'SUM',
  'SUMIF',
  'SUMIFS',
  'SUMPRODUCT',
  'SUMSQ',
  'SUMX2MY2',
  'SUMX2PY2',
  'SUMXMY2',
  'SWITCH',
  'SYD',
  'T',
  'TAN',
  'TANH',
  'TBILLEQ',
  'TBILLPRICE',
  'TBILLYIELD',
  'TDIST',
  'TDISTRT',
  'TEXT',
  'TEXTJOIN',
  'TIME',
  'TIMEVALUE',
  'TINV',
  'TODAY',
  'TRANSPOSE',
  'TREND',
  'TRIM',
  'TRIMMEAN',
  'TRUE',
  'TRUNC',
  'TTEST',
  'TYPE',
  'UNICHAR',
  'UNICODE',
  'UNIQUE',
  'UPPER',
  'VALUE',
  'VARA',
  'VARP',
  'VARPA',
  'VARS',
  'VLOOKUP',
  'WEEKDAY',
  'WEEKNUM',
  'WORKDAY',
  'XIRR',
  'XNPV',
  'XOR',
  'YEAR',
  'YEARFRAC',
  'ZTEST'
]);

for (const key of formulsjs) {
  if (
    !functions.has(key as FunctionName) &&
    !specialFunctions.has(key) &&
    builtinFunctionSet.has(key as FunctionName)
  ) {
    console.log(key);
  }
}
