import moment from 'moment';

export function mockValue(schema: any) {
  const placeholderImage = `data:image/svg+xml,%3C%3Fxml version='1.0' standalone='no'%3F%3E%3C!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN' 'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'%3E%3Csvg t='1631083237695' class='icon' viewBox='0 0 1024 1024' version='1.1' xmlns='http://www.w3.org/2000/svg' p-id='2420' xmlns:xlink='http://www.w3.org/1999/xlink' width='1024' height='1024'%3E%3Cdefs%3E%3Cstyle type='text/css'%3E%3C/style%3E%3C/defs%3E%3Cpath d='M959.872 128c0.032 0.032 0.096 0.064 0.128 0.128v767.776c-0.032 0.032-0.064 0.096-0.128 0.128H64.096c-0.032-0.032-0.096-0.064-0.128-0.128V128.128c0.032-0.032 0.064-0.096 0.128-0.128h895.776zM960 64H64C28.8 64 0 92.8 0 128v768c0 35.2 28.8 64 64 64h896c35.2 0 64-28.8 64-64V128c0-35.2-28.8-64-64-64z' p-id='2421' fill='%23bfbfbf'%3E%3C/path%3E%3Cpath d='M832 288c0 53.024-42.976 96-96 96s-96-42.976-96-96 42.976-96 96-96 96 42.976 96 96zM896 832H128V704l224-384 256 320h64l224-192z' p-id='2422' fill='%23bfbfbf'%3E%3C/path%3E%3C/svg%3E`;
  if (
    schema.type === 'date' ||
    schema.type === 'datetime' ||
    schema.type === 'time' ||
    schema.type === 'month' ||
    schema.type === 'static-date' ||
    schema.type === 'static-datetime' ||
    schema.type === 'static-time' ||
    schema.type === 'static-month' ||
    schema.type === 'input-date' ||
    schema.type === 'input-datetime' ||
    schema.type === 'input-time' ||
    schema.type === 'input-month'
  ) {
    return moment().format('X');
  } else if (schema.type === 'image' || schema.type === 'static-image') {
    return placeholderImage;
  } else if (schema.type === 'images' || schema.type === 'static-images') {
    return [placeholderImage];
  } else if (schema.type === 'number' || schema.type === 'input-number') {
    return (Math.random() * 1000).toFixed(schema.precision ?? 0);
  }

  return '假数据';
}
