import FormulaError from '../../FormulaError';
import {TestCase, buildEnv, testEvalCases} from './buildEnv';

const data = [[]];

const env = buildEnv(data);

function runTest(testCase: TestCase) {
  testEvalCases(testCase, env);
}

test('COUPDAYS', () => {
  // 还有很多用例没从 formulajs 里拷出来
  runTest({
    'COUPDAYS("01/25/2011", "11/15/2011", 2, 1)': 181
  });
});

test('CUMIPMT', () => {
  runTest({
    'CUMIPMT(0.1 / 12, 30 * 12, 100000, 13, 24, 0)': -9916.77251395708
  });
});

test('CUMPRINC', () => {
  runTest({
    'CUMPRINC(0.1 / 12, 30 * 12, 100000, 13, 24, 0)': -614.0863271085149
  });
});

test('DB', () => {
  runTest({
    'DB(1000000, 100000, 6, 1)': 319000
  });
});

test('DDB', () => {
  runTest({
    'DDB(1000000, 100000, 6, 1)': 333333.3333333333
  });
});

test('DISC', () => {
  runTest({
    'DISC("01/04/2023", "01/31/2023", 99.71275, 100, 0)': 0.0383
  });
});

test('DOLLARDE', () => {
  runTest({
    'DOLLARDE(1.1, 4)': 1.25,
    'DOLLARDE(1.1, 1.5)': 1.1
  });
});

test('DOLLARFR', () => {
  runTest({
    'DOLLARFR(1.1, 1)': 1.1,
    'DOLLARFR(1.25, 4)': 1.1
  });
});

test('EFFECT', () => {
  runTest({
    'EFFECT(0.1, 4)': 0.10381289062499977
  });
});

test('FV', () => {
  runTest({
    'FV(0.06 / 12, 10, -200, -500, 1)': 2581.4033740601185
  });
});

test('FVSCHEDULE', () => {
  runTest({
    'FVSCHEDULE(100, {0.09, 0.1, 0.11})': 133.08900000000003
  });
});

test('IPMT', () => {
  runTest({
    'IPMT(0.1 / 12, 6, 2 * 12, 100000, 1000000, 0)': 928.8235718400465
  });
});

test('IRR', () => {
  runTest({
    'IRR({-75000, 12000, 15000, 18000, 21000, 24000})': 0.05715142887178467
  });
});

test('ISPMT', () => {
  runTest({
    'ISPMT(0.1 / 12, 6, 2 * 12, 100000)': -625
  });
});

test('MIRR', () => {
  runTest({
    'MIRR({-75000, 12000, 15000, 18000, 21000, 24000}, 0.1, 0.12)': 0.07971710360838036
  });
});

test('NOMINAL', () => {
  runTest({
    'NOMINAL(0.1, 4)': 0.09645475633778045
  });
});

test('NPER', () => {
  runTest({
    'NPER(0, -100, -1000, 10000)': 90
  });
});

test('NPV', () => {
  runTest({
    'NPV(0.1, -10000, 2000, 4000, 8000)': 1031.3503176012546
  });
});

test('PDURATION', () => {
  runTest({
    'PDURATION(0.1, 1000, 2000)': 7.272540897341714
  });
});

test('PMT', () => {
  runTest({
    'PMT(0.06 / 12, 18 * 12, 0, 50000)': -129.0811608679973
  });
});

test('PPMT', () => {
  runTest({
    'PPMT(0.1 / 12, 1, 2 * 12, 2000)': -75.62318600836667
  });
});

test('PRICEDISC', () => {
  runTest({
    'PRICEDISC("01/05/2023", "01/31/2023", 0.038, 100, 0)': 99.72555556
  });
});

test('PV', () => {
  runTest({
    'PV(0.1 / 12, 2 * 12, 1000, 10000, 0)': -29864.950264779152
  });
});

test('RATE', () => {
  runTest({
    'RATE(2 * 12, -1000, -10000, 100000)': 0.06517891177181546
  });
});

test('RRI', () => {
  runTest({
    'RRI(8, 10000, 11000)': 0.011985024140399592
  });
});

test('SLN', () => {
  runTest({
    'SLN(30000, 7500, 10)': 2250
  });
});

test('SYD', () => {
  runTest({
    'SYD(30, 7, 10, 1)': 4.181818181818182
  });
});

test('TBILLEQ', () => {
  runTest({
    'TBILLEQ("03/31/2008", "06/01/2008", 0.0914)': 0.09412721351734614
  });
});

test('TBILLPRICE', () => {
  runTest({
    'TBILLPRICE("03/31/2008", "06/01/2008", 0.0914)': 98.45127777777778
  });
});

test('TBILLYIELD', () => {
  runTest({
    'TBILLYIELD("03/31/2008", "06/01/2008", 98.45127777777778)': 0.09283779963354702
  });
});

test('XIRR', () => {
  runTest({
    'XIRR({-10000, 2750, 4250, 3250, 2750}, {"01/01/2008", "03/01/2008", "10/30/2008", "02/15/2009", "04/01/2009"}, 0.1)': 0.373362535
  });
});

test('XNPV', () => {
  // 这个结果有偏差，不知道为啥
  runTest({
    'XNPV(0.09, {-10000, 2750, 4250, 3250, 2750}, {"01/01/2008", "03/01/2008", "10/30/2008", "02/15/2009", "04/01/2009"})': 2086.647602031535
  });
});
