/** generated by genPresetIcons.ts, do not edit */

export type IconNames =
  | 'down'
  | 'side'
  | 'up'
  | 'downGray'
  | 'sideGray'
  | 'upGray'
  | 'flagRed'
  | 'flagYellow'
  | 'flagGreen'
  | 'diamondRed'
  | 'triangleYellow'
  | 'circleGreen'
  | 'crossRed'
  | 'exclamationYellow'
  | 'checkGreen'
  | 'crossSymbolRed'
  | 'exclamationSymbolYellow'
  | 'checkSymbolGreen'
  | 'circleRed'
  | 'circleYellow'
  | 'trafficLightRed'
  | 'trafficLightYellow'
  | 'trafficLightGreen'
  | 'downIncline'
  | 'upIncline'
  | 'downInclineGray'
  | 'upInclineGray'
  | 'oneFilledBars'
  | 'twoFilledBars'
  | 'threeFilledBars'
  | 'fourFilledBars'
  | 'circleBlack'
  | 'circleGray'
  | 'circleLightRed'
  | 'circleWhite'
  | 'circleThreeWhiteQuarters'
  | 'circleTwoWhiteQuarters'
  | 'circleOneWhiteQuarter'
  | 'zeroFilledBars';

export const presetIcons: Record<IconNames, string> = {
  down: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNNy41IDE1TDAuNSA4SDVWMUgxMFY4SDE0LjVMNy41IDE1WiIgZmlsbD0iI0ZGOTE5OCIgLz4KCTxwYXRoIGQ9Ik0xMCA4LjVIMTMuMjkyOUw3LjUgMTQuMjkyOUwxLjcwNzExIDguNUg1SDUuNVY4VjEuNUg5LjVWOFY4LjVIMTBaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  side: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTUgOC41TDggMTUuNUw4IDExTDEgMTFMMSA2TDggNkw4IDEuNUwxNSA4LjVaIiBmaWxsPSIjRjhEQjhGIiAvPgoJPHBhdGggZD0iTTguNSA2TDguNSAyLjcwNzExTDE0LjI5MjkgOC41TDguNSAxNC4yOTI5TDguNSAxMUw4LjUgMTAuNUw4IDEwLjVMMS41IDEwLjVMMS41IDYuNUw4IDYuNUw4LjUgNi41TDguNSA2WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  up: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNNy41IDFMMTQuNSA4TDEwIDhWMTVMNSAxNUw1IDhMMC41IDhMNy41IDFaIiBmaWxsPSIjQTJEREFBIiAvPgoJPHBhdGggZD0iTTUgNy41TDEuNzA3MTEgNy41TDcuNSAxLjcwNzExTDEzLjI5MjkgNy41TDEwIDcuNUg5LjVWOFYxNC41TDUuNSAxNC41TDUuNSA4VjcuNUg1WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  downGray:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxnIGNsaXAtcGF0aD0idXJsKCNjbGlwMCkiPgoJCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTQgMTRMNC4xMDA1MSAxNEw3LjI4MjQ5IDEwLjgxOEwyLjMzMjc0IDUuODY4MjdMNS44NjgyNyAyLjMzMjc0TDEwLjgxOCA3LjI4MjQ5TDE0IDQuMTAwNTFMMTQgMTRaIiBmaWxsPSIjNTA1MDUwIiAvPgoJCTxwYXRoIGQ9Ik0xMS4xNzE2IDcuNjM2MDRMMTMuNSA1LjMwNzYxTDEzLjUgMTMuNUw1LjMwNzYxIDEzLjVMNy42MzYwNCAxMS4xNzE2TDcuOTg5NTkgMTAuODE4TDcuNjM2MDQgMTAuNDY0NUwzLjAzOTg0IDUuODY4MjdMNS44NjgyNyAzLjAzOTg0TDEwLjQ2NDUgNy42MzYwNEwxMC44MTggNy45ODk1OUwxMS4xNzE2IDcuNjM2MDRaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPC9nPgoJPGRlZnM+CgkJPGNsaXBQYXRoIGlkPSJjbGlwMCI+CgkJCTxyZWN0IHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgZmlsbD0id2hpdGUiIC8+CgkJPC9jbGlwUGF0aD4KCTwvZGVmcz4KPC9zdmc+Cg==',
  sideGray:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTUgOC41TDggMTUuNUw4IDExTDEgMTFMMSA2TDggNkw4IDEuNUwxNSA4LjVaIiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTguNSA2TDguNSAyLjcwNzExTDE0LjI5MjkgOC41TDguNSAxNC4yOTI5TDguNSAxMUw4LjUgMTAuNUw4IDEwLjVMMS41IDEwLjVMMS41IDYuNUw4IDYuNUw4LjUgNi41TDguNSA2WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  upGray:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNNy41IDFMMTQuNSA4TDEwIDhWMTVMNSAxNUw1IDhMMC41IDhMNy41IDFaIiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTUgNy41TDEuNzA3MTEgNy41TDcuNSAxLjcwNzExTDEzLjI5MjkgNy41TDEwIDcuNUg5LjVWOFYxNC41TDUuNSAxNC41TDUuNSA4VjcuNUg1WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  flagRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik01IDFMNSAxMEwxNCA1LjVMNSAxWiIgZmlsbD0iI0ZGOTE5OCIgLz4KCTxwYXRoIGQ9Ik0xMi44ODIgNS41TDUuNSA5LjE5MDk4TDUuNSAxLjgwOTAyTDEyLjg4MiA1LjVaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iMiIgeT0iMC45OTk5OTYiIHdpZHRoPSIyIiBoZWlnaHQ9IjE0IiBmaWxsPSIjNzI3MjcyIiAvPgo8L3N2Zz4K',
  flagYellow:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik01IDFMNSAxMEwxNCA1LjVMNSAxWiIgZmlsbD0iI0Y4REI4RiIgLz4KCTxwYXRoIGQ9Ik0xMi44ODIgNS41TDUuNSA5LjE5MDk4TDUuNSAxLjgwOTAyTDEyLjg4MiA1LjVaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iMiIgeT0iMC45OTk5OTYiIHdpZHRoPSIyIiBoZWlnaHQ9IjE0IiBmaWxsPSIjNzI3MjcyIiAvPgo8L3N2Zz4K',
  flagGreen:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik01IDFMNSAxMEwxNCA1LjVMNSAxWiIgZmlsbD0iI0EyRERBQSIgLz4KCTxwYXRoIGQ9Ik0xMi44ODIgNS41TDUuNSA5LjE5MDk4TDUuNSAxLjgwOTAyTDEyLjg4MiA1LjVaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iMiIgeT0iMC45OTk5OTYiIHdpZHRoPSIyIiBoZWlnaHQ9IjE0IiBmaWxsPSIjNzI3MjcyIiAvPgo8L3N2Zz4K',
  diamondRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxyZWN0IHg9IjgiIHk9IjEiIHdpZHRoPSI5Ljg5OTUiIGhlaWdodD0iOS44OTk1IiByeD0iMiIgdHJhbnNmb3JtPSJyb3RhdGUoNDUgOCAxKSIgZmlsbD0iI0ZGOTE5OCIgLz4KCTxyZWN0IHg9IjgiIHk9IjEuNzA3MTEiIHdpZHRoPSI4Ljg5OTUiIGhlaWdodD0iOC44OTk1IiByeD0iMS41IiB0cmFuc2Zvcm09InJvdGF0ZSg0NSA4IDEuNzA3MTEpIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  triangleYellow:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xIDE1SDE1TDggMUwxIDE1WiIgZmlsbD0iI0Y4REI4RiIgLz4KCTxwYXRoIGQ9Ik04IDIuMTE4MDNMMTQuMTkxIDE0LjVIMS44MDkwMkw4IDIuMTE4MDNaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  circleGreen:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xNSA4QzE1IDExLjg2NiAxMS44NjYgMTUgOCAxNUM0LjEzNDAxIDE1IDEgMTEuODY2IDEgOEMxIDQuMTM0MDEgNC4xMzQwMSAxIDggMUMxMS44NjYgMSAxNSA0LjEzNDAxIDE1IDhaIiBmaWxsPSIjQTJEREFBIiAvPgoJPHBhdGggZD0iTTE0LjUgOEMxNC41IDExLjU4OTkgMTEuNTg5OSAxNC41IDggMTQuNUM0LjQxMDE1IDE0LjUgMS41IDExLjU4OTkgMS41IDhDMS41IDQuNDEwMTUgNC40MTAxNSAxLjUgOCAxLjVDMTEuNTg5OSAxLjUgMTQuNSA0LjQxMDE1IDE0LjUgOFoiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cjwvc3ZnPgo=',
  crossRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xNC45OTk5IDcuOTk5OTZDMTQuOTk5OSAxMS44NjU5IDExLjg2NTkgMTQuOTk5OSA3Ljk5OTk2IDE0Ljk5OTlDNC4xMzM5OSAxNC45OTk5IDEgMTEuODY1OSAxIDcuOTk5OTZDMSA0LjEzMzk5IDQuMTMzOTkgMSA3Ljk5OTk2IDFDMTEuODY1OSAxIDE0Ljk5OTkgNC4xMzM5OSAxNC45OTk5IDcuOTk5OTZaIiBmaWxsPSIjRkY5MTk4IiAvPgoJPHBhdGggZD0iTTE0LjQ5OTkgNy45OTk5NkMxNC40OTk5IDExLjU4OTggMTEuNTg5OCAxNC40OTk5IDcuOTk5OTYgMTQuNDk5OUM0LjQxMDEzIDE0LjQ5OTkgMS41IDExLjU4OTggMS41IDcuOTk5OTZDMS41IDQuNDEwMTMgNC40MTAxMyAxLjUgNy45OTk5NiAxLjVDMTEuNTg5OCAxLjUgMTQuNDk5OSA0LjQxMDEzIDE0LjQ5OTkgNy45OTk5NloiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTYuNTg1OCA4TDQuMjkyOTEgNS43MDcxMUw1LjcwNzEyIDQuMjkyODlMOC4wMDAwMSA2LjU4NTc5TDEwLjI5MjkgNC4yOTI4OUwxMS43MDcxIDUuNzA3MTFMOS40MTQyMyA4TDExLjcwNzEgMTAuMjkyOUwxMC4yOTI5IDExLjcwNzFMOC4wMDAwMSA5LjQxNDIxTDUuNzA3MTIgMTEuNzA3MUw0LjI5MjkxIDEwLjI5MjlMNi41ODU4IDhaIiBmaWxsPSJ3aGl0ZSIgLz4KPC9zdmc+Cg==',
  exclamationYellow:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xNSA4QzE1IDExLjg2NiAxMS44NjYgMTUgOCAxNUM0LjEzNDAxIDE1IDEgMTEuODY2IDEgOEMxIDQuMTM0MDEgNC4xMzQwMSAxIDggMUMxMS44NjYgMSAxNSA0LjEzNDAxIDE1IDhaIiBmaWxsPSIjRjhEQjhGIiAvPgoJPHBhdGggZD0iTTE0LjUgOEMxNC41IDExLjU4OTkgMTEuNTg5OSAxNC41IDggMTQuNUM0LjQxMDE1IDE0LjUgMS41IDExLjU4OTkgMS41IDhDMS41IDQuNDEwMTUgNC40MTAxNSAxLjUgOCAxLjVDMTEuNTg5OSAxLjUgMTQuNSA0LjQxMDE1IDE0LjUgOFoiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cGF0aCBkPSJNNy4yNzE1MiA4LjY1MzlMNy4wNTk2IDUuNDkwMDlDNy4wMTk4NyA0Ljg3MzYyIDcgNC40MzEwOSA3IDQuMTYyNDhDNyAzLjc5NzAxIDcuMDk0OTIgMy41MTI5OSA3LjI4NDc3IDMuMzEwNDRDNy40NzkwMyAzLjEwMzQ4IDcuNzMyODkgMyA4LjA0NjM2IDNDOC40MjYwNSAzIDguNjc5OTEgMy4xMzIxIDguODA3OTUgMy4zOTYzQzguOTM1OTggMy42NTYxIDkgNC4wMzI1OCA5IDQuNTI1NzZDOSA0LjgxNjM4IDguOTg0NTUgNS4xMTE0IDguOTUzNjQgNS40MTA4M0w4LjY2ODg3IDguNjY3MTFDOC42Mzc5NyA5LjA1NDYgOC41NzE3NCA5LjM1MTgzIDguNDcwMiA5LjU1ODc4QzguMzY4NjUgOS43NjU3NCA4LjIwMDg4IDkuODY5MjIgNy45NjY4OSA5Ljg2OTIyQzcuNzI4NDggOS44NjkyMiA3LjU2MjkxIDkuNzcwMTUgNy40NzAyIDkuNTcxOTlDNy4zNzc0OCA5LjM2OTQ0IDcuMzExMjYgOS4wNjM0MSA3LjI3MTUyIDguNjUzOVpNOC4wMDY2MiAxM0M3LjczNzMxIDEzIDcuNTAxMSAxMi45MTQxIDcuMjk4MDEgMTIuNzQyNEM3LjA5OTM0IDEyLjU2NjMgNyAxMi4zMjE5IDcgMTIuMDA5MkM3IDExLjczNjIgNy4wOTQ5MiAxMS41MDUxIDcuMjg0NzcgMTEuMzE1N0M3LjQ3OTAzIDExLjEyMiA3LjcxNTIzIDExLjAyNTEgNy45OTMzOCAxMS4wMjUxQzguMjcxNTIgMTEuMDI1MSA4LjUwNzczIDExLjEyMiA4LjcwMTk5IDExLjMxNTdDOC45MDA2NiAxMS41MDUxIDkgMTEuNzM2MiA5IDEyLjAwOTJDOSAxMi4zMTc1IDguOTAwNjYgMTIuNTU5NyA4LjcwMTk5IDEyLjczNThDOC41MDMzMSAxMi45MTE5IDguMjcxNTIgMTMgOC4wMDY2MiAxM1oiIGZpbGw9IndoaXRlIiAvPgo8L3N2Zz4K',
  checkGreen:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xNSA4QzE1IDExLjg2NiAxMS44NjYgMTUgOCAxNUM0LjEzNDAxIDE1IDEgMTEuODY2IDEgOEMxIDQuMTM0MDEgNC4xMzQwMSAxIDggMUMxMS44NjYgMSAxNSA0LjEzNDAxIDE1IDhaIiBmaWxsPSIjQTJEREFBIiAvPgoJPHBhdGggZD0iTTE0LjUgOEMxNC41IDExLjU4OTkgMTEuNTg5OSAxNC41IDggMTQuNUM0LjQxMDE1IDE0LjUgMS41IDExLjU4OTkgMS41IDhDMS41IDQuNDEwMTUgNC40MTAxNSAxLjUgOCAxLjVDMTEuNTg5OSAxLjUgMTQuNSA0LjQxMDE1IDE0LjUgOFoiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTEyLjgwNSA1LjU5MzJMNy42MzkxNSAxMi42MDQxTDQuMjQxNjcgOC42NTE4OUw1Ljc1ODMgNy4zNDgxMUw3LjUxODcyIDkuMzk1OTRMMTEuMTk0OSA0LjQwNjhMMTIuODA1IDUuNTkzMloiIGZpbGw9IndoaXRlIiAvPgo8L3N2Zz4K',
  crossSymbolRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNNi4xOTczNSA4TDIgMy44MDI2NUwzLjgwMjY1IDJMOCA2LjE5NzM1TDEyLjE5NzMgMkwxNCAzLjgwMjY1TDkuODAyNjUgOEwxNCAxMi4xOTczTDEyLjE5NzMgMTRMOCA5LjgwMjY1TDMuODAyNjUgMTRMMiAxMi4xOTczTDYuMTk3MzUgOFoiIGZpbGw9IiNGRjkxOTgiIC8+Cgk8cGF0aCBkPSJNOC4zNTM1NSA2LjU1MDlMMTIuMTk3MyAyLjcwNzExTDEzLjI5MjkgMy44MDI2NUw5LjQ0OTEgNy42NDY0NUw5LjA5NTU1IDhMOS40NDkxIDguMzUzNTVMMTMuMjkyOSAxMi4xOTczTDEyLjE5NzMgMTMuMjkyOUw4LjM1MzU1IDkuNDQ5MUw4IDkuMDk1NTVMNy42NDY0NSA5LjQ0OTFMMy44MDI2NSAxMy4yOTI5TDIuNzA3MTEgMTIuMTk3M0w2LjU1MDkgOC4zNTM1NUw2LjkwNDQ1IDhMNi41NTA5IDcuNjQ2NDVMMi43MDcxMSAzLjgwMjY1TDMuODAyNjUgMi43MDcxMUw3LjY0NjQ1IDYuNTUwOUw4IDYuOTA0NDVMOC4zNTM1NSA2LjU1MDlaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  exclamationSymbolYellow:
    'data:image/svg+xml;base64,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',
  checkSymbolGreen:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTQgNC4yOTU3OEw2LjY4MjAzIDE0TDIgOC42NzgyMUwzLjYzNDE3IDcuMjU2MDhMNi41NTIxOCAxMC41NzI4TDEyLjI2MjggM0wxNCA0LjI5NTc4WiIgZmlsbD0iI0EyRERBQSIgLz4KCTxwYXRoIGQ9Ik02Ljk1MTM5IDEwLjg3MzlMMTIuMzYyNiAzLjY5ODE4TDEzLjI5ODIgNC4zOTYwNEw2LjY1MjIgMTMuMjA5MUwyLjcwNzQ2IDguNzI1MzdMMy41ODcyNyA3Ljk1OTczTDYuMTc2NzggMTAuOTAzMUw2LjU4MjAyIDExLjM2MzdMNi45NTEzOSAxMC44NzM5WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  circleRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xNSA4QzE1IDExLjg2NiAxMS44NjYgMTUgOCAxNUM0LjEzNDAxIDE1IDEgMTEuODY2IDEgOEMxIDQuMTM0MDEgNC4xMzQwMSAxIDggMUMxMS44NjYgMSAxNSA0LjEzNDAxIDE1IDhaIiBmaWxsPSIjRkY5MTk4IiAvPgoJPHBhdGggZD0iTTE0LjUgOEMxNC41IDExLjU4OTkgMTEuNTg5OSAxNC41IDggMTQuNUM0LjQxMDE1IDE0LjUgMS41IDExLjU4OTkgMS41IDhDMS41IDQuNDEwMTUgNC40MTAxNSAxLjUgOCAxLjVDMTEuNTg5OSAxLjUgMTQuNSA0LjQxMDE1IDE0LjUgOFoiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cjwvc3ZnPgo=',
  circleYellow:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xNSA4QzE1IDExLjg2NiAxMS44NjYgMTUgOCAxNUM0LjEzNDAxIDE1IDEgMTEuODY2IDEgOEMxIDQuMTM0MDEgNC4xMzQwMSAxIDggMUMxMS44NjYgMSAxNSA0LjEzNDAxIDE1IDhaIiBmaWxsPSIjRjhEQjhGIiAvPgoJPHBhdGggZD0iTTE0LjUgOEMxNC41IDExLjU4OTkgMTEuNTg5OSAxNC41IDggMTQuNUM0LjQxMDE1IDE0LjUgMS41IDExLjU4OTkgMS41IDhDMS41IDQuNDEwMTUgNC40MTAxNSAxLjUgOCAxLjVDMTEuNTg5OSAxLjUgMTQuNSA0LjQxMDE1IDE0LjUgOFoiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cjwvc3ZnPgo=',
  trafficLightRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xIDNDMSAxLjg5NTQzIDEuODk1NDMgMSAzIDFIMTNDMTQuMTA0NiAxIDE1IDEuODk1NDMgMTUgM1YxM0MxNSAxNC4xMDQ2IDE0LjEwNDYgMTUgMTMgMTVIM0MxLjg5NTQzIDE1IDEgMTQuMTA0NiAxIDEzVjNaIiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTMgMS41SDEzQzEzLjgyODQgMS41IDE0LjUgMi4xNzE1NyAxNC41IDNWMTNDMTQuNSAxMy44Mjg0IDEzLjgyODQgMTQuNSAxMyAxNC41SDNDMi4xNzE1NyAxNC41IDEuNSAxMy44Mjg0IDEuNSAxM1YzQzEuNSAyLjE3MTU3IDIuMTcxNTcgMS41IDMgMS41WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KCTxwYXRoIGQ9Ik0xNCA4QzE0IDQuNjg2MjkgMTEuMzEzNyAyIDggMkM0LjY4NjI5IDIgMiA0LjY4NjI5IDIgOEMyIDExLjMxMzcgNC42ODYyOSAxNCA4IDE0QzExLjMxMzcgMTQgMTQgMTEuMzEzNyAxNCA4WiIgZmlsbD0id2hpdGUiIC8+Cgk8cGF0aCBkPSJNMTMgOEMxMyA1LjIzODU4IDEwLjc2MTQgMyA4IDNDNS4yMzg1OCAzIDMgNS4yMzg1OCAzIDhDMyAxMC43NjE0IDUuMjM4NTggMTMgOCAxM0MxMC43NjE0IDEzIDEzIDEwLjc2MTQgMTMgOFoiIGZpbGw9IiNGRjkxOTgiIC8+Cjwvc3ZnPgo=',
  trafficLightYellow:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xIDNDMSAxLjg5NTQzIDEuODk1NDMgMSAzIDFIMTNDMTQuMTA0NiAxIDE1IDEuODk1NDMgMTUgM1YxM0MxNSAxNC4xMDQ2IDE0LjEwNDYgMTUgMTMgMTVIM0MxLjg5NTQzIDE1IDEgMTQuMTA0NiAxIDEzVjNaIiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTMgMS41SDEzQzEzLjgyODQgMS41IDE0LjUgMi4xNzE1NyAxNC41IDNWMTNDMTQuNSAxMy44Mjg0IDEzLjgyODQgMTQuNSAxMyAxNC41SDNDMi4xNzE1NyAxNC41IDEuNSAxMy44Mjg0IDEuNSAxM1YzQzEuNSAyLjE3MTU3IDIuMTcxNTcgMS41IDMgMS41WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KCTxwYXRoIGQ9Ik0xNCA4QzE0IDQuNjg2MjkgMTEuMzEzNyAyIDggMkM0LjY4NjI5IDIgMiA0LjY4NjI5IDIgOEMyIDExLjMxMzcgNC42ODYyOSAxNCA4IDE0QzExLjMxMzcgMTQgMTQgMTEuMzEzNyAxNCA4WiIgZmlsbD0id2hpdGUiIC8+Cgk8cGF0aCBkPSJNMTMgOEMxMyA1LjIzODU4IDEwLjc2MTQgMyA4IDNDNS4yMzg1OCAzIDMgNS4yMzg1OCAzIDhDMyAxMC43NjE0IDUuMjM4NTggMTMgOCAxM0MxMC43NjE0IDEzIDEzIDEwLjc2MTQgMTMgOFoiIGZpbGw9IiNGOERCOEYiIC8+Cjwvc3ZnPgo=',
  trafficLightGreen:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGQ9Ik0xIDNDMSAxLjg5NTQzIDEuODk1NDMgMSAzIDFIMTNDMTQuMTA0NiAxIDE1IDEuODk1NDMgMTUgM1YxM0MxNSAxNC4xMDQ2IDE0LjEwNDYgMTUgMTMgMTVIM0MxLjg5NTQzIDE1IDEgMTQuMTA0NiAxIDEzVjNaIiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTMgMS41SDEzQzEzLjgyODQgMS41IDE0LjUgMi4xNzE1NyAxNC41IDNWMTNDMTQuNSAxMy44Mjg0IDEzLjgyODQgMTQuNSAxMyAxNC41SDNDMi4xNzE1NyAxNC41IDEuNSAxMy44Mjg0IDEuNSAxM1YzQzEuNSAyLjE3MTU3IDIuMTcxNTcgMS41IDMgMS41WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KCTxwYXRoIGQ9Ik0xNCA4QzE0IDQuNjg2MjkgMTEuMzEzNyAyIDggMkM0LjY4NjI5IDIgMiA0LjY4NjI5IDIgOEMyIDExLjMxMzcgNC42ODYyOSAxNCA4IDE0QzExLjMxMzcgMTQgMTQgMTEuMzEzNyAxNCA4WiIgZmlsbD0id2hpdGUiIC8+Cgk8cGF0aCBkPSJNMTMgOEMxMyA1LjIzODU4IDEwLjc2MTQgMyA4IDNDNS4yMzg1OCAzIDMgNS4yMzg1OCAzIDhDMyAxMC43NjE0IDUuMjM4NTggMTMgOCAxM0MxMC43NjE0IDEzIDEzIDEwLjc2MTQgMTMgOFoiIGZpbGw9IiNBMkREQUEiIC8+Cjwvc3ZnPgo=',
  downIncline:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTMgMTVMMy4xMDA1MyAxNUw2LjI4MjUxIDExLjgxOEwxLjMzMjc2IDYuODY4MjdMNC44NjgzIDMuMzMyNzNMOS44MTgwNSA4LjI4MjQ4TDEzIDUuMTAwNUwxMyAxNVoiIGZpbGw9IiNGOERCOEYiIC8+Cgk8cGF0aCBkPSJNNi42MzYwNyAxMS40NjQ1TDIuMDM5ODcgNi44NjgyN0w0Ljg2ODMgNC4wMzk4NEw5LjQ2NDQ5IDguNjM2MDNMOS44MTgwNSA4Ljk4OTU5TDEwLjE3MTYgOC42MzYwM0wxMi41IDYuMzA3NjFMMTIuNSAxNC41TDQuMzA3NjQgMTQuNUw2LjYzNjA3IDEyLjE3MTZMNi45ODk2MiAxMS44MThMNi42MzYwNyAxMS40NjQ1WiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  upIncline:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTMgM0wzLjEwMDUgM0w2LjI4MjQ4IDYuMTgxOThMMS4zMzI3MyAxMS4xMzE3TDQuODY4MjcgMTQuNjY3M0w5LjgxODAxIDkuNzE3NTFMMTMgMTIuODk5NVYzWiIgZmlsbD0iI0Y4REI4RiIgLz4KCTxwYXRoIGQ9Ik02LjYzNjAzIDUuODI4NDNMNC4zMDc2MSAzLjVMMTIuNSAzLjVWMTEuNjkyNEwxMC4xNzE2IDkuMzYzOTZMOS44MTgwMSA5LjAxMDQxTDkuNDY0NDYgOS4zNjM5Nkw0Ljg2ODI3IDEzLjk2MDJMMi4wMzk4NCAxMS4xMzE3TDYuNjM2MDMgNi41MzU1M0w2Ljk4OTU5IDYuMTgxOThMNi42MzYwMyA1LjgyODQzWiIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  downInclineGray:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxnIGNsaXAtcGF0aD0idXJsKCNjbGlwMCkiPgoJCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTQgMTRMNC4xMDA1MSAxNEw3LjI4MjQ5IDEwLjgxOEwyLjMzMjc0IDUuODY4MjdMNS44NjgyNyAyLjMzMjc0TDEwLjgxOCA3LjI4MjQ5TDE0IDQuMTAwNTFMMTQgMTRaIiBmaWxsPSIjNTA1MDUwIiAvPgoJCTxwYXRoIGQ9Ik0xMS4xNzE2IDcuNjM2MDRMMTMuNSA1LjMwNzYxTDEzLjUgMTMuNUw1LjMwNzYxIDEzLjVMNy42MzYwNCAxMS4xNzE2TDcuOTg5NTkgMTAuODE4TDcuNjM2MDQgMTAuNDY0NUwzLjAzOTg0IDUuODY4MjdMNS44NjgyNyAzLjAzOTg0TDEwLjQ2NDUgNy42MzYwNEwxMC44MTggNy45ODk1OUwxMS4xNzE2IDcuNjM2MDRaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPC9nPgoJPGRlZnM+CgkJPGNsaXBQYXRoIGlkPSJjbGlwMCI+CgkJCTxyZWN0IHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgZmlsbD0id2hpdGUiIC8+CgkJPC9jbGlwUGF0aD4KCTwvZGVmcz4KPC9zdmc+Cg==',
  upInclineGray:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxnIGNsaXAtcGF0aD0idXJsKCNjbGlwMCkiPgoJCTxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgY2xpcC1ydWxlPSJldmVub2RkIiBkPSJNMTQgMkw0LjEwMDUxIDJMNy4yODI0OSA1LjE4MTk4TDIuMzMyNzQgMTAuMTMxN0w1Ljg2ODI3IDEzLjY2NzNMMTAuODE4IDguNzE3NTFMMTQgMTEuODk5NUwxNCAyWiIgZmlsbD0iIzUwNTA1MCIgLz4KCQk8cGF0aCBkPSJNMTEuMTcxNiA4LjM2Mzk2TDEzLjUgMTAuNjkyNEwxMy41IDIuNUw1LjMwNzYxIDIuNUw3LjYzNjA0IDQuODI4NDNMNy45ODk1OSA1LjE4MTk4TDcuNjM2MDQgNS41MzU1M0wzLjAzOTg1IDEwLjEzMTdMNS44NjgyNyAxMi45NjAyTDEwLjQ2NDUgOC4zNjM5NkwxMC44MTggOC4wMTA0MUwxMS4xNzE2IDguMzYzOTZaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPC9nPgoJPGRlZnM+CgkJPGNsaXBQYXRoIGlkPSJjbGlwMCI+CgkJCTxyZWN0IHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgZmlsbD0id2hpdGUiIC8+CgkJPC9jbGlwUGF0aD4KCTwvZGVmcz4KPC9zdmc+Cg==',
  oneFilledBars:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxyZWN0IHg9IjEiIHk9IjEwIiB3aWR0aD0iMyIgaGVpZ2h0PSI1IiBmaWxsPSIjODRCREVDIiAvPgoJPHJlY3QgeD0iMS41IiB5PSIxMC41IiB3aWR0aD0iMiIgaGVpZ2h0PSI0IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iNSIgeT0iNyIgd2lkdGg9IjMiIGhlaWdodD0iOCIgZmlsbD0iI0NDQ0NDQyIgLz4KCTxyZWN0IHg9IjUuNSIgeT0iNy41IiB3aWR0aD0iMiIgaGVpZ2h0PSI3IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iOSIgeT0iNCIgd2lkdGg9IjMiIGhlaWdodD0iMTEiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSI5LjUiIHk9IjQuNSIgd2lkdGg9IjIiIGhlaWdodD0iMTAiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cmVjdCB4PSIxMyIgeT0iMSIgd2lkdGg9IjMiIGhlaWdodD0iMTQiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSIxMy41IiB5PSIxLjUiIHdpZHRoPSIyIiBoZWlnaHQ9IjEzIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  twoFilledBars:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxyZWN0IHg9IjEiIHk9IjEwIiB3aWR0aD0iMyIgaGVpZ2h0PSI1IiBmaWxsPSIjODRCREVDIiAvPgoJPHJlY3QgeD0iMS41IiB5PSIxMC41IiB3aWR0aD0iMiIgaGVpZ2h0PSI0IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iNSIgeT0iNyIgd2lkdGg9IjMiIGhlaWdodD0iOCIgZmlsbD0iIzg0QkRFQyIgLz4KCTxyZWN0IHg9IjUuNSIgeT0iNy41IiB3aWR0aD0iMiIgaGVpZ2h0PSI3IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iOSIgeT0iNCIgd2lkdGg9IjMiIGhlaWdodD0iMTEiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSI5LjUiIHk9IjQuNSIgd2lkdGg9IjIiIGhlaWdodD0iMTAiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cmVjdCB4PSIxMyIgeT0iMSIgd2lkdGg9IjMiIGhlaWdodD0iMTQiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSIxMy41IiB5PSIxLjUiIHdpZHRoPSIyIiBoZWlnaHQ9IjEzIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  threeFilledBars:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxyZWN0IHg9IjEiIHk9IjEwIiB3aWR0aD0iMyIgaGVpZ2h0PSI1IiBmaWxsPSIjODRCREVDIiAvPgoJPHJlY3QgeD0iMS41IiB5PSIxMC41IiB3aWR0aD0iMiIgaGVpZ2h0PSI0IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iNSIgeT0iNyIgd2lkdGg9IjMiIGhlaWdodD0iOCIgZmlsbD0iIzg0QkRFQyIgLz4KCTxyZWN0IHg9IjUuNSIgeT0iNy41IiB3aWR0aD0iMiIgaGVpZ2h0PSI3IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iOSIgeT0iNCIgd2lkdGg9IjMiIGhlaWdodD0iMTEiIGZpbGw9IiM4NEJERUMiIC8+Cgk8cmVjdCB4PSI5LjUiIHk9IjQuNSIgd2lkdGg9IjIiIGhlaWdodD0iMTAiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cmVjdCB4PSIxMyIgeT0iMSIgd2lkdGg9IjMiIGhlaWdodD0iMTQiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSIxMy41IiB5PSIxLjUiIHdpZHRoPSIyIiBoZWlnaHQ9IjEzIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  fourFilledBars:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxyZWN0IHg9IjEiIHk9IjEwIiB3aWR0aD0iMyIgaGVpZ2h0PSI1IiBmaWxsPSIjODRCREVDIiAvPgoJPHJlY3QgeD0iMS41IiB5PSIxMC41IiB3aWR0aD0iMiIgaGVpZ2h0PSI0IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iNSIgeT0iNyIgd2lkdGg9IjMiIGhlaWdodD0iOCIgZmlsbD0iIzg0QkRFQyIgLz4KCTxyZWN0IHg9IjUuNSIgeT0iNy41IiB3aWR0aD0iMiIgaGVpZ2h0PSI3IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iOSIgeT0iNCIgd2lkdGg9IjMiIGhlaWdodD0iMTEiIGZpbGw9IiM4NEJERUMiIC8+Cgk8cmVjdCB4PSI5LjUiIHk9IjQuNSIgd2lkdGg9IjIiIGhlaWdodD0iMTAiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cmVjdCB4PSIxMyIgeT0iMSIgd2lkdGg9IjMiIGhlaWdodD0iMTQiIGZpbGw9IiM4NEJERUMiIC8+Cgk8cmVjdCB4PSIxMy41IiB5PSIxLjUiIHdpZHRoPSIyIiBoZWlnaHQ9IjEzIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  circleBlack:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxjaXJjbGUgY3g9IjgiIGN5PSI4IiByPSI3IiBmaWxsPSIjNTA1MDUwIiAvPgoJPGNpcmNsZSBjeD0iOCIgY3k9IjgiIHI9IjYuNSIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  circleGray:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxjaXJjbGUgY3g9IjgiIGN5PSI4IiByPSI3IiBmaWxsPSIjOUI5QjlCIiAvPgoJPGNpcmNsZSBjeD0iOCIgY3k9IjgiIHI9IjYuNSIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLW9wYWNpdHk9IjAuMiIgLz4KPC9zdmc+Cg==',
  circleLightRed:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxlbGxpcHNlIGN4PSI4IiBjeT0iOCIgcng9IjciIHJ5PSI3IiB0cmFuc2Zvcm09InJvdGF0ZSgtMTgwIDggOCkiIGZpbGw9IiNGRjgwODAiIC8+Cgk8cGF0aCBkPSJNMS41IDhDMS41IDQuNDEwMTUgNC40MTAxNSAxLjUgOCAxLjVDMTEuNTg5OSAxLjUgMTQuNSA0LjQxMDE1IDE0LjUgOEMxNC41IDExLjU4OTkgMTEuNTg5OSAxNC41IDggMTQuNUM0LjQxMDE1IDE0LjUgMS41IDExLjU4OTggMS41IDhaIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K',
  circleWhite:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxjaXJjbGUgY3g9IjgiIGN5PSI4IiByPSI3IiBmaWxsPSIjNTA1MDUwIiAvPgoJPGNpcmNsZSBjeD0iOCIgY3k9IjgiIHI9IjYiIHRyYW5zZm9ybT0icm90YXRlKC05MCA4IDgpIiBmaWxsPSJ3aGl0ZSIgLz4KPC9zdmc+Cg==',
  circleThreeWhiteQuarters:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxjaXJjbGUgY3g9IjgiIGN5PSI4IiByPSI3IiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTggMkM2LjgxMzMxIDIgNS42NTMyOCAyLjM1MTg5IDQuNjY2NTggMy4wMTExOEMzLjY3OTg5IDMuNjcwNDcgMi45MTA4NSA0LjYwNzU0IDIuNDU2NzMgNS43MDM5QzIuMDAyNiA2LjgwMDI1IDEuODgzNzggOC4wMDY2NSAyLjExNTI5IDkuMTcwNTRDMi4zNDY4IDEwLjMzNDQgMi45MTgyNSAxMS40MDM1IDMuNzU3MzYgMTIuMjQyNkM0LjU5NjQ4IDEzLjA4MTggNS42NjU1OCAxMy42NTMyIDYuODI5NDYgMTMuODg0N0M3Ljk5MzM1IDE0LjExNjIgOS4xOTk3NSAxMy45OTc0IDEwLjI5NjEgMTMuNTQzM0MxMS4zOTI1IDEzLjA4OTEgMTIuMzI5NSAxMi4zMjAxIDEyLjk4ODggMTEuMzMzNEMxMy42NDgxIDEwLjM0NjcgMTQgOS4xODY2OCAxNCA4TDggOEw4IDJaIiBmaWxsPSJ3aGl0ZSIgLz4KPC9zdmc+Cg==',
  circleTwoWhiteQuarters:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxjaXJjbGUgY3g9IjgiIGN5PSI4IiByPSI3IiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTggMkM2LjQwODcgMiA0Ljg4MjU4IDIuNjMyMTQgMy43NTczNiAzLjc1NzM2QzIuNjMyMTQgNC44ODI1OCAyIDYuNDA4NyAyIDhDMiA5LjU5MTMgMi42MzIxNCAxMS4xMTc0IDMuNzU3MzYgMTIuMjQyNkM0Ljg4MjU4IDEzLjM2NzkgNi40MDg3IDE0IDggMTRMOCA4TDggMloiIGZpbGw9IndoaXRlIiAvPgo8L3N2Zz4K',
  circleOneWhiteQuarter:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxjaXJjbGUgY3g9IjgiIGN5PSI4IiByPSI3IiBmaWxsPSIjNTA1MDUwIiAvPgoJPHBhdGggZD0iTTggMkM3LjIxMjA3IDIgNi40MzE4NSAyLjE1NTE5IDUuNzAzOSAyLjQ1NjcyQzQuOTc1OTUgMi43NTgyNSA0LjMxNDUxIDMuMjAwMjEgMy43NTczNiAzLjc1NzM2QzMuMjAwMjEgNC4zMTQ1MSAyLjc1ODI1IDQuOTc1OTUgMi40NTY3MiA1LjcwMzlDMi4xNTUxOSA2LjQzMTg1IDIgNy4yMTIwNyAyIDhMOCA4TDggMloiIGZpbGw9IndoaXRlIiAvPgo8L3N2Zz4K',
  zeroFilledBars:
    'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KCTxyZWN0IHg9IjEiIHk9IjEwIiB3aWR0aD0iMyIgaGVpZ2h0PSI1IiBmaWxsPSIjQ0NDQ0NDIiAvPgoJPHJlY3QgeD0iMS41IiB5PSIxMC41IiB3aWR0aD0iMiIgaGVpZ2h0PSI0IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iNSIgeT0iNyIgd2lkdGg9IjMiIGhlaWdodD0iOCIgZmlsbD0iI0NDQ0NDQyIgLz4KCTxyZWN0IHg9IjUuNSIgeT0iNy41IiB3aWR0aD0iMiIgaGVpZ2h0PSI3IiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgoJPHJlY3QgeD0iOSIgeT0iNCIgd2lkdGg9IjMiIGhlaWdodD0iMTEiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSI5LjUiIHk9IjQuNSIgd2lkdGg9IjIiIGhlaWdodD0iMTAiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS1vcGFjaXR5PSIwLjIiIC8+Cgk8cmVjdCB4PSIxMyIgeT0iMSIgd2lkdGg9IjMiIGhlaWdodD0iMTQiIGZpbGw9IiNDQ0NDQ0MiIC8+Cgk8cmVjdCB4PSIxMy41IiB5PSIxLjUiIHdpZHRoPSIyIiBoZWlnaHQ9IjEzIiBzdHJva2U9ImJsYWNrIiBzdHJva2Utb3BhY2l0eT0iMC4yIiAvPgo8L3N2Zz4K'
};
