/**
 * 将 drawingml 配置转成内置 json 格式，避免运行时再次解析
 */

import {readFileSync, writeFileSync} from 'fs';
import {parseXML} from '../src/util/xml';
import {Shape} from '../src/openxml/drawing/Shape';
import {parseShape} from '../src/word/parse/parseShape';

import jsdom from 'jsdom';
import prettier from 'prettier';

const {JSDOM} = jsdom;
const {DOMParser} = new JSDOM(``).window;

global.DOMParser = DOMParser;

const drawingML = parseXML(
  readFileSync(
    './OfficeOpenXML-DrawingMLGeometries/presetShapeDefinitions.xml',
    'utf-8'
  )
);

let outputFile: string[] = [
  '/** generated by tools/converDarwingML.ts, do not edit */',
  `import {Shape} from './Shape';`
];

const shapeMap: {[key: string]: Shape} = {};

for (const shape of drawingML
  .getElementsByTagName('presetShapeDefinitons')
  .item(0)!.children) {
  const shapeName = shape.tagName;
  shapeMap[shapeName] = parseShape(shape);
}

outputFile.push(
  'export const presetShape: Record<string, Shape> = ' +
    JSON.stringify(shapeMap, null, 2) +
    ';'
);

prettier.resolveConfig('../../../.prettierrc').then(options => {
  const formatted = prettier.format(outputFile.join('\n'), {
    ...options,
    parser: 'typescript'
  });
  writeFileSync('../src/openxml/word/drawing/presetShape.ts', formatted);
});
