/**
 * 将文件转成 base64 字符串
 */
import {readFileSync, writeFileSync} from 'fs';

import prettier from 'prettier';

import process from 'node:process';
import path from 'node:path';

const file = process.argv[2];

const tsFile = process.argv[3];

const content = readFileSync(file);

const varName = path.basename(tsFile.replace(/\.ts$/, ''));

const base64Content = content.toString('base64');

const outputFile = `
/** generated by convertFileToBase64.ts, do not edit */

export const ${varName} = '${base64Content}';
`;

prettier.resolveConfig('../../../.prettierrc').then(options => {
  const formatted = prettier.format(outputFile, {
    ...options,
    parser: 'typescript'
  });
  writeFileSync(tsFile, formatted);
});
